/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.CommandManager;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.requesthandler.OBRHS_WorkerThread;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.locus.LocusAndAlleles;

public abstract class CommandParser {
    public static final String NOT_PARSED = "CME_NP";
    static /* synthetic */ Class class$0;

    public static String parseSession(Session sess, String sessionGroup, int typ, long id) {
        StringBuffer msb = new StringBuffer();
        String[] infoTarget = new String[3];
        Vector commands = sess.getVector("SES_COMMAND");
        if (commands != null) {
            Iterator iter = commands.iterator();
            while (iter.hasNext()) {
                String commandLine = (String)iter.next();
                if ((commandLine = commandLine.trim()).length() == 0) continue;
                CommandParser.extractInfos(commandLine, infoTarget);
                commandLine = infoTarget[0];
                if (commandLine.startsWith("##TD|") || commandLine.startsWith("##TC|") || commandLine.startsWith("##TDESC|")) continue;
                String commandDate = infoTarget[1];
                String objectGroup = infoTarget[2];
                Zeile z = new Zeile(commandLine, ' ');
                String command = z.getString(0, null);
                if (command == null || command.trim().length() == 0) continue;
                CommandManagerExecutive cme = CommandManager.getExecutive(command);
                if (cme == null) {
                    if (command.equals("ML")) {
                        cme = CommandManager.getExecutive("MI");
                    } else if (command.equals("MLOS")) {
                        cme = CommandManager.getExecutive("MI");
                    } else if (command.equals("MI")) {
                        cme = CommandManager.getExecutive("MI");
                    } else if (command.equals("MIOS")) {
                        cme = CommandManager.getExecutive("MI");
                    } else if (command.equals("MGENEALOGY")) {
                        cme = CommandManager.getExecutive("MI");
                    }
                }
                if (cme != null) {
                    try {
                        String ps = cme.getParsedCommandIfTouched(command, z, sessionGroup, typ, id, objectGroup);
                        if (ps != null) {
                            if (ps.equals(NOT_PARSED)) {
                                String string = "Not parsed: " + commandLine;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("de.hannse.netobjects.objectstore.CommandParser");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.debug(string, clazz);
                                continue;
                            }
                            msb.append(Base64Manager.encodeBase64(String.valueOf(commandDate) + ps)).append("\n");
                            continue;
                        }
                        if (id != 0L) continue;
                        String string = "No result while parsing: " + commandLine;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.netobjects.objectstore.CommandParser");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, null, clazz);
                    }
                    catch (Exception e) {
                        String string = "Problem while parsing: " + commandLine;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.netobjects.objectstore.CommandParser");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, e, clazz);
                    }
                    continue;
                }
                System.out.println("No executive for " + command);
            }
        }
        return msb.toString();
    }

    public static void extractInfos(String commandLine, String[] target) {
        int ind;
        String commandDate = "";
        String objectGroup = null;
        if (commandLine.startsWith("[") && (ind = commandLine.indexOf("]")) != -1) {
            String eingeklammert = commandLine.substring(1, ind).trim();
            commandLine = commandLine.substring(ind + 1, commandLine.length()).trim();
            commandLine = CommandManagerExecutive.checkServiceRoomTag(commandLine, null);
            Zeile z = new Zeile(eingeklammert, '|');
            objectGroup = z.getStringNONEmpty(1, null);
            long millis = z.getLong(0, 0L);
            if (millis != 0L) {
                commandDate = objectGroup != null ? "[" + DatumFormat.getTimeString(millis) + "; group:" + objectGroup + "] " : "[" + DatumFormat.getTimeString(millis) + "] ";
            }
        }
        target[0] = commandLine;
        target[1] = commandDate;
        target[2] = objectGroup;
    }

    public static void specialSessionOutput(Session session, String sessionGroup) {
        String[] infoTarget = new String[3];
        String[] arr = new String[]{"LOa", "LOe", "LOn", "LOC_ALLEL_DICT", "Lc", "Ln", "Ll", "STn"};
        System.out.println("*************************************");
        System.out.println(OBRHS_WorkerThread.getSessionDetails(session, sessionGroup));
        GregorianCalendar greg = new GregorianCalendar();
        Date date = session.getDate("IDO_START_DATE");
        if (date != null) {
            greg.setTimeInMillis(date.getTime());
            System.out.println("Start: " + new MyDate(greg).getDateTimeForFileName());
        }
        if ((date = session.getDate("IDO_END_DATE")) != null) {
            greg.setTimeInMillis(date.getTime());
            System.out.println("Ende: " + new MyDate(greg).getDateTimeForFileName());
        }
        System.out.println("*************************************");
        Vector vv = (Vector)session.get("SES_COMMAND");
        if (vv != null) {
            int i = 0;
            while (i < vv.size()) {
                String commandLine = (String)vv.elementAt(i);
                CommandParser.extractInfos(commandLine, infoTarget);
                commandLine = infoTarget[0];
                String commandDate = infoTarget[1];
                String objectGroup = infoTarget[2];
                if (!commandLine.startsWith("MAI_NEW")) {
                    if (commandLine.startsWith("MAI_IMPORT_WITH_ROOM_OR_RACKPOS")) {
                        System.out.println(String.valueOf(commandDate) + ": Kaefig-Gruppen-Transfer");
                        Zeile z = new Zeile(commandLine, ' ');
                        System.out.println("          Quellgruppe:   " + z.getString(8, "?"));
                        System.out.println("          QuellKaefigID: " + z.getString(2, "?"));
                        System.out.println("          OwnerID:       " + z.getString(9, "?"));
                        System.out.println("          Ziel-RaumID:   " + z.getString(3, "?"));
                        System.out.println("          Quel-Rack:     " + z.getString(4, "?") + " S: " + z.getString(5, "?") + " C: " + z.getString(6, "?") + " R: " + z.getString(7, "?"));
                        String imp = z.getStringB64(1, "?");
                        z = new Zeile(imp, '\n');
                        int ii = 0;
                        while (ii < z.size()) {
                            System.out.println("          ---------------------");
                            Zeile z2 = new Zeile(z.getString(ii), ' ');
                            int iii = 0;
                            while (iii < z2.size()) {
                                String info = z2.getString(iii);
                                boolean shown = false;
                                int inex = info.indexOf("=");
                                if (inex != -1) {
                                    int j = 0;
                                    while (j < arr.length && !shown) {
                                        if (info.startsWith(arr[j])) {
                                            int k;
                                            Object ooo = IDObjectXMLHandler.getObject(info.substring(inex + 1, info.length()));
                                            if (ooo instanceof String) {
                                                System.out.println("          " + arr[j] + " : " + ooo);
                                            } else if (ooo instanceof String[]) {
                                                String[] sarr = (String[])ooo;
                                                k = 0;
                                                while (k < sarr.length) {
                                                    System.out.println("          " + arr[j] + " : " + sarr[k]);
                                                    ++k;
                                                }
                                            } else if (ooo instanceof LocusAndAlleles[]) {
                                                LocusAndAlleles[] new_name = (LocusAndAlleles[])ooo;
                                                k = 0;
                                                while (k < new_name.length) {
                                                    System.out.println("          " + arr[j] + " : " + new_name[k]);
                                                    ++k;
                                                }
                                            }
                                            shown = true;
                                        }
                                        ++j;
                                    }
                                }
                                if (!shown) {
                                    System.out.println("          " + z2.getString(iii));
                                }
                                ++iii;
                            }
                            System.out.println("          ---------------------");
                            ++ii;
                        }
                        System.out.println("--------------------------------------------------");
                    } else {
                        System.out.println(String.valueOf(commandDate) + ": " + commandLine);
                    }
                }
                ++i;
            }
        }
    }
}

