/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.CommandManager;
import de.hannse.netobjects.objectstore.DoObject;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.StopWatch;
import mausoleum.helper.Zeile;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.WeaningControl;

public class CommandRequestBroadcaster
implements Runnable {
    private static final HashSet SPECIAL_CONTENT_KEYS = new HashSet();
    private static final HashMap ACKNOWLEDGED_GROUPS = new HashMap();
    private final ObjectRequest ivObjectRequest;
    private final String ivMainGroup;
    private final ServerCommunicator ivMainContact;
    private final HashMap ivErgebnisHashmap = new HashMap();
    private final HashMap ivServiceRoomOverrides;

    static {
        SPECIAL_CONTENT_KEYS.add("#soc");
        SPECIAL_CONTENT_KEYS.add("#sno");
        SPECIAL_CONTENT_KEYS.add("#swm");
        SPECIAL_CONTENT_KEYS.add("#sri");
        SPECIAL_CONTENT_KEYS.add("#licex");
    }

    public CommandRequestBroadcaster(Hashtable objectBag, ObjectRequest objectRequest, HashSet specialCommands, Session session, ServerCommunicator mainContact, Vector newObjects, HashSet weanedMiceIdentifiers, HashMap serviceRoomOverrides) {
        DoObject doob;
        String swid1 = StopWatch.start("44 BC 1 handle");
        this.ivObjectRequest = objectRequest;
        this.ivMainGroup = objectRequest.ivGroup;
        this.ivMainContact = mainContact;
        this.ivServiceRoomOverrides = serviceRoomOverrides;
        DoObject doObject = doob = session == null ? null : new DoObject();
        if (!objectBag.isEmpty()) {
            if (specialCommands != null && !specialCommands.isEmpty()) {
                this.ivErgebnisHashmap.put("#soc", new HashSet(specialCommands));
            }
            String swid2 = StopWatch.start("44 BC 2 newObjects");
            if (newObjects != null && doob != null && CommandManager.cvActive) {
                CommandRequestBroadcaster.manageNewObjects(newObjects, this.ivErgebnisHashmap, doob);
            }
            StopWatch.stop(swid2);
            String swid3 = StopWatch.start("44 BC 3 weaned");
            if (weanedMiceIdentifiers != null && CommandManager.cvActive) {
                CommandRequestBroadcaster.manageWeanedMice(weanedMiceIdentifiers, objectBag, this.ivErgebnisHashmap);
            }
            StopWatch.stop(swid3);
            String swid4 = StopWatch.start("44 BC 4 changed");
            if (CommandManager.cvActive) {
                CommandRequestBroadcaster.manageChangedObjects(objectBag, this.ivErgebnisHashmap, doob, this.ivServiceRoomOverrides);
            }
            StopWatch.stop(swid4);
            this.addInfoToProt(session);
            String swid5 = StopWatch.start("44 BC 5 writeHT");
            if (CommandManager.cvActive) {
                ObjectStoreServer.writeHashtable(objectBag, session, objectRequest.ivAction == 87);
            }
            StopWatch.stop(swid5);
        }
        if (CommandManager.cvActive) {
            objectRequest.finish();
            if (session != null) {
                if (doob != null && doob.hasTouchedObjects()) {
                    session.addToUndo(doob);
                }
                session.clearRedoStack();
                ServerPortal.checkUndoAndRedoInGroup(doob, session);
            }
            new Thread(this).start();
        }
        StopWatch.stop(swid1);
    }

    public CommandRequestBroadcaster(Hashtable objectBag, ObjectRequest objectRequest, Session session, ServerCommunicator mainContact, HashMap serviceRoomOverrides) {
        this.ivObjectRequest = objectRequest;
        this.ivMainGroup = objectRequest.ivGroup;
        this.ivMainContact = mainContact;
        this.ivServiceRoomOverrides = serviceRoomOverrides;
        if (!objectBag.isEmpty()) {
            CommandRequestBroadcaster.manageChangedObjects(objectBag, this.ivErgebnisHashmap, null, this.ivServiceRoomOverrides);
            this.addInfoToProt(session);
            ObjectStoreServer.writeHashtable(objectBag, session, false);
        }
        objectRequest.finish();
        new Thread(this).start();
    }

    private void addInfoToProt(Session session) {
        try {
            MyDate md = new MyDate(new GregorianCalendar());
            StringBuilder msb = new StringBuilder();
            msb.append("# ").append(DatumFormat.getProtDateTimeString(md));
            msb.append(" ").append(ObjectRequest.getActionString(this.ivObjectRequest.ivAction));
            if (session != null) {
                msb.append(" Session ID: ").append(session.getID()).append(" group: ").append(session.getGroup()).append(" userID: ").append(session.get("SES_USER"));
            }
            msb.append("\n");
            String info = msb.toString();
            Iterator iterator = this.ivErgebnisHashmap.keySet().iterator();
            while (iterator.hasNext()) {
                Hashtable groupHT;
                String group = (String)iterator.next();
                if (SPECIAL_CONTENT_KEYS.contains(group)) continue;
                Object ooo = ACKNOWLEDGED_GROUPS.get(group);
                if (ooo == null) {
                    ooo = new File(GroupFileManager.getProtocolsPath(group)).exists() ? group : NULLObject.INSTANCE;
                    ACKNOWLEDGED_GROUPS.put(group, ooo);
                }
                if (!group.equals(ooo) || (groupHT = (Hashtable)this.ivErgebnisHashmap.get(group)) == null || groupHT.isEmpty()) continue;
                Iterator iterator2 = groupHT.keySet().iterator();
                while (iterator2.hasNext()) {
                    Integer type = (Integer)iterator2.next();
                    String typeString = IDObject.getFilenameForTypeServerSide(type);
                    FileManager.pureAppend(GroupFileManager.getTypeProtocolPath(group, typeString, md), info);
                }
            }
        }
        catch (Exception e) {
            Log.error("Problem adding info to protocol", e, this);
        }
    }

    private static void manageChangedObjects(Hashtable objectBag, HashMap ergebnisHashmap, DoObject doob, HashMap serviceRoomOverrides) {
        Enumeration en = objectBag.elements();
        while (en.hasMoreElements()) {
            Integer tk;
            Hashtable objectTypeHT;
            IDObject idObject = (IDObject)en.nextElement();
            if (idObject.ivPropertyMask == null || idObject.ivPropertyMask.isEmpty()) continue;
            idObject.incVersion();
            String group = idObject.getGroup();
            Hashtable groupHT = (Hashtable)ergebnisHashmap.get(group);
            if (groupHT == null) {
                groupHT = new Hashtable();
                ergebnisHashmap.put(group, groupHT);
            }
            if ((objectTypeHT = (Hashtable)groupHT.get(tk = (Integer)idObject.get("IDO_TYPE_ID"))) == null) {
                objectTypeHT = new Hashtable();
                groupHT.put(tk, objectTypeHT);
            }
            if (idObject.canSitInRoom()) {
                Long serviceRoomID;
                HashMap<String, Long> hm = (HashMap<String, Long>)ergebnisHashmap.get("#sri");
                if (hm == null) {
                    hm = new HashMap<String, Long>();
                    ergebnisHashmap.put("#sri", hm);
                }
                String srid = idObject.getIdentifierString();
                Long l = serviceRoomID = serviceRoomOverrides != null ? (Long)serviceRoomOverrides.get(srid) : null;
                if (serviceRoomID == null && idObject.existed()) {
                    serviceRoomID = idObject.getServiceRoomID();
                }
                if (serviceRoomID == null) {
                    hm.put(srid, AllgUtils.NIX_ROOM);
                } else {
                    hm.put(srid, serviceRoomID);
                }
            }
            objectTypeHT.put(idObject.get("IDO_ID"), new HashMap(idObject.ivPropertyMask));
            if (doob != null) {
                doob.manageIDObjectFormObjectBag(idObject);
            }
            idObject.commit(false);
        }
    }

    public static void manageNewObjects(Vector newObjects, HashMap ergebnisHashmap, DoObject doob) {
        if (newObjects != null && !newObjects.isEmpty()) {
            HashMap newObjectsHM = new HashMap();
            Iterator iter = newObjects.iterator();
            while (iter.hasNext()) {
                Integer typ;
                Vector<Object> typVec;
                IDObject ido = (IDObject)iter.next();
                String group = ido.getGroup();
                HashMap<Integer, Vector<Object>> hm = (HashMap<Integer, Vector<Object>>)newObjectsHM.get(group);
                if (hm == null) {
                    hm = new HashMap<Integer, Vector<Object>>();
                    newObjectsHM.put(group, hm);
                }
                if ((typVec = (Vector<Object>)hm.get(typ = (Integer)ido.get("IDO_TYPE_ID"))) == null) {
                    typVec = new Vector<Object>();
                    hm.put(typ, typVec);
                }
                typVec.add(ido.get("IDO_ID"));
                if (doob == null) continue;
                doob.manageNewObject(ido);
            }
            ergebnisHashmap.put("#sno", newObjectsHM);
        }
    }

    private static void manageWeanedMice(HashSet weanedMiceIdentifiers, Hashtable objectBag, HashMap ergebnisHashmap) {
        if (weanedMiceIdentifiers != null && !weanedMiceIdentifiers.isEmpty()) {
            Vector<String> weanedMiceIdentifierV = new Vector<String>();
            Iterator iter = weanedMiceIdentifiers.iterator();
            while (iter.hasNext()) {
                Cage cage;
                String identifier = (String)iter.next();
                Zeile idz = new Zeile(identifier, '|');
                if (idz.size() != 3) continue;
                String groupName = idz.getString(0);
                long mouseID = idz.getLong(2, 0L);
                Mouse mouse = (Mouse)ObjectStoreServer.getObjectToUpdate(1, mouseID, groupName, objectBag);
                if (mouse == null || (cage = (Cage)ObjectStoreServer.getObjectToUpdate(2, mouse.getActCageID(0L), groupName, objectBag)) == null || WeaningControl.istNochNichtAbgesetzt(mouse, cage)) continue;
                mouse.setBoolean("MOS_ABGES", true);
                weanedMiceIdentifierV.add(identifier);
            }
            if (!weanedMiceIdentifierV.isEmpty()) {
                ergebnisHashmap.put("#swm", weanedMiceIdentifierV);
            }
        }
    }

    public void run() {
        if (Log.shouldLog(0)) {
            Log.subdebug("Start broadcasting command result", this);
        }
        this.ivObjectRequest.ivObject = this.ivErgebnisHashmap;
        if (this.ivMainContact != null) {
            if (Log.shouldLog(0)) {
                Log.subdebug("Sending command result to " + this.ivMainContact.toString(), this);
            }
            try {
                this.ivMainContact.sendObjectAndUR(this.ivObjectRequest, true);
            }
            catch (Throwable e) {
                Log.error("Problem sending command result to " + this.ivMainContact.toString(), e, this);
            }
            if (Log.shouldLog(0)) {
                Log.subdebug("Finished sending command result to " + this.ivMainContact.toString(), this);
            }
        }
        HashMap serviceRoomIds = (HashMap)this.ivErgebnisHashmap.get("#sri");
        String magicString = this.ivObjectRequest.ivMagicString;
        String clientString = this.ivObjectRequest.ivClientString;
        Enumeration en = ServerPortal.getCommunicators();
        while (en.hasMoreElements()) {
            ServerCommunicator sc = (ServerCommunicator)en.nextElement();
            if (sc == this.ivMainContact) continue;
            ObjectRequest nor = null;
            HashMap ergebnisHM = null;
            Iterator iter = this.ivErgebnisHashmap.keySet().iterator();
            while (iter.hasNext()) {
                HashMap hm;
                Hashtable groupHT;
                String group = (String)iter.next();
                if (SPECIAL_CONTENT_KEYS.contains(group) || !sc.isInterstedInGroup(group) || sc.willBeKilled()) continue;
                if (nor == null || ergebnisHM == null) {
                    ergebnisHM = new HashMap();
                    nor = new ObjectRequest(this.ivObjectRequest.ivAction, ergebnisHM, this.ivMainGroup, null);
                    nor.finish();
                    nor.ivMagicString = magicString;
                    nor.ivClientString = clientString;
                    nor.ivKamVonWoanders = !group.equals(this.ivMainGroup);
                    ergebnisHM.put("#sri", serviceRoomIds);
                }
                if ((groupHT = (Hashtable)this.ivErgebnisHashmap.get(group)) == null) continue;
                ergebnisHM.put(group, groupHT);
                HashMap alleNeuen = (HashMap)this.ivErgebnisHashmap.get("#sno");
                if (alleNeuen == null || (hm = (HashMap)alleNeuen.get(group)) == null) continue;
                HashMap<String, HashMap> groupNeue = (HashMap<String, HashMap>)ergebnisHM.get("#sno");
                if (groupNeue == null) {
                    groupNeue = new HashMap<String, HashMap>();
                    ergebnisHM.put("#sno", groupNeue);
                }
                groupNeue.put(group, hm);
            }
            if (nor == null || sc == null) continue;
            if (Log.shouldLog(0)) {
                Log.subdebug("Sending update information to " + sc.toString(), this);
            }
            try {
                sc.sendObjectAndUR(nor, true);
            }
            catch (Throwable e) {
                Log.error("Problem sending update information to " + sc.toString(), e, this);
            }
            if (!Log.shouldLog(0)) continue;
            Log.subdebug("Finished sending update information to " + sc.toString(), this);
        }
    }
}

