/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IdentifiableObject;
import de.hannse.netobjects.objectstore.LifeStateReporter;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectManagerCache;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.extras.StrInflDefl;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.util.InstallationType;

public abstract class IDObject
implements Serializable,
LifeStateReporter,
Comparable,
IdentifiableObject {
    private static final long serialVersionUID = -2740719063105921963L;
    private static final boolean CHECK_SET = true;
    private static final String VALUE_SEP = "'";
    public static final char VALUE_SEP_CHAR = '\'';
    public static final String IDENTIFIER_SEPARATOR = "|";
    public static final char IDENTIFIER_SEPARATOR_CHAR = '|';
    public static final String SPACE = " ";
    public static final String ASCII_RETURN = "\n";
    private static final String ASCII_TAIL = "END";
    public static final String BROWSER_TRENNER = " = ";
    public static final String SERVICE_PREFIX = "[S] ";
    public static final int T_MOUSE = 1;
    public static final int T_CAGE = 2;
    public static final int T_RACK = 3;
    public static final int T_MATING = 4;
    public static final int T_SESSION = 5;
    public static final int T_USER = 6;
    public static final int T_LINE = 7;
    public static final int T_STRAIN = 8;
    public static final int T_VISIT = 9;
    public static final int T_ROOM = 10;
    public static final int T_MAIL = 11;
    public static final int T_EXPERIMENT = 12;
    public static final int T_RESULT = 13;
    public static final int T_LOCUS = 14;
    public static final int T_TASK = 15;
    public static final int T_LICENSE = 16;
    public static final int T_STANDARD_TASK = 17;
    public static final int T_USER_GROUP = 18;
    public static final int T_IDOBJECT_GROUP = 19;
    public static final int T_OWNER_GROUP = 20;
    public static final int T_MOUSE_COHORT = 21;
    public static final int T_BUILDING = 22;
    public static final int T_TG_JOB = 23;
    public static final int T_TRAFFIC_REPORT_LINE = 24;
    public static final int MAX_TYP = 50;
    public static final int[] SHAREABLE_TYPES = new int[]{3, 10, 7, 8, 14, 16};
    public static final int SUBTYP_UNKNOWN = 0;
    public static final int SUBTYP_OWNER_GROUP = 1;
    public static final int SUBTYP_MOUSE_COHORT = 2;
    private static final String F_Mouse = "mice";
    private static final String F_Cage = "cages";
    private static final String F_Rack = "racks";
    private static final String F_Wedding = "weddings";
    private static final String F_Session = "sessions";
    private static final String F_User = "user";
    private static final String F_Line = "lines";
    private static final String F_Strain = "strains";
    private static final String F_Room = "rooms";
    private static final String F_Mail = "mail";
    private static final String F_Experiment = "experiments";
    private static final String F_Result = "results";
    private static final String F_Locus = "loci";
    private static final String F_Task = "tasks";
    private static final String F_License = "licenses";
    private static final String F_StandardTask = "stdtasks";
    private static final String F_UserGroup = "usergroup";
    private static final String F_IDObjectGroup = "idobjectgroup";
    private static final String F_OwnerGroup = "ownergroup";
    private static final String F_MouseCohort = "mousecohort";
    private static final String F_Building = "building";
    private static final String F_TGJob = "tgjobs";
    private static final String F_TrafficReportLine = "trafficreportline";
    public static final String F_SS_CAGE = "cage";
    public static final String F_SS_MOUSE = "mouse";
    public static final String F_SS_RACK = "rack";
    public static final String F_SS_SESSION = "session";
    public static final String F_SS_USER = "user";
    public static final String F_SS_ROOM = "room";
    public static final String F_SS_LINE = "line";
    public static final String F_SS_LOCUS = "loci";
    public static final String F_SS_STRAIN = "strain";
    public static final String F_SS_MAIL = "mail";
    public static final String F_SS_EXPERIMENT = "experiments";
    public static final String F_SS_RESULT = "results";
    public static final String F_SS_LICENSE = "license";
    public static final String F_SS_IDOBJECT_GROUP = "idobjectgroup";
    public static final String F_SS_BUILDING = "building";
    public static final String F_SS_TG_JOB = "tgjobs";
    public static final String F_SS_TRAFFIC_REPORT_LINE = "trafficreportline";
    private static final String L_Mouse = "MOUSE";
    private static final String L_Cage = "CAGE";
    private static final String L_Rack = "RACK";
    private static final String L_Wedding = "WEDDING";
    private static final String L_Session = "SESSION";
    private static final String L_User = "USER";
    private static final String L_Line = "LINE";
    private static final String L_Strain = "STRAIN";
    private static final String L_Room = "ROOM";
    private static final String L_Mail = "MAIL";
    private static final String L_Experiment = "EXPERIMENT";
    private static final String L_Result = "RESULT";
    private static final String L_Locus = "LOCUS";
    private static final String L_Task = "TASK";
    private static final String L_License = "LICENSE";
    private static final String L_StandardTask = "STDTASK";
    private static final String L_UserGroup = "USERGROUP";
    private static final String L_IDObjectGroup = "IDOBJECTGROUP";
    private static final String L_OwnerGroup = "OWNERGROUP";
    private static final String L_MouseCohort = "MOUSECOHORT";
    private static final String L_Building = "BUILDING";
    private static final String L_TGJob = "TGJOB";
    private static final String L_TrafficReportLine = "TRAFFICREPORTLINE";
    public static final String C_Mouse;
    public static final String C_Cage;
    public static final String C_Rack;
    public static final String C_Wedding;
    public static final String C_Session;
    public static final String C_User;
    public static final String C_Line;
    public static final String C_Strain;
    public static final String C_Room;
    public static final String C_Mail;
    public static final String C_Experiment;
    public static final String C_Result;
    public static final String C_Locus;
    public static final String C_Task;
    public static final String C_License;
    public static final String C_StandardTask;
    public static final String C_UserGroup;
    public static final String C_IDObjectGroup;
    public static final String C_OwnerGroup;
    public static final String C_MouseCohort;
    public static final String C_Building;
    public static final String C_TGJob;
    public static final String C_TrafficReportLine;
    public static final String PREFIX = "IDO_";
    public static final String ID = "IDO_ID";
    public static final String TYPE_ID = "IDO_TYPE_ID";
    public static final String GROUP = "IDO_GROUP";
    public static final String START = "IDO_START_DATE";
    public static final String END = "IDO_END_DATE";
    public static final String VERSION = "IDO_VERSION";
    public static final String UNIQUELONG = "IDO_UNIQUELONG";
    public static final String NEVER_EXISTED = "IDO_NEVER_EXISTED";
    public static final String VISIBLE = "IDO_VISIBLE";
    public static final String TAG_SESSIONS = "IDO_SESS";
    public static final String ORIGINAL_GROUP = "IDO_OGROUP";
    public static final String FOREIGN_KEY = "IDO_FKEY";
    public static final String DOKUMENTE = "IDO_DOK";
    public static final String SERVICE_ID = "IDO_SERVID";
    public static final String USER_GROUPS = "IDO_UGROUPS";
    public static final String USER_GROUP_IDS = "IDO_UGROUPIDS";
    public static final String SUB_TYPE = "IDO_SUBTYP";
    public static final int DOCU_COL_KENNUNG = 0;
    public static final int DOCU_COL_FILENAME = 1;
    public static final int DOCU_COL_FILEDATE = 2;
    public static final int DOCU_COL_UPLOADDATE = 3;
    public static final int DOCU_COL_FILESIZE = 4;
    public static final String[] ATTRIBUTES;
    public static final String[] ORDERED_ATTRIBUTES;
    private static final transient Class[] CLASSES_BY_TYPE;
    private static final transient String[] LABELS_BY_TYPE;
    private static final transient String[] FILENAMES_BY_TYPE_CLIENT_SIDE;
    private static final transient HashMap ALLOWED_ATTRIBUTES;
    public static final transient HashMap TRANSFER_KEY_ARRAYS;
    public static final transient HashMap TRANSFER_INTERPRETER_ARRAYS;
    private static final transient String[] FILENAMES_BY_TYPE_SERVER_SIDE;
    private static final transient HashSet DONT_COPY_TO_SUBS;
    public static Comparator SORTER_BY_NAME;
    public Hashtable ivProperties = new Hashtable();
    public transient Hashtable ivPropertyMask = null;
    private final transient TreeSet ivSessions = ProcessDefinition.isClient() ? null : new TreeSet();
    private transient String ivIdentifier = null;
    public boolean ivIsNew = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Mouse = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("mausoleum.cage.Cage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Cage = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("mausoleum.rack.Rack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Rack = clazz3.getName();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("mausoleum.wedding.Wedding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Wedding = clazz4.getName();
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("de.hannse.netobjects.session.Session");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Session = clazz5.getName();
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("de.hannse.netobjects.user.User");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_User = clazz6.getName();
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("mausoleum.line.Line");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Line = clazz7.getName();
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("mausoleum.strain.Strain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Strain = clazz8.getName();
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("mausoleum.room.Room");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Room = clazz9.getName();
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("mausoleum.mail.Mail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Mail = clazz10.getName();
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("mausoleum.experiment.Experiment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Experiment = clazz11.getName();
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("mausoleum.result.Result");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Result = clazz12.getName();
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("mausoleum.locus.Locus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Locus = clazz13.getName();
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("mausoleum.task.DisplayTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Task = clazz14.getName();
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("mausoleum.license.License");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_License = clazz15.getName();
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("mausoleum.task.standards.StandardTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_StandardTask = clazz16.getName();
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("mausoleum.usergroup.UserGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_UserGroup = clazz17.getName();
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("mausoleum.idobjectgroup.IDObjectGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_IDObjectGroup = clazz18.getName();
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("mausoleum.idobjectgroup.OwnerGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_OwnerGroup = clazz19.getName();
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("mausoleum.idobjectgroup.MouseCohort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_MouseCohort = clazz20.getName();
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("mausoleum.building.Building");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_Building = clazz21.getName();
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("mausoleum.tgjob.TGJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_TGJob = clazz22.getName();
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("mausoleum.reports.TrafficReportLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        C_TrafficReportLine = clazz23.getName();
        String[] stringArray = new String[32];
        stringArray[0] = ID;
        Class<?> clazz24 = class$23;
        if (clazz24 == null) {
            try {
                clazz24 = class$23 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz24.getName();
        stringArray[2] = TYPE_ID;
        Class<?> clazz25 = class$24;
        if (clazz25 == null) {
            try {
                clazz25 = class$24 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz25.getName();
        stringArray[4] = GROUP;
        Class<?> clazz26 = class$25;
        if (clazz26 == null) {
            try {
                clazz26 = class$25 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz26.getName();
        stringArray[6] = START;
        Class<?> clazz27 = class$26;
        if (clazz27 == null) {
            try {
                clazz27 = class$26 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz27.getName();
        stringArray[8] = END;
        Class<?> clazz28 = class$26;
        if (clazz28 == null) {
            try {
                clazz28 = class$26 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz28.getName();
        stringArray[10] = VERSION;
        Class<?> clazz29 = class$24;
        if (clazz29 == null) {
            try {
                clazz29 = class$24 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz29.getName();
        stringArray[12] = UNIQUELONG;
        Class<?> clazz30 = class$23;
        if (clazz30 == null) {
            try {
                clazz30 = class$23 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz30.getName();
        stringArray[14] = VISIBLE;
        Class<?> clazz31 = class$27;
        if (clazz31 == null) {
            try {
                clazz31 = class$27 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz31.getName();
        stringArray[16] = NEVER_EXISTED;
        Class<?> clazz32 = class$27;
        if (clazz32 == null) {
            try {
                clazz32 = class$27 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz32.getName();
        stringArray[18] = ORIGINAL_GROUP;
        Class<?> clazz33 = class$25;
        if (clazz33 == null) {
            try {
                clazz33 = class$25 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz33.getName();
        stringArray[20] = FOREIGN_KEY;
        Class<?> clazz34 = class$25;
        if (clazz34 == null) {
            try {
                clazz34 = class$25 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz34.getName();
        stringArray[22] = DOKUMENTE;
        Class<?> clazz35 = class$25;
        if (clazz35 == null) {
            try {
                clazz35 = class$25 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz35.getName();
        stringArray[24] = SERVICE_ID;
        Class<?> clazz36 = class$23;
        if (clazz36 == null) {
            try {
                clazz36 = class$23 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[25] = clazz36.getName();
        stringArray[26] = USER_GROUPS;
        Class<?> clazz37 = class$28;
        if (clazz37 == null) {
            try {
                clazz37 = class$28 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[27] = clazz37.getName();
        stringArray[28] = USER_GROUP_IDS;
        Class<?> clazz38 = class$29;
        if (clazz38 == null) {
            try {
                clazz38 = class$29 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[29] = clazz38.getName();
        stringArray[30] = SUB_TYPE;
        Class<?> clazz39 = class$24;
        if (clazz39 == null) {
            try {
                clazz39 = class$24 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[31] = clazz39.getName();
        ATTRIBUTES = stringArray;
        ORDERED_ATTRIBUTES = new String[]{ID, START, END, VERSION, UNIQUELONG, VISIBLE, NEVER_EXISTED, ORIGINAL_GROUP, FOREIGN_KEY, DOKUMENTE, SERVICE_ID, USER_GROUPS, USER_GROUP_IDS, SUB_TYPE};
        CLASSES_BY_TYPE = new Class[50];
        LABELS_BY_TYPE = new String[50];
        FILENAMES_BY_TYPE_CLIENT_SIDE = new String[50];
        ALLOWED_ATTRIBUTES = new HashMap();
        TRANSFER_KEY_ARRAYS = new HashMap();
        TRANSFER_INTERPRETER_ARRAYS = new HashMap();
        FILENAMES_BY_TYPE_SERVER_SIDE = new String[50];
        DONT_COPY_TO_SUBS = new HashSet();
        SORTER_BY_NAME = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof IDObject && arg1 instanceof IDObject) {
                    IDObject io0 = (IDObject)arg0;
                    IDObject io1 = (IDObject)arg1;
                    return io0.getBrowseName().compareToIgnoreCase(io1.getBrowseName());
                }
                return 0;
            }
        };
        try {
            TreeMap allowedAttributes = new TreeMap();
            int i = 0;
            while (i < ATTRIBUTES.length) {
                allowedAttributes.put(ATTRIBUTES[i], Class.forName(ATTRIBUTES[i + 1]));
                i += 2;
            }
            ALLOWED_ATTRIBUTES.put(Class.forName("de.hannse.netobjects.objectstore.IDObject"), allowedAttributes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[2] = F_SS_CAGE;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[1] = F_SS_MOUSE;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[3] = F_SS_RACK;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[5] = F_SS_SESSION;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[6] = "user";
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[10] = F_SS_ROOM;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[7] = F_SS_LINE;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[14] = "loci";
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[8] = F_SS_STRAIN;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[11] = "mail";
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[12] = "experiments";
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[16] = F_SS_LICENSE;
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[19] = "idobjectgroup";
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[22] = "building";
        if (InstallationType.hasTGMode()) {
            IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[23] = "tgjobs";
        }
        IDObject.FILENAMES_BY_TYPE_SERVER_SIDE[13] = "results";
        DONT_COPY_TO_SUBS.add(ID);
        DONT_COPY_TO_SUBS.add(TYPE_ID);
        DONT_COPY_TO_SUBS.add(GROUP);
        DONT_COPY_TO_SUBS.add(START);
        DONT_COPY_TO_SUBS.add(VERSION);
        DONT_COPY_TO_SUBS.add(UNIQUELONG);
        DONT_COPY_TO_SUBS.add(FOREIGN_KEY);
        DONT_COPY_TO_SUBS.add(SERVICE_ID);
        DONT_COPY_TO_SUBS.add(USER_GROUPS);
        DONT_COPY_TO_SUBS.add(USER_GROUP_IDS);
        DONT_COPY_TO_SUBS.add("LIN_ENTERER");
        DONT_COPY_TO_SUBS.add("LOC_ENTERER");
        DONT_COPY_TO_SUBS.add("STR_ENTERER");
        DONT_COPY_TO_SUBS.add("LIC_UI");
        DONT_COPY_TO_SUBS.add(DOKUMENTE);
    }

    public static void init() {
        boolean res = true;
        res &= IDObject.enter(5, L_Session, C_Session, F_Session);
        res &= IDObject.enter(6, L_User, C_User, "user");
        res &= IDObject.enter(1, L_Mouse, C_Mouse, F_Mouse);
        res &= IDObject.enter(2, L_Cage, C_Cage, F_Cage);
        res &= IDObject.enter(3, L_Rack, C_Rack, F_Rack);
        if (InstallationType.useMatings()) {
            res &= IDObject.enter(4, L_Wedding, C_Wedding, F_Wedding);
        }
        res &= IDObject.enter(7, L_Line, C_Line, F_Line);
        res &= IDObject.enter(8, L_Strain, C_Strain, F_Strain);
        res &= IDObject.enter(10, L_Room, C_Room, F_Room);
        res &= IDObject.enter(11, L_Mail, C_Mail, "mail");
        res &= IDObject.enter(12, L_Experiment, C_Experiment, "experiments");
        res &= IDObject.enter(13, L_Result, C_Result, "results");
        res &= IDObject.enter(14, L_Locus, C_Locus, "loci");
        res &= IDObject.enter(15, L_Task, C_Task, F_Task);
        res &= IDObject.enter(16, L_License, C_License, F_License);
        res &= IDObject.enter(17, L_StandardTask, C_StandardTask, F_StandardTask);
        res &= IDObject.enter(18, L_UserGroup, C_UserGroup, F_UserGroup);
        res &= IDObject.enter(19, L_IDObjectGroup, C_IDObjectGroup, "idobjectgroup");
        res &= IDObject.enter(20, L_OwnerGroup, C_OwnerGroup, F_OwnerGroup);
        res &= IDObject.enter(21, L_MouseCohort, C_MouseCohort, F_MouseCohort);
        res &= IDObject.enter(22, L_Building, C_Building, "building");
        res &= IDObject.enter(24, L_TrafficReportLine, C_TrafficReportLine, "trafficreportline");
        if (InstallationType.hasTGMode()) {
            res &= IDObject.enter(23, L_TGJob, C_TGJob, "tgjobs");
        }
        if (!res) {
            Class<?> clazz = class$30;
            if (clazz == null) {
                try {
                    clazz = class$30 = Class.forName("de.hannse.netobjects.objectstore.IDObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problematic definitions in IDObjects. Shutting down server", null, clazz);
            System.exit(1);
        }
    }

    public static String[] getTransportKeys(int type) {
        Class acl = CLASSES_BY_TYPE[type];
        return acl != null ? (String[])TRANSFER_KEY_ARRAYS.get(acl) : null;
    }

    public static IDObjectXMLHandler.IOXInterpret[] getTransportInterpreters(int type) {
        Class acl = CLASSES_BY_TYPE[type];
        return acl != null ? (IDObjectXMLHandler.IOXInterpret[])TRANSFER_INTERPRETER_ARRAYS.get(acl) : null;
    }

    public static String getASCIILabelForType(int type) {
        return LABELS_BY_TYPE[type];
    }

    public static void splitInObjectDumps(Vector in, Vector out) {
        if (in != null && !in.isEmpty()) {
            Vector<String> tout = new Vector<String>();
            int i = 0;
            while (i < in.size()) {
                String ts = (String)in.elementAt(i);
                if (ts.startsWith(ASCII_TAIL)) {
                    tout.addElement(ts);
                    out.addElement(tout);
                    tout = new Vector();
                } else {
                    tout.addElement(ts);
                }
                ++i;
            }
        }
    }

    public static HashMap combineIDObjectCollections(Collection[] collarr) {
        HashMap<Object, IDObject> erg = new HashMap<Object, IDObject>();
        int i = 0;
        while (i < collarr.length) {
            Iterator iter = collarr[i].iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                erg.put(ido.get(ID), ido);
            }
            ++i;
        }
        return erg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String commonGroup(Vector idObjects) {
        String commonGroup = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            try {
                Iterator iter = idObjects.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        return commonGroup;
                    }
                    IDObject iob = (IDObject)iter.next();
                    String group = iob.getGroup();
                    if (group == null) {
                        return null;
                    }
                    if (commonGroup == null) {
                        commonGroup = group;
                        continue;
                    }
                    if (!commonGroup.equals(group)) break;
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return commonGroup;
    }

    public static boolean touchable(Vector idObjects) {
        if (idObjects != null && !idObjects.isEmpty()) {
            Object ooo = idObjects.firstElement();
            if (ooo instanceof Mouse) {
                return Mouse.areMiceTouchable(idObjects);
            }
            if (ooo instanceof Cage) {
                return Cage.areCagesTouchable(idObjects);
            }
            return true;
        }
        return false;
    }

    public static HashMap sortByGroup(Vector idObjects) {
        HashMap<String, Vector<IDObject>> res = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            res = new HashMap<String, Vector<IDObject>>();
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                String group = ido.getGroup(null);
                if (group == null) continue;
                Vector<IDObject> v = (Vector<IDObject>)res.get(group);
                if (v == null) {
                    v = new Vector<IDObject>();
                    res.put(group, v);
                }
                v.add(ido);
            }
            if (res.isEmpty()) {
                res = null;
            }
        }
        return res;
    }

    public static long getCommonMouseRefID(Vector v, String tag, long unsetVal, long multipleVal) {
        if (v != null && !v.isEmpty()) {
            HashSet<Long> hs = new HashSet<Long>();
            int i = 0;
            while (i < v.size()) {
                IDObject mausi = (IDObject)v.elementAt(i);
                Long key = new Long(mausi.getLong(tag, -1L));
                hs.add(key);
                ++i;
            }
            if (!hs.isEmpty()) {
                if (hs.size() == 1) {
                    Long longi = (Long)hs.iterator().next();
                    if (longi != -1L) {
                        return longi;
                    }
                } else {
                    return multipleVal;
                }
            }
        }
        return unsetVal;
    }

    public static void handleLongToArr(IDObject obi, String tag, long id, boolean addIt) {
        long[] neuArr = null;
        long[] altArr = (long[])obi.get(tag);
        if (altArr == null) {
            if (addIt) {
                neuArr = new long[]{id};
            }
        } else {
            HashSet<Long> hs = new HashSet<Long>();
            int i = 0;
            while (i < altArr.length) {
                hs.add(new Long(altArr[i]));
                ++i;
            }
            if (addIt) {
                hs.add(new Long(id));
            } else {
                hs.remove(new Long(id));
            }
            if (!hs.isEmpty()) {
                neuArr = new long[hs.size()];
                int pos = 0;
                Iterator iter = hs.iterator();
                while (iter.hasNext()) {
                    Long longi = (Long)iter.next();
                    neuArr[pos++] = longi;
                }
            }
        }
        obi.set(tag, neuArr);
    }

    public static int getCommonIntValue(Vector idobjects, String tag, int nullValue, int errorValue) {
        int tmpValue = nullValue;
        if (idobjects != null && !idobjects.isEmpty()) {
            boolean first = true;
            Iterator iter = idobjects.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                if (first) {
                    tmpValue = ido.getInt(tag, nullValue);
                    first = false;
                    continue;
                }
                if (tmpValue == ido.getInt(tag, nullValue)) continue;
                return errorValue;
            }
        }
        return tmpValue;
    }

    public static int getCommonIntValueFrommArray(Vector idobjects, String tag, int arrPos, int nullValue, int errorValue) {
        int tmpValue = nullValue;
        if (idobjects != null && !idobjects.isEmpty()) {
            boolean first = true;
            Iterator iter = idobjects.iterator();
            while (iter.hasNext()) {
                int val;
                IDObject ido = (IDObject)iter.next();
                int[] arr = (int[])ido.get(tag);
                int n = val = arr == null ? nullValue : arr[arrPos];
                if (first) {
                    tmpValue = val;
                    first = false;
                    continue;
                }
                if (tmpValue == val) continue;
                return errorValue;
            }
        }
        return tmpValue;
    }

    public static IDObject initObjectFromTransport(Integer type, String group, String transport) {
        return IDObject.initObjectFromTransport(type, group, transport, null, null, false);
    }

    public static IDObject initObjectFromTransport(Integer type, String group, String transport, String[] keys, IDObjectXMLHandler.IOXInterpret[] interpreters, boolean tagsPresent) {
        IDObject res = IDObject.giveNewObjectOfType(type);
        if (res != null) {
            res.ivProperties.put(GROUP, group);
            res.ivProperties.put(TYPE_ID, type);
            Zeile z = null;
            z = transport.contains(VALUE_SEP) ? new Zeile(transport, '\'') : new Zeile(StrInflDefl.inflate(transport), '\'');
            String[] stringArray = keys = keys != null ? keys : (String[])TRANSFER_KEY_ARRAYS.get(res.getClass());
            if (!tagsPresent) {
                IDObjectXMLHandler.IOXInterpret[] iOXInterpretArray = interpreters = interpreters != null ? interpreters : (IDObjectXMLHandler.IOXInterpret[])TRANSFER_INTERPRETER_ARRAYS.get(res.getClass());
            }
            if (keys != null && keys.length == z.size()) {
                int i = 0;
                while (i < keys.length) {
                    String s = z.getStringNONEmptyWithoutTrim(i, null);
                    if (s != null) {
                        if (tagsPresent) {
                            res.ivProperties.put(keys[i], IDObjectXMLHandler.getObject(s, group, false));
                        } else {
                            res.ivProperties.put(keys[i], interpreters[i].holObject(s, group));
                        }
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    public static boolean nonEmptyAndAllActiveAndChangeable(Vector idObjects) {
        Iterator iter;
        if (idObjects != null && !idObjects.isEmpty() && (iter = idObjects.iterator()).hasNext()) {
            IDObject iog = (IDObject)iter.next();
            return iog.isAliveAndVisible() && iog.mayAttributeBeChangedByCommand();
        }
        return false;
    }

    public static boolean nonEmptyAndAllChangeable(Vector idObjects) {
        Iterator iter;
        if (idObjects != null && !idObjects.isEmpty() && (iter = idObjects.iterator()).hasNext()) {
            IDObject iog = (IDObject)iter.next();
            return iog.mayAttributeBeChangedByCommand();
        }
        return false;
    }

    public static boolean allActive(Vector idObjects) {
        Iterator iter;
        if (idObjects != null && !idObjects.isEmpty() && (iter = idObjects.iterator()).hasNext()) {
            IDObject iog = (IDObject)iter.next();
            return iog.isAliveAndVisible();
        }
        return false;
    }

    public String getAttributeKeyDeclaration() {
        return IDObject.getAttributeKeyDeclaration((String[])TRANSFER_KEY_ARRAYS.get(this.getClass()), true);
    }

    public static String getAttributeKeyDeclaration(String[] keys, boolean withReturn) {
        if (keys != null) {
            StringBuilder msb = new StringBuilder();
            int i = 0;
            while (i < keys.length) {
                if (i != 0) {
                    msb.append(ObjectManagerCache.MAIN_SEP);
                }
                msb.append(keys[i]);
                ++i;
            }
            if (withReturn) {
                msb.append(ASCII_RETURN);
            }
            return msb.toString();
        }
        return null;
    }

    public String getCacheString() {
        StringBuilder msb = new StringBuilder(1000);
        this.appendCacheString(msb, true, null, null);
        return msb.toString();
    }

    public void appendCacheString(StringBuilder msb, boolean mitNL, StringBuilder inflSB, StringBuilder indexSB) {
        msb.append(this.getID()).append(ObjectManagerCache.MAIN_SEP);
        msb.append(this.getInt(VERSION)).append(ObjectManagerCache.MAIN_SEP);
        msb.append(this.isAlive() ? "1" : "0").append(ObjectManagerCache.MAIN_SEP);
        if (indexSB != null) {
            indexSB.append(msb.toString());
        }
        if (inflSB != null) {
            inflSB.setLength(0);
            this.appendValueString(inflSB);
            msb.append(StrInflDefl.deflate(inflSB.toString()));
        } else {
            this.appendValueString(msb);
        }
        if (mitNL) {
            msb.append(ASCII_RETURN);
        }
    }

    public String getValueString() {
        StringBuilder msb = new StringBuilder(1000);
        this.appendValueString(msb);
        return msb.toString();
    }

    public void appendValueString(StringBuilder msb) {
        String[] keys = (String[])TRANSFER_KEY_ARRAYS.get(this.getClass());
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                Object o;
                if (i != 0) {
                    msb.append(VALUE_SEP);
                }
                if ((o = this.ivProperties.get(keys[i])) != null) {
                    msb.append(IDObjectXMLHandler.getTransport(o, false, false));
                }
                ++i;
            }
        }
    }

    public static String getIdentifierString(String group, int typeID, long id) {
        StringBuilder msb = new StringBuilder(group);
        msb.append(IDENTIFIER_SEPARATOR).append(typeID).append(IDENTIFIER_SEPARATOR).append(id);
        return msb.toString();
    }

    public static Class getClassForType(int type) {
        return CLASSES_BY_TYPE[type];
    }

    public static int getTypeByClass(Class theClass, int defVal) {
        if (theClass != null) {
            int i = 0;
            while (i < CLASSES_BY_TYPE.length) {
                if (theClass.equals(CLASSES_BY_TYPE[i])) {
                    return i;
                }
                ++i;
            }
        }
        return defVal;
    }

    public static Integer getTypeByClass(Class theClass) {
        int clbt = IDObject.getTypeByClass(theClass, -1);
        return clbt == -1 ? null : new Integer(clbt);
    }

    public static IDObject giveNewObjectOfType(int type) {
        Class cl = CLASSES_BY_TYPE[type];
        if (cl != null) {
            try {
                return (IDObject)cl.newInstance();
            }
            catch (Exception e) {
                String string = "Problem creating new IDObject of type " + type;
                Class<?> clazz = class$30;
                if (clazz == null) {
                    try {
                        clazz = class$30 = Class.forName("de.hannse.netobjects.objectstore.IDObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return null;
    }

    public static String getFilenameForTypeClientSide(int type) {
        return FILENAMES_BY_TYPE_CLIENT_SIDE[type];
    }

    public static String[] getFilenamesForTypeServerSide() {
        return FILENAMES_BY_TYPE_SERVER_SIDE;
    }

    public static String getFilenameForTypeServerSide(int type) {
        return FILENAMES_BY_TYPE_SERVER_SIDE[type];
    }

    public static int getTypeForStringServerSide(String s) {
        if (s != null) {
            int i = 0;
            while (i < FILENAMES_BY_TYPE_SERVER_SIDE.length) {
                if (s.equals(FILENAMES_BY_TYPE_SERVER_SIDE[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static long getMinimalID(int type, String group) {
        if (type == 12 && "service".equals(group)) {
            return 5000L;
        }
        return 0L;
    }

    private static boolean enter(int type, String label, String startClassName, String filename) {
        IDObject.LABELS_BY_TYPE[type] = label;
        IDObject.FILENAMES_BY_TYPE_CLIENT_SIDE[type] = filename;
        try {
            Class<?> startClass;
            IDObject.CLASSES_BY_TYPE[type] = startClass = Class.forName(startClassName);
            TreeMap allowedAttributes = new TreeMap();
            HashMap marksForAttribut = new HashMap();
            String[] orderedKeys = IDObject.fillAllowedsAndFindOrdered(allowedAttributes, marksForAttribut, startClass, type);
            if (orderedKeys != null) {
                IDObjectXMLHandler.IOXInterpret[] allowedInterprets = new IDObjectXMLHandler.IOXInterpret[allowedAttributes.keySet().size() - 2];
                int pos = 0;
                while (pos < orderedKeys.length) {
                    allowedInterprets[pos] = IDObjectXMLHandler.getInterpreter((String)marksForAttribut.get(orderedKeys[pos]));
                    ++pos;
                }
                TRANSFER_KEY_ARRAYS.put(startClass, orderedKeys);
                ALLOWED_ATTRIBUTES.put(startClass, allowedAttributes);
                TRANSFER_INTERPRETER_ARRAYS.put(startClass, allowedInterprets);
                return true;
            }
        }
        catch (Exception e) {
            String string = "Problem while entering type " + type + " and class: " + startClassName;
            Class<?> clazz = class$30;
            if (clazz == null) {
                try {
                    clazz = class$30 = Class.forName("de.hannse.netobjects.objectstore.IDObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
        return false;
    }

    public static String[] fillAllowedsAndFindOrdered(TreeMap allowedAttributes, HashMap marksForAttribut, Class startClass, int type) {
        String[] ordereds = null;
        Class runningClass = startClass;
        try {
            while (!runningClass.getName().equals("java.lang.Object")) {
                Field[] farr = runningClass.getDeclaredFields();
                if (farr != null) {
                    int fi = 0;
                    while (fi < farr.length) {
                        if (farr[fi].getName().startsWith("ATTRIBUTES")) {
                            String[] eattributes = (String[])farr[fi].get(null);
                            int i = 0;
                            while (i < eattributes.length) {
                                String classID = eattributes[i + 1];
                                allowedAttributes.put(eattributes[i], Class.forName(classID));
                                String mark = IDObjectXMLHandler.getMarkByClassSTring(classID);
                                if (mark == null) {
                                    if (type != 13) {
                                        Log.error("IDObject missing transport mark for  " + startClass.getName() + " attribute: " + eattributes[i] + " cid: " + classID, null, startClass);
                                    }
                                } else {
                                    marksForAttribut.put(eattributes[i], mark);
                                }
                                i += 2;
                            }
                        } else if (ordereds == null && farr[fi].getName().startsWith("ORDERED_ATTRIBUTES")) {
                            ordereds = (String[])farr[fi].get(null);
                        }
                        ++fi;
                    }
                }
                runningClass = runningClass.getSuperclass();
            }
        }
        catch (Exception nsfe) {
            Log.error("IDObject Exception at getAllowedAttributesForClass " + startClass.getName(), nsfe, startClass);
        }
        boolean hasErrors = false;
        if (ordereds != null) {
            if (ordereds.length != allowedAttributes.size() - 2) {
                Log.error("Length of ordered array does not match allowed attributes", null, startClass);
                hasErrors = true;
            }
            Iterator iterator = allowedAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (key.equals(TYPE_ID) || key.equals(GROUP) || StringHelper.isIn(key, ordereds, true)) continue;
                Log.error("Attribute >" + key + "< is not defined in ordered array", null, startClass);
                hasErrors = true;
            }
            int j = 0;
            while (j < ordereds.length) {
                if (!allowedAttributes.containsKey(ordereds[j])) {
                    Log.error("Undefined attribute >" + ordereds[j] + "< in ordered array", null, startClass);
                    hasErrors = true;
                } else if (ordereds[j].equals(GROUP)) {
                    Log.error("Attribute >" + ordereds[j] + "< should not be defined in ordered array", null, startClass);
                    hasErrors = true;
                } else if (ordereds[j].equals(TYPE_ID)) {
                    Log.error("Attribute >" + ordereds[j] + "< should not be defined in ordered array", null, startClass);
                    hasErrors = true;
                }
                ++j;
            }
        } else {
            Log.error("Missing ordered attribute definition", null, startClass);
            hasErrors = true;
        }
        return hasErrors ? null : ordereds;
    }

    public IDObject() {
        Integer typeid = IDObject.getTypeByClass(this.getClass());
        if (typeid != null) {
            this.ivProperties.put(TYPE_ID, typeid);
        }
        this.ivProperties.put(VERSION, new Integer(1));
    }

    public void dispose() {
        if (this.ivProperties != null) {
            this.ivProperties.clear();
            this.ivProperties = null;
        }
        if (this.ivPropertyMask != null) {
            this.ivPropertyMask.clear();
            this.ivPropertyMask = null;
        }
        if (this.ivSessions != null) {
            this.ivSessions.clear();
        }
        this.ivIdentifier = null;
    }

    public String getName() {
        return null;
    }

    public String getFactSheetName(boolean withType) {
        String name;
        StringBuilder msb = new StringBuilder();
        if (withType) {
            msb.append(Babel.get(IDObject.getASCIILabelForType(this.getTyp()))).append(SPACE);
        }
        if ((name = this.getName()) == null) {
            msb.append("[ID: ").append(this.getID()).append("]");
        } else {
            msb.append(name);
        }
        return msb.toString();
    }

    public String getTaskKey() {
        return null;
    }

    public static boolean canSitInRoom(int type) {
        return type == 1 || type == 2 || type == 3;
    }

    public boolean canSitInRoom() {
        return false;
    }

    public static boolean storesSession(int type, String group) {
        if (type == 3) {
            return "service".equals(group);
        }
        return type != 5;
    }

    public boolean storesSession() {
        return IDObject.storesSession(this.getInt(TYPE_ID), this.getGroup());
    }

    public Long getServiceRoomID() {
        return null;
    }

    public String getBrowseName() {
        return "IDObject " + this.getID();
    }

    public String getBrowseNameInclServicePrefix() {
        return String.valueOf(this.isSharedWithOtherGroups() ? SERVICE_PREFIX : "") + this.getBrowseName();
    }

    public String getBrowseNameWITHOUTServicePrefix() {
        String s = this.getBrowseName();
        if (s.startsWith(SERVICE_PREFIX)) {
            s = s.substring(SERVICE_PREFIX.length(), s.length()).trim();
        }
        return s;
    }

    public String getNonNullName() {
        String s = this.getName();
        if (s == null && (s = this.getBrowseName()) == null) {
            s = String.valueOf(this.getClass().getName()) + SPACE + this.getID();
        }
        return s;
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        Date end;
        target.add("Type = " + IDObject.getASCIILabelForType(this.getTyp()));
        target.add("ID = " + this.getLong(ID));
        Date start = this.getDate(START);
        if (start != null) {
            target.add("Start = " + DatumFormat.getDateTimeString(start.getTime()));
        }
        if ((end = this.getDate(END)) != null) {
            target.add("End = " + DatumFormat.getDateTimeString(end.getTime()));
        }
        target.add("Version = " + this.getInt(VERSION));
    }

    public void setSessions(TreeSet ts) {
        if (this.ivSessions != null) {
            this.ivSessions.clear();
            if (ts != null) {
                this.ivSessions.addAll(ts);
            }
        }
    }

    public TreeSet getSessions() {
        return this.ivSessions;
    }

    public void addSession(Long sid) {
        if (this.ivSessions != null && sid != null) {
            this.ivSessions.add(sid);
        }
    }

    public void afterInit() {
    }

    public HashMap getPropertiesHM() {
        HashMap hm = new HashMap(this.ivProperties.size() + 10);
        Iterator iter = this.ivProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            hm.put(key, this.ivProperties.get(key));
        }
        return hm;
    }

    public void setValues(HashMap hm) {
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object val = hm.get(key);
            this.set(key, val);
        }
        this.commit(false);
    }

    public void setValuesWithoutCommit(HashMap hm) {
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object val = hm.get(key);
            this.set(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object val) {
        Class kcl = this.getClass(key);
        if (kcl == null) {
            Log.error("SET: No Atrribute " + key + " defined", new IllegalArgumentException(), this);
            return;
        }
        if (val != null && !(val instanceof NULLObject) && !kcl.isInstance(val)) {
            Log.error("SET: Wrong value for " + key + " IS: " + val.getClass().getName() + " should be: " + kcl.getName(), new IllegalArgumentException(), this);
            return;
        }
        Hashtable hashtable = this.ivProperties;
        synchronized (hashtable) {
            if (this.ivPropertyMask == null) {
                this.ivPropertyMask = new Hashtable();
            }
            if (val == null) {
                this.ivPropertyMask.put(key, NULLObject.INSTANCE);
            } else {
                this.ivPropertyMask.put(key, val);
            }
        }
    }

    public Class getClass(String key) {
        TreeMap ht = (TreeMap)ALLOWED_ATTRIBUTES.get(this.getClass());
        if (ht == null) {
            return null;
        }
        return (Class)ht.get(key);
    }

    public static TreeMap getAllowedAttriubutes(Class idObjectClass) {
        return (TreeMap)ALLOWED_ATTRIBUTES.get(idObjectClass);
    }

    public Object get(String key, Object defVal) {
        Object res = this.get(key);
        if (res == null) {
            return defVal;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        block5: {
            Hashtable hashtable = this.ivProperties;
            synchronized (hashtable) {
                Object erg;
                block4: {
                    if (this.ivPropertyMask == null || (erg = this.ivPropertyMask.get(key)) == null) break block5;
                    if (!(erg instanceof NULLObject)) break block4;
                    return null;
                }
                return erg;
            }
        }
        return this.ivProperties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOriginalAndChangeds(HashMap originals, HashMap changeds) {
        Hashtable hashtable = this.ivProperties;
        synchronized (hashtable) {
            if (this.ivPropertyMask != null) {
                Iterator iter = this.ivPropertyMask.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    if (originals != null) {
                        Object val = this.ivProperties.get(key);
                        if (val == null) {
                            val = NULLObject.INSTANCE;
                        }
                        originals.put(key, val);
                    }
                    changeds.put(key, this.ivPropertyMask.get(key));
                }
            }
        }
    }

    public String getPropertymaskString() {
        return this.ivProperties != null ? this.ivProperties.toString() : "<empty>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean incVersion) {
        IDObject iDObject = this;
        synchronized (iDObject) {
            if (incVersion) {
                this.incVersion();
            }
            Hashtable hashtable = this.ivProperties;
            synchronized (hashtable) {
                if (this.ivPropertyMask != null) {
                    Iterator iter = this.ivPropertyMask.keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        Object val = this.ivPropertyMask.get(key);
                        if (val instanceof NULLObject) {
                            if (this.ivProperties.get(key) == null) continue;
                            this.ivProperties.remove(key);
                            continue;
                        }
                        this.ivProperties.put(key, val);
                    }
                    this.ivPropertyMask.clear();
                    this.ivPropertyMask = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollBack() {
        Hashtable hashtable = this.ivProperties;
        synchronized (hashtable) {
            if (this.ivPropertyMask != null) {
                this.ivPropertyMask.clear();
                this.ivPropertyMask = null;
            }
        }
    }

    public void incVersion() {
        Integer version = (Integer)this.ivProperties.get(VERSION);
        if (version == null) {
            this.set(VERSION, new Integer(1));
        } else {
            this.set(VERSION, new Integer(version + 1));
        }
    }

    public String toString() {
        return IDObjectXMLHandler.getXMLString(this, this.getString(GROUP, null));
    }

    public String toString(String group) {
        return IDObjectXMLHandler.getXMLString(this, group);
    }

    public String getExportString(boolean isInInstitute) {
        return "";
    }

    public boolean isDead() {
        return this.get(END) != null || !this.existed();
    }

    public boolean isAlive() {
        return this.get(END) == null && this.existed();
    }

    public boolean isAlive(long millis) {
        if (this.existed()) {
            Date end = this.getDate(END);
            return end == null || end.getTime() >= millis;
        }
        return false;
    }

    public boolean isVisible() {
        return this.getBoolean(VISIBLE, true) && this.existed();
    }

    public boolean isAliveAndVisible() {
        return this.isAlive() && this.isVisible();
    }

    public boolean existed() {
        return !this.neverExisted();
    }

    public boolean neverExisted() {
        return this.getBoolean(NEVER_EXISTED, false);
    }

    public boolean isFullServicableObject() {
        return false;
    }

    public abstract String getName(String var1);

    public Long getLongID() {
        return (Long)this.get(ID);
    }

    public long getID() {
        return this.getLong(ID, 0L);
    }

    public long getID(long defVal) {
        return this.getLong(ID, defVal);
    }

    public long getTopLevelID(long defVal) {
        if (this.isSharedWithOtherGroups()) {
            return this.getLong(SERVICE_ID, defVal);
        }
        return this.getLong(ID, defVal);
    }

    public int getTyp() {
        return this.getInt(TYPE_ID, 0);
    }

    public int getTyp(int defVal) {
        return this.getInt(TYPE_ID, defVal);
    }

    public String getGroup() {
        return this.getString(GROUP, null);
    }

    public String getGroup(String defVal) {
        return this.getString(GROUP, defVal);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        String s = (String)this.get(key);
        return s != null ? s : defaultValue;
    }

    public String getForcedString(String key, String defaultValue) {
        Object ooo = this.get(key);
        if (ooo != null) {
            if (ooo instanceof String) {
                return (String)ooo;
            }
            return ooo.toString();
        }
        return defaultValue;
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public Vector getVector(String key) {
        return (Vector)this.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean booli = (Boolean)this.get(key);
        if (booli == null) {
            return defaultValue;
        }
        return booli;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Long longi = (Long)this.get(key);
        if (longi == null) {
            return defaultValue;
        }
        return longi;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Integer inti = (Integer)this.get(key);
        if (inti == null) {
            return defaultValue;
        }
        return inti;
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public char getChar(String key, char defVal) {
        Character chari = (Character)this.get(key);
        if (chari == null) {
            return defVal;
        }
        return chari.charValue();
    }

    public void setDouble(String key, String i) {
        this.set(key, new Double(Double.parseDouble(i)));
    }

    public void setInt(String key, String i) {
        this.set(key, new Integer(Integer.parseInt(i)));
    }

    public void setInt(String key, String i, int nullVal) {
        int val = Integer.parseInt(i);
        if (val == nullVal) {
            this.set(key, null);
        } else {
            this.set(key, new Integer(val));
        }
    }

    public void setLong(String key, String l) {
        this.set(key, new Long(Long.parseLong(l)));
    }

    public void setInt(String key, int i) {
        this.set(key, new Integer(i));
    }

    public void setInt(String key, int i, int nullVal) {
        if (i == nullVal) {
            this.set(key, null);
        } else {
            this.set(key, new Integer(i));
        }
    }

    public void setLong(String key, long l) {
        this.set(key, new Long(l));
    }

    public void setDate(String key, long millis) {
        this.set(key, new Date(millis));
    }

    public void setDate(String key, String millis) {
        this.set(key, new Date(Long.parseLong(millis)));
    }

    public void setBoolean(String key, boolean b) {
        this.set(key, new Boolean(b));
    }

    public void setChar(String key, char c) {
        this.set(key, new Character(c));
    }

    public boolean equals(Object no) {
        if (!(no instanceof IDObject)) {
            return false;
        }
        IDObject nido = (IDObject)no;
        if (nido.getID() != this.getID()) {
            return false;
        }
        if (nido.getTyp() != this.getTyp()) {
            return false;
        }
        return nido.getGroup("").equals(this.getGroup(""));
    }

    public String getIdentifierString() {
        if (this.ivIdentifier == null) {
            this.ivIdentifier = IDObject.getIdentifierString(this.getGroup(""), this.getTyp(), this.getID());
        }
        return this.ivIdentifier;
    }

    public String getExtendedIdentifier() {
        return new StringBuilder(this.getIdentifierString()).append(IDENTIFIER_SEPARATOR).append(this.getInt(VERSION)).toString();
    }

    public String getCLLWIDString() {
        if (this.get(END) == null) {
            return Long.toString(this.getLong(ID));
        }
        return "+ " + Long.toString(this.getLong(ID));
    }

    public Object getObjectForSpecialIndex() {
        return null;
    }

    public static boolean useSpezialIndex(int type) {
        return type == 11;
    }

    public boolean isObjectIdenticalForGroupTransfer(IDObject idObject) {
        return false;
    }

    public void mergeNecessAtrrsToServiceObject(IDObject serviceObject, Hashtable objectBag) {
    }

    public Vector getSharedGroups() {
        String[] garr = (String[])this.get(USER_GROUPS);
        if (garr != null && garr.length != 0) {
            Vector<String> v = new Vector<String>(garr.length);
            int i = 0;
            while (i < garr.length) {
                v.add(garr[i]);
                ++i;
            }
            return v;
        }
        return new Vector();
    }

    public String getSharedGroupNames() {
        StringBuilder msb = new StringBuilder();
        String[] garr = (String[])this.get(USER_GROUPS);
        if (garr != null && garr.length != 0) {
            Vector v = this.getSharedGroups();
            Collections.sort(v, StringHelper.CASE_INSENSITIVE_COMPARER);
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                msb.append(group);
            }
        }
        return msb.toString();
    }

    public boolean mayAttributeBeChangedByCommand() {
        return this.get(SERVICE_ID) == null;
    }

    public boolean isSharedWithOtherGroups() {
        return this.get(SERVICE_ID) != null;
    }

    public IDObject getServiceGroupObject(Hashtable objectBag) {
        return ObjectStoreServer.getObjectToUpdate(this.getTyp(), this.getLong(SERVICE_ID, -1L), "service", objectBag);
    }

    public String[] getMergeAttributesFromServiceToExistingGroupObject() {
        return null;
    }

    public IDObject getSubObjectForGroup(String regularGroup, Hashtable objectBag) {
        if (regularGroup != null && this.isServiceGroupObject() && ProcessDefinition.isServer()) {
            String[] groups = (String[])this.get(USER_GROUPS);
            long[] objectIDs = (long[])this.get(USER_GROUP_IDS);
            if (groups != null && objectIDs != null && groups.length != 0 && groups.length == objectIDs.length) {
                int i = 0;
                while (i < groups.length) {
                    if (regularGroup.equals(groups[i])) {
                        return ObjectStore.getObjectDeadOrAlive(this.getTyp(), objectIDs[i], groups[i], objectBag, false);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public HashMap getSubObjectsByGroupOnServer(Hashtable objectBag) {
        if (ProcessDefinition.isServer()) {
            int type = this.getTyp();
            HashMap<String, IDObject> res = new HashMap<String, IDObject>();
            String[] groups = (String[])this.get(USER_GROUPS);
            long[] objectIDs = (long[])this.get(USER_GROUP_IDS);
            if (groups != null && objectIDs != null && groups.length != 0 && groups.length == objectIDs.length) {
                int i = 0;
                while (i < groups.length) {
                    IDObject ido = null;
                    if (objectBag != null) {
                        ido = (IDObject)objectBag.get(IDObject.getIdentifierString(groups[i], type, objectIDs[i]));
                    }
                    if (ido == null) {
                        ido = ObjectStore.getObjectDeadOrAlive(type, objectIDs[i], groups[i], objectBag, false);
                    }
                    if (ido != null) {
                        res.put(groups[i], ido);
                    }
                    ++i;
                }
            }
            return res;
        }
        return null;
    }

    public IDObject getSharedObjectFromServiceObjectOnServer(String otherGroup) {
        if (ProcessDefinition.isServer() && this.getGroup().equals("service")) {
            String[] groups = (String[])this.get(USER_GROUPS);
            long[] objectIDs = (long[])this.get(USER_GROUP_IDS);
            if (groups != null && objectIDs != null && groups.length != 0 && groups.length == objectIDs.length) {
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].equals(otherGroup)) {
                        return ObjectStore.getObjectDeadOrAlive(this.getTyp(), objectIDs[i], otherGroup, null, false);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public IDObject getSharedObject(String otherGroup, Hashtable objectBag) {
        HashMap hm;
        IDObject serviceObject;
        if (ProcessDefinition.isServer() && this.isSharedWithOtherGroups() && (serviceObject = ObjectStore.getObjectDeadOrAlive(this.getTyp(), this.getLong(SERVICE_ID, -1L), "service", objectBag, false)) != null && (hm = serviceObject.getSubObjectsByGroupOnServer(objectBag)) != null) {
            return (IDObject)hm.get(otherGroup);
        }
        return null;
    }

    public void setAndPropagateAttributes(Hashtable objectBag, HashMap attributes, String key, Object val) {
        if (ProcessDefinition.isServer() && this.mayAttributeBeChangedByCommand()) {
            HashMap hm;
            if (attributes != null) {
                this.setAttributes(attributes);
            }
            if (key != null) {
                this.set(key, val);
            }
            if (this.getGroup().equals("service") && (hm = this.getSubObjectsByGroupOnServer(objectBag)) != null) {
                Iterator iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    Iterator iterator;
                    String group = (String)iter.next();
                    IDObject groupObject = (IDObject)hm.get(group);
                    if (attributes != null) {
                        iterator = attributes.keySet().iterator();
                        while (iterator.hasNext()) {
                            String akey = (String)iterator.next();
                            groupObject.propagateAttributeInSubObject(akey, attributes.get(akey));
                        }
                    } else if (key != null) {
                        groupObject.propagateAttributeInSubObject(key, val);
                    } else if (attributes == null && key == null && val == null && this.ivPropertyMask != null) {
                        iterator = this.ivPropertyMask.keySet().iterator();
                        while (iterator.hasNext()) {
                            String pmkey = (String)iterator.next();
                            groupObject.propagateAttributeInSubObject(pmkey, this.ivPropertyMask.get(pmkey));
                        }
                    }
                    objectBag.put(groupObject.getIdentifierString(), groupObject);
                }
            }
        }
    }

    public void propagateAttributeInSubObject(String key, Object val) {
        this.set(key, val);
    }

    public void setAttributes(HashMap attributes) {
        if (attributes != null) {
            Iterator iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String tag = (String)iterator.next();
                this.set(tag, attributes.get(tag));
            }
        }
    }

    public IDObject createSharedCopyOfServiceObject(String group, Hashtable objectBag, Vector newObjectsTarget) {
        if (ProcessDefinition.isServer() && group != null && !group.equals("service")) {
            IDObject obi;
            HashMap hm = this.getSubObjectsByGroupOnServer(objectBag);
            if (hm != null && (obi = (IDObject)hm.get(group)) != null) {
                objectBag.put(obi.getIdentifierString(), obi);
                return obi;
            }
            return this.finalizeSubObject(this.createNewCopy(group, objectBag, newObjectsTarget), group);
        }
        return null;
    }

    public IDObject createServiceCopyOfGroupObject(Hashtable objectBag, Vector newObjectsTarget) {
        IDObject obi = null;
        if (ProcessDefinition.isServer()) {
            obi = this.createNewCopy("service", objectBag, newObjectsTarget);
        }
        return obi;
    }

    private IDObject createNewCopy(String targetGroup, Hashtable objectBag, Vector newObjectsTarget) {
        IDObject obi = IDObject.giveNewObjectOfType(this.getTyp());
        if (obi != null) {
            obi.set(START, new Date());
            obi.set(GROUP, targetGroup);
            if (!DataLayer.cvDataLayer.provideNewIDToIDObject(obi)) {
                Log.error("couldn't get ID for new Object", null, this);
                return null;
            }
            this.copyAttributesForSubObject(obi);
            objectBag.put(this.getIdentifierString(), this);
            objectBag.put(obi.getIdentifierString(), obi);
            newObjectsTarget.addElement(obi);
        }
        return obi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAttributesForSubObject(IDObject subObject) {
        Iterator iter = this.ivProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (DONT_COPY_TO_SUBS.contains(key)) continue;
            subObject.set(key, this.ivProperties.get(key));
        }
        Hashtable hashtable = this.ivProperties;
        synchronized (hashtable) {
            if (this.ivPropertyMask != null) {
                Iterator iter2 = this.ivPropertyMask.keySet().iterator();
                while (iter2.hasNext()) {
                    String key = (String)iter2.next();
                    if (DONT_COPY_TO_SUBS.contains(key)) continue;
                    subObject.set(key, this.ivPropertyMask.get(key));
                }
            }
        }
    }

    public IDObject finalizeSubObject(IDObject subObject, String subGroup) {
        if (this.isServiceGroupObject() && subObject != null) {
            subObject.set(SERVICE_ID, new Long(this.getID()));
            if (!this.incUserGroupNamesAndUserGroupIDs(subGroup, subObject)) {
                Log.error("Fatal error while creating shared copy of " + this, null, this);
            }
            return subObject;
        }
        return null;
    }

    public boolean isServiceGroupObject() {
        return "service".equals(this.getGroup());
    }

    public boolean incUserGroupNamesAndUserGroupIDs(String group, IDObject groupObject) {
        if (this.isServiceGroupObject()) {
            Object[] serviceObjectGroupNames = (String[])this.get(USER_GROUPS);
            long[] serviceObjectGroupObjectIds = null;
            if (serviceObjectGroupNames != null) {
                serviceObjectGroupObjectIds = (long[])this.get(USER_GROUP_IDS);
                if (serviceObjectGroupObjectIds == null || serviceObjectGroupObjectIds.length != serviceObjectGroupNames.length) {
                    Log.error("Mismatch of groupNames [" + serviceObjectGroupNames.length + "] and groupIDs [" + (serviceObjectGroupObjectIds == null ? "<null>" : Integer.toString(serviceObjectGroupObjectIds.length)) + "] in Object " + this.getIdentifierString() + " : " + this.toString(), null, this);
                    return false;
                }
                if (ArrayHelper.contained(group, serviceObjectGroupNames)) {
                    return true;
                }
                String[] newObjectGroupNames = new String[serviceObjectGroupNames.length + 1];
                long[] newObjectGroupObjectIds = new long[serviceObjectGroupNames.length + 1];
                int i = 0;
                while (i < serviceObjectGroupNames.length) {
                    newObjectGroupNames[i] = serviceObjectGroupNames[i];
                    newObjectGroupObjectIds[i] = serviceObjectGroupObjectIds[i];
                    ++i;
                }
                serviceObjectGroupNames = newObjectGroupNames;
                serviceObjectGroupObjectIds = newObjectGroupObjectIds;
            } else {
                serviceObjectGroupNames = new String[1];
                serviceObjectGroupObjectIds = new long[1];
            }
            serviceObjectGroupNames[serviceObjectGroupNames.length - 1] = group;
            serviceObjectGroupObjectIds[serviceObjectGroupNames.length - 1] = groupObject.getID();
            this.set(USER_GROUPS, serviceObjectGroupNames);
            this.set(USER_GROUP_IDS, serviceObjectGroupObjectIds);
            return true;
        }
        return false;
    }

    public String getLink() {
        return "<a href=\"http://OBJ|" + this.getIdentifierString() + "\">" + this.getName() + "</a>";
    }

    public int compareTo(Object o) {
        if (o instanceof IDObject) {
            IDObject ido = (IDObject)o;
            return this.getBrowseName().compareToIgnoreCase(ido.getBrowseName());
        }
        return 0;
    }

    public String getFilterSplitDateString(String key) {
        Date date = this.getDate(key);
        if (date != null) {
            MyDate md = MyDate.getMyDate(date.getTime());
            return md.getFilterString();
        }
        return "";
    }

    public String getFilterSplitDateIntString(String key) {
        Integer date = (Integer)this.get(key);
        if (date != null) {
            MyDate md = MyDate.getMyDate(date.intValue());
            return md.getFilterString();
        }
        return "";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.ivProperties);
        if (this.ivSessions != null) {
            out.writeObject(IDObjectXMLHandler.getSessionString(this.ivSessions));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.ivProperties = (Hashtable)ois.readObject();
        if (this.ivSessions != null) {
            Object ooo = ois.readObject();
            if (ooo instanceof Vector) {
                this.setSessions(new TreeSet((Vector)ooo));
            } else if (ooo instanceof TreeSet) {
                this.setSessions((TreeSet)ooo);
            } else if (ooo instanceof String) {
                this.setSessions(IDObjectXMLHandler.getSessionTreset((String)ooo));
            }
        }
    }

    public static class IDObjectIdentifier {
        public final String ivGroup;
        public final int ivTyp;
        public final long ivID;

        public IDObjectIdentifier(String idString) {
            Zeile z = new Zeile(idString, '|');
            this.ivGroup = z.getString(0, "");
            this.ivTyp = z.getInt(1, 0);
            this.ivID = z.getLong(2, 0L);
        }
    }
}

