/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.NumberFormatter;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;

public class IndexObject
implements Serializable {
    private static final long serialVersionUID = 3343202211222155712L;
    private static final Comparator COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof IndexObject && arg1 instanceof IndexObject) {
                IndexObject iod0 = (IndexObject)arg0;
                IndexObject iod1 = (IndexObject)arg1;
                if (iod0.ivNumber > iod1.ivNumber) {
                    return -1;
                }
                if (iod0.ivNumber < iod1.ivNumber) {
                    return 1;
                }
                if (iod0.ivObjectID > iod1.ivObjectID) {
                    return 1;
                }
                if (iod0.ivObjectID < iod1.ivObjectID) {
                    return -1;
                }
            }
            return 0;
        }
    };
    public int ivObjectType = 0;
    public long ivObjectID = 0L;
    public double ivNumber = 0.0;

    public static IndexObject[] getArray(String transportString, int typ) {
        Zeile z = new Zeile(transportString, '|');
        IndexObject[] res = new IndexObject[z.size()];
        int i = 0;
        while (i < z.size()) {
            int ind;
            boolean ok = false;
            String s = z.getString(i, null);
            if (s != null && (ind = s.indexOf(",")) != -1) {
                res[i] = new IndexObject(typ, Long.parseLong(s.substring(0, ind)), Double.parseDouble(s.substring(ind + 1, s.length())));
                ok = true;
            }
            if (!ok) {
                return null;
            }
            ++i;
        }
        return res;
    }

    public static String getTransportString(IndexObject[] arr) {
        StringBuffer msb = new StringBuffer();
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (i != 0) {
                    msb.append("|");
                }
                msb.append(arr[i].ivObjectID).append(",").append(arr[i].ivNumber);
                ++i;
            }
        }
        return msb.toString();
    }

    public static String getDisplayString(String transportString, String group, int typ) {
        if (transportString.trim().length() == 0 || transportString.trim().equals("0")) {
            return null;
        }
        try {
            IDObject ido = ObjectStore.getObjectDeadOrAlive(typ, Long.parseLong(transportString), group, null, false);
            if (ido != null) {
                return ido.getBrowseName();
            }
        }
        catch (Exception ido) {
            // empty catch block
        }
        try {
            IndexObject[] arr = IndexObject.getArray(transportString, typ);
            if (arr != null) {
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < arr.length) {
                    IDObject ido = ObjectStore.getObjectDeadOrAlive(typ, arr[i].ivObjectID, group, null, false);
                    if (ido != null) {
                        if (msb.length() != 0) {
                            msb.append(" ");
                        }
                        msb.append(ido.getBrowseName()).append(" (").append(NumberFormatter.STRAIN_FROMATTER.format(arr[i].ivNumber)).append(")");
                    }
                    ++i;
                }
                return msb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getDisplayString(IndexObject[] arr, String group, int typ, boolean mitZahl, boolean zahlMitMax1Nachkommastelle, boolean mitServicePrefix) {
        StringBuffer msb = new StringBuffer();
        Vector list = IndexObject.getSorteds(arr);
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IDObject str;
                IndexObject iob = (IndexObject)iterator.next();
                if (msb.length() != 0) {
                    msb.append(" ");
                }
                if ((str = ObjectStore.getObjectDeadOrAlive(typ, iob.ivObjectID, group, null, false)) == null) continue;
                msb.append(ProcessDefinition.isServer() || !mitServicePrefix ? str.getBrowseNameWITHOUTServicePrefix() : str.getBrowseNameInclServicePrefix());
                if (!mitZahl) continue;
                if (zahlMitMax1Nachkommastelle) {
                    msb.append(" (").append(NumberFormatter.STRAIN_FROMATTER_M1NKS.format(iob.ivNumber)).append(") ");
                    continue;
                }
                msb.append(" (").append(NumberFormatter.STRAIN_FROMATTER.format(iob.ivNumber)).append(") ");
            }
            list.clear();
            list = null;
        }
        return msb.toString();
    }

    public static Vector getSorteds(IndexObject[] arr) {
        Vector<IndexObject> res = null;
        if (arr != null && (res = new Vector<IndexObject>(Arrays.asList(arr))).size() > 1) {
            Collections.sort(res, COMPARER);
        }
        return res;
    }

    public static boolean match(IndexObject[] arr1, IndexObject[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 != null && arr2 == null) {
            return false;
        }
        if (arr1 == null && arr2 != null) {
            return false;
        }
        if (arr1 != null && arr2 != null) {
            if (arr1.length != arr2.length) {
                return false;
            }
            if (arr1.length == 0) {
                return true;
            }
            if (arr1.length == 1) {
                return arr1[0].ivObjectID == arr2[0].ivObjectID && arr1[0].ivNumber == arr2[0].ivNumber;
            }
            HashMap<Long, Double> hm1 = new HashMap<Long, Double>();
            int i = 0;
            while (i < arr1.length) {
                hm1.put(new Long(arr1[i].ivObjectID), new Double(arr1[i].ivNumber));
                ++i;
            }
            HashMap<Long, Double> hm2 = new HashMap<Long, Double>();
            int i2 = 0;
            while (i2 < arr2.length) {
                hm2.put(new Long(arr2[i2].ivObjectID), new Double(arr2[i2].ivNumber));
                ++i2;
            }
            if (hm1.size() != hm2.size()) {
                return false;
            }
            Iterator iter = hm1.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (hm1.get(key).equals(hm2.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IndexObject() {
    }

    public IndexObject(int t, long i, double num) {
        this.ivObjectType = t;
        this.ivObjectID = i;
        this.ivNumber = num;
    }

    public IndexObject(IndexObject model) {
        this.ivObjectType = model.ivObjectType;
        this.ivObjectID = model.ivObjectID;
        this.ivNumber = model.ivNumber;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IndexObject) {
            IndexObject io = (IndexObject)obj;
            return this.ivObjectType == io.ivObjectType && this.ivObjectID == io.ivObjectID && this.ivNumber == io.ivNumber;
        }
        return false;
    }
}

