/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.util.Log;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import mausoleum.db.DBAssistant;

public class ObjectHoler
implements Runnable {
    private final int ivObjectType;
    private final long[] ivObjectIDs;
    private final String ivTicket;
    private final String ivGroup;
    private HashMap ivRunningTarget = null;
    private HashMap ivFinishedTarget = null;
    private Vector ivSammler = new Vector(100);

    public ObjectHoler(String group, int type, long[] ids, String ticket, HashMap runningTarget, HashMap finishedTarget) {
        this.ivGroup = group;
        this.ivObjectType = type;
        this.ivObjectIDs = ids;
        this.ivTicket = ticket;
        this.ivRunningTarget = runningTarget;
        this.ivFinishedTarget = finishedTarget;
        this.ivRunningTarget.put(this.ivTicket, this.ivSammler);
    }

    public void run() {
        if (DataLayer.USE_DB) {
            DBAssistant.getMoreObjects(this.ivGroup, this.ivObjectType, this.ivObjectIDs, false, this.ivSammler, true);
        } else {
            IDObject ido = null;
            Hashtable bag = new Hashtable(this.ivObjectIDs.length * 2);
            int i = 0;
            while (i < this.ivObjectIDs.length) {
                try {
                    ido = ObjectStoreServer.getObjectDeadOrAlive(this.ivObjectType, this.ivObjectIDs[i], this.ivGroup, bag, false, false);
                }
                catch (Exception e) {
                    Log.error("Problem retrieving Object! Group: " + this.ivGroup + " Type: " + this.ivObjectType + " ID " + this.ivObjectIDs[i], e, this);
                }
                if (ido != null) {
                    this.ivSammler.add(ido.getValueString());
                }
                ++i;
            }
        }
        this.ivFinishedTarget.put(this.ivTicket, this.ivSammler);
        this.ivRunningTarget.remove(this.ivTicket);
        this.ivRunningTarget = null;
        this.ivFinishedTarget = null;
        this.ivSammler = null;
    }
}

