/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;

public abstract class ObjectManagerCache {
    public static String MAIN_SEP = "!";
    public static char MAIN_SEP_C = (char)33;
    public static char MAIN_SEP_OLD_C = (char)167;
    private static final String FILENAME = ".objects3";
    private static final String FILENAME_OLD2 = ".objects2";
    private static final String FILENAME_OLD = ".objects";
    private static final String[] OLD_FILENAMES = new String[]{".objects", ".objects2"};
    static /* synthetic */ Class class$0;

    public static void saveCache(String group, int objectType, Hashtable ghm) {
        String dir = "files/client/" + group;
        FileManager.prepareDirs(dir);
        String pathname = String.valueOf(dir) + "/" + IDObject.getFilenameForTypeClientSide(objectType) + FILENAME;
        try {
            FileWriter fw = new FileWriter(pathname);
            boolean first = true;
            Iterator iterator2 = ghm.values().iterator();
            while (iterator2.hasNext()) {
                IDObject ido = (IDObject)iterator2.next();
                if (first) {
                    first = false;
                    String decl = ido.getAttributeKeyDeclaration();
                    if (decl == null) {
                        fw.close();
                        FileManager.deleteFile(pathname);
                        String string = "Missing declaration for " + IDObject.getFilenameForTypeClientSide(objectType);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectManagerCache");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, null, clazz);
                        return;
                    }
                    fw.write(decl);
                }
                fw.write(ido.getCacheString());
            }
            fw.close();
        }
        catch (Throwable e) {
            String s = Log.formatString("Could not save " + pathname + " -> " + e, 5);
            try {
                FileWriter fw = new FileWriter("files/" + group + "/shutdown.log", true);
                fw.write(s);
                fw.flush();
                fw.close();
            }
            catch (Exception e2) {
                System.out.println("Gro\u00dfes Problem " + s);
            }
        }
        int i = 0;
        while (i < OLD_FILENAMES.length) {
            pathname = String.valueOf(dir) + "/" + IDObject.getFilenameForTypeClientSide(objectType) + OLD_FILENAMES[i];
            FileManager.deleteFile(pathname);
            ++i;
        }
    }

    public static Vector initCache(String group, int objectType, Hashtable target) {
        String typeName = IDObject.getFilenameForTypeClientSide(objectType);
        String dir = "files/client/" + group;
        String pathname = String.valueOf(dir) + "/" + typeName + FILENAME;
        if (new File(pathname).exists()) {
            return ObjectManagerCache.initNewStyle(group, objectType, target, pathname, MAIN_SEP_C, false);
        }
        pathname = String.valueOf(dir) + "/" + typeName + FILENAME_OLD2;
        if (new File(pathname).exists()) {
            return ObjectManagerCache.initNewStyle(group, objectType, target, pathname, MAIN_SEP_OLD_C, true);
        }
        pathname = String.valueOf(dir) + "/" + typeName + FILENAME_OLD;
        if (new File(pathname).exists()) {
            return ObjectManagerCache.initOldStyle(group, objectType, target, pathname);
        }
        return ObjectManagerCache.initNewStyle(group, objectType, target, null, MAIN_SEP_C, false);
    }

    private static Vector initNewStyle(String group, int objectType, Hashtable target, String path, char mainSep, boolean tagsPresent) {
        ObjectRequest mor;
        HashMap cache = new HashMap(2000);
        String keyDeclaration = null;
        if (path != null) {
            try {
                LineNumberReader lnr = new LineNumberReader(new FileReader(path));
                keyDeclaration = lnr.readLine();
                String line = lnr.readLine();
                while (line != null) {
                    new CacheObject(line, cache, mainSep);
                    line = lnr.readLine();
                }
                lnr.close();
            }
            catch (Exception e) {
                System.out.println("Problem " + e);
            }
        }
        Hashtable<Long, IDObject> groupHashtable = new Hashtable<Long, IDObject>(cache.size() + 500);
        target.put(group, groupHashtable);
        Long extraObject = null;
        if (objectType == 11) {
            extraObject = UserManager.getUser().getLongID();
        }
        if ((mor = RequestManager.createSendAndGetAnswer((byte)1, new Byte((byte)objectType), group, extraObject)) == null || mor.ivAction != 1 || !mor.isFinished() || mor.ivObject == null || !(mor.ivObject instanceof Vector)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectManagerCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn("Could not get list of actual objects from server", null, clazz);
            return null;
        }
        Vector liste = (Vector)mor.ivObject;
        long[] ids = (long[])liste.elementAt(0);
        int[] vss = (int[])liste.elementAt(1);
        String[] localkeys = ObjectManagerCache.genKeys(keyDeclaration, mainSep);
        IDObjectXMLHandler.IOXInterpret[] localInterpreters = ObjectManagerCache.genInterpreters(localkeys, objectType);
        Integer type = new Integer(objectType);
        if (ids.length != 0) {
            Vector<Long> nochZuHolen = new Vector<Long>(ids.length);
            int i = 0;
            while (i < ids.length) {
                Long key = new Long(ids[i]);
                boolean hols = true;
                CacheObject co = (CacheObject)cache.get(key);
                if (co != null && co.ivVersion == vss[i] && localkeys != null && (localInterpreters != null || tagsPresent)) {
                    groupHashtable.put(key, IDObject.initObjectFromTransport(type, group, co.ivTransport, localkeys, localInterpreters, tagsPresent));
                    hols = false;
                }
                if (hols) {
                    nochZuHolen.addElement(key);
                }
                ++i;
            }
            cache.clear();
            return nochZuHolen;
        }
        return null;
    }

    private static String[] genKeys(String decl, char mainSep) {
        if (decl != null) {
            Zeile z = new Zeile(decl, mainSep);
            String[] res = new String[z.size()];
            int i = 0;
            while (i < res.length) {
                res[i] = z.getString(i);
                ++i;
            }
            return res;
        }
        return null;
    }

    public static IDObjectXMLHandler.IOXInterpret[] genInterpreters(String[] keys, int objectType) {
        String[] tkeys = IDObject.getTransportKeys(objectType);
        IDObjectXMLHandler.IOXInterpret[] tinter = IDObject.getTransportInterpreters(objectType);
        if (tkeys != null && tinter != null && keys != null) {
            IDObjectXMLHandler.IOXInterpret[] res = new IDObjectXMLHandler.IOXInterpret[keys.length];
            int i = 0;
            while (i < res.length) {
                int ind = ArrayHelper.findStringInArray(keys[i], tkeys);
                if (ind == -1) {
                    return null;
                }
                res[i] = tinter[ind];
                ++i;
            }
            return res;
        }
        return null;
    }

    private static Vector initOldStyle(String group, int objectType, Hashtable target, String path) {
        ObjectRequest mor;
        Hashtable groupHashTable = null;
        try {
            HashMap hm;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object ooo = ois.readObject();
            ois.close();
            if (ooo instanceof Hashtable) {
                groupHashTable = (Hashtable)ooo;
            } else if (ooo instanceof HashMap && (ooo = (hm = (HashMap)ooo).get(group)) != null && ooo instanceof HashMap) {
                hm = (HashMap)ooo;
                groupHashTable = new Hashtable(hm.size() * 2);
                Iterator iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    groupHashTable.put(key, hm.get(key));
                }
            }
        }
        catch (Exception e) {
            String string = "Could not read " + path;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectManagerCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
        if (groupHashTable == null) {
            groupHashTable = new Hashtable();
        }
        target.put(group, groupHashTable);
        Long extraObject = null;
        if (objectType == 11) {
            extraObject = UserManager.getUser().getLongID();
        }
        if ((mor = RequestManager.createSendAndGetAnswer((byte)1, new Byte((byte)objectType), group, extraObject)) == null || mor.ivAction != 1 || !mor.isFinished() || mor.ivObject == null || !(mor.ivObject instanceof Vector)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectManagerCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn("Could not get list of actual objects from server", null, clazz);
            return null;
        }
        Vector liste = (Vector)mor.ivObject;
        long[] ids = (long[])liste.elementAt(0);
        int[] vss = (int[])liste.elementAt(1);
        if (ids.length == 0) {
            groupHashTable.clear();
            return null;
        }
        Vector<Long> nochZuHolen = new Vector<Long>();
        Hashtable<Long, IDObject> tmpGroupHashTable = new Hashtable<Long, IDObject>();
        int i = 0;
        while (i < ids.length) {
            Long key = new Long(ids[i]);
            IDObject iob = (IDObject)groupHashTable.get(key);
            if (iob != null) {
                if (iob.getInt("IDO_VERSION") != vss[i]) {
                    nochZuHolen.addElement(key);
                } else {
                    tmpGroupHashTable.put(key, iob);
                }
            } else {
                nochZuHolen.addElement(key);
            }
            ++i;
        }
        target.put(group, tmpGroupHashTable);
        return nochZuHolen;
    }

    private static class CacheObject {
        public int ivVersion;
        public String ivTransport;

        public CacheObject(String line, HashMap cache, char mainSep) {
            Zeile z = new Zeile(line, mainSep);
            if (z.size() >= 4) {
                Long id = new Long(z.getLong(0, 0L));
                this.ivVersion = z.getInt(1, 0);
                this.ivTransport = z.getString(3, "");
                cache.put(id, this);
            }
        }
    }
}

