/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.objectstore.ObjectProvider;
import de.hannse.netobjects.objectstore.ObjectProviderMail;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import mausoleum.main.ProcessDefinition;
import mausoleum.task.standards.StandardTask;

public class ObjectPortal {
    private static Hashtable cvObjectPortals = null;
    private final String ivGroup;
    private final Hashtable ivProviders;
    static /* synthetic */ Class class$0;

    public static void init() {
        if (ProcessDefinition.isServer() && cvObjectPortals == null) {
            cvObjectPortals = new Hashtable();
            String[] gnames = DataLayer.cvDataLayer.getGroupStringArray(false);
            if (gnames != null && gnames.length != 0) {
                int z = 1;
                while (z <= 2) {
                    int i = 0;
                    while (i < gnames.length) {
                        if (gnames[i] == null || "null".equalsIgnoreCase(gnames[i])) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.objectstore.ObjectPortal");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error("Group 'null' present", null, clazz);
                            String nullDir = GroupFileManager.getGroupDir("null");
                            if (new File(nullDir).exists()) {
                                FileManager.deleteDir(nullDir, true);
                            }
                        } else {
                            int[] typen = null;
                            if (gnames[i].equals("service")) {
                                if (z == 1) {
                                    typen = DataLayer.getTypen(gnames[i]);
                                }
                            } else if (z != 1) {
                                typen = DataLayer.getTypen(gnames[i]);
                            }
                            if (typen != null) {
                                StandardTask.init(gnames[i]);
                                ObjectPortal op = new ObjectPortal(gnames[i], typen);
                                cvObjectPortals.put(gnames[i], op);
                            }
                        }
                        ++i;
                    }
                    ++z;
                }
            }
        }
    }

    public static void dispose() {
        cvObjectPortals.clear();
    }

    public static void lookForGroup(String groupname) {
        if (cvObjectPortals.get(groupname) == null) {
            cvObjectPortals.put(groupname, new ObjectPortal(groupname, DataLayer.getTypen(groupname)));
        }
    }

    public static ObjectProvider getObjectProvider(String group, int type) {
        ObjectPortal op = (ObjectPortal)cvObjectPortals.get(group);
        return op != null && op.ivProviders != null ? (ObjectProvider)op.ivProviders.get(new Integer(type)) : null;
    }

    public static void digestObjectBag(Hashtable objectBag) {
        if (ProcessDefinition.isServer() && objectBag != null && !objectBag.isEmpty() && !cvObjectPortals.isEmpty()) {
            Enumeration en = objectBag.elements();
            while (en.hasMoreElements()) {
                ObjectProvider opro;
                IDObject iob = (IDObject)en.nextElement();
                ObjectPortal op = (ObjectPortal)cvObjectPortals.get(iob.getGroup());
                if (op == null || (opro = (ObjectProvider)op.ivProviders.get(new Integer(iob.getTyp()))) == null) continue;
                opro.digestIDObject(iob);
            }
        }
    }

    private ObjectPortal(String group, int[] typlist) {
        if (group == null || "null".equalsIgnoreCase(group)) {
            throw new IllegalArgumentException("Group name not valid: " + group);
        }
        this.ivProviders = new Hashtable(typlist.length);
        this.ivGroup = group;
        int i = 0;
        while (i < typlist.length) {
            this.ivProviders.put(new Integer(typlist[i]), typlist[i] == 11 ? new ObjectProviderMail(this.ivGroup, typlist[i]) : new ObjectProvider(this.ivGroup, typlist[i]));
            ++i;
        }
        Log.log("ObjectProvider initialised for group " + group, this);
        if (ProcessDefinition.isServer() && ProcessDefinition.isServer() && !group.equals("service")) {
            ObjectIndex.createIndex(group);
        }
    }
}

