/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.cagetalker.CageTalker;

public class ObjectProvider {
    protected final String ivGroup;
    protected final int ivType;
    protected final Hashtable ivOld = new Hashtable();
    protected Hashtable ivNew = null;

    public ObjectProvider(String group, int type) {
        this(group, type, true);
    }

    protected ObjectProvider(String group, int type, boolean getObjects) {
        this.ivGroup = group;
        this.ivType = type;
        if (getObjects) {
            this.ivNew = DataLayer.cvDataLayer.getAllActualObjects(group, type);
            if (type == 2 && CageTalker.useCageTalker() && !DataLayer.USE_DB) {
                Enumeration en = this.getActualObjects();
                while (en.hasMoreElements()) {
                    Cage cage = (Cage)en.nextElement();
                    String ctID = cage.getString("CAG_CTID", null);
                    if (ctID == null) continue;
                    CageTalker.addUsedCagetalkerID(ctID);
                }
            }
        }
    }

    public Enumeration getActualObjects() {
        return this.ivNew.elements();
    }

    public Iterator getActualObjectsIter() {
        return this.ivNew.values().iterator();
    }

    public void fillWithActualObjects(Vector target) {
        if (this.ivNew != null && !this.ivNew.isEmpty()) {
            target.addAll(this.ivNew.values());
        }
    }

    public Vector getActualObjectVector() {
        Vector v = new Vector();
        v.addAll(this.ivNew.values());
        return v;
    }

    public int getAnzActualObjects() {
        return this.ivNew.size();
    }

    public void reinitObjects() {
        this.ivNew.clear();
        this.ivNew = DataLayer.cvDataLayer.getAllActualObjects(this.ivGroup, this.ivType);
    }

    public Enumeration getAllObjects() {
        Hashtable allHT = DataLayer.cvDataLayer.getAllObjects(this.ivGroup, this.ivType);
        if (allHT != null) {
            return allHT.elements();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveIDAndVersionOfActualObjects(ObjectRequest or) {
        Hashtable hashtable = this.ivNew;
        synchronized (hashtable) {
            int anz = this.ivNew.size();
            long[] ids = new long[anz];
            int[] vss = new int[anz];
            Enumeration en = this.ivNew.elements();
            int z = 0;
            while (en.hasMoreElements()) {
                IDObject iob = (IDObject)en.nextElement();
                ids[z] = iob.getID();
                vss[z] = iob.getInt("IDO_VERSION");
                ++z;
            }
            Vector<long[]> v = new Vector<long[]>(2);
            v.addElement(ids);
            v.addElement(vss);
            or.ivObject = v;
        }
    }

    public Vector getObjectsDeadOrAlive(long[] ids, boolean onlyActual) {
        Vector<IDObject> res = new Vector<IDObject>();
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                IDObject ido = this.getObjectDeadOrAlive(ids[i], onlyActual, false);
                if (ido != null) {
                    res.add(ido);
                }
                ++i;
            }
        }
        return res;
    }

    public IDObject getObjectDeadOrAlive(long id, boolean onlyActual, boolean evenNonExisteds) {
        if (id <= 0L) {
            return null;
        }
        Long key = new Long(id);
        IDObject res = (IDObject)this.ivNew.get(key);
        if (res != null && (res.existed() || evenNonExisteds)) {
            return res;
        }
        if (onlyActual) {
            return null;
        }
        res = (IDObject)this.ivOld.get(key);
        if (res != null && res.existed()) {
            return res;
        }
        res = DataLayer.cvDataLayer.getObject(this.ivGroup, this.ivType, id, onlyActual);
        if (res != null && (res.existed() || evenNonExisteds)) {
            return res;
        }
        return null;
    }

    public void digestIDObject(IDObject obj) {
        Long key = (Long)obj.get("IDO_ID");
        if (key != null) {
            if (obj.get("IDO_END_DATE") == null) {
                this.ivNew.put(key, obj);
            } else {
                this.ivNew.remove(key);
                this.ivOld.put(key, obj);
            }
        }
    }
}

