/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectProvider;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.db.DBAssistant;
import mausoleum.mail.Mail;

public class ObjectProviderMail
extends ObjectProvider {
    public ObjectProviderMail(String group, int type) {
        super(group, type, false);
        if (!DataLayer.USE_DB) {
            this.init();
        }
    }

    private void init() {
        Mail mail;
        Object key;
        Hashtable actMails = DataLayer.cvDataLayer.getAllActualObjects(this.ivGroup, this.ivType);
        if (this.ivNew != null) {
            this.ivNew.clear();
        } else {
            this.ivNew = new Hashtable(actMails.size() * 3 / 2);
        }
        Iterator iterator = actMails.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            mail = (Mail)actMails.get(key);
            this.ivNew.put(key, new MailShortInfo(mail));
        }
        iterator = actMails.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            mail = (Mail)actMails.get(key);
            mail.dispose();
        }
        actMails.clear();
    }

    public Enumeration getActualObjects() {
        Hashtable actMails = DataLayer.cvDataLayer.getAllActualObjects(this.ivGroup, this.ivType);
        return actMails.elements();
    }

    public Vector getActualObjectVector() {
        Vector v = new Vector();
        Hashtable actMails = DataLayer.cvDataLayer.getAllActualObjects(this.ivGroup, this.ivType);
        if (actMails != null) {
            v.addAll(actMails.values());
        }
        return v;
    }

    public int getAnzActualObjects() {
        return DataLayer.USE_DB ? DBAssistant.getActualObjectCount(this.ivGroup, 11) : this.ivNew.size();
    }

    public void reinitObjects() {
        this.init();
    }

    public Enumeration getAllObjects() {
        Hashtable allHT = DataLayer.cvDataLayer.getAllObjects(this.ivGroup, this.ivType);
        if (allHT != null) {
            return allHT.elements();
        }
        return null;
    }

    public void giveIDAndVersionOfActualObjects(ObjectRequest or) {
        or.ivObject = this.giveIDAndVersionOfActualObjects((Long)or.ivExtraObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector giveIDAndVersionOfActualObjects(Long userID) {
        int userIDInt = userID.intValue();
        Vector<long[]> v = new Vector<long[]>(2);
        Hashtable hashtable = this.ivNew;
        synchronized (hashtable) {
            Vector<Long> tv = new Vector<Long>(this.ivNew.size() / 5);
            Iterator iterator = this.ivNew.keySet().iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                MailShortInfo msi = (MailShortInfo)this.ivNew.get(id);
                if (msi.ivOwnerID != userIDInt) continue;
                tv.add(id);
            }
            int anz = tv.size();
            long[] ids = new long[anz];
            int[] vss = new int[anz];
            int z = 0;
            Iterator iterator2 = tv.iterator();
            while (iterator2.hasNext()) {
                Long id = (Long)iterator2.next();
                MailShortInfo msi = (MailShortInfo)this.ivNew.get(id);
                ids[z] = id;
                vss[z] = msi.ivVersion;
                ++z;
            }
            v.addElement(ids);
            v.addElement(vss);
            tv.clear();
            tv = null;
        }
        return v;
    }

    public IDObject getObjectDeadOrAlive(long id, boolean onlyActual, boolean evenNonExisteds) {
        IDObject res;
        if (id > 0L && (res = DataLayer.cvDataLayer.getObject(this.ivGroup, this.ivType, id, onlyActual)) != null && (res.existed() || evenNonExisteds)) {
            return res;
        }
        return null;
    }

    public void digestIDObject(IDObject obj) {
        Long key = (Long)obj.get("IDO_ID");
        if (key != null) {
            if (obj.get("IDO_END_DATE") == null) {
                this.ivNew.put(key, new MailShortInfo((Mail)obj));
            } else {
                this.ivNew.remove(key);
            }
        }
    }

    public static class MailShortInfo {
        public int ivVersion;
        public int ivOwnerID;

        public MailShortInfo(Mail mail) {
            this.ivVersion = mail.getInt("IDO_VERSION");
            this.ivOwnerID = (int)mail.getLong("MAI_OWNER_ID", 0L);
        }
    }
}

