/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.ObjectProvider;
import de.hannse.netobjects.objectstore.ObjectProviderMail;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.objectstore.requesthandler.OBRHS_Service_Manager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.db.DBAssistant;
import mausoleum.main.ProcessDefinition;

public abstract class ObjectStore {
    public static Vector getObjectsDeadOrAlive(int type, HashSet ids, String group, Hashtable objectBag, boolean onlyActual) {
        Vector<IDObject> res = new Vector<IDObject>();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            IDObject ido = ObjectStore.getObjectDeadOrAlive(type, id, group, objectBag, onlyActual);
            if (ido == null) continue;
            res.add(ido);
        }
        return res;
    }

    public static IDObject getObjectDeadOrAlive(int type, long id, String group, Hashtable objectBag, boolean onlyActual) {
        return ObjectStore.getObjectDeadOrAlive(type, id, group, objectBag, onlyActual, false);
    }

    public static IDObject getObjectDeadOrAlive(int type, long id, String group, Hashtable objectBag, boolean onlyActual, boolean evenNoxExisteds) {
        if (id > 0L) {
            if (ProcessDefinition.isServer()) {
                return ObjectStoreServer.getObjectDeadOrAlive(type, id, group, objectBag, onlyActual, evenNoxExisteds);
            }
            if (ProcessDefinition.isClient()) {
                return ObjectStore.getClientObject(type, id, group);
            }
        }
        return null;
    }

    public static Vector getObjects(int type, long[] ids, String group) {
        if (ids != null && ids.length != 0) {
            if (ProcessDefinition.isServer()) {
                if (DataLayer.USE_DB) {
                    Vector target = new Vector();
                    DBAssistant.getMoreObjects(group, type, ids, true, target, false);
                    return target;
                }
                ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
                if (op != null) {
                    return op.getObjectsDeadOrAlive(ids, false);
                }
            } else {
                Vector<IDObject> v = new Vector<IDObject>(ids.length);
                int i = 0;
                while (i < ids.length) {
                    IDObject ido = ObjectStore.getClientObject(type, ids[i], group);
                    if (ido != null) {
                        v.add(ido);
                    }
                    ++i;
                }
                return v;
            }
        }
        return null;
    }

    public static Vector getClientObjects(int type, long[] ids, String[] groups) {
        Vector<IDObject> v = null;
        if (ids != null && groups != null) {
            v = new Vector<IDObject>(ids.length);
            int i = 0;
            while (i < ids.length) {
                IDObject ido = ObjectStore.getClientObject(type, ids[i], groups[i]);
                if (ido != null) {
                    v.add(ido);
                }
                ++i;
            }
        }
        return v;
    }

    public static IDObject getClientObject(IDObject.IDObjectIdentifier idi) {
        return ObjectStore.getClientObject(idi.ivTyp, idi.ivID, idi.ivGroup);
    }

    public static IDObject getClientObject(int type, long id, String group) {
        ObjectManager manager;
        if (ProcessDefinition.isClient() && (manager = ObjectStoreClient.getManager(type)) != null) {
            return manager.getObject(id, group);
        }
        return null;
    }

    public static Vector getActualObjects(int type, String group) {
        ObjectManager manager;
        if (ProcessDefinition.isServer()) {
            return IntermediaerHelfer.getActualObjects(type, group);
        }
        if (ProcessDefinition.isClient() && (manager = ObjectStoreClient.getManager(type)) != null) {
            return manager.getActualObjectVector(group);
        }
        return null;
    }

    public static Iterator getActualObjectsITER(int type, String group) {
        ObjectManager manager;
        if (ProcessDefinition.isServer()) {
            return IntermediaerHelfer.getActualObjectsITER(type, group);
        }
        if (ProcessDefinition.isClient() && (manager = ObjectStoreClient.getManager(type)) != null) {
            return manager.getAllActITER(group);
        }
        return null;
    }

    public static void getAllObjects(int type, String group, Vector target) {
        if (ProcessDefinition.isServer()) {
            if (DataLayer.USE_DB) {
                Hashtable ht = DBAssistant.getAllObjects(group, type);
                target.addAll(ht.values());
                ht.clear();
            } else {
                ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
                if (op != null) {
                    Enumeration en = op.getAllObjects();
                    while (en.hasMoreElements()) {
                        target.add(en.nextElement());
                    }
                }
            }
        }
    }

    public static boolean handleGiveList(ObjectRequest or) {
        if (or.ivGroup != null) {
            Byte byti = (Byte)or.ivObject;
            int type = byti.intValue();
            if (DataLayer.USE_DB) {
                HashMap hm = new HashMap();
                long userID = -1L;
                if (type == 11) {
                    Long mailUserIdentifier = (Long)or.ivExtraObject;
                    userID = mailUserIdentifier;
                }
                DBAssistant.getActualIDVersionList(or.ivGroup, type, userID, hm);
                long[] ids = new long[hm.size()];
                int[] vss = new int[hm.size()];
                int z = 0;
                Iterator iterator = hm.keySet().iterator();
                while (iterator.hasNext()) {
                    Long id = (Long)iterator.next();
                    Integer version = (Integer)hm.get(id);
                    ids[z] = id;
                    vss[z] = version;
                    ++z;
                }
                Vector<long[]> v = new Vector<long[]>(2);
                v.addElement(ids);
                v.addElement(vss);
                hm.clear();
                or.ivObject = v;
                return true;
            }
            ObjectProvider opr = ObjectPortal.getObjectProvider(or.ivGroup, type);
            if (opr != null) {
                opr.giveIDAndVersionOfActualObjects(or);
                return true;
            }
        }
        return false;
    }

    public static void enterIDsForMail(Long mailUserIdentifier, HashMap erg) {
        ObjectProviderMail opm;
        Vector v;
        ObjectProvider op;
        if (!DataLayer.USE_DB && (op = ObjectPortal.getObjectProvider("service", 11)) != null && op instanceof ObjectProviderMail && (v = (opm = (ObjectProviderMail)op).giveIDAndVersionOfActualObjects(mailUserIdentifier)) != null && !v.isEmpty()) {
            long[] ids = (long[])v.firstElement();
            int i = 0;
            while (i < ids.length) {
                IDObject ido = opm.getObjectDeadOrAlive(ids[i], true, false);
                if (ido != null) {
                    OBRHS_Service_Manager.enterID(ido, erg);
                }
                ++i;
            }
        }
    }
}

