/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.user.UserManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.AftermathObject;

public class ObjectStoreClient {
    private static final HashMap MANAGERS = new HashMap();

    public static void addBroker(ObjectManager gob, int type) {
        MANAGERS.put(new Integer(type), gob);
    }

    public static HashSet getAllMausoleumTables() {
        HashSet sammler = new HashSet();
        if (ProcessDefinition.isClient()) {
            Iterator iter = MANAGERS.values().iterator();
            while (iter.hasNext()) {
                ObjectManager om = (ObjectManager)iter.next();
                om.addMausoleumTableModelConsumers(sammler);
            }
        }
        return sammler;
    }

    public static void digestObjectRequest(ObjectRequest or) {
        if (or.ivObject != null && or.ivObject instanceof HashMap) {
            HashMap objectsByGroup = (HashMap)or.ivObject;
            HashMap newObjectsByGroup = (HashMap)objectsByGroup.get("#sno");
            Vector objectHashsForGroups = new Vector();
            HashMap serviceRoomHM = (HashMap)objectsByGroup.get("#sri");
            Enumeration eng = UserManager.getGroupNamesServiceLast();
            while (eng.hasMoreElements()) {
                String group = (String)eng.nextElement();
                Hashtable groupHT = (Hashtable)objectsByGroup.get(group);
                if (groupHT == null || groupHT.isEmpty()) continue;
                Hashtable<Integer, Vector> objectHash = new Hashtable<Integer, Vector>();
                HashMap newObjects = null;
                if (newObjectsByGroup != null) {
                    newObjects = (HashMap)newObjectsByGroup.get(group);
                }
                HashMap ausRaumVerschwunden = MausoleumClient.isServiceCaretaker() ? new HashMap() : null;
                Enumeration en = groupHT.keys();
                while (en.hasMoreElements()) {
                    Integer objectTypeKey = (Integer)en.nextElement();
                    ObjectManager objectManager = (ObjectManager)MANAGERS.get(objectTypeKey);
                    if (objectManager == null) continue;
                    Vector newObjectIDs = null;
                    if (newObjects != null) {
                        newObjectIDs = (Vector)newObjects.get(objectTypeKey);
                    }
                    Hashtable theObjects = (Hashtable)groupHT.get(objectTypeKey);
                    if (MausoleumClient.isServiceCaretaker() && IDObject.canSitInRoom(objectTypeKey)) {
                        Vector ov;
                        Hashtable normale = new Hashtable();
                        Hashtable nochHolen = new Hashtable();
                        ObjectStoreClient.handleSCTExtra(theObjects, normale, nochHolen, serviceRoomHM, group, groupHT, objectTypeKey, objectManager, ausRaumVerschwunden, newObjectIDs);
                        if (!nochHolen.isEmpty()) {
                            long[] ids = new long[nochHolen.size()];
                            int pos = 0;
                            Iterator iter = nochHolen.keySet().iterator();
                            while (iter.hasNext()) {
                                Long longi = (Long)iter.next();
                                ids[pos++] = longi;
                                normale.put(longi, nochHolen.get(longi));
                            }
                            objectManager.getObjectsFromServer(ids, false, group);
                            if (objectTypeKey == 2) {
                                ObjectManager mausManager;
                                Vector indMice = new Vector(100);
                                int i = 0;
                                while (i < ids.length) {
                                    Cage cage = (Cage)objectManager.getObject(new Long(ids[i]), group);
                                    if (cage != null) {
                                        cage.determineActualMice();
                                        CageManager.checkWeddingStatus(cage, true, true);
                                        CageColorManager.prepareCage(cage);
                                        cage.addActualMice(indMice);
                                    }
                                    ++i;
                                }
                                if (!indMice.isEmpty() && (mausManager = (ObjectManager)MANAGERS.get(new Integer(1))) != null) {
                                    mausManager.notifyConsumers(indMice);
                                }
                                indMice.clear();
                                indMice = null;
                            }
                        }
                        if ((ov = objectManager.updateObjectsIfPresent(normale, newObjectIDs, group)) == null || ov.isEmpty()) continue;
                        objectHash.put(objectTypeKey, ov);
                        continue;
                    }
                    Vector ov = objectManager.updateObjectsIfPresent(theObjects, newObjectIDs, group);
                    if (ov == null || ov.isEmpty()) continue;
                    objectHash.put(objectTypeKey, ov);
                }
                objectHashsForGroups.add(objectHash);
                if (ausRaumVerschwunden == null || ausRaumVerschwunden.isEmpty()) continue;
                Iterator iter = ausRaumVerschwunden.keySet().iterator();
                while (iter.hasNext()) {
                    Integer typeKey = (Integer)iter.next();
                    ObjectManager objectManager = (ObjectManager)MANAGERS.get(typeKey);
                    if (objectManager == null) continue;
                    objectManager.notifyConsumersForServiceRoomLeaving(typeKey, group, (HashSet)ausRaumVerschwunden.get(typeKey));
                }
            }
            Iterator iter = objectHashsForGroups.iterator();
            while (iter.hasNext()) {
                Hashtable objectHash = (Hashtable)iter.next();
                AftermathObject amo = new AftermathObject();
                Enumeration en = objectHash.keys();
                while (en.hasMoreElements()) {
                    Integer objectTypeKey = (Integer)en.nextElement();
                    ObjectManager objectManager = (ObjectManager)MANAGERS.get(objectTypeKey);
                    if (objectManager == null) continue;
                    objectManager.performObjectInsertionAftermath(or, (Vector)objectHash.get(objectTypeKey), amo);
                }
                amo.performFinalAftermath();
            }
        }
    }

    private static void handleSCTExtra(Hashtable theObjects, Hashtable normale, Hashtable nochHolen, HashMap serviceRoomHM, String group, Hashtable groupHT, Integer objectTypeKey, ObjectManager objectManager, HashMap ausRaumVerschwunden, Vector newObjectIDs) {
        Enumeration enx = theObjects.keys();
        while (enx.hasMoreElements()) {
            Long objectID = (Long)enx.nextElement();
            boolean drin = false;
            if (serviceRoomHM != null) {
                Long srID = (Long)serviceRoomHM.get(IDObject.getIdentifierString(group, objectTypeKey, objectID));
                boolean bl = drin = srID != null && srID.equals(MausoleumClient.cvServiceCTRoomID);
            }
            if (drin) {
                if (objectManager.getLocalObject(objectID, group) != null) {
                    normale.put(objectID, theObjects.get(objectID));
                    continue;
                }
                nochHolen.put(objectID, theObjects.get(objectID));
                continue;
            }
            objectManager.removeObject(group, objectID);
            HashSet<Long> entfHS = (HashSet<Long>)ausRaumVerschwunden.get(objectTypeKey);
            if (entfHS == null) {
                entfHS = new HashSet<Long>();
                ausRaumVerschwunden.put(objectTypeKey, entfHS);
            }
            entfHS.add(objectID);
        }
    }

    public static ObjectManager getManager(int objectType) {
        return (ObjectManager)MANAGERS.get(new Integer(objectType));
    }

    public static void addConsumer(ObjectConsumer oc, int type) {
        ObjectManager gob = (ObjectManager)MANAGERS.get(new Integer(type));
        if (gob != null) {
            gob.addConsumer(oc);
        }
    }

    public static void addConsumer(ObjectConsumer oc, int[] types) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                ObjectManager gob = (ObjectManager)MANAGERS.get(new Integer(types[i]));
                if (gob != null) {
                    gob.addConsumer(oc);
                }
                ++i;
            }
        }
    }

    public static void removeConsumer(ObjectConsumer oc, int type) {
        ObjectManager gob = (ObjectManager)MANAGERS.get(new Integer(type));
        if (gob != null) {
            gob.removeConsumer(oc);
        }
    }

    public static void removeConsumer(ObjectConsumer oc, int[] types) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                ObjectManager gob = (ObjectManager)MANAGERS.get(new Integer(types[i]));
                if (gob != null) {
                    gob.removeConsumer(oc);
                }
                ++i;
            }
        }
    }
}

