/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import mausoleum.mail.Mail;

public class ObjectStoreServer {
    static /* synthetic */ Class class$0;

    public static boolean insertSingleMailObjectToForeignGroup(Mail mail) {
        mail.addSession(new Long(System.currentTimeMillis()));
        ObjectStoreServer.commitObject(mail, mail.getGroup());
        ServerPortal.broadcastObjectToGroup(mail, mail.getGroup(), false, false);
        return true;
    }

    public static void commitObject(IDObject iob, String group) {
        Hashtable<String, IDObject> toSend = new Hashtable<String, IDObject>(1);
        toSend.put("a", iob);
        if (!DataLayer.USE_DB) {
            ObjectPortal.digestObjectBag(toSend);
        }
        DataLayer.cvDataLayer.digestObjectBag(toSend, group);
    }

    public static boolean writeHashtable(Hashtable objectBag, Session session, boolean noSessionAllowed) {
        Long sid = null;
        if (session != null) {
            sid = session.ivIsServiceSession ? new Long(-session.getID()) : new Long(session.getID());
        } else if (!noSessionAllowed) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectStoreServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("No valid session supplied for 'writeHashtable'", illegalArgumentException, clazz);
        }
        if (sid != null) {
            Enumeration en = objectBag.elements();
            while (en.hasMoreElements()) {
                IDObject iob = (IDObject)en.nextElement();
                iob.addSession(sid);
            }
        }
        if (!DataLayer.USE_DB) {
            ObjectPortal.digestObjectBag(objectBag);
        }
        DataLayer.cvDataLayer.digestObjectBag(objectBag, session != null ? session.getGroup() : null);
        return true;
    }

    public static IDObject getObjectToUpdate(int type, long id, String myGroup, Hashtable objectBag) {
        return ObjectStoreServer.getObjectDeadOrAlive(type, id, myGroup, objectBag, false, false);
    }

    public static IDObject getObjectDeadOrAlive(int type, long id, String group, Hashtable objectBag, boolean onlyActual, boolean evenNonExisteds) {
        IDObject res = null;
        if (id > 0L && group != null && type > 0) {
            String key;
            String string = key = objectBag != null ? IDObject.getIdentifierString(group, type, id) : null;
            if (objectBag != null) {
                res = (IDObject)objectBag.get(key);
            }
            if (res == null && (res = IntermediaerHelfer.getObjectDeadOrAlive(group, type, id, onlyActual, evenNonExisteds)) != null && objectBag != null) {
                objectBag.put(key, res);
            }
            if (res == null) {
                String string2 = "Object not found Group >" + group + "< Type >" + IDObject.getASCIILabelForType(type) + "< ID " + id;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectStoreServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string2, null, clazz);
            }
        }
        return res;
    }

    public static Vector getActualObjects(int type, String group) {
        Hashtable ht = DataLayer.cvDataLayer.getAllActualObjects(group, type);
        if (ht == null) {
            return new Vector();
        }
        Vector erg = new Vector(ht.size());
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            erg.addElement(en.nextElement());
        }
        return erg;
    }
}

