/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.actions;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.actions.OBRHAction;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class OABrowse
extends OBRHAction {
    public static final String COM_OBJECT = "object";
    public static final String COM_OBJECTLIST = "objectlist";
    public static final String COM_OBJECTS = "objects";
    public static final String COM_GROUPS = "groups";
    static /* synthetic */ Class class$0;

    public OABrowse() {
        super((byte)33, 4);
    }

    public void handle(ObjectRequest or, ObjectRequestHandlerServer obrhs) {
        obrhs.denyOrFinish(or, OABrowse.handleBrowse(or));
    }

    private static boolean handleBrowse(ObjectRequest or) {
        boolean finishIt = false;
        Vector<String> resLines = new Vector<String>();
        Vector v = StringHelper.splitStringByAny((String)or.ivObject, "|");
        HashSet wantedObjectTypes = (HashSet)or.ivExtraObject;
        String com = (String)v.elementAt(0);
        if (com.equalsIgnoreCase(COM_GROUPS)) {
            Enumeration en = DataLayer.cvDataLayer.getAllGroupnames(false);
            while (en.hasMoreElements()) {
                String groupName = (String)en.nextElement();
                resLines.add(String.valueOf(groupName) + "\t" + COM_OBJECTS + "|" + groupName);
            }
            Collections.sort(resLines, StringHelper.CASE_INSENSITIVE_COMPARER);
            or.ivExtraObject = DataLayer.cvDataLayer.getGroups(true);
            finishIt = OABrowse.finishBrowse(or, resLines);
        } else if (com.equalsIgnoreCase(COM_OBJECTS)) {
            String group = (String)v.elementAt(1);
            int[] typen = DataLayer.getTypen(group);
            int i = 0;
            while (i < typen.length) {
                Integer key = new Integer(typen[i]);
                if (wantedObjectTypes == null || wantedObjectTypes.contains(key)) {
                    resLines.add(String.valueOf(IDObject.getASCIILabelForType(key)) + " [" + IntermediaerHelfer.getActualObjectCount(group, typen[i]) + "]" + "\t" + COM_OBJECTLIST + "|" + group + "|" + key);
                }
                ++i;
            }
            Collections.sort(resLines);
            finishIt = OABrowse.finishBrowse(or, resLines);
        } else if (com.equalsIgnoreCase(COM_OBJECTLIST)) {
            try {
                Vector aov;
                String group = (String)v.elementAt(1);
                String typIS = (String)v.elementAt(2);
                Integer objectType = new Integer(typIS);
                if ((wantedObjectTypes == null || wantedObjectTypes.contains(objectType)) && (aov = ObjectStore.getActualObjects(Integer.parseInt(typIS), group)) != null) {
                    Iterator iterator = aov.iterator();
                    while (iterator.hasNext()) {
                        IDObject obi = (IDObject)iterator.next();
                        resLines.add(String.valueOf(obi.getBrowseName()) + "\t" + COM_OBJECT + "|" + group + "|" + typIS + "|" + obi.getID());
                    }
                }
                Collections.sort(resLines);
            }
            catch (Throwable e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.actions.OABrowse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem bei BROWSE[objectlist]", e, clazz);
            }
            finishIt = OABrowse.finishBrowse(or, resLines);
        } else if (com.equalsIgnoreCase(COM_OBJECT)) {
            try {
                IDObject obi;
                String group = (String)v.elementAt(1);
                String typIS = (String)v.elementAt(2);
                String idLS = (String)v.elementAt(3);
                Integer objectType = new Integer(typIS);
                if ((wantedObjectTypes == null || wantedObjectTypes.contains(objectType)) && (obi = ObjectStore.getObjectDeadOrAlive(Integer.parseInt(typIS), Long.parseLong(idLS), group, null, false)) != null) {
                    obi.addBrowserLines(resLines, group, wantedObjectTypes);
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.actions.OABrowse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem bei BROWSE[object]", e, clazz);
            }
            finishIt = OABrowse.finishBrowse(or, resLines);
        }
        return finishIt;
    }

    private static boolean finishBrowse(ObjectRequest or, Vector lines) {
        String[] preres = new String[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            preres[i] = (String)lines.elementAt(i);
            ++i;
        }
        or.ivObject = preres;
        return true;
    }
}

