/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.actions;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.actions.OBRHAction;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.tools.Base64Manager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class OAFindGroupBasicObjects
extends OBRHAction {
    public OAFindGroupBasicObjects() {
        super((byte)67, 8);
    }

    public void handle(ObjectRequest or, ObjectRequestHandlerServer obrhs) {
        boolean finishIt = false;
        String group = (String)or.ivObject;
        Zeile zzz = new Zeile((String)or.ivExtraObject, '|');
        String resultat = null;
        if (group != null) {
            int type = zzz.getInt(0, -1);
            if (type == 3) {
                resultat = this.handleFindGroupRacksFromBasicObjects(or, group, zzz.getBoolean(1, "1", "0", false));
            } else {
                Vector idos = ObjectStore.getActualObjects(type, group);
                StringBuffer msb = new StringBuffer();
                Iterator iterator = idos.iterator();
                while (iterator.hasNext()) {
                    Strain strain;
                    String prefi;
                    Line line;
                    IDObject ido = (IDObject)iterator.next();
                    if (!ido.isAliveAndVisible()) continue;
                    boolean serviceImportable = true;
                    if (ido instanceof Line && (line = (Line)ido).isBreeder()) {
                        serviceImportable = false;
                    }
                    if (msb.length() != 0) {
                        msb.append("\n");
                    }
                    msb.append(ido.getID()).append("|");
                    String name = ido.getBrowseName();
                    if (ido instanceof Locus) {
                        Locus locus = (Locus)ido;
                        String alleles = locus.getLocusAllelString();
                        if (alleles != null && alleles.length() != 0) {
                            name = String.valueOf(name) + " (" + alleles + ")";
                        }
                    } else if (ido instanceof Line) {
                        String prefi2;
                        Line line2 = (Line)ido;
                        LocusAndAlleles[] lal = (LocusAndAlleles[])line2.get("LIN_LOCIALLELES");
                        if (lal != null && lal.length != 0) {
                            StringBuilder lasb = new StringBuilder();
                            int i = 0;
                            while (i < lal.length) {
                                Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, lal[i].ivLocusID, line2.getGroup(), null, false);
                                if (locus != null) {
                                    if (lasb.length() != 0) {
                                        lasb.append(", ");
                                    }
                                    lasb.append(locus.getBrowseName());
                                }
                                ++i;
                            }
                            if (lasb.length() != 0) {
                                name = String.valueOf(name) + " (" + lasb.toString() + ")";
                            }
                        }
                        if ((prefi2 = line2.getString("LIN_ETPREFIX", null)) != null && prefi2.trim().length() != 0) {
                            name = String.valueOf(name) + " [" + prefi2 + "]";
                        }
                    } else if (ido instanceof Strain && (prefi = (strain = (Strain)ido).getString("STR_ETPREFIX", null)) != null && prefi.trim().length() != 0) {
                        name = String.valueOf(name) + " [" + prefi + "]";
                    }
                    msb.append(Base64Manager.encodeBase64(name)).append("|");
                    msb.append(Base64Manager.encodeBase64(ido.getString("IDO_DOK", ""))).append("|");
                    msb.append(ido.getLong("IDO_SERVID", -1L)).append("|");
                    msb.append(serviceImportable ? "1" : "0");
                }
                resultat = msb.toString();
            }
        }
        if (resultat != null) {
            or.ivObject = resultat;
            finishIt = true;
        }
        obrhs.denyOrFinish(or, finishIt);
    }

    private String handleFindGroupRacksFromBasicObjects(ObjectRequest or, String group, boolean withMiceInfo) {
        String resultat = null;
        if (group != null) {
            StringBuffer msb = new StringBuffer();
            Vector racks = ObjectStore.getActualObjects(3, group);
            if (racks != null && !racks.isEmpty()) {
                Collections.sort(racks, AllgUtils.ID_OBJECT_BY_BROWSERNAME);
                Iterator iter = racks.iterator();
                while (iter.hasNext()) {
                    Rack rack = (Rack)iter.next();
                    if (msb.length() != 0) {
                        msb.append("\n");
                    }
                    msb.append(rack.getID()).append("|");
                    msb.append(Base64Manager.encodeBase64(rack.getBrowseName())).append("|");
                    msb.append("|");
                    msb.append(rack.getLong("IDO_SERVID", -1L)).append("|");
                    msb.append("1|");
                    msb.append(rack.getInt("RCK_SIDES")).append("|");
                    msb.append(rack.getInt("RCK_ROWS")).append("|");
                    msb.append(rack.getInt("RCK_COLUMNS")).append("|");
                    int anzMice = 0;
                    int anzMatings = 0;
                    int anzNonEmpty = 0;
                    long[] occ = (long[])rack.get("RCK_CAGES");
                    if (occ != null) {
                        int i = 0;
                        while (i < occ.length) {
                            if (occ[i] != 0L) {
                                Cage cage;
                                msb.append("1");
                                if (withMiceInfo && (cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, occ[i], group, null, true)) != null) {
                                    boolean mating = false;
                                    boolean maleDa = false;
                                    boolean femaleDa = false;
                                    boolean nonEmpty = false;
                                    Visit[] vs = (Visit[])cage.get("CAG_VISIT");
                                    if (vs != null) {
                                        int ci = 0;
                                        while (ci < vs.length) {
                                            if (vs[ci].ivEndDate == null) {
                                                Mouse mouse;
                                                ++anzMice;
                                                nonEmpty = true;
                                                if (!mating && (mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, vs[ci].ivMouseID, group, null, true)) != null) {
                                                    int sex = mouse.getSex();
                                                    if (!maleDa && sex == 1 && mouse.isSexActive()) {
                                                        maleDa = true;
                                                        if (femaleDa) {
                                                            mating = true;
                                                        }
                                                    } else if (!femaleDa && sex == 2 && mouse.isSexActive()) {
                                                        femaleDa = true;
                                                        if (maleDa) {
                                                            mating = true;
                                                        }
                                                    }
                                                }
                                            }
                                            ++ci;
                                        }
                                    }
                                    if (mating) {
                                        ++anzMatings;
                                    }
                                    if (nonEmpty) {
                                        ++anzNonEmpty;
                                    }
                                }
                            } else {
                                msb.append("0");
                            }
                            ++i;
                        }
                    }
                    msb.append("|");
                    msb.append(anzMice).append("|");
                    msb.append(anzMatings).append("|");
                    msb.append(anzNonEmpty).append("|");
                }
            }
            resultat = msb.toString();
        }
        return resultat;
    }
}

