/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.actions;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.objectstore.actions.OBRHAction;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.HashMap;

public class OALogin
extends OBRHAction {
    public OALogin() {
        super((byte)3, 5);
    }

    public void handle(ObjectRequest or, ObjectRequestHandlerServer obrhs) {
        boolean finishIt = false;
        if (or != null && or.ivObject != null && or.ivObject instanceof HashMap) {
            HashMap ht = (HashMap)or.ivObject;
            String group = (String)ht.get("IDO_GROUP");
            boolean isAdmin = "Administrator".equals(group);
            if (!isAdmin && !DataLayer.cvDataLayer.isGroupEnabled(group)) {
                or.ivObject = "The group does not exist or is disabled";
            } else if (!isAdmin && !ServerPortal.isLoginAllowedByReserveds(group)) {
                or.ivObject = "#licex";
            } else if (isAdmin) {
                if (ht.get("USR_PASSWORD").equals(ObjectRequestHandlerServer.cvAktAdminPassword)) {
                    HashMap<String, Object> hashMap;
                    or.ivObject = hashMap = new HashMap<String, Object>();
                    hashMap.put("USR_LANGUAGE", "en");
                    if (!ServerPortal.isAdministratorLoginAllowed()) {
                        Log.warn("Additional Administrator logged in. Setting to emergency mode", this);
                        hashMap.put("USR_MODE", new Integer(1001));
                    } else {
                        hashMap.put("USR_MODE", new Integer(1000));
                    }
                    hashMap.put("USR_NAME", "Administrator");
                    hashMap.put("IDO_GROUP", "Administrator");
                    obrhs.ivGroupName = "Administrator";
                    obrhs.ivUserName = "Administrator";
                    obrhs.ivCommunicator.setIsAdministrator(true);
                    obrhs.ivCommunicator.setStatus(2);
                    finishIt = true;
                }
            } else {
                User loggedinUser = User.handleLogin(or);
                if (loggedinUser != null) {
                    obrhs.ivGroupName = loggedinUser.getGroup();
                    obrhs.ivUserName = loggedinUser.getString("USR_NAME");
                    obrhs.ivSession = new Session();
                    obrhs.ivSession.setLong("SES_USER", loggedinUser.getID());
                    obrhs.ivSession.set("IDO_START_DATE", new Date());
                    obrhs.ivSession.set("IDO_GROUP", loggedinUser.getGroup());
                    obrhs.ivSession.set("SES_ADRESS", obrhs.ivCommunicator.getNetAddress());
                    DataLayer.cvDataLayer.provideNewIDToIDObject(obrhs.ivSession);
                    obrhs.ivSession.commit(true);
                    obrhs.ivSession.ivIsServiceSession = obrhs.ivGroupName.equals("service");
                    ObjectStoreServer.commitObject(obrhs.ivSession, obrhs.ivGroupName);
                    or.ivObject = loggedinUser.getPropertiesHM();
                    obrhs.ivCommunicator.setIsAdministrator(false);
                    obrhs.ivCommunicator.setStatus(2);
                    finishIt = true;
                }
            }
        }
        obrhs.denyOrFinish(or, finishIt);
    }
}

