/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.actions;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.actions.OBRHAction;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mausoleum.cage.Cage;
import mausoleum.datalayer.DataLayerMausoleum;

public class OARestoreGroup
extends OBRHAction {
    static /* synthetic */ Class class$0;

    public OARestoreGroup() {
        super((byte)29, 4);
    }

    public void handle(ObjectRequest or, ObjectRequestHandlerServer obrhs) {
        obrhs.denyOrFinish(or, this.handleRESTOREGROUP(or));
    }

    private boolean handleRESTOREGROUP(ObjectRequest or) {
        boolean finishIt = false;
        try {
            String groupName = (String)or.ivObject;
            byte[] data = (byte[])or.ivExtraObject;
            if (DataLayer.cvDataLayer.addGroup(groupName, null)) {
                String zn;
                Vector<ZipEntry> secondaryXMLFiles = new Vector<ZipEntry>();
                HashSet<String> erledigte = new HashSet<String>();
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(data)));
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    zn = ze.getName();
                    if (zn.endsWith(".roi")) {
                        OARestoreGroup.handleROI(ze, zis, groupName);
                        erledigte.add(zn);
                    } else if (zn.endsWith(".troi")) {
                        OARestoreGroup.handleROI(ze, zis, groupName);
                        erledigte.add(zn);
                    } else if (zn.endsWith(".stxt")) {
                        OARestoreGroup.handleNormalFile(ze, zis, groupName);
                        erledigte.add(zn);
                    } else if (zn.startsWith("docs/") || zn.startsWith("docs\\")) {
                        OARestoreGroup.handleNormalFile(ze, zis, groupName);
                        erledigte.add(zn);
                    }
                    ze = zis.getNextEntry();
                }
                zis.close();
                zis = new ZipInputStream(new ByteArrayInputStream(data));
                ze = zis.getNextEntry();
                while (ze != null) {
                    zn = ze.getName();
                    if (!erledigte.contains(zn)) {
                        if (zn.equals("Backup.xml")) {
                            this.handleXMLEntry(zis, groupName, (DataLayerMausoleum)DataLayer.cvDataLayer);
                        } else if (zn.endsWith(".xml")) {
                            secondaryXMLFiles.addElement(ze);
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.close();
                GroupFileManager.prepareGroupDir(groupName);
                ObjectPortal.lookForGroup(groupName);
                finishIt = true;
            }
        }
        catch (Exception e) {
            Log.error("Problem bei handleRESTOREGROUP", e, this);
        }
        return finishIt;
    }

    private void handleXMLEntry(ZipInputStream zis, String groupname, DataLayerMausoleum dlfs) throws Exception {
        IDObject idu = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(zis));
        String line = in.readLine();
        while (line != null) {
            try {
                String tt = line.trim();
                if (tt.startsWith("<I")) {
                    Cage nc;
                    idu = IDObjectXMLHandler.initObjectFromXMLString(tt, groupname, dlfs);
                    idu.set("IDO_GROUP", groupname);
                    if (idu instanceof Cage && (nc = (Cage)idu).get("IDO_END_DATE") == null && nc.getInt("CAG_PSEUDOID") <= 0) {
                        nc.setInt("CAG_PSEUDOID", (int)nc.getID());
                    }
                    idu.commit(true);
                    dlfs.saveIDObject(idu);
                }
                line = in.readLine();
            }
            catch (Exception e) {
                System.out.println("Problem bei handleXMLEntry " + line + " -> " + e);
            }
        }
        zis.closeEntry();
    }

    private static void handleROI(ZipEntry ze, ZipInputStream zis, String group) throws Exception {
        try {
            byte[] b = OARestoreGroup.readEntryData(zis);
            if (b != null) {
                String dirname = GroupFileManager.getResultsPath(group);
                FileManager.prepareDirs(dirname);
                FileOutputStream fos = new FileOutputStream(String.valueOf(dirname) + "/" + ze.getName());
                fos.write(b);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            System.out.println("Problem bei handleROI " + e);
        }
    }

    private static void handleNormalFile(ZipEntry ze, ZipInputStream zis, String group) throws Exception {
        try {
            byte[] b = OARestoreGroup.readEntryData(zis);
            if (b != null) {
                String dirname = GroupFileManager.getGroupDir(group);
                String filename = ze.getName();
                filename = StringHelper.gSub(filename, "\\", "/");
                String destFilename = String.valueOf(dirname) + "/" + filename;
                FileManager.prepareDirsForFile(destFilename);
                FileOutputStream fos = new FileOutputStream(destFilename);
                fos.write(b);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            System.out.println("Problem bei handleROI " + e);
        }
    }

    private static final byte[] readEntryData(ZipInputStream zis) {
        byte[] buff = new byte[2048];
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean cont = true;
            while (cont) {
                int gel = zis.read(buff, 0, 2048);
                if (gel == -1) {
                    cont = false;
                    continue;
                }
                bos.write(buff, 0, gel);
            }
            byte[] b = bos.toByteArray();
            bos.close();
            zis.closeEntry();
            return b;
        }
        catch (Throwable e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Could not read ZipEntry", e, clazz);
            return null;
        }
    }
}

