/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.requesthandler;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.CommandManager;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.objectstore.SearchProcess;
import de.hannse.netobjects.objectstore.actions.OBRHAction;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ObjectRequestHandlerServer
extends ObjectRequestHandler
implements Runnable {
    public static final int MAX_SEARCHES = 3;
    public static final int MAX_SEND_OBJECTS = 25;
    public static final String DAS_WARS = "DAS_WARS";
    private static final String DEFAULT_ADMIN_PASSWORD = "WsyAoAZpsy";
    public static final String ADMIN_PASSWORD_DIRNAME = "data";
    public static final String ADMIN_PASSWORD_FILENAME = "data/madmpw.txt";
    public static final String MIN_LOG_LEVEL_FILENAME = "data/minloglevel.txt";
    public static final HashMap SEARCHES = new HashMap(3);
    public static final HashMap OBJECT_HOLER = new HashMap(100);
    public static final HashMap OBJECT_HOLER_FINISHED = new HashMap(100);
    public static boolean cvActive = true;
    public static String cvAktAdminPassword = null;
    public ServerCommunicator ivCommunicator = null;
    public Session ivSession = null;
    public String ivGroupName = null;
    public String ivGroupNameHOSExtra = null;
    public String ivUserName = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ObjectRequestHandlerServer(ServerCommunicator sc) {
        this.ivCommunicator = sc;
        String s = FileManager.getStringFromFile(ADMIN_PASSWORD_FILENAME, false);
        cvAktAdminPassword = s == null || s.trim().length() == 0 ? DEFAULT_ADMIN_PASSWORD : s;
    }

    public void dohandleObjectRequest(ObjectRequest or) {
        if (!cvActive) {
            this.denyRequest(or);
            return;
        }
        try {
            long l1 = System.currentTimeMillis();
            if (Log.shouldLog(0)) {
                Log.subdebug("New Objectrequest " + or.toShortString(), this);
            }
            OBRHAction.handleRequest(or, this);
            if (Log.shouldLog(0)) {
                Log.subdebug("Finished Objectrequest (" + (System.currentTimeMillis() - l1) + " ms) " + or.ivMagicString, this);
            }
            return;
        }
        catch (Exception e) {
            String string = "Problem executing request " + or;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            this.denyRequest(or);
            return;
        }
    }

    public int getNumSessionCommands() {
        Vector v = null;
        if (this.ivSession != null) {
            v = this.ivSession.getVector("SES_COMMAND");
        }
        return v == null ? 0 : v.size();
    }

    public static void handleCOMMITSUICIDE() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("User requested shutdown", clazz);
        cvActive = false;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("ObjectRequestHandlerServer was set to passive", clazz2);
        ServerPortal.shutDown();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("ServerPortal was shut down", clazz3);
        CommandManager.cvActive = false;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("CommandManager was set to passive", clazz4);
        Iterator iter = SEARCHES.values().iterator();
        while (iter.hasNext()) {
            SearchProcess sp = (SearchProcess)iter.next();
            sp.commitSuicide();
        }
        SEARCHES.clear();
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Search processes were terminated", clazz5);
        ObjectPortal.dispose();
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("ObjectPortal was terminated", clazz6);
        DataLayer.cvActive = false;
        Class<?> clazz7 = class$1;
        if (clazz7 == null) {
            try {
                clazz7 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("DataLayer was terminated", clazz7);
        Class<?> clazz8 = class$1;
        if (clazz8 == null) {
            try {
                clazz8 = class$1 = Class.forName("de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("User requested shutdown completed", clazz8);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void endYourSession() {
        Session sess;
        if (this.ivSession != null && (sess = this.ivSession) != null) {
            sess.ivIsNew = false;
            sess.set("IDO_END_DATE", new Date());
            sess.commit(true);
            ObjectStoreServer.commitObject(sess, sess.getGroup());
            this.ivSession = null;
        }
    }

    public void denyOrFinish(ObjectRequest or, boolean finishIt, Object res) {
        or.ivObject = res;
        this.denyOrFinish(or, finishIt);
    }

    public void denyOrFinish(ObjectRequest or, boolean finishIt) {
        if (finishIt) {
            ObjectRequestHandlerServer.finishRequest(or, this.ivCommunicator);
        } else {
            this.denyRequest(or);
        }
    }

    public void finishRequest(ObjectRequest or) {
        ObjectRequestHandlerServer.finishRequest(or, this.ivCommunicator);
    }

    private static void finishRequest(ObjectRequest or, ServerCommunicator communicator) {
        if (or != null) {
            or.finish();
            if (communicator != null) {
                communicator.sendObjectAndUR(or, false);
            }
        }
    }

    public void denyRequest(ObjectRequest or) {
        if (or != null) {
            or.deny();
            if (this.ivCommunicator != null) {
                this.ivCommunicator.sendObjectAndUR(or, false);
            }
        }
    }
}

