/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.server.http;

import de.hannse.netobjects.server.http.NetworkRequest;
import de.hannse.netobjects.server.http.NetworkResponse;
import de.hannse.netobjects.server.http.Resource;
import de.hannse.netobjects.util.Log;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class HTTPRequestWorker
extends Thread {
    private Socket ivSocket = null;

    public HTTPRequestWorker(Socket s) {
        this.ivSocket = s;
    }

    public void run() {
        DataOutputStream out_stream = null;
        try {
            out_stream = new DataOutputStream(this.ivSocket.getOutputStream());
        }
        catch (IOException e) {
            Log.warn("Problem getting output stream ", e, this);
            this.ivSocket = null;
            return;
        }
        try {
            NetworkRequest request = NetworkRequest.generateRequest(this.ivSocket.getInputStream(), this.ivSocket.getInetAddress().toString());
            if (request != null) {
                this.processRequest(request, out_stream);
                out_stream.flush();
                out_stream.close();
                this.ivSocket = null;
            }
        }
        catch (Exception e) {
            Log.warn("Problem processing request 2 ", e, this);
        }
    }

    private void processRequest(NetworkRequest request, DataOutputStream out) throws Exception {
        NetworkResponse res = new NetworkResponse();
        String result = Resource.handleResourceRequest(request.getRequestString(), res);
        out.write(result.getBytes());
        byte[] b = res.getData();
        if (b != null) {
            try {
                out.write(b);
            }
            catch (SocketException e) {
                Log.warn("SocketException while writing response byte data ", null, this);
            }
            catch (Exception e) {
                Log.error("Could not write response byte data ", e, this);
            }
        }
    }
}

