/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.server.http;

import de.hannse.netobjects.server.http.NetworkResponse;
import de.hannse.netobjects.tools.FileManager;
import java.io.File;
import java.util.Hashtable;
import mausoleum.util.InstallationType;

public class Resource {
    public static final String DIRNAME = "HTML";
    private static Hashtable cvResources = new Hashtable();
    public String ivName = null;
    public String ivFileName = null;
    public byte[] ivData = null;
    public String ivType = null;
    public long ivFileDate = -1L;

    public static String handleResourceRequest(String name, NetworkResponse response) {
        Resource res;
        if (name.indexOf(".jar") != -1) {
            return Resource.handleJAR(name, response);
        }
        if (name.trim().length() == 0) {
            String string = name = InstallationType.isFish() ? "homeF.html" : "home.html";
        }
        if ((res = (Resource)cvResources.get(name)) == null) {
            res = Resource.createResource(name);
        }
        if (res == null) {
            StringBuffer msb = new StringBuffer();
            msb.append("HTTP/1.0 404 Not found\r\n");
            msb.append("\r\n");
            response.setData(null);
            return msb.toString();
        }
        res = Resource.checkResource(res);
        StringBuffer msb = new StringBuffer();
        msb.append("HTTP/1.0 200 OK\r\n");
        msb.append("Content-Type: " + res.ivType + "\r\n");
        msb.append("Content-Length: " + res.ivData.length + "\r\n");
        msb.append("\r\n");
        response.setData(res.ivData);
        return msb.toString();
    }

    private static String handleJAR(String name, NetworkResponse response) {
        Resource res;
        int ind = name.indexOf("?");
        if (ind != -1) {
            name = name.substring(0, ind);
        }
        if ((res = (Resource)cvResources.get(name)) == null) {
            res = Resource.createResource(name);
        }
        if (res == null) {
            StringBuffer msb = new StringBuffer();
            msb.append("HTTP/1.0 404 Not found\r\n");
            msb.append("\r\n");
            response.setData(null);
            return msb.toString();
        }
        res = Resource.checkResource(res);
        StringBuffer msb = new StringBuffer();
        msb.append("HTTP/1.0 200 OK\r\n");
        msb.append("Content-Type: " + res.ivType + "\r\n");
        msb.append("Content-Length: " + res.ivData.length + "\r\n");
        msb.append("x-java-jnlp-version-id: " + res.ivFileDate + "\r\n");
        msb.append("\r\n");
        response.setData(res.ivData);
        return msb.toString();
    }

    private static Resource checkResource(Resource res) {
        File f = new File(res.ivFileName);
        if (!f.exists()) {
            return res;
        }
        if (f.lastModified() > res.ivFileDate) {
            return Resource.createResource(res.ivName);
        }
        return res;
    }

    private static Resource createResource(String name) {
        if ("favicon.ico".equals(name) && InstallationType.isFish()) {
            name = "faviconF.ico";
        }
        String fn = "HTML/" + name;
        File f = new File(fn);
        byte[] b = FileManager.getBytesFromFile(fn);
        if (b == null) {
            return null;
        }
        Resource res = new Resource();
        res.ivName = name;
        res.ivFileName = fn;
        res.ivData = b;
        res.ivFileDate = f.lastModified();
        res.ivType = fn.endsWith(".gif") ? "image/gif" : (fn.endsWith(".jpeg") || fn.endsWith(".jpg") || fn.endsWith(".jpe") ? "image/jpeg" : (fn.endsWith(".jar") ? "application/java-archive" : (fn.endsWith(".jnlp") ? "application/x-java-jnlp-file" : (fn.endsWith(".class") ? "application/java-class" : (fn.endsWith(".htm") || fn.endsWith(".html") ? "text/html" : "text/plain")))));
        cvResources.put(name, res);
        return res;
    }
}

