/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.session;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.DoObject;
import de.hannse.netobjects.objectstore.IDObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import mausoleum.helper.Zeile;

public class Session
extends IDObject {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final String SES_PREFIX = "SES_";
    public static final String USERID = "SES_USER";
    public static final String NETADDRESS = "SES_ADRESS";
    public static final String COMMANDS = "SES_COMMAND";
    public static final String[] ATTRIBUTES_SES;
    public static final String[] ORDERED_ATTRIBUTES;
    private static final int MAX_UNDO = 20;
    private final transient Stack ivUndoStack = new Stack();
    private final transient Stack ivRedoStack = new Stack();
    public transient boolean ivIsServiceSession = false;
    public transient long ivServiceRoomID = 0L;
    public transient HashSet ivGroupNames = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        String[] stringArray = new String[6];
        stringArray[0] = USERID;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = NETADDRESS;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = COMMANDS;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        ATTRIBUTES_SES = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", USERID, NETADDRESS, COMMANDS};
    }

    public void addToLog(Zeile newCommands, String objectGroup, long millis) {
        Vector<String> commandsSoFar = this.getVector(COMMANDS);
        if (commandsSoFar == null) {
            commandsSoFar = new Vector<String>();
            this.set(COMMANDS, commandsSoFar);
        }
        String group = this.getGroup();
        String milliPre = null;
        milliPre = objectGroup == null || objectGroup.equals(group) ? "[" + millis + "]" : "[" + millis + "|" + objectGroup + "]";
        int i = 0;
        while (i < newCommands.size()) {
            String command = newCommands.getStringNONEmpty(i, null);
            if (command != null) {
                command = CommandManagerExecutive.checkServiceRoomTag(command, null);
                commandsSoFar.add(String.valueOf(milliPre) + command);
            }
            ++i;
        }
    }

    public String getName(String nullval) {
        return nullval;
    }

    public String getName() {
        return null;
    }

    public String getBrowseName() {
        return "Session " + this.getID();
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        Vector v;
        String s;
        super.addBrowserLines(target, group, wantedObjectTypes);
        long l = this.getLong(USERID, 0L);
        if (l != 0L) {
            target.add("User\tobject|" + group + "|" + 6 + "|" + l);
        }
        if ((s = this.getString(NETADDRESS, null)) != null) {
            target.add("Net address = " + s);
        }
        if ((v = (Vector)this.get(COMMANDS)) != null) {
            target.add("Commands = " + v.size());
        }
    }

    public boolean isUndoPossible() {
        return !this.ivUndoStack.isEmpty();
    }

    public DoObject getUndo() {
        if (this.ivUndoStack.isEmpty()) {
            return null;
        }
        DoObject doob = (DoObject)this.ivUndoStack.pop();
        this.ivRedoStack.push(doob);
        return doob;
    }

    public boolean isRedoPossible() {
        return !this.ivRedoStack.isEmpty();
    }

    public DoObject getRedo() {
        if (this.ivRedoStack.isEmpty()) {
            return null;
        }
        DoObject doob = (DoObject)this.ivRedoStack.pop();
        this.ivUndoStack.push(doob);
        return doob;
    }

    public void checkForObjectCollision(DoObject doo, Session actingSession) {
        if (actingSession != this) {
            this.adjustStackForCollision(this.ivUndoStack, doo);
            this.adjustStackForCollision(this.ivRedoStack, doo);
        }
    }

    public void addToUndo(DoObject doob) {
        while (this.ivUndoStack.size() > 20) {
            this.ivUndoStack.removeElementAt(0);
        }
        this.ivUndoStack.push(doob);
    }

    public void clearRedoStack() {
        this.ivRedoStack.clear();
    }

    public void clearBothStacks() {
        this.ivUndoStack.clear();
        this.ivRedoStack.clear();
    }

    public boolean liesWithinSessionTime(long millis) {
        Date d = this.getDate("IDO_START_DATE");
        if (d != null && millis < d.getTime()) {
            return false;
        }
        d = this.getDate("IDO_END_DATE");
        return d == null || millis <= d.getTime();
    }

    private void adjustStackForCollision(Stack stack, DoObject doo) {
        if (!stack.isEmpty()) {
            int i = stack.size() - 1;
            while (i >= 0) {
                DoObject sdoo = (DoObject)stack.elementAt(i);
                if (sdoo.containsSameTouchedObjects(doo)) {
                    int j = 0;
                    while (j <= i) {
                        stack.removeElementAt(0);
                        ++j;
                    }
                    return;
                }
                --i;
            }
        }
    }
}

