/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.session;

import de.hannse.netobjects.session.Session;
import java.io.Serializable;
import java.util.Date;

public class ShortSessionInfo
implements Serializable {
    private static final long serialVersionUID = 7890012063042284417L;
    public final long ivSessionID;
    public final long ivUserID;
    public long ivStartMillis = -1L;
    public long ivEndMillis = -1L;
    public int ivNumCommands = 0;

    public ShortSessionInfo(Session s) {
        this.ivSessionID = s.getID();
        this.ivUserID = s.getLong("SES_USER");
        if (s.get("IDO_START_DATE") != null) {
            this.ivStartMillis = ((Date)s.get("IDO_START_DATE")).getTime();
        }
        if (s.get("IDO_END_DATE") != null) {
            this.ivEndMillis = ((Date)s.get("IDO_END_DATE")).getTime();
        }
        if (s.getVector("SES_COMMAND") != null) {
            this.ivNumCommands = s.getVector("SES_COMMAND").size();
        }
    }

    public ShortSessionInfo(long sessionID, long userID, long start, long end, int numc) {
        this.ivSessionID = sessionID;
        this.ivUserID = userID;
        this.ivStartMillis = start;
        this.ivEndMillis = end;
        this.ivNumCommands = numc;
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("ShortInfo for Session: ").append(this.ivSessionID).append("\n");
        msb.append("  -> UserID:      ").append(this.ivUserID).append("\n");
        msb.append("  -> startMillis: ").append(this.ivStartMillis).append("\n");
        msb.append("  -> endMillis:   ").append(this.ivEndMillis).append("\n");
        return msb.toString();
    }
}

