/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.user;

import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.ConfigReader;
import de.hannse.netobjects.util.Log;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.helper.File2Dict;
import mausoleum.main.ProcessDefinition;
import mausoleum.requester.privileges.EditPrivilegeDialog;

public class Privileges {
    public static final String PRIV_BABEL_PREFIX = "XXXPRIV_";
    public static final String ALLOWED = "x";
    public static final String NOT_ALLOWED = "";
    public static final String ALWAYS_ALLOWED = "A";
    public static final String ALWAYS_FORBIDDEN = "#";
    public static final String FUNCTION = "FUNCTION";
    public static final String CATEGORY = "CATEGORY";
    private static HashMap cvPrivileges = null;
    private static HashMap cvPrivilegesByRole = null;
    private static HashMap cvAlwaysAllowedPrivilegesByRole = null;
    private static HashMap cvAlwaysForbiddenPrivilegesByRole = null;
    private static HashMap cvCategoryByPrivilege = null;
    private static HashSet cvCategories = null;
    static /* synthetic */ Class class$0;

    static {
        Privileges.init(EditPrivilegeDialog.getValidPrivileges());
    }

    public static void init(String privContent) {
        cvPrivileges = new HashMap(300);
        cvPrivilegesByRole = new HashMap(10);
        cvAlwaysAllowedPrivilegesByRole = new HashMap(10);
        cvAlwaysForbiddenPrivilegesByRole = new HashMap(10);
        cvCategoryByPrivilege = new HashMap(300);
        cvCategories = new HashSet();
        if (ProcessDefinition.isClient()) {
            Vector lines = ConfigReader.getLinesFromString(privContent, "\t", false);
            if (lines != null && !lines.isEmpty()) {
                Vector eintraege = File2Dict.convertToDict(lines, "\t", ALWAYS_FORBIDDEN, "@", false);
                if (eintraege == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("de.hannse.netobjects.user.Privileges");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("No Privilege-Entries in file data/privileges64.txt found", null, clazz);
                } else {
                    Iterator iter = eintraege.iterator();
                    while (iter.hasNext()) {
                        Hashtable ht = (Hashtable)iter.next();
                        String func = (String)ht.get(FUNCTION);
                        if (func == null) continue;
                        ht.remove(FUNCTION);
                        String category = (String)ht.get(CATEGORY);
                        if (category != null) {
                            category = category.toUpperCase().trim();
                            ht.remove(CATEGORY);
                            cvCategoryByPrivilege.put(func, category);
                            cvCategories.add(category);
                        }
                        Iterator iterator = Babel.getAvailableLanguagesShort().iterator();
                        while (iterator.hasNext()) {
                            String lang = (String)iterator.next();
                            String val = (String)ht.get(lang);
                            if (val == null) continue;
                            ht.remove(lang);
                            val = val.trim();
                            if (val.length() == 0) continue;
                            Babel.enterBabelValue(lang, PRIV_BABEL_PREFIX + func, val);
                        }
                        HashSet<String> roles = new HashSet<String>();
                        Enumeration en = ht.keys();
                        while (en.hasMoreElements()) {
                            String role = (String)en.nextElement();
                            String val = (String)ht.get(role);
                            String rut = role.toUpperCase().trim();
                            if (val.equalsIgnoreCase(ALWAYS_ALLOWED)) {
                                Privileges.addToHashMap(cvAlwaysAllowedPrivilegesByRole, rut, func);
                            } else if (val.equalsIgnoreCase(ALWAYS_FORBIDDEN)) {
                                Privileges.addToHashMap(cvAlwaysForbiddenPrivilegesByRole, rut, func);
                            }
                            if (!val.equalsIgnoreCase(ALLOWED) && !val.equalsIgnoreCase(ALWAYS_ALLOWED)) continue;
                            roles.add(rut);
                            Privileges.addToHashMap(cvPrivilegesByRole, rut, func);
                        }
                        cvPrivileges.put(func.toUpperCase().trim(), roles);
                    }
                }
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.user.Privileges");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Keine Privilegien-Datei gefunden", null, clazz);
                Alert.showAlert("Privileges are not defined. Closing program", true);
                System.exit(1);
            }
        }
    }

    private static void addToHashMap(HashMap target, String rolleUpperCaseTrim, String privilege) {
        Vector<String> v = (Vector<String>)target.get(rolleUpperCaseTrim);
        if (v == null) {
            v = new Vector<String>();
            target.put(rolleUpperCaseTrim, v);
        }
        v.add(privilege);
    }

    public static boolean hasPrivilege(String privilege) {
        if (ProcessDefinition.isClient()) {
            return Privileges.hasPrivilege(UserManager.getUser(), privilege);
        }
        return false;
    }

    public static boolean hasPrivilege(User user, String privilege) {
        String roleDesc = User.getStringForStatus(user.getInt("USR_MODE", 0));
        HashSet privRoles = (HashSet)cvPrivileges.get(privilege);
        if (privRoles == null) {
            System.out.println("Privilegien nicht definiert fuer " + privilege);
            System.out.println(cvPrivileges);
        } else if (privRoles.contains(roleDesc)) {
            Vector v = (Vector)user.get("USR_SUBPRIV");
            if (v == null) {
                return true;
            }
            return !v.contains(privilege);
        }
        return false;
    }

    public static boolean isPrivilegeImmutable(User user, String privilege) {
        String roleDesc = User.getStringForStatus(user.getInt("USR_MODE", 0));
        String rut = roleDesc.toUpperCase().trim();
        Vector v = (Vector)cvAlwaysAllowedPrivilegesByRole.get(rut);
        if (v != null && v.contains(privilege)) {
            return true;
        }
        v = (Vector)cvAlwaysForbiddenPrivilegesByRole.get(rut);
        return v != null && v.contains(privilege);
    }

    public static Vector getPrivileges(User user) {
        String roleDesc = User.getStringForStatus(user.getInt("USR_MODE", 0));
        return (Vector)cvPrivilegesByRole.get(roleDesc.toUpperCase().trim());
    }

    public static Vector getPrivileges(String roleDesc) {
        return (Vector)cvPrivilegesByRole.get(roleDesc.toUpperCase().trim());
    }

    public static String getCategory(String privilege) {
        return (String)cvCategoryByPrivilege.get(privilege);
    }

    public static Vector getRoles() {
        Vector erg = new Vector();
        erg.addAll(cvPrivilegesByRole.keySet());
        return erg;
    }

    public static Vector getCategories() {
        Vector erg = new Vector();
        erg.addAll(cvCategories);
        Collections.sort(erg);
        return erg;
    }
}

