/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.user;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.Zeile;
import mausoleum.mail.RecipientRequester;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.AftermathObject;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.rack.frame.RackOverview;
import mausoleum.requester.InitializationProgress;
import mausoleum.requester.preferences.Preferences;
import mausoleum.room.RoomManager;
import mausoleum.ui.UIDef;

public class UserManager
extends ObjectManager {
    private static final Vector GROUP_NAMES = new Vector();
    public static User cvOriginalUser = null;
    private static User cvUser = null;
    private static long cvUserID = 0L;
    private static String cvGroup = null;
    private static int cvRole = 0;
    private static String cvUserName = null;
    public static boolean cvTouchForeignMice = false;
    public static boolean cvIsCareTaker = false;
    public static boolean cvIsGURU = false;
    public static UserManager cvInstance;
    private static boolean cvWasStartedBefore;

    static {
        cvWasStartedBefore = false;
    }

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new UserManager();
        }
    }

    public static void setUser(User user) {
        double userFactor;
        cvUser = user;
        if (user != null) {
            Babel.cvUserLangue = user.getString("USR_LANGUAGE", "en");
            cvUserID = user.getID();
            cvGroup = user.getGroup();
            cvRole = user.getInt("USR_MODE", 0);
            cvUserName = user.getString("USR_NAME", null);
            cvTouchForeignMice = Privileges.hasPrivilege("TOUCH_FOREIGN_MICE");
            cvIsCareTaker = UserManager.isACareTaker(cvUser);
            cvIsGURU = cvRole == 42;
        } else {
            Babel.cvUserLangue = "en";
            cvUserID = 0L;
            cvGroup = null;
            cvRole = 0;
            cvUserName = null;
            cvTouchForeignMice = false;
            cvIsCareTaker = false;
            cvIsGURU = false;
        }
        if (!cvWasStartedBefore && UIDef.setUserfactor(userFactor = Preferences.getClientScaleFactor(UserManager.getUserWithoutDisguise(), 1.0))) {
            FontManager.resetFonts();
            InitializationProgress.reinit();
        }
        cvWasStartedBefore = true;
    }

    public static User getPseudoGuru(User headOfService, String group) {
        User pseudoGuru = new User();
        pseudoGuru.set("USR_LANGUAGE", headOfService.getString("USR_LANGUAGE", "en"));
        pseudoGuru.set("IDO_GROUP", group);
        pseudoGuru.set("USR_MODE", new Integer(42));
        pseudoGuru.set("USR_NAME", headOfService.getName("???"));
        pseudoGuru.set("IDO_START_DATE", new Date());
        pseudoGuru.set("IDO_ID", new Long(-1L));
        return pseudoGuru;
    }

    public static User getOriginalUser() {
        return cvOriginalUser;
    }

    public static void setOriginalUser(User user) {
        cvOriginalUser = user;
    }

    public static boolean isRealUser() {
        return !UserManager.isPseudoGuruSession();
    }

    public static boolean isPseudoGuruSession() {
        return cvOriginalUser != null;
    }

    public static User getUser() {
        return cvUser;
    }

    public static User getUserWithoutDisguise() {
        return cvOriginalUser != null ? cvOriginalUser : cvUser;
    }

    public static long getIDOFUser() {
        return cvUserID;
    }

    public static String getNameOfUser() {
        return cvUserName;
    }

    public static int getRoleOfUser() {
        return cvRole;
    }

    public static String getGroupOfUser() {
        return cvGroup;
    }

    public static void addGroup(String groupName) {
        if (!GROUP_NAMES.contains(groupName)) {
            GROUP_NAMES.add(groupName);
        }
    }

    public static void setGroup(String groupName) {
        GROUP_NAMES.clear();
        GROUP_NAMES.add(groupName);
    }

    public static boolean groupContained(String group) {
        return GROUP_NAMES.contains(group);
    }

    public static Vector getGroupNamesWithoutServiceInServiceRoom(String exemptGroup, Rack actualRack) {
        Vector<String> v = new Vector<String>();
        if (MausoleumClient.isServiceCaretaker()) {
            Long sgID = actualRack != null ? (Long)actualRack.get("IDO_SERVID") : null;
            Iterator iter = GROUP_NAMES.iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                if (group.equals("service") || exemptGroup != null && exemptGroup.equals(group) || RoomManager.getGROUPRoomIDForServiceRoom(group) == -1L) continue;
                if (sgID != null) {
                    Rack gruppenRack = RackManager.findGroupRack(group, sgID);
                    if (gruppenRack == null) continue;
                    v.add(group);
                    continue;
                }
                v.add(group);
            }
        }
        Collections.sort(v, StringHelper.CASE_INSENSITIVE_COMPARER);
        return v;
    }

    public static Vector getGroupNamesWithService() {
        Vector v = new Vector(GROUP_NAMES.size());
        v.addAll(GROUP_NAMES);
        Collections.sort(v);
        return v;
    }

    public static Vector getGroupNamesWithoutService() {
        Vector v = new Vector(GROUP_NAMES.size());
        v.addAll(GROUP_NAMES);
        if (v.contains("service")) {
            v.remove("service");
        }
        Collections.sort(v);
        return v;
    }

    public static Enumeration getGroupNamesServiceLast() {
        Vector<String> v = new Vector<String>(GROUP_NAMES.size());
        v.addAll(GROUP_NAMES);
        if (v.contains("service")) {
            v.remove("service");
            v.add("service");
        }
        return v.elements();
    }

    public static Enumeration getGroupsEnumeration() {
        return GROUP_NAMES.elements();
    }

    public static String[] getGroupAndService(String group) {
        if ("service".equals(group)) {
            return new String[]{"service"};
        }
        return new String[]{group, "service"};
    }

    public static final long getUserIDWithoutDisguise() {
        if (cvOriginalUser != null) {
            return cvOriginalUser.getID();
        }
        return UserManager.getIDOFUser();
    }

    public static final String getUserGroupWithoutDisguise() {
        if (cvOriginalUser != null) {
            return cvOriginalUser.getGroup();
        }
        return UserManager.getGroupOfUser();
    }

    public static String getFirstGroup() {
        if (MausoleumClient.isServiceCaretaker() || MausoleumClient.isHeadOfService()) {
            return "service";
        }
        if (GROUP_NAMES.size() == 1) {
            return (String)GROUP_NAMES.firstElement();
        }
        return null;
    }

    public static boolean isAAdmin() {
        return cvRole == 1000 || cvRole == 1001;
    }

    public static boolean isACareTaker(User user) {
        if (user != null) {
            int ur = user.getInt("USR_MODE", 0);
            return ur == 30 || ur == 550;
        }
        return false;
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static User getUser(long id, String group) {
        return (User)ObjectStore.getObjectDeadOrAlive(6, id, group, null, false);
    }

    public static Vector getActualObjects(String group) {
        return cvInstance.getActualObjectVector(group);
    }

    public static Vector getActualHandlingUsers(String group) {
        Vector v = cvInstance.getActualObjectVector(group);
        Vector<User> res = new Vector<User>();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            int status = user.getInt("USR_MODE", 0);
            if (status != 42 && status != 2 && status != 30 && status != 550) continue;
            res.add(user);
        }
        return res;
    }

    public static void addPossibleOwners(String group, boolean myselfPermitted, Vector names, Vector objectIds, Vector recipInfos) {
        Vector u = UserManager.getActualAndVisibleObjects(group);
        int i = 0;
        while (i < u.size()) {
            User user = (User)u.elementAt(i);
            if (Privileges.hasPrivilege(user, "CAN_OWN") && (myselfPermitted || user.getID() != UserManager.getIDOFUser())) {
                if (names != null) {
                    names.add(user.getName());
                    objectIds.add(user.get("IDO_ID"));
                } else if (recipInfos != null) {
                    recipInfos.add(new RecipientRequester.RecInfo(group, user.getName(), user.getLongID(), user.getBoolean("USR_VET", false)));
                }
            }
            ++i;
        }
    }

    public static Vector getActualAndVisibleObjects(String group) {
        Vector<User> v = new Vector<User>();
        Iterator iter = cvInstance.getActualObjectVector(group).iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            if (!user.isAliveAndVisible()) continue;
            v.add(user);
        }
        Collections.sort(v);
        return v;
    }

    public static Vector getGuruNames(String group) {
        Vector<String> erg = new Vector<String>();
        Vector users = UserManager.getActualAndVisibleObjects(group);
        int i = 0;
        while (i < users.size()) {
            User user = (User)users.elementAt(i);
            if (user.getInt("USR_MODE") == 42) {
                erg.addElement(user.getName());
            }
            ++i;
        }
        return erg;
    }

    public static Vector getGurus(String group) {
        return UserManager.getGurus(group, false);
    }

    public static Vector getGurus(String group, boolean allGuruLikes) {
        int lookForRole = 42;
        if (allGuruLikes) {
            if ("service".equals(group)) {
                lookForRole = 500;
            } else if ("tgservice".equals(group)) {
                lookForRole = 600;
            }
        }
        Vector<User> erg = new Vector<User>();
        Vector users = UserManager.getActualAndVisibleObjects(group);
        int i = 0;
        while (i < users.size()) {
            User user = (User)users.elementAt(i);
            if (user.getInt("USR_MODE") == lookForRole) {
                erg.addElement(user);
            }
            ++i;
        }
        return erg;
    }

    public static Vector getHeadOfServiceNames(Vector subtractedPrivilegesTarget, Vector idTarget) {
        return UserManager.getServiceNames(500, idTarget, subtractedPrivilegesTarget);
    }

    public static Vector getServiceCaretakerNames(Vector idTarget) {
        return UserManager.getServiceNames(550, idTarget, null);
    }

    private static Vector getServiceNames(int mode, Vector idTarget, Vector subtractedPrivilegesTarget) {
        Vector<String> erg = new Vector<String>();
        Vector v = (Vector)RequestManager.createSendAndGetObjectIfFinished((byte)42, "service", null, new Integer(mode));
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                Zeile z = new Zeile(s, '|');
                if (z.getInt(1, 0) != mode) continue;
                erg.add(z.getString(0));
                if (idTarget != null) {
                    idTarget.add(new Long(z.getLong(2, 0L)));
                }
                if (subtractedPrivilegesTarget == null) continue;
                String sp = z.getStringNONEmpty(3, null);
                if (sp == null) {
                    subtractedPrivilegesTarget.add(ArrayHelper.LEER);
                    continue;
                }
                subtractedPrivilegesTarget.add(IDObjectXMLHandler.getObject(sp, "service", true));
            }
        }
        return erg;
    }

    public static Vector getTouchyUsers(Vector objectsForTouching) {
        Vector<User> users = new Vector<User>();
        String commonGroup = IDObject.commonGroup(objectsForTouching);
        if (commonGroup != null) {
            Iterator iter = UserManager.getActualObjects(commonGroup).iterator();
            while (iter.hasNext()) {
                User user = (User)iter.next();
                if (user == null || !user.isAliveAndVisible()) continue;
                boolean takeit = true;
                Iterator iterator = objectsForTouching.iterator();
                while (iterator.hasNext() && takeit) {
                    Object ooo = iterator.next();
                    if (ooo instanceof Mouse) {
                        Mouse mouse = (Mouse)ooo;
                        if (mouse.isTouchable(user)) continue;
                        takeit = false;
                        continue;
                    }
                    if (ooo instanceof Cage) {
                        Cage cage = (Cage)ooo;
                        if (cage.isTouchable(user)) continue;
                        takeit = false;
                        continue;
                    }
                    takeit = false;
                }
                if (!takeit) continue;
                users.add(user);
            }
            Collections.sort(users);
        }
        return users;
    }

    public static User findUserByName(String userName, String group) {
        if (userName != null) {
            Enumeration en = cvInstance.getActualObjectEnumeration(group);
            while (en.hasMoreElements()) {
                User usi = (User)en.nextElement();
                if (!userName.equals(usi.get("USR_NAME"))) continue;
                return usi;
            }
        }
        return null;
    }

    public static String getNameOfUser(long id, String group) {
        if (id == 0L) {
            return Babel.get("UNKNOWN");
        }
        User usi = UserManager.getUser(id, group);
        if (usi == null) {
            return Babel.get("UNKNOWN");
        }
        return usi.getString("USR_NAME");
    }

    private UserManager() {
        super(6);
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && MausoleumClient.cvManagerInitialized && sentObjects != null && !sentObjects.isEmpty()) {
            User usi;
            if (cvUser != null && (usi = (User)ObjectStore.getObjectDeadOrAlive(6, cvUser.getID(), cvUser.getString("IDO_GROUP", ""), null, true)) != null && usi.getInt("IDO_VERSION", 0) > cvUser.getInt("IDO_VERSION", 0)) {
                cvUser = usi;
            }
            aftermathObject.redrawRackFrame();
            if (DefaultManager.getCageDisplayMode() == 2) {
                CageManager.prepareSingleColorsOfAllCages(2, null);
                RackOverview.cageColorModeChanged();
            }
        }
    }
}

