/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.user;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import java.util.HashSet;
import mausoleum.cage.Cage;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public abstract class UserRoomRestriction {
    private static transient boolean[] cvRoomsRestricted = null;
    private static transient HashSet cvRestrictedRoomIDs = null;
    private static transient HashSet cvRestrictionOverrideMouseIDs = null;
    private static transient HashSet cvRestrictionOverrideCageIDs = null;

    public static void addRestrictionOverrideObject(Object o) {
        if (UserRoomRestriction.areRoomsRestricted()) {
            if (o instanceof Mouse) {
                Mouse mouse = (Mouse)o;
                if (cvRestrictionOverrideMouseIDs == null) {
                    cvRestrictionOverrideMouseIDs = new HashSet();
                }
                cvRestrictionOverrideMouseIDs.add(mouse.get("IDO_ID"));
            }
            if (o instanceof Cage) {
                Cage cage = (Cage)o;
                if (cvRestrictionOverrideCageIDs == null) {
                    cvRestrictionOverrideCageIDs = new HashSet();
                }
                cvRestrictionOverrideCageIDs.add(cage.get("IDO_ID"));
            }
        }
    }

    public static void resetRoomRestriction() {
        if (cvRestrictedRoomIDs != null) {
            cvRestrictedRoomIDs.clear();
            cvRestrictedRoomIDs = null;
        }
        if (cvRestrictionOverrideCageIDs != null) {
            cvRestrictionOverrideCageIDs.clear();
            cvRestrictionOverrideCageIDs = null;
        }
        if (cvRestrictionOverrideMouseIDs != null) {
            cvRestrictionOverrideMouseIDs.clear();
            cvRestrictionOverrideMouseIDs = null;
        }
        cvRoomsRestricted = null;
    }

    public static boolean areRoomsRestricted() {
        if (cvRoomsRestricted == null) {
            long[] rrIds;
            boolean restr = false;
            if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("USR_ROOM_RESTRICTION_POSSIBLE") && (rrIds = (long[])UserManager.getUser().get("USR_R_ROOMS")) != null) {
                cvRestrictedRoomIDs = new HashSet();
                int i = 0;
                while (i < rrIds.length) {
                    cvRestrictedRoomIDs.add(new Long(rrIds[i]));
                    ++i;
                }
                restr = true;
            }
            cvRoomsRestricted = new boolean[]{restr};
        }
        return cvRoomsRestricted[0];
    }

    public static boolean isObjectRestricted(Object object) {
        if (UserRoomRestriction.areRoomsRestricted()) {
            return !UserRoomRestriction.takeObjectWithRoomRestriction(object);
        }
        return false;
    }

    public static boolean takeObjectWithRoomRestriction(Object object) {
        boolean takeit = false;
        Room room = null;
        if (object instanceof Mouse) {
            Mouse mouse = (Mouse)object;
            if (cvRestrictionOverrideMouseIDs != null && cvRestrictionOverrideMouseIDs.contains(mouse.get("IDO_ID"))) {
                takeit = true;
            } else {
                room = mouse.getRoom();
            }
        } else if (object instanceof Cage) {
            Cage cage = (Cage)object;
            if (cvRestrictionOverrideCageIDs != null && cvRestrictionOverrideCageIDs.contains(cage.get("IDO_ID"))) {
                takeit = true;
            } else {
                room = cage.getRoom();
            }
        } else if (object instanceof Rack) {
            Rack rack = (Rack)object;
            room = rack.getRoom();
        } else if (object instanceof Room) {
            room = (Room)object;
        } else {
            takeit = true;
        }
        if (room != null) {
            takeit = cvRestrictedRoomIDs.contains(room.get("IDO_ID"));
        }
        return takeit;
    }
}

