/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.util.Iterator;
import java.util.Vector;

public abstract class ConfigReader {
    public static Vector getLinesFromString(String cont, String trenner, boolean keepSplittedLines) {
        Vector erg = new Vector();
        if (cont != null && cont.length() != 0) {
            Vector lines = StringHelper.splitStringByAny(cont, "\n");
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String lineString = (String)iterator.next();
                if (lineString.trim().length() == 0 || lineString.startsWith("#")) continue;
                Vector line = StringHelper.splitStringByAny(lineString, trenner);
                ConfigReader.handleSplittedLine(line, erg, keepSplittedLines, trenner);
            }
        }
        return erg;
    }

    public static Vector getLines(String filename, String trenner, boolean keepSplittedLines) {
        Vector erg = new Vector();
        Vector lines = FileManager.getSplittedLinesFromFile(filename, trenner, "#");
        if (lines != null) {
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                Vector line = (Vector)iter.next();
                ConfigReader.handleSplittedLine(line, erg, keepSplittedLines, trenner);
            }
        }
        return erg;
    }

    private static void handleSplittedLine(Vector line, Vector erg, boolean keepSplittedLines, String trenner) {
        if (!line.isEmpty()) {
            if (keepSplittedLines) {
                Vector<String> nline = new Vector<String>();
                erg.add(nline);
                int i = 0;
                while (i < line.size()) {
                    String el = (String)line.elementAt(i);
                    nline.add(Base64Manager.getDecodedString(el));
                    ++i;
                }
            } else {
                StringBuffer lineSB = new StringBuffer();
                int i = 0;
                while (i < line.size()) {
                    String el = (String)line.elementAt(i);
                    if (i != 0) {
                        lineSB.append(trenner);
                    }
                    lineSB.append(Base64Manager.getDecodedString(el));
                    ++i;
                }
                erg.add(lineSB.toString());
            }
        }
    }
}

