/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class DirPutzer
implements Runnable {
    private static final Vector DIRS_TO_WATCH = new Vector();
    private static DirPutzer cvInstance = null;

    public static void addDirPutzer(String dir, long alterungsZeit, long karenzZeit) {
        if (cvInstance == null) {
            cvInstance = new DirPutzer();
            Thread thread = new Thread(cvInstance);
            thread.setPriority(1);
            thread.start();
        }
        new DirPutzerEntry(dir, alterungsZeit, karenzZeit);
    }

    private DirPutzer() {
    }

    public void run() {
        while (true) {
            Log.subdebug("Delete old files ", this);
            Iterator iter = DIRS_TO_WATCH.iterator();
            while (iter.hasNext()) {
                DirPutzerEntry dpe = (DirPutzerEntry)iter.next();
                dpe.putze(dpe.ivDirPath);
            }
            try {
                Thread.sleep(43200000L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static class DirPutzerEntry
    implements Runnable {
        public final String ivDirPath;
        public final long ivAlterungsZeit;
        public final long ivKarenzZeit;

        public DirPutzerEntry(String dir, long alterungsZeit, long karenzZeit) {
            while (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.ivDirPath = dir;
            this.ivAlterungsZeit = alterungsZeit;
            this.ivKarenzZeit = karenzZeit;
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
        }

        public void run() {
            if (this.ivKarenzZeit > 0L) {
                try {
                    Thread.sleep(this.ivKarenzZeit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.putze(this.ivDirPath);
            DIRS_TO_WATCH.add(this);
        }

        public void putze(String dirPath) {
            long minMillis = System.currentTimeMillis() - this.ivAlterungsZeit;
            File f = new File(dirPath);
            if (f.exists() && f.isDirectory()) {
                String[] files = f.list();
                int i = 0;
                while (i < files.length) {
                    String subPath = String.valueOf(dirPath) + "/" + files[i];
                    try {
                        File sf = new File(subPath);
                        if (sf.isFile()) {
                            if (sf.lastModified() < minMillis) {
                                Log.log("Delete File " + subPath, this);
                                FileManager.deleteFile(subPath);
                            }
                        } else if (sf.isDirectory()) {
                            this.putze(subPath);
                        }
                    }
                    catch (Exception e) {
                        Log.error("Problem deleting file " + subPath, e, this);
                    }
                    ++i;
                }
            }
        }
    }
}

