/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.DatumsParser;
import mausoleum.helper.Zeile;

public class MyDate {
    public static final int NULL_DATUM = Integer.MIN_VALUE;
    private static final int VARSTART = -2147483598;
    public static final int VAR_HEUTE = -2147483598;
    public static final int VAR_GESTERN = -2147483597;
    public static final int VAR_ANFANG_DIESE_WOCHE = -2147483596;
    public static final int VAR_ENDE_LETZTE_WOCHE = -2147483595;
    public static final int VAR_ANFANG_LETZTE_WOCHE = -2147483594;
    public static final int VAR_ANFANG_DIESER_MONAT = -2147483593;
    public static final int VAR_ENDE_LETZTER_MONAT = -2147483592;
    public static final int VAR_ANFANG_LETZTER_MONAT = -2147483591;
    public static final int VAR_ANFANG_DIESES_QUARTAL = -2147483590;
    public static final int VAR_ENDE_LETZTES_QUARTAL = -2147483589;
    public static final int VAR_ANFANG_LETZTES_QUARTAL = -2147483588;
    public static final int VAR_ANFANG_DIESES_JAHR = -2147483587;
    public static final int VAR_ENDE_LETZETS_JAHR = -2147483586;
    public static final int VAR_ANFANG_LETZTES_JAHR = -2147483585;
    public static final int VAR_ZUKUNFT = -2147483584;
    public static final int VAR_VERGANGENHEIT = -2147483583;
    public static final int[] VARS = new int[]{-2147483598, -2147483597, -2147483596, -2147483595, -2147483594, -2147483593, -2147483592, -2147483591, -2147483590, -2147483589, -2147483588, -2147483587, -2147483586, -2147483585};
    public static final String[] VAR_BABELS = new String[]{"VAR_HEUTE", "VAR_GESTERN", "VAR_ANFANG_DIESE_WOCHE", "VAR_ENDE_LETZTE_WOCHE", "VAR_ANFANG_LETZTE_WOCHE", "VAR_ANFANG_DIESER_MONAT", "VAR_ENDE_LETZTER_MONAT", "VAR_ANFANG_LETZTER_MONAT", "VAR_ANFANG_DIESES_QUARTAL", "VAR_ENDE_LETZTES_QUARTAL", "VAR_ANFANG_LETZTES_QUARTAL", "VAR_ANFANG_DIESES_JAHR", "VAR_ENDE_LETZETS_JAHR", "VAR_ANFANG_LETZTES_JAHR"};
    public static final long EINE_MINUTE = 60000L;
    public static final long EINE_STUNDE = 3600000L;
    public static final long EIN_TAG = 86400000L;
    public static final long EINE_WOCHE = 604800000L;
    public static final long EIN_MONAT = 2592000000L;
    public static final int TAG_MO = 0;
    public static final int TAG_DI = 1;
    public static final int TAG_MI = 2;
    public static final int TAG_DO = 3;
    public static final int TAG_FR = 4;
    public static final int TAG_SA = 5;
    public static final int TAG_SO = 6;
    public static final int[] NORMAL_JAHR_TABELLE = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] SCHALT_JAHR_TABELLE = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] WEEKDAYS = new String[]{"MO", "DI", "MI", "DO", "FR", "SA", "SO"};
    private static final Calendar JETZT_CAL = Calendar.getInstance();
    public static final int JETZT_JAHR = JETZT_CAL.get(1);
    public static final int JETZT_MONAT = JETZT_CAL.get(2);
    public static final int JETZT_TAG = JETZT_CAL.get(5);
    private static final GregorianCalendar GREG1 = new GregorianCalendar();
    public static final int HEUTE = MyDate.getTage(System.currentTimeMillis());
    private static final int[] CONV_PLATZ = new int[3];
    public int ivJahr = 0;
    public int ivMonat = 0;
    public int ivTag = 0;
    public int ivStunde = 0;
    public int ivMinute = 0;
    public int ivSekunde = 0;
    public int ivMillis = 0;

    public static int getTage(long millis) {
        return MyDate.getMyDate(millis).getTage();
    }

    public static int getTage(Date d) {
        return MyDate.getMyDate(d.getTime()).getTage();
    }

    public static void main(String[] args) {
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483598)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483597)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483596)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483595)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483594)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483593)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483592)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483591)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483590)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483589)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483588)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483587)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483586)));
        System.out.println(DatumFormat.getJustDateString(MyDate.getTageForVar(-2147483585)));
        System.out.println();
        System.out.println("-------------------------------------------");
        System.out.println();
        MyDate md = new MyDate(new GregorianCalendar());
        int i = 0;
        while (i <= 365) {
            System.out.println(String.valueOf(md.ivTag) + "." + md.ivMonat + "." + md.ivJahr);
            md.nextDay();
            if (md.ivTag == 1) {
                System.out.println();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int getTage(int tag, int monat, int jahr) {
        block4: {
            if (monat <= 0 || monat > 12 || tag <= 0 || tag > 31) {
                return -2147483648;
            }
            tage = 0;
            tempJahr = 1970;
            if (jahr >= tempJahr) ** GOTO lbl12
            while (tempJahr > jahr) {
                tage -= MyDate.getTageImJahr(--tempJahr);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                tage += MyDate.getTageImJahr(tempJahr);
                ++tempJahr;
lbl12:
                // 2 sources

                ** while (tempJahr < jahr)
            }
        }
        meineTabelle = MyDate.getMonatsTabelle(jahr);
        maxmo = monat - 1;
        tempMonat = 0;
        while (tempMonat < maxmo) {
            tage += meineTabelle[tempMonat];
            ++tempMonat;
        }
        return tage += tag - 1;
    }

    public static void convertTMJ(int days, int[] arr) {
        int year = 1970;
        int ajd = MyDate.getTageImJahr(year);
        while (days < 0) {
            days += MyDate.getTageImJahr(--year);
        }
        while (days >= ajd) {
            days -= ajd;
            ajd = MyDate.getTageImJahr(++year);
        }
        arr[2] = year;
        int[] myTab = MyDate.getMonatsTabelle(arr[2]);
        int month = 0;
        while (days >= myTab[month]) {
            days -= myTab[month];
            ++month;
        }
        arr[1] = month + 1;
        arr[0] = days + 1;
    }

    public static int getJahr(int tage) {
        return new MyDate((int)tage).ivJahr;
    }

    public static void fillKWInfo(int tage, int[] kwYear) {
        MyDate md = new MyDate(tage);
        int tag = md.ivTag;
        int monat = md.ivMonat;
        int jahr = md.ivJahr--;
        int wota = MyDate.getWochentag(tage);
        md.ivTag = 4;
        md.ivMonat = 1;
        int tageFKW = md.getTage();
        if (tage < (tageFKW -= MyDate.getWochentag(tageFKW))) {
            kwYear[1] = jahr - 1;
            md.ivTag = 4;
            md.ivMonat = 1;
            tageFKW = md.getTage();
            tageFKW -= MyDate.getWochentag(tageFKW);
            kwYear[0] = (tage - tageFKW) / 7 + 1;
        } else if (monat == 12 && tag == 29 && wota <= 0) {
            kwYear[0] = 1;
            kwYear[1] = jahr + 1;
        } else if (monat == 12 && tag == 30 && wota <= 1) {
            kwYear[0] = 1;
            kwYear[1] = jahr + 1;
        } else if (monat == 12 && tag == 31 && wota <= 2) {
            kwYear[0] = 1;
            kwYear[1] = jahr + 1;
        } else {
            kwYear[1] = jahr;
            kwYear[0] = (tage - tageFKW) / 7 + 1;
        }
    }

    public static boolean isTagExistent(int tag, int monat, int jahr) {
        int[] myTab = MyDate.getMonatsTabelle(jahr);
        if (monat < 1 || monat > myTab.length) {
            return false;
        }
        int mday = myTab[monat - 1];
        return tag >= 1 && tag <= mday;
    }

    public static int[] getMonatsTabelle(int y) {
        if (MyDate.istEsEinSchaltjahr(y)) {
            return SCHALT_JAHR_TABELLE;
        }
        return NORMAL_JAHR_TABELLE;
    }

    private static int getTageImJahr(int y) {
        if (MyDate.istEsEinSchaltjahr(y)) {
            return 366;
        }
        return 365;
    }

    public static int getTageImMonat(int m, int y) {
        return MyDate.getMonatsTabelle(y)[m - 1];
    }

    public static boolean istEsEinSchaltjahr(int y) {
        if (y % 400 == 0) {
            return true;
        }
        if (y % 100 == 0) {
            return false;
        }
        return y % 4 == 0;
    }

    public static Date getDateFromExcelDateString(String s) {
        try {
            int spind = s.lastIndexOf(" ");
            if (spind != -1) {
                String vorn = s.substring(0, spind).trim();
                String hint = s.substring(spind + 1, s.length()).trim();
                int datum = DatumsParser.getDatum(vorn);
                Zeile z = new Zeile(hint, ':');
                MyDate md = new MyDate(datum);
                md.ivStunde = z.getInt(0, 0);
                md.ivMinute = z.getInt(1, 0);
                md.ivSekunde = z.getInt(2, 0);
                return new Date(md.getTime());
            }
            int datum = DatumsParser.getDatum(s);
            MyDate md = new MyDate(datum);
            return new Date(md.getTime());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean sameDay(MyDate a, MyDate b) {
        return a.ivJahr == b.ivJahr && a.ivMonat == b.ivMonat && a.ivTag == b.ivTag;
    }

    public static int getTageForVar(int var) {
        if (var == -2147483598) {
            return MyDate.getTage(System.currentTimeMillis());
        }
        if (var == -2147483597) {
            return MyDate.getTage(System.currentTimeMillis()) - 1;
        }
        if (var == -2147483596) {
            int minus = MyDate.getWochentag(MyDate.getTage(System.currentTimeMillis()));
            return MyDate.getTage(System.currentTimeMillis()) - minus;
        }
        if (var == -2147483595) {
            int minus = 1 + MyDate.getWochentag(MyDate.getTage(System.currentTimeMillis()));
            return MyDate.getTage(System.currentTimeMillis()) - minus;
        }
        if (var == -2147483594) {
            int minus = 7 + MyDate.getWochentag(MyDate.getTage(System.currentTimeMillis()));
            return MyDate.getTage(System.currentTimeMillis()) - minus;
        }
        if (var == -2147483593) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            md.ivTag = 1;
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr);
        }
        if (var == -2147483592) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            md.ivTag = 1;
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr) - 1;
        }
        if (var == -2147483591) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            md.ivTag = 1;
            --md.ivMonat;
            if (md.ivMonat < 1) {
                --md.ivJahr;
                md.ivMonat = 12;
            }
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr);
        }
        if (var == -2147483590) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            if (md.ivMonat <= 3) {
                md.ivTag = 1;
                md.ivMonat = 1;
            } else if (md.ivMonat <= 6) {
                md.ivTag = 1;
                md.ivMonat = 4;
            } else if (md.ivMonat <= 9) {
                md.ivTag = 1;
                md.ivMonat = 7;
            } else {
                md.ivTag = 1;
                md.ivMonat = 10;
            }
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr);
        }
        if (var == -2147483589) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            if (md.ivMonat <= 3) {
                md.ivTag = 1;
                md.ivMonat = 1;
            } else if (md.ivMonat <= 6) {
                md.ivTag = 1;
                md.ivMonat = 4;
            } else if (md.ivMonat <= 9) {
                md.ivTag = 1;
                md.ivMonat = 7;
            } else {
                md.ivTag = 1;
                md.ivMonat = 10;
            }
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr) - 1;
        }
        if (var == -2147483588) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            if (md.ivMonat <= 3) {
                md.ivTag = 31;
                md.ivMonat = 12;
                --md.ivJahr;
            } else if (md.ivMonat <= 6) {
                md.ivTag = 1;
                md.ivMonat = 1;
            } else if (md.ivMonat <= 9) {
                md.ivTag = 1;
                md.ivMonat = 4;
            } else {
                md.ivTag = 1;
                md.ivMonat = 7;
            }
            return MyDate.getTage(md.ivTag, md.ivMonat, md.ivJahr);
        }
        if (var == -2147483587) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            return MyDate.getTage(1, 1, md.ivJahr);
        }
        if (var == -2147483586) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            return MyDate.getTage(31, 12, md.ivJahr - 1);
        }
        if (var == -2147483585) {
            MyDate md = MyDate.getMyDate(System.currentTimeMillis());
            return MyDate.getTage(1, 1, md.ivJahr - 1);
        }
        return Integer.MIN_VALUE;
    }

    public static synchronized MyDate getMyDate(long millis) {
        GREG1.setTimeInMillis(millis);
        return new MyDate(GREG1);
    }

    public MyDate(int tage) {
        this.convertTage(tage);
    }

    public MyDate(GregorianCalendar gc) {
        this.init(gc);
    }

    public String toString() {
        return String.valueOf(this.ivTag) + ". " + this.ivMonat + ". " + this.ivJahr + "  " + this.ivStunde + ":" + this.ivMinute + ":" + this.ivSekunde;
    }

    public static int getWochentag(int tag, int monat, int jahr) {
        return MyDate.getWochentag(MyDate.getTage(tag, monat, jahr));
    }

    public static int getWochentag(int tage) {
        return (tage + 3) % 7;
    }

    public long getTime() {
        int days = MyDate.getTage(this.ivTag, this.ivMonat, this.ivJahr);
        long res = (long)days * 86400000L;
        res += (long)(this.ivStunde * 1000 * 60 * 60);
        res += (long)(this.ivMinute * 1000 * 60);
        res += (long)(this.ivSekunde * 1000);
        return res += (long)this.ivMillis;
    }

    public int getTage() {
        return MyDate.getTage(this.ivTag, this.ivMonat, this.ivJahr);
    }

    public String getDateTimeForFileName() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivJahr);
        msb.append("-");
        if (this.ivMonat < 10) {
            msb.append("0");
        }
        msb.append(this.ivMonat);
        msb.append("-");
        if (this.ivTag < 10) {
            msb.append("0");
        }
        msb.append(this.ivTag);
        msb.append("-");
        if (this.ivStunde < 10) {
            msb.append("0");
        }
        msb.append(this.ivStunde);
        msb.append("-");
        if (this.ivMinute < 10) {
            msb.append("0");
        }
        msb.append(this.ivMinute);
        msb.append("-");
        if (this.ivSekunde < 10) {
            msb.append("0");
        }
        msb.append(this.ivSekunde);
        return msb.toString();
    }

    public String getShortDateTimeForFileName() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivJahr % 100);
        if (this.ivMonat < 10) {
            msb.append("0");
        }
        msb.append(this.ivMonat);
        if (this.ivTag < 10) {
            msb.append("0");
        }
        msb.append(this.ivTag);
        msb.append("-");
        if (this.ivStunde < 10) {
            msb.append("0");
        }
        msb.append(this.ivStunde);
        if (this.ivMinute < 10) {
            msb.append("0");
        }
        msb.append(this.ivMinute);
        if (this.ivSekunde < 10) {
            msb.append("0");
        }
        msb.append(this.ivSekunde);
        return msb.toString();
    }

    public String getFilterString() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivJahr).append(" / ");
        if (this.ivMonat < 10) {
            msb.append("0");
        }
        msb.append(this.ivMonat);
        return msb.toString();
    }

    public String getYYYY_MM() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivJahr).append("_");
        if (this.ivMonat < 10) {
            msb.append("0");
        }
        msb.append(this.ivMonat);
        return msb.toString();
    }

    public void nextDay() {
        int[] mtab = MyDate.getMonatsTabelle(this.ivJahr);
        ++this.ivTag;
        if (this.ivTag > mtab[this.ivMonat - 1]) {
            this.ivTag = 1;
            ++this.ivMonat;
            if (this.ivMonat > 12) {
                this.ivMonat = 1;
                ++this.ivJahr;
            }
        }
    }

    public void nextMonth() {
        ++this.ivMonat;
        if (this.ivMonat > 12) {
            this.ivMonat = 1;
            ++this.ivJahr;
        }
    }

    private void init(GregorianCalendar gc) {
        this.ivJahr = gc.get(1);
        this.ivMonat = gc.get(2) + 1;
        this.ivTag = gc.get(5);
        this.ivStunde = gc.get(11);
        this.ivMinute = gc.get(12);
        this.ivSekunde = gc.get(13);
        this.ivMillis = gc.get(14);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertTage(int days) {
        int[] nArray = CONV_PLATZ;
        synchronized (CONV_PLATZ) {
            MyDate.convertTMJ(days, CONV_PLATZ);
            this.ivTag = CONV_PLATZ[0];
            this.ivMonat = CONV_PLATZ[1];
            this.ivJahr = CONV_PLATZ[2];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

