/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.XMLNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class XMLParser {
    private String partTag = "";
    private XMLNode currentNode;
    private XMLNode rootNode;
    private StringBuffer sbContent;
    int line;

    public static XMLNode parseXMLString(String content) {
        XMLParser p = new XMLParser();
        p.parse(content);
        return p.getRoot();
    }

    public static XMLNode parseXMLFile(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            return XMLParser.parseXMLFile(is);
        }
        catch (Exception e) {
            System.out.println("KEIN INPUTSTREAM FUER: " + filename);
            return null;
        }
    }

    public static XMLNode parseXMLFile(InputStream is) {
        XMLParser p = new XMLParser();
        try {
            p.parse(is);
        }
        catch (IOException e) {
            System.out.println("IOException bei XMLParse: " + e);
            return null;
        }
        return p.getRoot();
    }

    public XMLNode parseAndGetRoot(String xml) {
        this.parse(xml);
        return this.getRoot();
    }

    public void parse(InputStream in) throws IOException {
        int n;
        this.currentNode = null;
        this.rootNode = null;
        this.line = 0;
        this.sbContent = new StringBuffer();
        byte[] buffer = new byte[65536];
        String xmls = "";
        while ((n = in.read(buffer)) > 0) {
            xmls = String.valueOf(xmls) + new String(buffer, 0, n);
        }
        this.parseBuffer(xmls.getBytes());
    }

    public void parse(String s) {
        this.currentNode = null;
        this.rootNode = null;
        this.line = 0;
        this.sbContent = new StringBuffer();
        this.parseBuffer(s.getBytes());
    }

    public XMLNode getRoot() {
        return this.rootNode;
    }

    private void parseBuffer(byte[] buffer) {
        StringBuffer sbTag = new StringBuffer();
        sbTag.append(this.partTag);
        boolean startTag = false;
        try {
            int i = 0;
            while (i < buffer.length) {
                char c = (char)buffer[i];
                if (c == '\n') {
                    ++this.line;
                }
                if (c == '<') {
                    startTag = true;
                } else if (c == '>') {
                    startTag = false;
                    this.parseTag(sbTag.toString());
                    sbTag = new StringBuffer();
                    this.partTag = "";
                } else if (startTag) {
                    sbTag.append(c);
                } else if (c != '\n' && c != '\r') {
                    this.sbContent.append(c);
                }
                ++i;
            }
            if (startTag) {
                this.partTag = sbTag.toString();
            }
        }
        catch (Exception ex) {
            System.err.println("Error while parsing at line : " + this.line);
            System.err.println(ex.toString());
        }
    }

    private String trimTag(String val) {
        boolean cont = true;
        while (cont) {
            int len = val.length();
            if (len != (val = StringHelper.gSub(val, "  ", " ")).length()) continue;
            cont = false;
        }
        val = StringHelper.gSub(val, " =", "=");
        val = StringHelper.gSub(val, "= ", "=");
        return val.trim();
    }

    private void parseTag(String val) {
        if ((val = this.trimTag(val)).startsWith("!---")) {
            return;
        }
        if (val.startsWith("/")) {
            XMLNode parent = this.currentNode.getParent();
            String content = this.sbContent.toString();
            if (content.length() > 0) {
                this.currentNode.setContent(content);
            }
            this.sbContent = new StringBuffer();
            if (parent != null) {
                parent.addKid(this.currentNode);
                this.currentNode = parent;
            } else {
                this.rootNode = this.currentNode;
            }
            return;
        }
        Vector v = StringHelper.splitStringBySpaces(val);
        int i = 0;
        while (i < v.size()) {
            XMLNode parent;
            String tag = ((String)v.elementAt(i)).trim();
            if (i == 0) {
                parent = this.currentNode;
                this.currentNode = new XMLNode(tag);
                this.currentNode.setParent(parent);
            } else {
                if (tag.startsWith("/")) {
                    parent = this.currentNode.getParent();
                    if (parent != null) {
                        parent.addKid(this.currentNode);
                    }
                    this.currentNode = parent;
                    return;
                }
                Vector w = StringHelper.splitStringByAny(tag, "=");
                if (w.size() == 2) {
                    String key = ((String)w.elementAt(0)).trim();
                    String value = ((String)w.elementAt(1)).trim();
                    if (value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    } else if (value.startsWith("'")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    this.currentNode.addAttribute(key, value);
                }
            }
            ++i;
        }
    }

    private void debug(int indent, XMLNode root) {
        int i = 0;
        while (i < indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(root.toString());
        Enumeration enum1 = root.kids();
        while (enum1.hasMoreElements()) {
            this.debug(indent + 1, (XMLNode)enum1.nextElement());
        }
    }

    public static void main(String[] args) throws Exception {
        XMLParser p = new XMLParser();
        p.parse(new FileInputStream(args[0]));
        p.debug(0, p.getRoot());
    }
}

