/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.webstart;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;

public class FileResource {
    public static final int TYP_JAR = 1;
    public static final int TYP_RESOURCE = 2;
    public int ivID = 0;
    public String ivFullPath = null;
    public String ivDirectory = null;
    public String ivFilename = null;
    public long ivLength = 0L;
    public long ivFileDate = 0L;
    public int ivType = 2;
    public byte[] ivFileData = null;
    public boolean ivRetrievable = false;
    public boolean ivPresent = false;

    public FileResource(int id, String fullpath, int typ) {
        if (fullpath != null) {
            this.ivID = id;
            this.ivFullPath = fullpath.trim();
            this.ivType = typ;
            if (this.ivFullPath.length() != 0) {
                int ind = this.ivFullPath.lastIndexOf("/");
                if (ind == -1) {
                    this.ivDirectory = ".";
                    this.ivFilename = this.ivFullPath;
                } else {
                    this.ivDirectory = this.ivFullPath.substring(0, ind);
                    this.ivFilename = this.ivFullPath.substring(ind + 1, this.ivFullPath.length());
                }
                this.checkInfos();
            }
        }
    }

    public FileResource(String infoLine) {
        StringTokenizer st = new StringTokenizer(infoLine, "|");
        this.ivID = Integer.parseInt(st.nextToken());
        this.ivType = Integer.parseInt(st.nextToken());
        this.ivFilename = st.nextToken();
        this.ivLength = Long.parseLong(st.nextToken());
        this.ivFileDate = Long.parseLong(st.nextToken());
        File f = new File(this.ivFilename);
        if (f.exists() && f.length() == this.ivLength && f.lastModified() > this.ivFileDate) {
            this.ivPresent = true;
        }
    }

    public String getInfoLine() {
        this.checkInfos();
        if (this.ivRetrievable) {
            StringBuffer msb = new StringBuffer();
            msb.append(this.ivID).append("|");
            msb.append(this.ivType).append("|");
            msb.append(this.ivFilename).append("|");
            msb.append(this.ivLength).append("|");
            msb.append(this.ivFileDate);
            return msb.toString();
        }
        return null;
    }

    public byte[] getFileData() {
        this.checkInfos();
        if (this.ivRetrievable) {
            if (this.ivFileData == null) {
                try {
                    this.ivFileData = new byte[(int)this.ivLength];
                    DataInputStream dis = new DataInputStream(new FileInputStream(this.ivFullPath));
                    dis.readFully(this.ivFileData);
                    dis.close();
                }
                catch (Exception e) {
                    System.out.println("Unable to load " + this.ivFullPath);
                    return null;
                }
            }
            return this.ivFileData;
        }
        return null;
    }

    private void checkInfos() {
        long fdate;
        long length;
        File f = new File(this.ivFullPath);
        if (f.exists() && f.isFile()) {
            this.ivRetrievable = true;
        }
        if ((length = f.length()) != this.ivLength) {
            this.ivFileData = null;
        }
        this.ivLength = length;
        if (this.ivLength == 0L) {
            this.ivRetrievable = false;
        }
        if ((fdate = f.lastModified()) != this.ivFileDate) {
            this.ivFileData = null;
        }
        this.ivFileDate = fdate;
    }
}

