/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

public class RowRecord
extends RecordData {
    private int rowNumber;
    private int rowHeight;
    private boolean collapsed;
    private boolean defaultFormat;
    private boolean matchesDefFontHeight;
    private int xfIndex;
    private int outlineLevel;
    private boolean groupStart;
    private static final int defaultHeightIndicator = 255;

    RowRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.rowNumber = IntegerHelper.getInt(data[0], data[1]);
        this.rowHeight = IntegerHelper.getInt(data[6], data[7]);
        int options = IntegerHelper.getInt(data[12], data[13], data[14], data[15]);
        this.outlineLevel = options & 7;
        this.groupStart = (options & 0x10) != 0;
        this.collapsed = (options & 0x20) != 0;
        this.matchesDefFontHeight = (options & 0x40) == 0;
        this.defaultFormat = (options & 0x80) != 0;
        this.xfIndex = (options & 0xFFF0000) >> 16;
    }

    boolean isDefaultHeight() {
        return this.rowHeight == 255;
    }

    public boolean matchesDefaultFontHeight() {
        return this.matchesDefFontHeight;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getOutlineLevel() {
        return this.outlineLevel;
    }

    public boolean getGroupStart() {
        return this.groupStart;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public int getXFIndex() {
        return this.xfIndex;
    }

    public boolean hasDefaultFormat() {
        return this.defaultFormat;
    }
}

