/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.administrator;

import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import mausoleum.administrator.gui.AdminBrowserPane;
import mausoleum.administrator.gui.AdminLogPane;
import mausoleum.administrator.gui.CommunicatorPane;
import mausoleum.alert.Alert;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.documents.NixSonderzeichenDocument;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FileHelper;
import mausoleum.helper.FontManager;
import mausoleum.helper.MFF;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.inspector.Inspector;
import mausoleum.main.ShutdownRequester;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.InitializationProgress;
import mausoleum.requester.MoreTextRequester;
import mausoleum.requester.Requester;
import mausoleum.requester.admin.ArmisSelectRequester;
import mausoleum.requester.privileges.EditPrivilegeDialog;
import mausoleum.requester.user.PWDoubleTextRequester;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UsergroupManager;
import mausoleum.util.Constants;
import mausoleum.util.HelloMessage;
import mausoleum.util.Standards;
import mausoleum.util.calendar.InstituteHolidayDialog;

public class AdministratorWindow
extends JFrame
implements ActionListener,
Comparator {
    private static final String SUCCESS_ALERT = "Your request was successfully executed";
    private static final String ERROR_ALERT = "Your request couldn't be executed";
    public static final String COM_CHECKBUTS = "checkbuts";
    private static final String COM_ARMIS_REPORT = "armisReport";
    private static final String COM_QUIT = "quit";
    public static final String COM_EDITHOLIDAYS = "editholidays";
    private static final String COM_EDITPRIVILEGES = "editprivileges";
    public static final String COM_SETDORMANTTHRES = "setdormantthres";
    private static final String COM_CHANGEPW = "changepw";
    private static final String COM_SHUTDOWN = "shutdown";
    public static final String COM_SETLOGLEVEL = "setloglevel";
    private static final String COM_CREATEHEADOFSERVICE = "createheadofservice";
    public static final String COM_CREATE_DEMO = "createDemo";
    public static final String COM_ENABLE_GROUP = "enableGroup";
    private static final String COM_DISABLE_GROUP = "disableGroup";
    private static final String COM_IMPORT_DEMO = "importDemo";
    public static final String COM_IMPORT = "import";
    public static final String COM_NEWGROUP = "newgroup";
    private static final String COM_EDIT_HELLO = "editHello";
    private static final String COM_EDIT_INST_INFO = "editInstInfo";
    private static final String COM_MODIFY_OBJECTS = "modifyObjects";
    private static final long serialVersionUID = 14643L;
    private static final int BUT_WIDTH = UIDef.getScaled(260);
    private static final int BUT_HEIGHT = UIDef.getScaled(32);
    private static final int TOT_WIDTH = UIDef.getScaled(880);
    private static final int TOT_HEIGHT = UIDef.getScaled(600);
    private static final int BUT_EXTRA_MARGIN = UIDef.getScaled(6);
    private static AdministratorWindow cvInstance = null;
    public static HashSet cvActiveGroups = new HashSet();
    public static HashMap cvGroupsInactivable = new HashMap();
    private final Vector ivButtons = new Vector();
    private final HashMap ivExtraMarginByActionCommand = new HashMap();
    private final JTabbedPane ivTabbedPane = new JTabbedPane();
    private final AdminBrowserPane ivBrowserPane;
    private final CommunicatorPane ivCommunicatorPane = new CommunicatorPane();

    public static AdministratorWindow getAdminWindow(boolean fullAdministrator) {
        if (cvInstance == null) {
            cvInstance = new AdministratorWindow(fullAdministrator);
        }
        return cvInstance;
    }

    private AdministratorWindow(boolean fullAdministrator) {
        this.setContentPane(new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                Iterator iter = AdministratorWindow.this.ivButtons.iterator();
                while (iter.hasNext()) {
                    Integer inti;
                    MGButton but = (MGButton)iter.next();
                    but.setBounds(x, y, BUT_WIDTH, BUT_HEIGHT);
                    y += BUT_HEIGHT + UIDef.INNER_RAND;
                    String s = but.getActionCommand();
                    if (s == null || (inti = (Integer)AdministratorWindow.this.ivExtraMarginByActionCommand.get(s)) == null) continue;
                    y += inti.intValue();
                }
                y = UIDef.RAND;
                AdministratorWindow.this.ivTabbedPane.setBounds(x += BUT_WIDTH + UIDef.INNER_RAND, y, iw - x, ih);
            }
        }));
        this.setIconImage(MausoleumImageStore.getLogo());
        if (fullAdministrator) {
            this.doSingleButton("Create new Group", COM_NEWGROUP);
            this.doSingleButton("Create new group from Backup", COM_IMPORT);
            this.doSingleButton("Create new Group from Demo", COM_IMPORT_DEMO);
            this.doSingleButton("Disable group", COM_DISABLE_GROUP);
            this.doSingleButton("Enable group", COM_ENABLE_GROUP);
            if (Privileges.hasPrivilege("EDIT_WELCOME_MESSAGE")) {
                this.doSingleButton("Edit Welcome message", COM_EDIT_HELLO);
            }
            if (Privileges.hasPrivilege("EDIT_INSTITUTE_INFO")) {
                this.doSingleButton("Edit Institue info", COM_EDIT_INST_INFO);
            }
            this.doSingleButton("Modify objects", COM_MODIFY_OBJECTS);
            this.doSingleButton("Create demo", COM_CREATE_DEMO);
            this.doSingleButton("Create Head of Service", COM_CREATEHEADOFSERVICE);
            this.ivExtraMarginByActionCommand.put(COM_IMPORT_DEMO, new Integer(BUT_EXTRA_MARGIN));
            this.ivExtraMarginByActionCommand.put(COM_CREATE_DEMO, new Integer(BUT_EXTRA_MARGIN));
            this.ivExtraMarginByActionCommand.put(COM_SETLOGLEVEL, new Integer(BUT_EXTRA_MARGIN));
            this.ivExtraMarginByActionCommand.put(COM_CREATEHEADOFSERVICE, new Integer(BUT_EXTRA_MARGIN));
            Boolean hab = (Boolean)RequestManager.createSendAndGetObjectIfFinished((byte)63);
            if (hab != null && hab.booleanValue()) {
                this.doSingleButton("Create Armis report", COM_ARMIS_REPORT);
                this.ivExtraMarginByActionCommand.put(COM_ARMIS_REPORT, new Integer(6));
            }
            this.doSingleButton("Shut down Server", COM_SHUTDOWN);
            this.doSingleButton("Change Admin password", COM_CHANGEPW);
            this.doSingleButton("Set dormancy limit", COM_SETDORMANTTHRES);
            this.doSingleButton("Set log level", COM_SETLOGLEVEL);
            this.doSingleButton("Edit privileges", COM_EDITPRIVILEGES);
            this.doSingleButton("Edit institute holidays", COM_EDITHOLIDAYS);
            this.doSingleButton("Quit", COM_QUIT);
            this.ivBrowserPane = new AdminBrowserPane(this);
            this.ivTabbedPane.add(Babel.get("OBJECTS"), this.ivBrowserPane);
            this.ivTabbedPane.add("Sessions", this.ivCommunicatorPane);
            this.ivTabbedPane.add(Babel.get("LOGS"), new AdminLogPane());
            this.getContentPane().add(this.ivTabbedPane);
        } else {
            this.doSingleButton("Shut down Server", COM_SHUTDOWN);
            this.doSingleButton("Set dormancy limit", COM_SETDORMANTTHRES);
            this.doSingleButton("Set log level", COM_SETLOGLEVEL);
            this.doSingleButton("Quit", COM_QUIT);
            this.ivBrowserPane = null;
            this.ivTabbedPane.add("Sessions", this.ivCommunicatorPane);
            this.ivTabbedPane.add(Babel.get("LOGS"), new AdminLogPane());
            this.getContentPane().add(this.ivTabbedPane);
        }
        this.setTitle("Administration");
        this.pack();
        Insets ivInsets = this.getInsets();
        int wantedHeight = this.calcButHeight() + 2 * UIDef.RAND;
        if (TOT_HEIGHT > wantedHeight) {
            wantedHeight = TOT_HEIGHT;
        }
        this.setSize(TOT_WIDTH + ivInsets.left + ivInsets.right, wantedHeight + ivInsets.top + ivInsets.bottom);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AdministratorWindow.this.exit();
            }
        });
        this.ivCommunicatorPane.fetch();
        this.actionPerformed(new ActionEvent(this, 1, COM_CHECKBUTS));
    }

    public void exit() {
        boolean res = Alert.showAlert("Do you really want to quit?", false);
        if (res) {
            TimeMachine.sayGoodBye();
            RequestManager.sendLogoutRequest();
            System.exit(0);
        }
    }

    private void doSingleButton(String t, String ac) {
        MGButton tb = new MGButton(t);
        tb.setActionCommand(ac);
        tb.addActionListener(this);
        tb.setFont(FontManager.getFont("SSB14"));
        this.getContentPane().add(tb);
        this.ivButtons.addElement(tb);
    }

    private void disableButtons() {
        int i = 0;
        while (i < this.ivButtons.size()) {
            MGButton b = (MGButton)this.ivButtons.elementAt(i);
            b.setEnabled(false);
            ++i;
        }
    }

    private void enableButtons() {
        int i = 0;
        while (i < this.ivButtons.size()) {
            MGButton b = (MGButton)this.ivButtons.elementAt(i);
            b.setEnabled(true);
            ++i;
        }
    }

    public static ObjectRequest performRequest(ObjectRequest mor) {
        if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)).isDenied()) {
            String error;
            String meldung = ERROR_ALERT;
            if (mor.ivObject != null && mor.ivObject instanceof String && (error = (String)mor.ivObject) != null && error.length() != 0) {
                meldung = error;
            }
            Alert.showAlert(meldung, true);
        } else if (mor.isFinished()) {
            Alert.showAlert(SUCCESS_ALERT, true);
        }
        return mor;
    }

    private void performRebuild(boolean fromExcel) {
        String groupName = AdministratorWindow.getAppropriateNewGroupName();
        if (groupName != null) {
            MFF ff = null;
            ff = fromExcel ? MFF.getFilter(2) : MFF.getFilter(6);
            File f = FileHelper.selectFile(this, "Select Input File", false, ff, null);
            if (f != null) {
                if (f.exists()) {
                    byte[] fileData = FileManager.getBytesFromFile(f.getAbsolutePath());
                    if (fileData != null) {
                        if (fileData.length != 0) {
                            ObjectRequest mor = null;
                            if (!fromExcel) {
                                mor = new ObjectRequest(29, groupName, null, fileData);
                            }
                            AdministratorWindow.performRequest(mor);
                        } else {
                            Alert.showAlert("Selected file is empty", true);
                        }
                    } else {
                        Alert.showAlert("Could not load selected file", true);
                    }
                } else {
                    Alert.showAlert("Could not find selected file", true);
                }
            }
        }
    }

    private static void performImportFromDemo() {
        File f = FileHelper.selectDir(cvInstance, "Select the directory of the group from your demo installation", null);
        if (f != null) {
            String[] files = f.list();
            boolean mouseda = false;
            boolean cageda = false;
            boolean userda = false;
            int i = 0;
            while (i < files.length) {
                if (files[i].equals("mouse.data")) {
                    mouseda = true;
                } else if (files[i].equals("cage.data")) {
                    cageda = true;
                } else if (files[i].equals("user.data")) {
                    userda = true;
                }
                ++i;
            }
            if (mouseda && cageda && userda) {
                String groupName = Requester.getString(cvInstance, "Group name");
                if (groupName != null) {
                    String zippath = "demo_" + MilliSpender.getMillis() + ".zip";
                    FileManager.zip(f.getAbsolutePath(), zippath, null, null);
                    if (new File(zippath).exists()) {
                        ObjectRequest or = new ObjectRequest(53, groupName, null, FileManager.getBytesFromFile(zippath));
                        if ((or = AdministratorWindow.performRequest(or)).isFinished()) {
                            if (AdministratorWindow.cvInstance.ivBrowserPane != null) {
                                AdministratorWindow.cvInstance.ivBrowserPane.reinit();
                            }
                        } else {
                            String s = "";
                            if (or.ivObject != null && or.ivObject instanceof String) {
                                s = (String)or.ivObject;
                            }
                            Alert.showAlert("Couldn't import the Demo group. " + s, true);
                        }
                    } else {
                        Alert.showAlert("Couldn't create transport data.", true);
                    }
                }
            } else {
                Alert.showAlert("The selected directory is not suitable.", true);
            }
        }
    }

    private static void performNewGroup(Frame sender) {
        String groupName = AdministratorWindow.getAppropriateNewGroupName();
        if (groupName == null) {
            return;
        }
        String guruName = Requester.getString(sender, "Guru name");
        if (guruName == null) {
            return;
        }
        if ((guruName = guruName.trim()).length() < 4) {
            Alert.showAlert("A Guruname must contain at least four characters", true);
            return;
        }
        boolean res = Alert.showAlert("Do you really want to add group " + groupName + " with guru " + guruName + "?", "YES", "NO", false);
        if (!res) {
            return;
        }
        String[] names = new String[]{groupName, guruName};
        ObjectRequest mor = new ObjectRequest(5, names, null, null);
        AdministratorWindow.performRequest(mor);
    }

    private static String getAppropriateNewGroupName() {
        KomfortTextField textfield = new KomfortTextField();
        textfield.setDocument(new NixSonderzeichenDocument(textfield));
        String groupName = Requester.getString(null, cvInstance, "Group name", "", textfield);
        if (groupName == null) {
            return null;
        }
        if ((groupName = groupName.trim()).length() < 3) {
            Alert.showAlert("A Groupname must contain at least three characters", true);
            return null;
        }
        if (groupName.equalsIgnoreCase("null") || groupName.equalsIgnoreCase("service") || groupName.equalsIgnoreCase("tgservice")) {
            Alert.showAlert("This groupname is reserved and cannot be used for normal groups", true);
            return null;
        }
        String[] existingGroupNames = UsergroupManager.getGroupNames(false);
        if (existingGroupNames != null && existingGroupNames.length != 0) {
            int i = 0;
            while (i < existingGroupNames.length) {
                if (existingGroupNames[i].equalsIgnoreCase(groupName)) {
                    Alert.showAlert("This group already exists", true);
                    return null;
                }
                ++i;
            }
        }
        return groupName;
    }

    public int compare(Object arg0, Object arg1) {
        ZipEntry z0 = (ZipEntry)arg0;
        ZipEntry z1 = (ZipEntry)arg1;
        return z0.getName().compareTo(z1.getName());
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals(COM_NEWGROUP)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.disableButtons();
                AdministratorWindow.performNewGroup(this);
                if (this.ivBrowserPane != null) {
                    this.ivBrowserPane.reinit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.enableButtons();
        } else if (comm.equals(COM_SHUTDOWN)) {
            boolean res = Alert.showAlert("This will shutdown the Mausoleum Server. Click 'OK' to shutdown.", false);
            if (res) {
                ObjectRequest mor = new ObjectRequest(19, null, null, null);
                RequestManager.sendObjectRequestAndForget(mor);
                ShutdownRequester.showShutDownRequester(cvInstance);
            }
        } else if (comm.equals(COM_IMPORT)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.disableButtons();
                this.performRebuild(false);
                InitializationProgress.dismiss();
                if (this.ivBrowserPane != null) {
                    this.ivBrowserPane.reinit();
                }
            }
            catch (Exception res) {
                // empty catch block
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.enableButtons();
        } else if (comm.equals(COM_CHANGEPW)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String s = PWDoubleTextRequester.getVerifiedPassword(Inspector.getInspector());
            this.setCursor(Cursor.getDefaultCursor());
            if (s != null) {
                if ((s = s.trim()).length() < 6) {
                    Alert.showAlert("Password is too short", true);
                } else {
                    ObjectRequest mor = new ObjectRequest(31, StringHelper.encrypt(s), null, null);
                    AdministratorWindow.performRequest(mor);
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
        } else if (comm.equals(COM_SETLOGLEVEL)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int ind = AllgChoiceRequester.getIndexAnswer((Frame)this, "Select log level", Log.MIN_LOG_CHOICES);
            if (ind != -1) {
                ObjectRequest mor = new ObjectRequest(62, new Integer(Log.MIN_LOG_VALUES[ind]), null, null);
                AdministratorWindow.performRequest(mor);
            }
            this.setCursor(Cursor.getDefaultCursor());
        } else if (COM_SETDORMANTTHRES.equals(comm)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Standards.setConfigInt("DORMANT_VAL", this, "Enter dormancy limit in minutes");
            this.setCursor(Cursor.getDefaultCursor());
        } else if (comm.equals(COM_QUIT)) {
            this.exit();
        } else if (comm.equals(COM_CREATEHEADOFSERVICE)) {
            String selGroup = this.getSelectedGroup();
            if (selGroup != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.disableButtons();
                try {
                    String password;
                    String userName = Requester.getString(this, "User name");
                    if (userName != null && (password = PWDoubleTextRequester.getVerifiedPassword(this)) != null) {
                        if ((password = password.trim()).length() < 6) {
                            Alert.showAlert("Password is too short", true);
                        } else {
                            HashMap<String, String> rht = new HashMap<String, String>(3);
                            rht.put("USR_NAME", userName);
                            rht.put("USR_PASSWORD", StringHelper.encrypt(password));
                            ObjectRequest mor = new ObjectRequest(52, rht, null, selGroup);
                            mor = AdministratorWindow.performRequest(mor);
                            if (mor.isFinished() && this.ivBrowserPane != null) {
                                this.ivBrowserPane.reinit();
                            }
                        }
                    }
                }
                catch (Exception exxx) {
                    Log.error("Problem creating Head of Service group", exxx, this);
                }
                this.enableButtons();
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (comm.equals(COM_IMPORT_DEMO)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.disableButtons();
                AdministratorWindow.performImportFromDemo();
            }
            catch (Exception selGroup) {
                // empty catch block
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.enableButtons();
        } else if (comm.equals(COM_CREATE_DEMO)) {
            if (AdministratorWindow.cvInstance.ivBrowserPane != null) {
                this.disableButtons();
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    String group = this.ivBrowserPane.ivBrowser.ivSelectedGroup;
                    if (group != null) {
                        ObjectRequest mor = new ObjectRequest(51, null, group, null);
                        if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)).isFinished() && mor.ivObject != null && mor.ivObject instanceof String) {
                            Alert.showAlert("The Demo ZIP-File was sucessfully created and is available on the server. The path is: >" + mor.ivObject + "<", true);
                        } else if (!mor.isFinished() && mor.ivObject instanceof String) {
                            Alert.showAlert((String)mor.ivObject, true);
                        }
                    }
                }
                catch (Exception exxx) {
                    Alert.showAlert("Couldn't create the Demo ZIP-File", true);
                }
                this.setCursor(Cursor.getDefaultCursor());
                this.enableButtons();
            }
        } else if (comm.equals(COM_ARMIS_REPORT)) {
            ObjectRequest mor = new ObjectRequest(65, new Integer(3), "service", null);
            if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)).isFinished()) {
                int anfangDieseWoche = MyDate.getTageForVar(-2147483596);
                int[] sonntage = new int[20];
                String[] soDispl = new String[20];
                int moTag = anfangDieseWoche;
                int i = 0;
                while (i < sonntage.length) {
                    sonntage[i] = moTag - 1;
                    soDispl[i] = " " + DatumFormat.getJustDateString(moTag) + " - " + DatumFormat.getJustDateString(moTag + 5);
                    moTag -= 7;
                    ++i;
                }
                HashSet rackServiceIDStrings = new HashSet();
                int datum = ArmisSelectRequester.getArmisReportProperties(this, (Vector)mor.ivObject, soDispl, sonntage, rackServiceIDStrings);
                if (datum != -1) {
                    mor = new ObjectRequest(64, new Integer(datum), UserManager.getFirstGroup(), rackServiceIDStrings);
                    if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)).isFinished() && mor.ivObject != null) {
                        Vector<Object> sammler = new Vector<Object>();
                        sammler.add(mor.ivObject);
                        FactSheetFrame.showTab(UserManager.getFirstGroup(), sammler, "Armis week report");
                    }
                }
            } else {
                Alert.showAlert("No racks found in service group", true);
            }
        } else if (comm.equals(COM_CHECKBUTS)) {
            this.checkButs();
        } else if (comm.equals(COM_EDITPRIVILEGES)) {
            new EditPrivilegeDialog(this);
        } else if (comm.equals(COM_EDITHOLIDAYS)) {
            InstituteHolidayDialog.editDefinitions(this);
        } else if (COM_DISABLE_GROUP.equals(comm)) {
            this.enDisableGroup(false);
        } else if (COM_ENABLE_GROUP.equals(comm)) {
            this.enDisableGroup(true);
        } else if (COM_EDIT_HELLO.equals(comm)) {
            HelloMessage.editSystemMessage(this, 1, "Edit Welcome message", null);
        } else if (COM_EDIT_INST_INFO.equals(comm)) {
            HelloMessage.editSystemMessage(this, 2, "Edit Institute info message", null);
        } else if (COM_MODIFY_OBJECTS.equals(comm)) {
            this.modifyObjects();
        }
    }

    private String getSelectedGroup() {
        return this.ivBrowserPane != null ? this.ivBrowserPane.ivBrowser.ivSelectedGroup : null;
    }

    private void modifyObjects() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String after = MoreTextRequester.getText(this, "Please enter Modification String", UIDef.getScaled(450), UIDef.getScaled(380), FontManager.getFont("SSP11"), false, "", false);
        if (after != null) {
            after = after.trim();
            try {
                this.disableButtons();
                if (RequestManager.createSendAndGetAnswer((byte)87, after, "service") != null) {
                    this.ivBrowserPane.reinitGroupNodes();
                    this.ivBrowserPane.repaint();
                    Alert.showAlert(SUCCESS_ALERT, true);
                } else {
                    Alert.showAlert(ERROR_ALERT, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.checkButs();
        }
    }

    private void enDisableGroup(boolean enable) {
        String selGroup = this.getSelectedGroup();
        if (selGroup != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.disableButtons();
                if (RequestManager.createSendAndGetAnswer((byte)80, selGroup, UserManager.getFirstGroup(), enable ? Constants.TRUE : Constants.FALSE) != null) {
                    if (enable) {
                        cvActiveGroups.add(selGroup);
                    } else {
                        cvActiveGroups.remove(selGroup);
                    }
                    this.ivBrowserPane.reinitGroupNodes();
                    this.ivBrowserPane.repaint();
                    Alert.showAlert(SUCCESS_ALERT, true);
                } else {
                    Alert.showAlert(ERROR_ALERT, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.checkButs();
        }
    }

    private void checkButs() {
        String selGroup = this.getSelectedGroup();
        boolean hasGroup = selGroup != null;
        boolean regularGroup = selGroup != null && !selGroup.equals("service") && !selGroup.equals("tgservice");
        Iterator iter = this.ivButtons.iterator();
        while (iter.hasNext()) {
            MGButton but = (MGButton)iter.next();
            boolean enabled = true;
            String bac = but.getActionCommand();
            if (bac.equals(COM_CREATE_DEMO)) {
                enabled = hasGroup;
            } else if (bac.equals(COM_CREATEHEADOFSERVICE)) {
                enabled = hasGroup && !regularGroup;
            } else if (bac.equals(COM_DISABLE_GROUP)) {
                if (regularGroup && cvActiveGroups.contains(selGroup)) {
                    Boolean disablebar = (Boolean)cvGroupsInactivable.get(selGroup);
                    if (disablebar == null) {
                        disablebar = (Boolean)RequestManager.createSendAndGetObjectIfFinished((byte)79, selGroup, UserManager.getFirstGroup());
                        if (disablebar == null) {
                            disablebar = Constants.FALSE;
                        }
                        cvGroupsInactivable.put(selGroup, disablebar);
                    }
                    enabled = disablebar;
                } else {
                    enabled = false;
                }
            } else if (bac.equals(COM_ENABLE_GROUP)) {
                enabled = regularGroup && !cvActiveGroups.contains(selGroup);
            }
            but.setEnabled(enabled);
        }
    }

    private int calcButHeight() {
        int y = 0;
        Iterator iter = this.ivButtons.iterator();
        while (iter.hasNext()) {
            Integer inti;
            MGButton but = (MGButton)iter.next();
            y += BUT_HEIGHT + UIDef.INNER_RAND;
            String s = but.getActionCommand();
            if (s == null || (inti = (Integer)this.ivExtraMarginByActionCommand.get(s)) == null) continue;
            y += inti.intValue();
        }
        return y;
    }
}

