/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.administrator.gui;

import de.hannse.netobjects.network.server.ServerCommunicatorInfo;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Component;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.ui.table.TableSortable;

public class CommunicatorTable
extends SortableTable
implements TableCellRenderer {
    private static final long serialVersionUID = 1789416513L;
    public MGButton ivColHeaderLabel = new MGButton();
    public JLabel ivListLabel = new JLabel();
    static /* synthetic */ Class class$0;

    public CommunicatorTable() {
        this.ivListLabel.setBackground(UIDef.NEW_BACKGROUND);
        this.setObjects(new Vector());
        this.ivColHeaderLabel.setFont(FontManager.getFont("SSB12"));
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                CommunicatorTable.this.ivColHeaderLabel.setText((String)value);
                return CommunicatorTable.this.ivColHeaderLabel;
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this);
        this.getSelectionModel().setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.getColumnModel().getColumn(2).setPreferredWidth(60);
    }

    public void fetch() {
        String s = (String)RequestManager.createSendAndGetObjectIfFinished((byte)55, null, null);
        if (s != null) {
            Vector<ServerCommunicatorInfo> v = new Vector<ServerCommunicatorInfo>();
            Vector lines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (line.trim().length() == 0) continue;
                v.add(new ServerCommunicatorInfo(line));
            }
            this.setObjects(v);
            this.tableChanged(new TableModelEvent(this));
            this.repaint();
        }
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "User";
            }
            case 1: {
                return "Group";
            }
            case 2: {
                return "Room";
            }
            case 3: {
                return "Address";
            }
            case 4: {
                return "Status";
            }
            case 5: {
                return "Commands";
            }
        }
        return "";
    }

    public int getRowCount() {
        if (this.ivObjects == null) {
            return 0;
        }
        return this.ivObjects.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ServerCommunicatorInfo sci = (ServerCommunicatorInfo)this.getObjectAtRow(rowIndex);
        if (sci != null) {
            switch (columnIndex) {
                case 0: {
                    return sci.ivUserName;
                }
                case 1: {
                    return sci.ivGroupName;
                }
                case 2: {
                    if (sci.ivRoomName != null && sci.ivRoomName.length() != 0) {
                        return sci.ivRoomName;
                    }
                    return "";
                }
                case 3: {
                    return sci.ivAddressName;
                }
                case 4: {
                    return sci.ivStatus;
                }
                case 5: {
                    return Integer.toString(sci.ivNumCommands);
                }
            }
            return "";
        }
        return "";
    }

    public Vector fillSortablesVector(int col) {
        if (this.getRowCount() <= 1) {
            return null;
        }
        Vector<TableSortable> erg = new Vector<TableSortable>();
        int row = 0;
        while (row < this.getRowCount()) {
            ServerCommunicatorInfo sci = (ServerCommunicatorInfo)this.getObjectAtRow(row);
            switch (col) {
                case 0: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)sci.ivUserName)));
                    break;
                }
                case 1: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)sci.ivGroupName)));
                    break;
                }
                case 2: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)(sci.ivRoomName != null ? sci.ivRoomName : ""))));
                    break;
                }
                case 3: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)sci.ivAddressName)));
                    break;
                }
                case 4: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)sci.ivStatus)));
                    break;
                }
                case 5: {
                    erg.addElement(new TableSortable(row, new Integer(sci.ivNumCommands)));
                    break;
                }
            }
            ++row;
        }
        return erg;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ServerCommunicatorInfo sci = (ServerCommunicatorInfo)this.getObjectAtRow(row);
        this.ivListLabel.setIcon(null);
        if (sci.ivBinIch) {
            this.ivListLabel.setFont(FontManager.getFont("SSP11"));
        } else {
            this.ivListLabel.setFont(FontManager.getFont("SSB11"));
        }
        if (column == 5) {
            this.ivListLabel.setHorizontalAlignment(4);
        } else {
            this.ivListLabel.setHorizontalAlignment(2);
        }
        StringBuffer msb = new StringBuffer();
        msb.append(" ").append(value).append(" ");
        this.ivListLabel.setText(msb.toString());
        this.ivListLabel.setOpaque(isSelected);
        return this.ivListLabel;
    }
}

