/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.cage.CageManager;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.Herzeloyde;
import mausoleum.extras.StrInflDefl;
import mausoleum.gui.CageCardToolTip;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MFLabel;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class Cage
extends IDObject {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final String CAG_PREFIX = "CAG_";
    public static final String VISIT = "CAG_VISIT";
    public static final String FLAG = "CAG_FLAG";
    public static final String POSITION = "CAG_POS";
    public static final String PSEUDOID = "CAG_PSEUDOID";
    public static final String COMMENT = "CAG_COMMENT";
    public static final String SUPERCAGE = "CAG_SUPERCAGE";
    public static final String SUBCAGEL = "CAG_SUBCAGEL";
    public static final String SUBCAGER = "CAG_SUBCAGER";
    public static final String SIDE = "CAG_SIDE";
    public static final String OLD_ISMATINGCAGE = "CAG_ISMATINGCAGE";
    public static final String TASKS = "CAG_TASKS";
    public static final String LICENSEID = "CAG_LICENSEID";
    public static final String AN_TAG = "CAG_ANTAG";
    public static final String ROOM = "CAG_ROOM";
    public static final String CAGETALKER_ID = "CAG_CTID";
    public static final String[] ATTRIBUTES_CAG;
    public static final String[] ORDERED_ATTRIBUTES;
    public static final int SIDE_NIX = 0;
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_RIGHT = 2;
    private static final int[] TOOLTIP_INFO;
    private static final boolean[] TOOLTIP_WANTEDS;
    private static final int POS_CAGETALKER_ID;
    public transient boolean ivIsWeddingCage = false;
    public transient boolean ivIsWeddingCageWithMissingGenotypes = false;
    public transient boolean ivIsSterileWeddingCage = false;
    private transient Color[] ivActColor = null;
    private transient Color[] ivActColorMatt = null;
    public transient boolean ivFatherPresent = false;
    public transient boolean ivMotherPresent = false;
    public transient boolean ivUniSex = false;
    public transient int ivHerzeloydeDays = -1;
    public transient long ivHerzeloydeMouseID = -1L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        String[] stringArray = new String[30];
        stringArray[0] = VISIT;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lmausoleum.visit.Visit;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = FLAG;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = POSITION;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("mausoleum.rack.RackPos");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = PSEUDOID;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = COMMENT;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = LICENSEID;
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = SUPERCAGE;
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = SUBCAGEL;
        Class<?> clazz8 = class$5;
        if (clazz8 == null) {
            try {
                clazz8 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        stringArray[16] = SUBCAGER;
        Class<?> clazz9 = class$5;
        if (clazz9 == null) {
            try {
                clazz9 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz9.getName();
        stringArray[18] = SIDE;
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz10.getName();
        stringArray[20] = OLD_ISMATINGCAGE;
        Class<?> clazz11 = class$6;
        if (clazz11 == null) {
            try {
                clazz11 = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz11.getName();
        stringArray[22] = TASKS;
        Class<?> clazz12 = class$7;
        if (clazz12 == null) {
            try {
                clazz12 = class$7 = Class.forName("[Lmausoleum.mouse.TaskExtended;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz12.getName();
        stringArray[24] = AN_TAG;
        Class<?> clazz13 = class$4;
        if (clazz13 == null) {
            try {
                clazz13 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[25] = clazz13.getName();
        stringArray[26] = ROOM;
        Class<?> clazz14 = class$5;
        if (clazz14 == null) {
            try {
                clazz14 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[27] = clazz14.getName();
        stringArray[28] = CAGETALKER_ID;
        Class<?> clazz15 = class$4;
        if (clazz15 == null) {
            try {
                clazz15 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[29] = clazz15.getName();
        ATTRIBUTES_CAG = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", VISIT, FLAG, POSITION, PSEUDOID, COMMENT, LICENSEID, SUPERCAGE, SUBCAGEL, SUBCAGER, SIDE, OLD_ISMATINGCAGE, TASKS, AN_TAG, ROOM, CAGETALKER_ID};
        int[] nArray = new int[8];
        nArray[1] = 8;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 3;
        nArray[6] = 6;
        nArray[7] = 7;
        TOOLTIP_INFO = nArray;
        TOOLTIP_WANTEDS = new boolean[15];
        POS_CAGETALKER_ID = ArrayHelper.findStringInArray(CAGETALKER_ID, ORDERED_ATTRIBUTES);
        int i = 0;
        while (i < TOOLTIP_INFO.length) {
            Cage.TOOLTIP_WANTEDS[Cage.TOOLTIP_INFO[i]] = true;
            ++i;
        }
    }

    public static Date getInDate(Mouse mausi, Cage cagi) {
        Visit vis;
        Visit[] varr;
        if (mausi != null && cagi != null && (varr = (Visit[])mausi.get("MOS_VISIT")) != null && (vis = Visit.findLatestUnfinishedVisit(varr, mausi.getID(), cagi.getID())) != null) {
            return vis.ivStartDate;
        }
        return null;
    }

    public static Date getLastOutDate(Mouse mausi, Cage cagi) {
        Visit vis;
        Visit[] varr;
        if (mausi != null && cagi != null && (varr = (Visit[])mausi.get("MOS_VISIT")) != null && (vis = Visit.findlastVisit(varr, mausi.getID(), cagi.getID())) != null) {
            return vis.ivEndDate;
        }
        return null;
    }

    public static long getNewCageID(Date creationDate, String group) {
        Long serverRes = (Long)RequestManager.createSendAndGetObjectIfFinished((byte)25, null, group);
        long uniqueLong = serverRes != null ? serverRes : 0L;
        StringBuilder msb = new StringBuilder();
        if (MausoleumClient.isServiceCaretaker()) {
            long srid = RoomManager.getGROUPRoomIDForServiceRoom(group);
            if (srid == -1L) {
                return 0L;
            }
            msb.append("CN_UNIQUE_ROOMID");
            msb.append(" ").append(creationDate.getTime());
            msb.append(" ").append(uniqueLong);
            msb.append(" ").append(srid).append("\n");
        } else {
            msb.append("CN_UNIQUE");
            msb.append(" ").append(creationDate.getTime());
            msb.append(" ").append(uniqueLong).append("\n");
        }
        RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), group);
        Cage cage = (Cage)CageManager.cvInstance.getObjectWithUniqueLong(uniqueLong, group);
        if (cage != null) {
            return cage.getID();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void hangleCageForTooltip(Cage c, long[] lastCageID, JComponent comptToSet) {
        if (c != null) {
            long cageID = c.getID();
            if (cageID == lastCageID[0]) return;
            String res = null;
            lastCageID[0] = cageID;
            int mode = DefaultManager.getCageTooltipMode();
            if (mode == 2) {
                String string = "MUTEX";
                synchronized ("MUTEX") {
                    CageCardToolTip.INSTANCE.setCage(c);
                    res = "a" + MilliSpender.getMillis();
                    // ** MonitorExit[var7_6] (shouldn't be in output)
                }
            } else if (mode == 3) {
                res = c.getToolTipString(true);
            } else if (mode == 1) {
                res = c.getToolTipString(false);
            }
            {
                comptToSet.setToolTipText(res);
                return;
            }
        } else {
            if (lastCageID[0] == -1L) return;
            if (DefaultManager.getCageTooltipMode() == 2) {
                CageCardToolTip.INSTANCE.setCage(null);
            }
            lastCageID[0] = -1L;
            comptToSet.setToolTipText(null);
        }
    }

    public static boolean areCagesRoomAccesibilityRestricted(Vector cages) {
        if (MausoleumClient.isRegularOrTGService() && cages != null && !cages.isEmpty() && cages.elementAt(0) instanceof Cage) {
            Iterator iter = cages.iterator();
            while (iter.hasNext()) {
                Cage cage = (Cage)iter.next();
                if (!cage.isRoomAccesibilityRestricted()) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getObjectForSpecialIndex(String encZeile, String group) {
        Zeile z;
        String s;
        if (CageTalker.useCageTalker() && (s = (z = new Zeile(StrInflDefl.inflate(encZeile), '\'')).getStringNONEmptyWithoutTrim(POS_CAGETALKER_ID, null)) != null) {
            return IDObjectXMLHandler.getObject("S", s, group);
        }
        return null;
    }

    public String getTaskKey() {
        return TASKS;
    }

    public int getNumberOfMice() {
        int sum = 0;
        Visit[] vs = (Visit[])this.get(VISIT);
        if (vs != null) {
            int i = 0;
            while (i < vs.length) {
                if (vs[i].ivEndDate == null) {
                    ++sum;
                }
                ++i;
            }
        }
        return sum;
    }

    private boolean crossCheckVisit(Visit cageVisit, Mouse mouse) {
        Visit[] mouseVisits;
        Visit[] visitArray = mouseVisits = mouse != null ? (Visit[])mouse.get("MOS_VISIT") : null;
        if (mouseVisits != null) {
            int i = 0;
            while (i < mouseVisits.length) {
                if (cageVisit.ivCageID == mouseVisits[i].ivCageID && cageVisit.ivMouseID == mouseVisits[i].ivMouseID && cageVisit.ivStartMode == mouseVisits[i].ivStartMode && cageVisit.ivStartDate.equals(mouseVisits[i].ivStartDate) && !mouseVisits[i].isUnfinished()) {
                    System.out.println("-----------------------------");
                    System.out.println("---        PROBLEM        ---");
                    System.out.println("-----------------------------");
                    Cage.outOneVisit(cageVisit, "CAGE:  ");
                    Cage.outOneVisit(mouseVisits[i], "MOUSE: ");
                    StringBuilder msb = new StringBuilder();
                    msb.append(CommandManagerExecutive.getServiceRoomTag(this, ""));
                    msb.append("CENDVISIT");
                    msb.append(" ");
                    msb.append(this.getID());
                    msb.append(" ");
                    msb.append(mouse.getID());
                    msb.append(" ");
                    msb.append(mouseVisits[i].ivStartDate.getTime());
                    msb.append(" ");
                    msb.append(mouseVisits[i].ivStartMode);
                    msb.append(" ");
                    msb.append(mouseVisits[i].ivEndDate.getTime());
                    msb.append(" ");
                    msb.append(mouseVisits[i].ivEndMode);
                    RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), this.getGroup());
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void outOneVisit(Visit visit, String prefix) {
        MyDate md;
        GregorianCalendar GREG = new GregorianCalendar();
        StringBuilder TSB = new StringBuilder(prefix);
        TSB.append(visit.ivCageID).append(" | ");
        TSB.append(visit.ivMouseID).append(" | ");
        if (visit.ivStartDate != null) {
            GREG.setTimeInMillis(visit.ivStartDate.getTime());
            md = new MyDate(GREG);
            TSB.append(DatumFormat.getProtDateTimeString(md));
        }
        TSB.append(" | ");
        TSB.append(visit.ivStartMode).append(" | ");
        if (visit.ivEndDate != null) {
            GREG.setTimeInMillis(visit.ivEndDate.getTime());
            md = new MyDate(GREG);
            TSB.append(DatumFormat.getProtDateTimeString(md));
        }
        TSB.append(" | ");
        TSB.append(visit.ivEndMode);
        System.out.println(TSB.toString());
    }

    public void determineActualMice() {
        this.ivFatherPresent = false;
        this.ivMotherPresent = false;
        this.ivUniSex = false;
        this.ivHerzeloydeDays = -1;
        this.ivHerzeloydeMouseID = -1L;
        Vector<Mouse> tempV = new Vector<Mouse>();
        Visit[] vs = (Visit[])this.get(VISIT);
        if (vs != null) {
            LongPunkt herzLP;
            HashSet<Long> mouseIDs = new HashSet<Long>();
            HashSet<Long> fatherIDs = new HashSet<Long>();
            HashSet<Long> motherIDs = new HashSet<Long>();
            HashSet<Integer> sexes = new HashSet<Integer>();
            int i = 0;
            while (i < vs.length) {
                if (vs[i].isUnfinished()) {
                    long mid = vs[i].ivMouseID;
                    Mouse mouse = (Mouse)ObjectStore.getClientObject(1, mid, this.getGroup());
                    this.crossCheckVisit(vs[i], mouse);
                    if (mouse != null && mouse.isAliveAndVisible()) {
                        tempV.add(mouse);
                        mouseIDs.add(new Long(mid));
                        Long pid = (Long)mouse.get("MOS_FATHER");
                        if (pid != null) {
                            fatherIDs.add(pid);
                        }
                        if ((pid = (Long)mouse.get("MOS_MOTHER")) != null) {
                            motherIDs.add(pid);
                        }
                        sexes.add(new Integer(mouse.getSex()));
                    }
                }
                ++i;
            }
            if (!mouseIDs.isEmpty()) {
                this.ivFatherPresent = false;
                Iterator iter = fatherIDs.iterator();
                while (iter.hasNext()) {
                    if (!mouseIDs.contains(iter.next())) continue;
                    this.ivFatherPresent = true;
                }
                this.ivMotherPresent = false;
                iter = motherIDs.iterator();
                while (iter.hasNext()) {
                    if (!mouseIDs.contains(iter.next())) continue;
                    this.ivMotherPresent = true;
                }
                boolean bl = this.ivUniSex = sexes.size() == 1;
            }
            if ((herzLP = Herzeloyde.fillHerzeloydeInfo(tempV)) != null && herzLP.ivY >= 0L) {
                this.ivHerzeloydeMouseID = herzLP.ivX;
                this.ivHerzeloydeDays = (int)herzLP.ivY;
            }
            tempV.clear();
            tempV = null;
            mouseIDs.clear();
            mouseIDs = null;
            fatherIDs.clear();
            fatherIDs = null;
            motherIDs.clear();
            motherIDs = null;
            sexes.clear();
            sexes = null;
        }
    }

    public boolean isRoomAccesibilityRestricted() {
        Room room;
        if (MausoleumClient.isRegularOrTGService() && (room = this.getRoom()) != null) {
            return !room.isAccessibleForGroups();
        }
        return false;
    }

    public String getOwnerString() {
        String s;
        Long ownerID;
        Vector mice = this.getActualMice();
        if (mice.isEmpty()) {
            return "";
        }
        if (Cage.belongToAll(mice)) {
            return "ALL";
        }
        if (Cage.isMixedOwnerMode(mice)) {
            return "MULTIPLE";
        }
        HashSet ownerIDs = Cage.getOwnerIDs(mice);
        Iterator iterator = ownerIDs.iterator();
        while (iterator.hasNext()) {
            ownerID = (Long)iterator.next();
            s = UserManager.getNameOfUser(ownerID, this.getGroup());
            if (ownerIDs.size() != 1) continue;
            if (s != null) {
                return s.toUpperCase();
            }
            return "unknown";
        }
        if (ownerIDs.size() == 1 && (iterator = ownerIDs.iterator()).hasNext()) {
            ownerID = (Long)iterator.next();
            s = UserManager.getNameOfUser(ownerID, this.getGroup());
            if (s != null) {
                return s.toUpperCase();
            }
            return "unknown";
        }
        StringBuffer msb = new StringBuffer();
        Iterator iterator2 = ownerIDs.iterator();
        while (iterator2.hasNext()) {
            Long ownerID2 = (Long)iterator2.next();
            String s2 = UserManager.getNameOfUser(ownerID2, this.getGroup());
            if (s2 == null) continue;
            if ((s2 = s2.toUpperCase().trim()).length() < 3) {
                msb.append(s2).append(" ");
                continue;
            }
            msb.append(s2.substring(0, 3)).append(" ");
        }
        return msb.toString().trim();
    }

    private static boolean isMixedOwnerMode(Vector mice) {
        if (mice.size() > 1) {
            HashSet first = new HashSet();
            Mouse mouse = (Mouse)mice.elementAt(0);
            mouse.addDirectAndIndirectOwnerIDs(first);
            HashSet temp = new HashSet();
            int i = 1;
            while (i < mice.size()) {
                temp.clear();
                mouse = (Mouse)mice.elementAt(i);
                mouse.addDirectAndIndirectOwnerIDs(temp);
                if (temp.size() != first.size()) {
                    return true;
                }
                Iterator iterator = temp.iterator();
                while (iterator.hasNext()) {
                    if (first.contains(iterator.next())) continue;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getOwnerAllString(String allGroupmembers) {
        Vector mice = this.getActualMice();
        if (mice.isEmpty()) {
            return "";
        }
        if (Cage.belongToAll(mice)) {
            return allGroupmembers;
        }
        HashSet v = Cage.getOwnerIDs(mice);
        StringBuffer msb = new StringBuffer();
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            Long longi = (Long)iterator.next();
            String s = UserManager.getNameOfUser(longi, this.getGroup());
            if (s == null) continue;
            if (msb.length() != 0) {
                msb.append(", ");
            }
            msb.append(s);
        }
        return msb.toString().trim();
    }

    public String getPureCageObjectString(String defVal, String prefix, String tag) {
        String erg = this.getString(tag, null);
        erg = erg != null && erg.trim().length() != 0 ? String.valueOf(prefix) + erg.trim() : defVal;
        return erg;
    }

    public String getLicenseString(String label) {
        String erg = this.getPureCageObjectString(null, "[c] ", LICENSEID);
        if (erg == null) {
            erg = this.getPureMouseObjectString(null, "[m] ", 16);
        }
        if (erg == null) {
            erg = this.getPureCageObjectString("", "[g] ", "IDO_GROUP");
        }
        if (label != null) {
            erg = String.valueOf(label) + erg;
        }
        return erg;
    }

    public String getPureMouseObjectString(String defVal, String prefix, int type) {
        if (this.getNumberOfMice() != 0) {
            TreeSet<String> ts = new TreeSet<String>();
            Vector mice = this.getActualMice();
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Line line;
                Mouse mouse = (Mouse)iter.next();
                String name = null;
                if (type == 16) {
                    name = mouse.getLicenseString(",", null);
                } else if (type == 7 && (line = mouse.getLine()) != null) {
                    name = line.getName();
                }
                if (name == null || name.trim().length() == 0) continue;
                ts.add(name.trim());
            }
            if (!ts.isEmpty()) {
                StringBuffer licsb = new StringBuffer();
                if (prefix != null) {
                    licsb.append(prefix);
                }
                Iterator iter2 = ts.iterator();
                while (iter2.hasNext()) {
                    licsb.append((String)iter2.next());
                    if (!iter2.hasNext()) continue;
                    licsb.append(", ");
                }
                return licsb.toString();
            }
        }
        return defVal;
    }

    public String getOwnerStringOslo(String prefix, String defaultOwnerString) {
        Vector mice = this.getActualMice();
        if (mice.isEmpty()) {
            return "";
        }
        String raus = null;
        if (Cage.belongToAll(mice)) {
            raus = defaultOwnerString;
        } else {
            User usi = this.getMainUser();
            if (usi != null) {
                raus = usi.getString("USR_NAME", null);
            }
            if (raus == null) {
                return defaultOwnerString;
            }
        }
        if (prefix != null) {
            return String.valueOf(prefix) + raus;
        }
        return raus;
    }

    public User getOwnerOslo() {
        Vector mice = this.getActualMice();
        if (!mice.isEmpty() && !Cage.belongToAll(mice)) {
            return this.getMainUser();
        }
        return null;
    }

    public String getOwnerStringOnlySingleEmailPreferred() {
        User usi;
        Vector mice = this.getActualMice();
        String raus = null;
        if (!mice.isEmpty() && !Cage.belongToAll(mice) && (usi = this.getMainUser()) != null && (raus = usi.getString("USR_EMAIL", null)) == null) {
            raus = usi.getString("USR_NAME", null);
        }
        return raus == null ? "" : raus;
    }

    public String getOwnerStringOnlySingleNamePreferred() {
        User usi;
        Vector mice = this.getActualMice();
        String raus = null;
        if (!mice.isEmpty() && !Cage.belongToAll(mice) && (usi = this.getMainUser()) != null && (raus = usi.getString("USR_NAME", null)) == null) {
            raus = usi.getString("USR_EMAIL", null);
        }
        if (raus == null) {
            return "";
        }
        return raus;
    }

    public int getNumOfPups() {
        int res = 0;
        Vector v = this.getActualMice();
        if (v != null) {
            Visit[] varr = (Visit[])this.get(VISIT);
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                boolean isPup = false;
                long mumID = mouse.getLong("MOS_MOTHER", 0L);
                long dadID = mouse.getLong("MOS_FATHER", 0L);
                if (mumID != 0L || dadID != 0L) {
                    int i = 0;
                    while (i < varr.length) {
                        if (varr[i].isUnfinished() && (varr[i].ivMouseID == mumID || varr[i].ivMouseID == dadID)) {
                            isPup = true;
                        }
                        ++i;
                    }
                }
                if (!isPup) continue;
                ++res;
            }
        }
        return res;
    }

    public String getRackPosString(String label) {
        Rack r;
        RackPos rp = (RackPos)this.get(POSITION);
        if (rp != null && (r = (Rack)ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, this.getString("IDO_GROUP"), null, false)) != null) {
            StringBuffer msb = new StringBuffer();
            if (label != null) {
                msb.append(label);
            }
            msb.append(r.getName()).append(" ");
            if (rp.ivSide == 0) {
                msb.append("A ");
            } else {
                msb.append("B ");
            }
            msb.append(String.valueOf(rp.ivRow + 1) + "." + (rp.ivColumn + 1));
            return msb.toString();
        }
        return null;
    }

    public int getTaskCount() {
        int sum = 0;
        Iterator iterator = this.getActualMice().iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            TaskExtended[] tarr = (TaskExtended[])mouse.get("MOS_TASKSEXT");
            if (tarr == null) continue;
            sum += tarr.length;
        }
        return sum;
    }

    private static boolean belongToAll(Vector mice) {
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse m = (Mouse)iter.next();
            long[] owners = (long[])m.get("MOS_OWNER");
            if (owners != null && owners.length != 0) {
                return false;
            }
            owners = (long[])m.get("MOS_OWNERGROUPS");
            if (owners == null || owners.length == 0) continue;
            return false;
        }
        return true;
    }

    private static HashSet getOwnerIDs(Vector mice) {
        HashSet erg = new HashSet();
        if (mice != null) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse m = (Mouse)iter.next();
                m.addDirectAndIndirectOwnerIDs(erg);
            }
        }
        return erg;
    }

    public HashSet getOwnerObjects() {
        HashSet<User> erg = new HashSet<User>();
        if (this.getNumberOfMice() != 0) {
            HashSet ownerIDs = Cage.getOwnerIDs(this.getActualMice());
            Iterator iterator = ownerIDs.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                User user = UserManager.getUser(id, this.getGroup());
                if (user == null) continue;
                erg.add(user);
            }
        }
        return erg;
    }

    public User getMainUser() {
        return this.getNumberOfMice() != 0 ? Cage.getMainUser(this.getActualMice(), this.getGroup()) : null;
    }

    public static User getMainUser(Vector mice, String group) {
        try {
            User usi;
            HashMap userHashmap = new HashMap();
            HashMap primaryUserHashmap = new HashMap();
            if (mice != null) {
                Iterator iter = mice.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    long[] owners = (long[])mouse.get("MOS_OWNER");
                    if (owners == null || owners.length == 0) continue;
                    int j = 0;
                    while (j < owners.length) {
                        Long userIDLong = new Long(owners[j]);
                        if (j == 0) {
                            Cage.macheEintrag(primaryUserHashmap, userIDLong);
                        }
                        Cage.macheEintrag(userHashmap, userIDLong);
                        ++j;
                    }
                }
            }
            if ((usi = Cage.getMainUserFromHashmap(primaryUserHashmap, false, group)) != null) {
                return usi;
            }
            return Cage.getMainUserFromHashmap(userHashmap, true, group);
        }
        catch (Exception e) {
            System.out.println("getMainUser Problem: Exception -> " + e);
            return null;
        }
    }

    private static void macheEintrag(HashMap anzByUserID, Long userIDLong) {
        Integer anzInt = (Integer)anzByUserID.get(userIDLong);
        if (anzInt == null) {
            anzByUserID.put(userIDLong, new Integer(1));
        } else {
            anzByUserID.put(userIDLong, new Integer(anzInt + 1));
        }
    }

    private static User getMainUserFromHashmap(HashMap userHashmap, boolean useAlphabet, String group) {
        if (userHashmap.isEmpty()) {
            return null;
        }
        if (userHashmap.size() == 1) {
            Iterator iter = userHashmap.keySet().iterator();
            Long uid = (Long)iter.next();
            return UserManager.getUser(uid, group);
        }
        int maxMice = 0;
        Vector<Long> possMainUsers = new Vector<Long>();
        Iterator iter = userHashmap.keySet().iterator();
        while (iter.hasNext()) {
            Long uid = (Long)iter.next();
            Integer anzInt = (Integer)userHashmap.get(uid);
            int anz = anzInt;
            if (anz == maxMice) {
                possMainUsers.addElement(uid);
                continue;
            }
            if (anz <= maxMice) continue;
            possMainUsers.clear();
            possMainUsers.addElement(uid);
            maxMice = anz;
        }
        if (possMainUsers.isEmpty()) {
            System.out.println("getMainUser Problem: Keinen Hauptuser nach Mauszahl");
            return null;
        }
        if (possMainUsers.size() == 1) {
            Long uid = (Long)possMainUsers.elementAt(0);
            return UserManager.getUser(uid, group);
        }
        if (useAlphabet) {
            Vector<String> usernames = new Vector<String>(possMainUsers.size());
            Iterator iter2 = possMainUsers.iterator();
            while (iter2.hasNext()) {
                String name;
                Long uid = (Long)iter2.next();
                User usi = UserManager.getUser(uid, group);
                if (usi == null || (name = usi.getString("USR_NAME", null)) == null) continue;
                usernames.addElement(name);
            }
            Collections.sort(usernames);
            String theUsername = (String)usernames.elementAt(0);
            Iterator iter3 = possMainUsers.iterator();
            while (iter3.hasNext()) {
                String name;
                Long uid = (Long)iter3.next();
                User usi = UserManager.getUser(uid, group);
                if (usi == null || (name = usi.getString("USR_NAME", null)) == null || !name.equals(theUsername)) continue;
                return usi;
            }
        }
        return null;
    }

    public String getName() {
        return this.getLabelIDString();
    }

    public String getName(String nullVal) {
        return this.getLabelIDString();
    }

    public String getBrowseName() {
        return this.getLabelIDString();
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        RackPos rp;
        Visit[] arr;
        char c;
        IDObject ido;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Number = " + this.getLabelIDString());
        long l = this.getLong(SUPERCAGE, 0L);
        if (l != 0L) {
            ido = ObjectStore.getObjectDeadOrAlive(2, l, group, null, false);
            target.add("Supercage: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + l);
        }
        if ((l = this.getLong(SUBCAGEL, 0L)) != 0L) {
            ido = ObjectStore.getObjectDeadOrAlive(2, l, group, null, false);
            target.add("Subcage left: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + l);
        }
        if ((l = this.getLong(SUBCAGER, 0L)) != 0L) {
            ido = ObjectStore.getObjectDeadOrAlive(2, l, group, null, false);
            target.add("Subcage right: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + l);
        }
        if ((c = this.getChar(FLAG)) == '\u0001') {
            target.add("Mark = \u261e");
        } else if (c != '\u0000') {
            char[] ica = new char[]{c};
            target.add("Mark = " + new String(ica));
        }
        int side = this.getInt(SIDE, 0);
        if (side == 1) {
            target.add("Side = left");
        } else if (side == 2) {
            target.add("Side = right");
        }
        String s = this.getString(LICENSEID, null);
        if (s != null) {
            target.add("License = " + s);
        }
        if ((s = this.getString(AN_TAG, null)) != null) {
            target.add("Tag = " + s);
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(1))) && (arr = (Visit[])this.get(VISIT)) != null) {
            int i = 0;
            while (i < arr.length) {
                IDObject ido2;
                Visit vis = arr[i];
                if (vis.ivEndDate == null) {
                    ido2 = ObjectStore.getObjectDeadOrAlive(1, vis.ivMouseID, group, null, false);
                    target.add("Act. visit by mouse: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 1 + "|" + vis.ivMouseID);
                } else {
                    ido2 = ObjectStore.getObjectDeadOrAlive(1, vis.ivMouseID, group, null, false);
                    target.add("Old visit by mouse: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 1 + "|" + vis.ivMouseID);
                }
                ++i;
            }
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(3))) && (rp = (RackPos)this.get(POSITION)) != null) {
            IDObject ido3 = ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, group, null, false);
            target.add("Rack: " + ido3.getBrowseName() + "\t" + "object|" + group + "|" + 3 + "|" + rp.ivRackID);
        }
        if ((s = this.getString(COMMENT, null)) != null && s.trim().length() != 0) {
            target.add("Comment\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public static boolean areCagesTouchable(Vector cages) {
        if (cages == null || cages.isEmpty() || !(cages.elementAt(0) instanceof Cage)) {
            return false;
        }
        Iterator iter = cages.iterator();
        while (iter.hasNext()) {
            Cage cage = (Cage)iter.next();
            if (cage.isTouchable()) continue;
            return false;
        }
        return true;
    }

    public boolean isTouchable() {
        if (ProcessDefinition.isClient() && this.isAlive()) {
            return Privileges.hasPrivilege("TOUCH_FOREIGN_CAGES") || this.itsMine(null);
        }
        return false;
    }

    public boolean isTouchable(User user) {
        if (ProcessDefinition.isClient() && this.isAlive()) {
            return Privileges.hasPrivilege(user, "TOUCH_FOREIGN_CAGES") || this.itsMine(user);
        }
        return false;
    }

    public boolean itsMine(User user) {
        if (this.isAlive()) {
            if (this.hasSubCages()) {
                Cage cr;
                boolean res = false;
                Cage cl = this.getLeftSubCage();
                if (cl != null) {
                    res |= cl.itsMine(user);
                }
                if ((cr = this.getRightSubCage()) != null) {
                    res |= cr.itsMine(user);
                }
                return res;
            }
            int num = 0;
            Visit[] visits = (Visit[])this.get(VISIT);
            if (visits != null && visits.length != 0) {
                int i = 0;
                while (i < visits.length) {
                    if (visits[i].isUnfinished()) {
                        ++num;
                        Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, visits[i].ivMouseID, this.getString("IDO_GROUP"), null, true);
                        if (mouse == null) {
                            Log.error("Missing Mouse: " + visits[i].ivMouseID + " in cage: " + this + " of group " + this.getString("IDO_GROUP"), null, this);
                        } else if (mouse.itsMine(user)) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return num == 0;
        }
        return false;
    }

    public String getRoomName() {
        Room room = this.getRoom();
        if (room != null) {
            return room.getName();
        }
        return "";
    }

    public Room getRoom() {
        Rack rack = this.getRack();
        if (rack != null) {
            return rack.getRoom();
        }
        if (this.get(ROOM) != null) {
            return (Room)ObjectStore.getObjectDeadOrAlive(10, this.getLong(ROOM, 0L), this.getString("IDO_GROUP"), null, false);
        }
        return null;
    }

    public boolean canSitInRoom() {
        return true;
    }

    public Long getServiceRoomID() {
        Room room;
        if (this.isAlive() && (room = this.getRoom()) != null) {
            return room.getServiceRoomID();
        }
        return null;
    }

    public String getRackName() {
        if (this.hasSuperCage()) {
            return this.getSuperCageIfThere().getRackName();
        }
        Rack rack = this.getRack();
        if (rack != null) {
            return rack.getName();
        }
        return "";
    }

    public String getRackPosName() {
        if (this.hasSuperCage()) {
            return this.getSuperCageIfThere().getRackPosName();
        }
        RackPos rp = (RackPos)this.get(POSITION);
        if (rp != null) {
            boolean mitSeite = true;
            Rack rack = this.getRack();
            if (rack != null) {
                boolean bl = mitSeite = rack.getInt("RCK_SIDES", 0) > 1;
            }
            return String.valueOf(mitSeite ? String.valueOf(rp.ivSide == 0 ? Babel.get("FRONT") : Babel.get("BACK")) + " " : "") + Babel.get("ROW_SHORT") + ":" + (rp.ivRow + 1) + " " + Babel.get("COL_SHORT") + ":" + (rp.ivColumn + 1);
        }
        return "";
    }

    public String getRackPosNameForCageTalker() {
        if (this.hasSuperCage()) {
            return this.getSuperCageIfThere().getRackPosName();
        }
        RackPos rp = (RackPos)this.get(POSITION);
        if (rp != null) {
            boolean mitSeite = true;
            Rack rack = this.getRack();
            if (rack != null) {
                boolean bl = mitSeite = rack.getInt("RCK_SIDES", 0) > 1;
            }
            return String.valueOf(mitSeite ? (rp.ivSide == 0 ? "F" : "B") : "") + "R" + (rp.ivRow + 1) + "C" + (rp.ivColumn + 1);
        }
        return "";
    }

    public String getRackAndPosName() {
        if (this.hasSuperCage()) {
            return this.getSuperCageIfThere().getRackAndPosName();
        }
        String rn = this.getRackName();
        if (rn.trim().length() != 0) {
            return String.valueOf(rn) + " " + this.getRackPosName();
        }
        return "";
    }

    public RackPos getRackPos() {
        return (RackPos)this.getSuperCageIfThere().get(POSITION);
    }

    public long getRackID(long defVal) {
        RackPos rp = (RackPos)this.get(POSITION);
        if (rp != null) {
            return rp.ivRackID;
        }
        return defVal;
    }

    public Rack getRack() {
        RackPos rp = (RackPos)this.get(POSITION);
        if (rp != null) {
            return (Rack)ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, this.getGroup(), null, false);
        }
        return null;
    }

    public String getLabelIDString() {
        StringBuffer msb = new StringBuffer();
        if (this.getChar(FLAG) == '\u0001') {
            msb.append("\u261e ");
        } else if (this.getChar(FLAG) != '\u0000') {
            char[] ica = new char[]{this.getChar(FLAG)};
            msb.append(String.valueOf(new String(ica)) + " ");
        }
        String pseudoid = this.getNumber();
        int stype = this.getInt(SIDE);
        if (stype == 1) {
            pseudoid = String.valueOf(this.getSuperCageIfThere().getNumber()) + "-L";
        } else if (stype == 2) {
            pseudoid = String.valueOf(this.getSuperCageIfThere().getNumber()) + "-R";
        }
        msb.append(pseudoid);
        if (this.isMatingCage()) {
            msb.append(" M");
        }
        return msb.toString();
    }

    public int getNumberOfSexedMice(int sex) {
        int anzf = 0;
        Iterator iter = this.getActualMice().iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            if (mouse.getSex(0) != sex) continue;
            ++anzf;
        }
        return anzf;
    }

    public String getLabelMouseNumberString() {
        return "number: " + this.getNumberOfMice();
    }

    public String getCageNumberWithSub() {
        String pseudoid = this.getSuperCageIfThere().getNumber();
        int stype = this.getInt(SIDE);
        if (stype == 1) {
            pseudoid = String.valueOf(pseudoid) + "-L";
        } else if (stype == 2) {
            pseudoid = String.valueOf(pseudoid) + "-R";
        }
        return pseudoid;
    }

    public String getToolTipString(boolean nurTasks) {
        String res = null;
        if (nurTasks) {
            res = TaskExtended.getToolTipStringTasks(this);
        } else {
            Color bg = Color.lightGray;
            Color[] ca = this.getColor();
            if (ca != null && (bg = ca[0]) == null) {
                bg = Color.lightGray;
            }
            String colorstring = ColorManager.getHTMLColorString(ColorManager.getLighterColor(bg));
            StringBuffer msb = new StringBuffer("<HTML><body");
            msb.append(" text=\"#000000\" bgcolor=\"").append(colorstring).append("\"");
            msb.append(">");
            String pseudoid = this.getCageNumberWithSub();
            msb.append("<b>&nbsp;CAGE: ").append(pseudoid).append("&nbsp;</b>\n");
            if (this.getNumberOfMice() != 0) {
                msb.append("<br><br>\n");
                msb.append("&nbsp;").append(this.getLabelLineString(true, ", ")).append("<br>\n");
                msb.append("&nbsp;").append(this.getLabelStrainString(true)).append("<br>\n");
                msb.append("&nbsp;").append(this.getLabelOwnerString(true)).append("<br>\n");
                Vector sammler = new Vector();
                this.sammleLabels(FontManager.getFont("SSP10"), false, sammler, null, TOOLTIP_WANTEDS, false);
                if (!sammler.isEmpty()) {
                    msb.append("<table>\n");
                    int i = 0;
                    while (i < sammler.size()) {
                        msb.append("\t<tr>\n");
                        Object[] blocks = (Object[])sammler.elementAt(i);
                        int kk = 0;
                        while (kk < TOOLTIP_INFO.length) {
                            int j = TOOLTIP_INFO[kk];
                            if (blocks[j] == null) {
                                msb.append("\t\t<td>&nbsp;</td>\n");
                            } else if (blocks[j] instanceof String) {
                                msb.append("\t\t<td>").append(blocks[j]).append("</td>\n");
                            } else if (blocks[j] instanceof MFLabel) {
                                msb.append("\t\t<td>");
                                this.appendMLFOHTML(msb, (MFLabel)blocks[j]);
                                msb.append("</td>\n");
                            } else if (blocks[j] instanceof Vector) {
                                Vector mlfov = (Vector)blocks[j];
                                msb.append("\t\t<td>");
                                int k = 0;
                                while (k < mlfov.size()) {
                                    this.appendMLFOHTML(msb, (MFLabel)mlfov.elementAt(k));
                                    ++k;
                                }
                                msb.append("</td>\n");
                            }
                            ++kk;
                        }
                        msb.append("\t</tr>\n");
                        ++i;
                    }
                    msb.append("</table>\n");
                }
            }
            msb.append("</body>");
            res = msb.toString();
        }
        return res;
    }

    private void appendMLFOHTML(StringBuffer msb, MFLabel mlfo) {
        if (mlfo.ivFont.isBold() && mlfo.ivFont.isItalic()) {
            msb.append("<b><i>").append(mlfo.ivString).append("</i></b>");
        } else if (mlfo.ivFont.isBold()) {
            msb.append("<b>").append(mlfo.ivString).append("</b>");
        } else if (mlfo.ivFont.isItalic()) {
            msb.append("<i>").append(mlfo.ivString).append("</i>");
        } else {
            msb.append(mlfo.ivString);
        }
    }

    public String getLabelLineString(boolean withLabel, String separator) {
        String s = AllgUtils.getTypeString(this, this.getActualMice(), 0, null, separator, true);
        if (withLabel) {
            return "line:  " + s;
        }
        return s;
    }

    public String getLabelStrainString(boolean withLabel) {
        return String.valueOf(withLabel ? "strain: " : "") + AllgUtils.getTypeString(this, this.getActualMice(), 1, true);
    }

    public String getLabelOwnerString(boolean withLabel) {
        return String.valueOf(withLabel ? "owners: " : "") + this.getOwnerString();
    }

    public Vector getAllMiceEverVisited() {
        Vector<Mouse> v = new Vector<Mouse>();
        Visit[] visits = (Visit[])this.get(VISIT);
        if (visits != null && visits.length != 0) {
            String group = this.getGroup();
            HashSet<Long> mouseIDs = new HashSet<Long>();
            int vi = 0;
            while (vi < visits.length) {
                Visit visit = visits[vi];
                if (visit.ivMouseID != 0L) {
                    mouseIDs.add(new Long(visit.ivMouseID));
                }
                ++vi;
            }
            Iterator iterator = mouseIDs.iterator();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, l, group, null, false);
                if (mouse == null) continue;
                v.add(mouse);
            }
        }
        return v;
    }

    public Vector getActualMice() {
        Vector erg = new Vector();
        this.addActualMice(erg);
        return erg;
    }

    public boolean isGVOCage() {
        Vector v = this.getActualMice();
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (!mouse.isGVO()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasUnfinishedVisits() {
        Visit[] vs = (Visit[])this.get(VISIT);
        if (vs != null) {
            int ci = 0;
            while (ci < vs.length) {
                if (vs[ci].ivEndDate == null) {
                    return true;
                }
                ++ci;
            }
        }
        return false;
    }

    public void addActualMice(Vector erg) {
        block7: {
            String group;
            block8: {
                block6: {
                    if (!this.hasSubCages()) break block6;
                    Cage subcage = this.getLeftSubCage();
                    if (subcage != null) {
                        subcage.addActualMice(erg);
                    }
                    if ((subcage = this.getRightSubCage()) == null) break block7;
                    subcage.addActualMice(erg);
                    break block7;
                }
                group = this.getGroup();
                if (!ProcessDefinition.isServer()) break block8;
                Visit[] vs = (Visit[])this.get(VISIT);
                if (vs == null) break block7;
                int ci = 0;
                while (ci < vs.length) {
                    Mouse mouse;
                    if (vs[ci].ivEndDate == null && (mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, vs[ci].ivMouseID, group, null, true)) != null) {
                        erg.add(mouse);
                    }
                    ++ci;
                }
                break block7;
            }
            Visit[] vs = (Visit[])this.get(VISIT);
            if (vs != null) {
                int ci = 0;
                while (ci < vs.length) {
                    Mouse mouse;
                    if (vs[ci].ivEndDate == null && (mouse = (Mouse)ObjectStore.getClientObject(1, vs[ci].ivMouseID, group)) != null) {
                        erg.add(mouse);
                    }
                    ++ci;
                }
            }
        }
    }

    public Cage getSuperCageIfThere() {
        long superID = this.getLong(SUPERCAGE, 0L);
        if (superID != 0L) {
            return (Cage)ObjectStore.getObjectDeadOrAlive(2, this.getLong(SUPERCAGE, 0L), this.getString("IDO_GROUP"), null, false);
        }
        return this;
    }

    public boolean hasSuperCage() {
        return this.get(SUPERCAGE) != null;
    }

    public boolean hasSubCages() {
        return this.get(SUBCAGEL) != null || this.get(SUBCAGER) != null;
    }

    public Cage getLeftSubCage() {
        if (this.get(SUBCAGEL) != null) {
            return (Cage)ObjectStore.getObjectDeadOrAlive(2, this.getLong(SUBCAGEL, 0L), this.getGroup(), null, false);
        }
        return null;
    }

    public Cage getRightSubCage() {
        if (this.get(SUBCAGER) != null) {
            return (Cage)ObjectStore.getObjectDeadOrAlive(2, this.getLong(SUBCAGER, 0L), this.getString("IDO_GROUP"), null, false);
        }
        return null;
    }

    public void sammleLabels(Font normFont, boolean veryShortDate, Vector alleSammler, HashMap sammlerByParents, boolean[] wantedInfos, boolean gtPralineMode) {
        if (alleSammler != null || sammlerByParents != null) {
            Vector sv = this.getActualMice();
            if (sv.size() > 1) {
                Collections.sort(sv, AllgUtils.MOUSE_ET_SORTER);
            }
            Iterator iter = sv.iterator();
            while (iter.hasNext()) {
                Mouse mausi = (Mouse)iter.next();
                if (mausi == null) continue;
                Object[] labels = mausi.fillLabelInformation(normFont, veryShortDate, this.getID(-1L), wantedInfos, gtPralineMode);
                if (alleSammler != null) {
                    alleSammler.add(labels);
                }
                if (sammlerByParents == null) continue;
                LongPunkt lp = new LongPunkt(mausi.getLong("MOS_FATHER", -1L), mausi.getLong("MOS_MOTHER", -1L));
                Vector<Object[]> v = (Vector<Object[]>)sammlerByParents.get(lp);
                if (v == null) {
                    v = new Vector<Object[]>();
                    sammlerByParents.put(lp, v);
                }
                v.add(labels);
            }
        }
    }

    public String getNumberString() {
        if (CageTalker.useCageTalker() && this.get(CAGETALKER_ID) != null) {
            return " *" + this.getCageNumberWithSub() + " ";
        }
        return " " + this.getCageNumberWithSub() + " ";
    }

    public int getIntNumber() {
        if (DefaultManager.useCagePseudoIDs()) {
            return this.getInt(PSEUDOID);
        }
        return (int)this.getID();
    }

    public String getNumber() {
        if (DefaultManager.useCagePseudoIDs()) {
            return Integer.toString(this.getInt(PSEUDOID));
        }
        return Long.toString(this.getID());
    }

    public boolean areMiceInside(Vector mice) {
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            if (!this.isMouseInside(mouse.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseInside(long mid) {
        Visit[] arr;
        if (mid > 0L && (arr = (Visit[])this.get(VISIT)) != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivEndDate == null && arr[i].ivMouseID == mid) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean wasMouseEverInside(long mid, Visit[] arr) {
        if (mid > 0L && arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivMouseID == mid) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isMatingCage() {
        if (ProcessDefinition.isClient()) {
            return this.ivIsWeddingCage;
        }
        if (ProcessDefinition.isServer()) {
            Vector v = new Vector();
            this.addActualMice(v);
            if (!v.isEmpty()) {
                boolean male = false;
                boolean female = false;
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    if (!mouse.isPossMatingPartner()) continue;
                    int sex = mouse.getSex();
                    if (sex == 1) {
                        male = true;
                    } else if (sex == 2) {
                        female = true;
                    }
                    if (!male || !female) continue;
                    return true;
                }
            }
            v.clear();
            Object var1_1 = null;
        }
        return false;
    }

    public Color[] getColor() {
        return this.getColor(DefaultManager.getCageDisplayMode());
    }

    public Color[] getColor(int overrideModus) {
        return this.getColor(overrideModus, overrideModus == -1);
    }

    public Color[] getColor(int modus, boolean useMasking) {
        if (modus == -1) {
            modus = DefaultManager.getCageDisplayMode();
        }
        if (modus == DefaultManager.getCageDisplayMode()) {
            return useMasking && this.ivActColorMatt != null ? this.ivActColorMatt : this.ivActColor;
        }
        Color[] res = CageColorManager.prepareColor(modus, this, this.getActualMice(), null);
        return res != null && useMasking && DefaultManager.getMaskCagesMode() == 3 ? Cage.mattiereFarben(res) : res;
    }

    public void prepareColorsForMode(int modus, boolean itsMine, Vector cageMice, HashMap merker) {
        this.ivActColorMatt = null;
        if (cageMice != null && !cageMice.isEmpty() || CageColorManager.showsColorForEmptyCages(modus)) {
            this.ivActColor = CageColorManager.prepareColor(modus, this, cageMice, merker);
            if (!itsMine && CageColorManager.needsMattColor(DefaultManager.getMaskCagesMode())) {
                this.ivActColorMatt = Cage.mattiereFarben(this.ivActColor);
            }
        } else {
            this.ivActColor = null;
        }
    }

    public static Color[] mattiereFarben(Color[] ccol) {
        if (ccol == null) {
            return null;
        }
        Color[] mattCols = new Color[ccol.length];
        int i = 0;
        while (i < ccol.length) {
            if (ccol[i] != null) {
                mattCols[i] = ccol[i] == CageColorManager.NULL_COLOR ? ccol[i] : ColorManager.getMatt(ccol[i]);
            }
            ++i;
        }
        return mattCols;
    }

    public String getTypeSTring() {
        Vector mice = this.getActualMice();
        if (mice.isEmpty()) {
            return null;
        }
        Hashtable<Long, String> myLines = new Hashtable<Long, String>();
        Hashtable<Object, String> myStrains = new Hashtable<Object, String>();
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse m = (Mouse)iter.next();
            Line line = m.getLine();
            if (line != null) {
                myLines.put(new Long(line.getID()), line.getBrowseName());
            }
            Vector strains = m.getStrains();
            Iterator iterator = strains.iterator();
            while (iterator.hasNext()) {
                Strain strain = (Strain)iterator.next();
                myStrains.put(strain.get("IDO_ID"), strain.getString("STR_NAME"));
            }
        }
        StringBuffer msb = new StringBuffer();
        Enumeration en = myLines.elements();
        while (en.hasMoreElements()) {
            msb.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            msb.append(", ");
        }
        msb.append(" // ");
        en = myStrains.elements();
        while (en.hasMoreElements()) {
            msb.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            msb.append(", ");
        }
        return msb.toString();
    }

    public boolean hasUntaggedMice(boolean withBreeder, Vector cageMice) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            if (mouse.get("MOS_EARTAG") != null || !withBreeder && mouse.isBreeder()) continue;
            return true;
        }
        return false;
    }

    public String getSpecialIndex() {
        String cti = this.getString(CAGETALKER_ID, null);
        return cti != null ? Base64Manager.encodeBase64(cti) : "";
    }

    public Object getSpecialIndexObject() {
        return this.get(CAGETALKER_ID);
    }

    public static Object getObjectForIndex(String index) {
        return index != null && index.length() != 0 ? Base64Manager.getDecodedString(index) : null;
    }

    public boolean isCageInRoomOrTransfer(long roomID) {
        if (this.get(SUPERCAGE) != null) {
            Cage sc = this.getSuperCageIfThere();
            if (sc != null) {
                return sc.isCageInRoomOrTransfer(roomID);
            }
            return false;
        }
        long crID = this.getLong(ROOM, -1L);
        if (crID != -1L) {
            return crID == roomID;
        }
        if (this.get(POSITION) == null) {
            return true;
        }
        Rack rack = this.getRack();
        if (rack != null) {
            long rrid = rack.getLong("RCK_ROOM", -1L);
            return rrid == 0L || rrid == roomID;
        }
        return false;
    }
}

