/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.mouse.Mouse;

public class AgeColor
extends MixColorMode {
    public static final int MODE_ALLES = 1;
    public static final int MODE_MAXIMUM = 2;
    public static final int MODE_DURCHSCHNITT = 3;
    private static final int NIX_WERT = Integer.MIN_VALUE;
    private static final Color NIX_COL = CageColorManager.UNDEFINED_COLOR;
    private static final Color[] NIX_ARR = new Color[]{NIX_COL};
    private static final Color COL_2_W = ColorManager.getColorFromString("lightsteelblue");
    private static final Color COL_1_M = ColorManager.getColorFromString("lightcyan");
    private static final Color COL_2_M = ColorManager.getColorFromString("lightgreen");
    private static final Color COL_3_M = Color.green;
    private static final Color COL_6_M = Color.yellow;
    private static final Color COL_1_Y = Color.orange;
    private static final Color COL_18_M = Color.red;
    private static final Color COL_2_Y = ColorManager.getColorFromString("darkred");
    private static final Color COL_P2_Y = Color.black;
    private static final Color[] COLORS = new Color[]{COL_2_W, COL_1_M, COL_2_M, COL_3_M, COL_6_M, COL_1_Y, COL_18_M, COL_2_Y, COL_P2_Y};
    private static final int[] VALUES = new int[]{14, 30, 60, 90, 182, 365, 540, 730};
    private static final Color[] TT_COLORS = new Color[]{CageColorManager.UNDEFINED_COLOR, COL_2_W, COL_1_M, COL_2_M, COL_3_M, COL_6_M, COL_1_Y, COL_18_M, COL_2_Y, COL_P2_Y};
    private static final String[] TT_STRINGS = new String[]{Babel.get("UNDEFINED"), "<= 2 " + Babel.get("WEEKS"), "1 " + Babel.get("MONTH"), "2 " + Babel.get("MONTHS"), "3 " + Babel.get("MONTHS"), "6 " + Babel.get("MONTHS"), "1 " + Babel.get("YEAR"), "18 " + Babel.get("MONTHS"), "2 " + Babel.get("YEARS"), "> 2 " + Babel.get("YEARS")};
    public static final AgeColor INSTANCE_ALLES = new AgeColor(1);
    public static final AgeColor INSTANCE_MAXIMUM = new AgeColor(2);
    public static final AgeColor INSTANCE_DURCHSCHNITT = new AgeColor(3);
    private final int ivModus;

    public static final Color getAgeColor(int days) {
        return AgeColor.getColor(days, VALUES, COLORS);
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return TT_STRINGS;
    }

    public static final Color getAgeColor(Mouse m) {
        int d = Integer.MIN_VALUE;
        Date bd = m.getDate("MOS_BIRTHDAY");
        if (bd != null) {
            d = MyDate.HEUTE - MyDate.getTage(bd.getTime());
        }
        return AgeColor.getColor(d, VALUES, COLORS);
    }

    public AgeColor(int modus) {
        this.ivModus = modus;
    }

    public String getInnerTooltip() {
        return AgeColor.createHTML(TT_COLORS, TT_STRINGS, false, 5);
    }

    public Color[] getColors() {
        return COLORS;
    }

    public int[] getValues() {
        return VALUES;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        if (cage.getNumberOfMice() != 0) {
            TreeMap dayCounts = new TreeMap();
            this.fillValues(cage, dayCounts, cageMice);
            if (this.ivModus == 1) {
                Color[] erg = new Color[dayCounts.size()];
                int i = 0;
                Iterator iter = dayCounts.keySet().iterator();
                while (iter.hasNext()) {
                    Integer dayKey = (Integer)iter.next();
                    int day = dayKey;
                    erg[i++] = day == Integer.MIN_VALUE ? NIX_COL : this.getColor(day);
                }
                return erg;
            }
            if (this.ivModus == 3) {
                int avg = 0;
                int anz = 0;
                if (!dayCounts.isEmpty()) {
                    Iterator iter = dayCounts.keySet().iterator();
                    while (iter.hasNext()) {
                        Integer dayKey = (Integer)iter.next();
                        int day = dayKey;
                        if (day == Integer.MIN_VALUE) continue;
                        int azew = (Integer)dayCounts.get(dayKey);
                        avg += day * azew;
                        anz += azew;
                    }
                }
                if (anz == 0) {
                    return NIX_ARR;
                }
                return new Color[]{this.getColor(avg / anz)};
            }
            if (this.ivModus == 2) {
                int max = Integer.MIN_VALUE;
                if (!dayCounts.isEmpty()) {
                    max = (Integer)dayCounts.lastKey();
                }
                if (max == Integer.MIN_VALUE) {
                    return NIX_ARR;
                }
                return new Color[]{this.getColor(max)};
            }
        }
        return null;
    }

    public int getValue(Cage cage, Vector cageMice) {
        return 0;
    }

    public void fillValues(Cage cage, TreeMap dayCounts, Vector cageMice) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Integer key;
            Integer dc;
            Mouse mouse = (Mouse)iter.next();
            int d = Integer.MIN_VALUE;
            Date bd = mouse.getDate("MOS_BIRTHDAY");
            if (bd != null) {
                d = MyDate.HEUTE - MyDate.getTage(bd.getTime());
            }
            if ((dc = (Integer)dayCounts.get(key = new Integer(d))) == null) {
                dayCounts.put(key, new Integer(1));
                continue;
            }
            dayCounts.put(key, new Integer(dc + 1));
        }
    }
}

