/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.ColorManager;

public abstract class ColorMode {
    public int ivModeInt;
    public String[] ivBabelisierteTooltips;

    public abstract boolean hasVaryingColorColorCodes();

    public abstract Color[] getCageColor(Cage var1, HashMap var2, Vector var3, HashMap var4);

    public abstract Color[] getColorsForDefaultLegend();

    public abstract String[] getStringsForDefaultLegend();

    public String getTooltip() {
        StringBuffer msb = new StringBuffer("<HTML><body marginwidth=\"5\" marginheight=\"5\">");
        msb.append(this.getInnerTooltip());
        msb.append("</body>");
        return msb.toString();
    }

    public String[] getBabelisierteTooltips(String[] babelArray) {
        if (this.ivBabelisierteTooltips == null) {
            this.ivBabelisierteTooltips = new String[babelArray.length];
            int i = 0;
            while (i < babelArray.length) {
                this.ivBabelisierteTooltips[i] = Babel.get(babelArray[i]);
                ++i;
            }
        }
        return this.ivBabelisierteTooltips;
    }

    public String getInnerTooltip() {
        return "";
    }

    public boolean showColorsForEmptyCage() {
        return false;
    }

    public static void manageLegend(Color col, String legend, HashMap legendsByColor) {
        if (col != null && legendsByColor != null) {
            Vector<String> v = (Vector<String>)legendsByColor.get(col);
            if (v == null) {
                v = new Vector<String>();
                legendsByColor.put(col, v);
                v.add(legend);
            } else if (!v.contains(legend)) {
                v.add(legend);
            }
        }
    }

    public static String createHTML(Color[] carr, String[] sarr, boolean mitBabel, int maxLines) {
        if (carr != null && sarr != null && carr.length != 0 && carr.length == sarr.length) {
            StringBuffer msb = new StringBuffer();
            msb.append("<table border=\"1\">\n");
            if (maxLines == 0) {
                int i = 0;
                while (i < carr.length) {
                    msb.append(" <tr>\n");
                    if (carr[i] == null) {
                        if (mitBabel) {
                            msb.append("  <td colspan=\"2\">&nbsp;").append(Babel.get(sarr[i])).append("&nbsp;</td>\n");
                        } else {
                            msb.append("  <td colspan=\"2\">&nbsp;").append(sarr[i]).append("&nbsp;</td>\n");
                        }
                    } else {
                        msb.append("  <td bgcolor=\"").append(ColorManager.getHTMLColorString(carr[i])).append("\">&nbsp;&nbsp;&nbsp;&nbsp;</td>\n");
                        if (mitBabel) {
                            msb.append("  <td>&nbsp;").append(Babel.get(sarr[i])).append("&nbsp;</td>\n");
                        } else {
                            msb.append("  <td>&nbsp;").append(sarr[i]).append("&nbsp;</td>\n");
                        }
                    }
                    msb.append(" </tr>\n");
                    ++i;
                }
            } else {
                int cols = carr.length / maxLines;
                if (carr.length % maxLines != 0) {
                    ++cols;
                }
                int offs = 0;
                while (offs < maxLines) {
                    msb.append(" <tr>\n");
                    int col = 0;
                    while (col < cols) {
                        int pos = offs + col * maxLines;
                        if (pos < carr.length) {
                            msb.append("  <td bgcolor=\"").append(ColorManager.getHTMLColorString(carr[pos])).append("\">&nbsp;&nbsp;&nbsp;&nbsp;</td>\n");
                            if (mitBabel) {
                                msb.append("  <td>&nbsp;").append(Babel.get(sarr[pos])).append("&nbsp;</td>\n");
                            } else {
                                msb.append("  <td>&nbsp;").append(sarr[pos]).append("&nbsp;</td>\n");
                            }
                        } else {
                            msb.append("  <td>&nbsp;</td>\n");
                            msb.append("  <td>&nbsp;</td>\n");
                        }
                        ++col;
                    }
                    msb.append(" </tr>\n");
                    ++offs;
                }
            }
            msb.append("</table>\n");
            return msb.toString();
        }
        return "";
    }
}

