/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.ColorMode;
import mausoleum.cage.colors.GroupColorManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;

public class GroupColor
extends ColorMode {
    public static final GroupColor INSTANCE = new GroupColor();
    private static final Color NO_GROUP = Color.lightGray;
    private Vector ivSortedGroupNames = null;
    private Color[] ivTTColors = null;
    private String[] ivTTNames = null;

    public static void fetchGroupnames() {
        if (ProcessDefinition.isServer() && DataLayer.cvDataLayer != null) {
            GroupColor.INSTANCE.ivSortedGroupNames = DataLayer.cvDataLayer.getSortedGroupNames(true);
            GroupColor.INSTANCE.ivSortedGroupNames.remove("service");
            GroupColorManager.init(GroupColor.INSTANCE.ivSortedGroupNames);
        }
    }

    public static void setGroupNames(Vector groupnames) {
        if (ProcessDefinition.isClient()) {
            GroupColor.INSTANCE.ivSortedGroupNames = new Vector();
            GroupColor.INSTANCE.ivSortedGroupNames.addAll(groupnames);
        }
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        Color col = NO_GROUP;
        if (ProcessDefinition.isServer()) {
            String group;
            if (this.ivSortedGroupNames == null) {
                GroupColor.fetchGroupnames();
            }
            if ((group = cage.getGroup()) != null) {
                int i = 0;
                while (i < this.ivSortedGroupNames.size()) {
                    if (group.equals(this.ivSortedGroupNames.elementAt(i))) {
                        col = GroupColorManager.getColor(group, i, this.ivSortedGroupNames.size());
                        if (col == null) {
                            col = NO_GROUP;
                        } else {
                            GroupColor.manageLegend(col, group, legendByColor);
                        }
                        break;
                    }
                    ++i;
                }
            }
        } else {
            col = GroupColorManager.getColor(cage.getGroup());
            if (col == null) {
                col = NO_GROUP;
            }
        }
        return new Color[]{col};
    }

    public boolean hasVaryingColorColorCodes() {
        return true;
    }

    public Color[] getColorsForDefaultLegend() {
        if (this.ivTTColors == null && this.ivSortedGroupNames != null) {
            if (MausoleumClient.isRegularOrTGService()) {
                Color c = GroupColorManager.getColor(UserManager.getFirstGroup());
                if (c == null) {
                    c = NO_GROUP;
                }
                this.ivTTColors = new Color[]{c};
            } else if (MausoleumClient.isServiceCaretaker()) {
                this.ivTTColors = new Color[this.ivSortedGroupNames.size()];
                int i = 0;
                while (i < this.ivSortedGroupNames.size()) {
                    Color c = GroupColorManager.getColor((String)this.ivSortedGroupNames.elementAt(i));
                    if (c == null) {
                        c = NO_GROUP;
                    }
                    this.ivTTColors[i] = c;
                    ++i;
                }
            }
        }
        return this.ivTTColors;
    }

    public String[] getStringsForDefaultLegend() {
        if (this.ivTTNames == null && this.ivSortedGroupNames != null) {
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivTTNames = new String[]{UserManager.getFirstGroup()};
            } else if (MausoleumClient.isServiceCaretaker()) {
                this.ivTTNames = new String[this.ivSortedGroupNames.size()];
                int i = 0;
                while (i < this.ivSortedGroupNames.size()) {
                    this.ivTTNames[i] = (String)this.ivSortedGroupNames.elementAt(i);
                    ++i;
                }
            }
        }
        return this.ivTTNames;
    }

    public String getInnerTooltip() {
        return Babel.get("TT_CC_GROUPS");
    }

    public boolean showColorsForEmptyCage() {
        return true;
    }
}

