/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.colors.GroupColor;
import mausoleum.gui.MusterColor;
import mausoleum.helper.ObjectTransporter;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.requester.rack.RackServiceDisplayFrame;
import mausoleum.util.PathStore;

public class GroupColorManager {
    private static final Color[] COLORS = new Color[]{new Color(250, 220, 220), new Color(220, 250, 220), new Color(220, 220, 250), new Color(240, 240, 220), new Color(240, 220, 240), new Color(220, 240, 240), new Color(240, 230, 230), new Color(255, 255, 153)};
    private static final HashMap COLORS_BY_INDPOINT = new HashMap();
    private static final HashMap COLORS_BY_GROUPNAME = new HashMap();
    private static final Vector GROUP_NAMES = new Vector();
    static /* synthetic */ Class class$0;

    public static void init(Vector groupnames) {
        GroupColorManager.initDefinedColors(ProcessDefinition.isServer() ? FileManager.getStringFromFile(PathStore.getGroupColorsPath()) : FileManager.getStringContentFromServer(PathStore.getGroupColorsPath()));
        GROUP_NAMES.clear();
        if (groupnames != null) {
            GROUP_NAMES.addAll(groupnames);
            GroupColor.setGroupNames(groupnames);
        }
    }

    public static void groupColorsChange(String transport) {
        if (ProcessDefinition.isServer()) {
            if (transport != null) {
                if (new File(PathStore.getGroupColorsDir()).exists()) {
                    FileManager.saveStringToFile(PathStore.getGroupColorsPath(), transport);
                }
            } else {
                FileManager.deleteFile(PathStore.getGroupColorsPath());
            }
            GroupColorManager.initDefinedColors(transport);
        }
    }

    public static void setColor(String groupName, Color col) {
        if (ProcessDefinition.isClient() && MausoleumClient.isHeadOfService()) {
            if (col != null) {
                COLORS_BY_GROUPNAME.put(groupName, col);
            } else {
                COLORS_BY_GROUPNAME.remove(groupName);
            }
            RequestManager.createSendAndGetAnswer((byte)60, ObjectTransporter.getTransport(COLORS_BY_GROUPNAME, false), "service");
            RackServiceDisplayFrame.groupColorsChanged();
        }
    }

    public static void initDefinedColors(String s) {
        COLORS_BY_GROUPNAME.clear();
        if (s != null && s.trim().length() != 0) {
            try {
                HashMap hm = (HashMap)ObjectTransporter.getObject(s, false);
                if (hm != null) {
                    Iterator iter = hm.keySet().iterator();
                    while (iter.hasNext()) {
                        String groupname = (String)iter.next();
                        COLORS_BY_GROUPNAME.put(groupname, hm.get(groupname));
                    }
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.cage.colors.GroupColorManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem initialising group colors", e, clazz);
            }
        }
    }

    public static Color getColor(String groupName) {
        if (groupName != null) {
            return GroupColorManager.getColor(groupName, GROUP_NAMES.indexOf(groupName), GROUP_NAMES.size());
        }
        return null;
    }

    public static Color getColor(String groupName, int ind, int groupSize) {
        Color col;
        if (groupName != null && (col = (Color)COLORS_BY_GROUPNAME.get(groupName)) != null) {
            return col;
        }
        Point key = new Point(ind, groupSize);
        Color c = (Color)COLORS_BY_INDPOINT.get(key);
        if (c == null) {
            if (ind >= groupSize) {
                c = Color.white;
            } else if (ind < COLORS.length) {
                c = COLORS[ind];
            } else {
                int musterModus = ind / COLORS.length;
                c = new MusterColor(COLORS[ind % COLORS.length], Color.white, musterModus);
            }
            COLORS_BY_INDPOINT.put(key, c);
        }
        return c;
    }
}

