/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MultiColorMode;
import mausoleum.cage.colors.StrainColor;
import mausoleum.gui.PralineColor;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.ui.UIDef;

public class LineStrainColor
extends MultiColorMode {
    public static final LineStrainColor INSTANCE = new LineStrainColor();

    public String getInnerTooltip() {
        return Babel.get("TT_CC_LINESTRAIN");
    }

    public void fillColors(Cage cage, HashSet colors, HashMap legendsByColor, Vector cageMice, HashMap merker) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            LineStrainColor.addColorForMouse((Mouse)iter.next(), colors, legendsByColor);
        }
    }

    private static void addColorForMouse(Mouse m, HashSet colors, HashMap legendsByColor) {
        Color c = null;
        if (m != null) {
            Line ll = m.getLine();
            if (ll == null) {
                c = CageColorManager.NULL_COLOR;
            } else if (ll.isBreeder()) {
                Color strainColor = StrainColor.INSTANCE.getColorForMouse(m, legendsByColor);
                if (strainColor == null) {
                    strainColor = CageColorManager.NULL_COLOR;
                }
                c = new PralineColor(strainColor, Line.BREEDER_COLOR);
            } else {
                c = (Color)ll.get("LIN_COLOR", UIDef.OBJECT_DEFAULT_COLOR);
                LineStrainColor.manageLegend(c, ll.getBrowseName(), legendsByColor);
            }
        }
        if (c != null) {
            colors.add(c);
        }
    }

    public boolean hasVaryingColorColorCodes() {
        return true;
    }

    public Color[] getColorsForDefaultLegend() {
        return null;
    }

    public String[] getStringsForDefaultLegend() {
        return null;
    }
}

