/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.mouse.Mouse;

public class MarkColor
extends ColorMode {
    private static final Color NO_MARK = CageColorManager.UNDEFINED_COLOR;
    private static final Color STANDARD = ColorManager.getColorFromString("red");
    private static final Color A = ColorManager.getColorFromString("greenyellow");
    private static final Color B = ColorManager.getColorFromString("navajowhite");
    private static final Color C = ColorManager.getColorFromString("chocolate");
    private static final Color D = ColorManager.getColorFromString("lightpink");
    private static final Color E = ColorManager.getColorFromString("chartreuse");
    private static final Color F = ColorManager.getColorFromString("aqua");
    private static final Color G = ColorManager.getColorFromString("skyblue");
    private static final Color H = ColorManager.getColorFromString("mediumseagreen");
    private static final Color I = ColorManager.getColorFromString("gold");
    private static final Color J = ColorManager.getColorFromString("sandybrown");
    private static final Color K = ColorManager.getColorFromString("khaki");
    private static final Color L = ColorManager.getColorFromString("aquamarine");
    private static final Color M = ColorManager.getColorFromString("paleturquoise");
    private static final Color N = ColorManager.getColorFromString("rosybrown");
    private static final Color O = ColorManager.getColorFromString("coral");
    private static final Color P = ColorManager.getColorFromString("orchid");
    private static final Color Q = ColorManager.getColorFromString("lawngreen");
    private static final Color R = ColorManager.getColorFromString("aqua");
    private static final Color S = ColorManager.getColorFromString("burlywood");
    private static final Color T = ColorManager.getColorFromString("thistle");
    private static final Color U = ColorManager.getColorFromString("seashell");
    private static final Color V = ColorManager.getColorFromString("tan");
    private static final Color W = ColorManager.getColorFromString("peachpuff");
    private static final Color X = ColorManager.getColorFromString("pink");
    private static final Color Y = ColorManager.getColorFromString("forestgreen");
    private static final Color Z = ColorManager.getColorFromString("lavender");
    private static final Color[] TT_COLORS = new Color[]{NO_MARK, STANDARD, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z};
    private static final String[] TT_BABELISIERT = new String[]{Babel.get("NOMARK"), Babel.get("STANDARD"), "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static HashMap cvColorsByChar = new HashMap();
    private final boolean ivCageMark;
    public static final MarkColor INSTANCE_CAGES;
    public static final MarkColor INSTANCE_MICE;

    static {
        cvColorsByChar.put(new Character('\u0001'), STANDARD);
        cvColorsByChar.put(new Character('A'), A);
        cvColorsByChar.put(new Character('B'), B);
        cvColorsByChar.put(new Character('C'), C);
        cvColorsByChar.put(new Character('D'), D);
        cvColorsByChar.put(new Character('E'), E);
        cvColorsByChar.put(new Character('F'), F);
        cvColorsByChar.put(new Character('G'), G);
        cvColorsByChar.put(new Character('H'), H);
        cvColorsByChar.put(new Character('I'), I);
        cvColorsByChar.put(new Character('J'), J);
        cvColorsByChar.put(new Character('K'), K);
        cvColorsByChar.put(new Character('L'), L);
        cvColorsByChar.put(new Character('M'), M);
        cvColorsByChar.put(new Character('N'), N);
        cvColorsByChar.put(new Character('O'), O);
        cvColorsByChar.put(new Character('P'), P);
        cvColorsByChar.put(new Character('Q'), Q);
        cvColorsByChar.put(new Character('R'), R);
        cvColorsByChar.put(new Character('S'), S);
        cvColorsByChar.put(new Character('T'), T);
        cvColorsByChar.put(new Character('U'), U);
        cvColorsByChar.put(new Character('V'), V);
        cvColorsByChar.put(new Character('W'), W);
        cvColorsByChar.put(new Character('X'), X);
        cvColorsByChar.put(new Character('Y'), Y);
        cvColorsByChar.put(new Character('Z'), Z);
        INSTANCE_CAGES = new MarkColor(true);
        INSTANCE_MICE = new MarkColor(false);
    }

    public MarkColor(boolean cageMark) {
        this.ivCageMark = cageMark;
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return TT_BABELISIERT;
    }

    public String getInnerTooltip() {
        return MarkColor.createHTML(TT_COLORS, TT_BABELISIERT, false, 7);
    }

    public boolean showColorsForEmptyCage() {
        return true;
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        if (this.ivCageMark) {
            Color c;
            Color res = CageColorManager.UNDEFINED_COLOR;
            Character mark = (Character)cage.get("CAG_FLAG");
            if (mark != null && (c = (Color)cvColorsByChar.get(mark)) != null) {
                res = c;
            }
            return new Color[]{res};
        }
        Vector v = cageMice;
        if (v != null && !v.isEmpty()) {
            HashSet<Color> colors = new HashSet<Color>();
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Color c;
                Mouse mouse = (Mouse)iter.next();
                Color res = CageColorManager.UNDEFINED_COLOR;
                Character mark = (Character)mouse.get("MOS_FLAG");
                if (mark != null && (c = (Color)cvColorsByChar.get(mark)) != null) {
                    res = c;
                }
                colors.add(res);
            }
            if (!colors.isEmpty()) {
                Color[] res = new Color[colors.size()];
                int pos = 0;
                Iterator iter2 = colors.iterator();
                while (iter2.hasNext()) {
                    res[pos++] = (Color)iter2.next();
                }
                return res;
            }
        }
        return null;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }
}

