/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;

public class MatingColor
extends ColorMode {
    public static final MatingColor INSTANCE = new MatingColor();
    private static final Color NO_MATING = CageColorManager.UNDEFINED_COLOR;
    private static final Color MATING = Color.red;
    private static final Color MATING_WITH_MISSING_GT = ColorManager.getColorFromString("indianred");
    private static final Color STERILE_MATING = ColorManager.getColorFromString("yellow");
    private static final Color[] NO_MATING_ARR = new Color[]{NO_MATING};
    private static final Color[] MATING_ARR = new Color[]{MATING};
    private static final Color[] MATING_WITH_MISSING_GT_ARR = new Color[]{MATING_WITH_MISSING_GT};
    private static final Color[] STERILE_MATING_ARR = new Color[]{STERILE_MATING};
    private static final Color[] TT_COLORS = new Color[]{NO_MATING, MATING, MATING_WITH_MISSING_GT, STERILE_MATING};
    private static final String[] TT_STRINGS = new String[]{"TT_CC_NO_MATING", "TT_CC_MATING", "TT_CC_MATING_WITH_MISSING_GT", "TT_CC_STERILE_MATING"};
    private CageMatingInfo ivInfo = new CageMatingInfo();

    public String getInnerTooltip() {
        return MatingColor.createHTML(TT_COLORS, TT_STRINGS, true, 0);
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return this.getBabelisierteTooltips(TT_STRINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        CageMatingInfo cageMatingInfo = this.ivInfo;
        synchronized (cageMatingInfo) {
            this.ivInfo.fill(cage);
            if (this.ivInfo.ivMating) {
                if (this.ivInfo.ivSterileMating) {
                    return STERILE_MATING_ARR;
                }
                if (this.ivInfo.ivMatingWithMissing) {
                    return MATING_WITH_MISSING_GT_ARR;
                }
                return MATING_ARR;
            }
            return NO_MATING_ARR;
        }
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }

    public static class CageMatingInfo {
        public boolean ivMating;
        public boolean ivMatingWithMissing;
        public boolean ivSterileMating;
        public final Vector ivMice = new Vector();

        public void fill(Cage cage) {
            this.ivMating = false;
            this.ivMatingWithMissing = false;
            this.ivSterileMating = false;
            if (ProcessDefinition.isClient()) {
                this.ivMating = cage.ivIsWeddingCage;
                this.ivMatingWithMissing = cage.ivIsWeddingCageWithMissingGenotypes;
                this.ivSterileMating = cage.ivIsSterileWeddingCage;
            } else {
                this.ivMice.clear();
                cage.addActualMice(this.ivMice);
                if (!this.ivMice.isEmpty()) {
                    boolean maleDa = false;
                    boolean femaleDa = false;
                    boolean nonFertileDa = false;
                    Iterator iterator = this.ivMice.iterator();
                    while (iterator.hasNext()) {
                        Mouse mouse = (Mouse)iterator.next();
                        if (!mouse.isSexActive()) continue;
                        nonFertileDa |= mouse.isNonFertile();
                        switch (mouse.getSex()) {
                            case 1: {
                                maleDa = true;
                                break;
                            }
                            case 2: {
                                femaleDa = true;
                                break;
                            }
                        }
                    }
                    this.ivMating = maleDa && femaleDa;
                    this.ivMatingWithMissing = false;
                    this.ivSterileMating = this.ivMating && nonFertileDa;
                }
            }
        }
    }
}

