/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.mouse.Mouse;

public class PregnantColor
extends ColorMode {
    public static final PregnantColor INSTANCE = new PregnantColor();
    private static final Color NO_PREGNANCY = CageColorManager.UNDEFINED_COLOR;
    private static final Color PREGNANT = ColorManager.getColorFromString("crimson");
    private static final Color PLUG = ColorManager.getColorFromString("greenyellow");
    private static final Color[] TT_COLORS = new Color[]{PREGNANT, PLUG, NO_PREGNANCY};
    private static final String[] TT_STRINGS = new String[]{"TT_CC_PREGNANT", "TT_CC_PLUG", "TT_CC_NO_PREGNANCY"};

    public static Color getColor(Mouse mouse) {
        if (mouse.getSex() == 2) {
            if (mouse.get("MOS_PREGNANT") != null) {
                return PREGNANT;
            }
            if (mouse.get("MOS_PLUGDATE") != null) {
                return PLUG;
            }
        }
        return NO_PREGNANCY;
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return this.getBabelisierteTooltips(TT_STRINGS);
    }

    public String getInnerTooltip() {
        return PregnantColor.createHTML(TT_COLORS, TT_STRINGS, true, 0);
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        Color[] res = null;
        HashSet<Color> colHT = new HashSet<Color>();
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            colHT.add(PregnantColor.getColor(mouse));
        }
        if (colHT.size() != 0) {
            res = new Color[colHT.size()];
            int pos = 0;
            int i = 0;
            while (i < TT_COLORS.length) {
                if (colHT.contains(TT_COLORS[i])) {
                    res[pos++] = TT_COLORS[i];
                }
                ++i;
            }
        }
        return res;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }
}

