/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.ui.UIDef;

public class TaskColor
extends ColorMode {
    public static final Color STANDARD_TASK_TRIANGLE_COLOR = new Color(200, 200, 200);
    public static final Color NONSTANDARD_TASK_TRIANGLE_COLOR = new Color(120, 90, 120);
    private static final Color GREEN = ColorManager.getColorFromString("greenyellow");
    private static final Color YELLOW = Color.yellow;
    private static final Color RED = ColorManager.getColorFromString("crimson");
    private static final Color WHITE = ColorManager.getColorFromString("ivory");
    private static final Color UNDEFINED_COLOR = Color.lightGray;
    private static final Color[] TASK_DAYS_BACKGROUNDS = new Color[]{RED, YELLOW, YELLOW, GREEN, GREEN, GREEN, Color.black, WHITE};
    public static final Color[] TASK_DAYS_SCHEDULE_SPALTEN_BACKGROUNDS = new Color[]{new Color(240, 240, 240), new Color(255, 240, 240), new Color(255, 255, 240), new Color(255, 255, 240), new Color(240, 255, 240), new Color(240, 255, 240), new Color(240, 255, 240), Color.white};
    public static final Color[] TASK_DAYS_SCHEDULE_BOX_BACKGROUNDS = new Color[]{Color.black, RED, YELLOW, YELLOW, GREEN, GREEN, GREEN, WHITE};
    public static final Color[] TASK_DAYS_SCHEDULE_BOX_FOREGROUNDS = new Color[]{Color.white, Color.white, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black};
    public static final Color[] TASK_COUNTER_BACKGROUNDS = new Color[]{Color.black, RED, YELLOW, GREEN, WHITE};
    public static final Color[] TASK_COUNTER_BACKGROUNDS_MATT = new Color[]{ColorManager.getMatt(TASK_COUNTER_BACKGROUNDS[0]), ColorManager.getMatt(TASK_COUNTER_BACKGROUNDS[1]), ColorManager.getMatt(TASK_COUNTER_BACKGROUNDS[2]), ColorManager.getMatt(TASK_COUNTER_BACKGROUNDS[3]), ColorManager.getMatt(TASK_COUNTER_BACKGROUNDS[4])};
    public static final Color[] TASK_COUNTER_BACKGROUNDS_MATT_MIX = new Color[]{ColorManager.mix(UIDef.SELECTED_BACKGROUND, TASK_COUNTER_BACKGROUNDS_MATT[0]), ColorManager.mix(UIDef.SELECTED_BACKGROUND, TASK_COUNTER_BACKGROUNDS_MATT[1]), ColorManager.mix(UIDef.SELECTED_BACKGROUND, TASK_COUNTER_BACKGROUNDS_MATT[2]), ColorManager.mix(UIDef.SELECTED_BACKGROUND, TASK_COUNTER_BACKGROUNDS_MATT[3]), ColorManager.mix(UIDef.SELECTED_BACKGROUND, TASK_COUNTER_BACKGROUNDS_MATT[4])};
    public static final Color[] TASK_COUNTER_FOREGROUNDS = new Color[]{Color.white, Color.white, Color.black, Color.black, Color.black};
    private static final Color[] TASK_DAYS_FOREGROUNDS = new Color[]{Color.white, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, Color.black};
    private static final Color TASK_FINISH_BACKGROUND = UIDef.OLD_BACKGROUND;
    private static final Color[] TT_COLORS = new Color[]{UNDEFINED_COLOR, TASK_FINISH_BACKGROUND, Color.black, RED, YELLOW, GREEN, WHITE};
    private static final String[] TT_STRINGS = new String[]{"TT_CC_NO_TASKS", "TT_CC_FINISHED_TASKS", "TT_CC_PAST_DUE", "TT_CC_DUE_TODAY", "TT_CC_DUE_2_DAYS", "TT_CC_DUE_5_DAYS", "TT_CC_DUE_LATER"};
    private static final Color[] TT_COLORS_ACT = new Color[]{UNDEFINED_COLOR, Color.black, RED, YELLOW, GREEN, WHITE};
    private static final String[] TT_STRINGS_ACT = new String[]{"TT_CC_NO_TASKS", "TT_CC_PAST_DUE", "TT_CC_DUE_TODAY", "TT_CC_DUE_2_DAYS", "TT_CC_DUE_5_DAYS", "TT_CC_DUE_LATER"};
    public static final TaskColor INSTANCE_MIT_FERTIG = new TaskColor(true);
    public static final TaskColor INSTANCE_OHNE_FERTIG = new TaskColor(false);
    private final boolean ivMitFertigen;

    public TaskColor(boolean mitFertigen) {
        this.ivMitFertigen = mitFertigen;
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return this.getBabelisierteTooltips(this.ivMitFertigen ? TT_STRINGS : TT_STRINGS_ACT);
    }

    public String getInnerTooltip() {
        if (this.ivMitFertigen) {
            return TaskColor.createHTML(TT_COLORS, TT_STRINGS, true, 0);
        }
        return TaskColor.createHTML(TT_COLORS_ACT, TT_STRINGS_ACT, true, 0);
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        return TaskColor.getBackgroundsByTaskDays(cage, this.ivMitFertigen, cageMice);
    }

    public static Color getFinishedTaskBackground() {
        return TASK_FINISH_BACKGROUND;
    }

    public static Color getBackgroundByTaskDays(int daysToGo) {
        if (daysToGo > TASK_DAYS_BACKGROUNDS.length - 3) {
            return TASK_DAYS_BACKGROUNDS[TASK_DAYS_BACKGROUNDS.length - 1];
        }
        if (daysToGo < 0) {
            return TASK_DAYS_BACKGROUNDS[TASK_DAYS_BACKGROUNDS.length - 2];
        }
        return TASK_DAYS_BACKGROUNDS[daysToGo];
    }

    public static Color getForeroundByTaskDays(int daysToGo) {
        if (daysToGo > TASK_DAYS_FOREGROUNDS.length - 3) {
            return TASK_DAYS_FOREGROUNDS[TASK_DAYS_FOREGROUNDS.length - 1];
        }
        if (daysToGo < 0) {
            return TASK_DAYS_FOREGROUNDS[TASK_DAYS_FOREGROUNDS.length - 2];
        }
        return TASK_DAYS_FOREGROUNDS[daysToGo];
    }

    private static Color[] getBackgroundsByTaskDays(Cage cage, boolean mitFertigen, Vector cageMice) {
        HashSet<Color> hs = new HashSet<Color>();
        if (cageMice != null) {
            Iterator iter = cageMice.iterator();
            while (iter.hasNext()) {
                Mouse maus = (Mouse)iter.next();
                boolean addedColor = false;
                TaskExtended[] tarr = (TaskExtended[])maus.get(maus.getTaskKey());
                if (tarr != null && tarr.length != 0) {
                    int i = 0;
                    while (i < tarr.length) {
                        if (tarr[i] != null && tarr[i].ivProcType != 0) {
                            if (tarr[i].isFinished()) {
                                if (mitFertigen) {
                                    hs.add(TASK_FINISH_BACKGROUND);
                                    addedColor = true;
                                }
                            } else {
                                hs.add(TaskColor.getBackgroundByTaskDays(tarr[i].getMinimumDays(MyDate.HEUTE)));
                                addedColor = true;
                            }
                        }
                        ++i;
                    }
                }
                if (addedColor) continue;
                hs.add(CageColorManager.UNDEFINED_COLOR);
            }
        }
        if (hs.isEmpty()) {
            return null;
        }
        Color[] erg = new Color[hs.size()];
        int i = 0;
        Iterator iter = hs.iterator();
        while (iter.hasNext()) {
            erg[i++] = (Color)iter.next();
        }
        return erg;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }
}

