/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.util.ArrayHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import jxl.Sheet;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;

public class DISMouse
implements DISheetImporter {
    private static final String NAME = "mice";
    private static final String TAG_ID = "FOREIGN_ID";
    private static final String TAG_EARTAG = "EARTAG";
    private static final String TAG_EARTAG_PREFIX = "EARTAG_PREFIX";
    private static final String TAG_SEX = "SEX";
    private static final String TAG_FATHER = "FATHER";
    private static final String TAG_MOTHER = "MOTHER";
    private static final String TAG_START_DATE = "START_DATE";
    private static final String TAG_START_MODE = "START_MODE";
    private static final String TAG_END_DATE = "END_DATE";
    private static final String TAG_END_MODE = "END_MODE";
    private static final String TAG_COAT_COLOR = "COAT_COLOR";
    private static final String TAG_STRAIN = "STRAIN";
    private static final String TAG_LINE = "LINE";
    private static final String TAG_GENOTYPE = "GENOTYPE";
    private static final String TAG_OWNERS = "OWNERS";
    private static final String TAG_GENERATION = "GENERATION";
    private static final String TAG_COMMENT = "COMMENT";
    private static final String TAG_ANTAG = "ANTAG";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "EARTAG", "EARTAG_PREFIX", "SEX", "FATHER", "MOTHER", "START_DATE", "START_MODE", "END_DATE", "END_MODE", "COAT_COLOR", "STRAIN", "LINE", "GENOTYPE", "OWNERS", "GENERATION", "COMMENT", "ANTAG"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID", "START_DATE", "START_MODE"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY", "COMMENT", "MOS_COMMENT", "ANTAG", "MOS_ANTAG", "EARTAG_PREFIX", "MOS_ETPF"};
    private static final Integer BIRTH = new Integer(1);
    private static Object[] SEX_MODE_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("male", "m", "maennchen", "bock", "mann")), new Integer(2), new HashSet<String>(Arrays.asList("female", "f", "w", "weibchen", "frau"))};
    private static Object[] START_MODE_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("birth", "b", "geburt")), new Integer(3), new HashSet<String>(Arrays.asList("import", "i"))};
    private static Object[] END_MODE_DICT = new Object[]{new Integer(4), new HashSet<String>(Arrays.asList("death", "d", "tod")), new Integer(6), new HashSet<String>(Arrays.asList("export", "x")), new Integer(5), new HashSet<String>(Arrays.asList("sacrifice", "s", "experiment"))};
    private static Object[] COAT_COLOR_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("black", "bl", "schwarz")), new Integer(9), new HashSet<String>(Arrays.asList("agouti", "ag", "a")), new Integer(4), new HashSet<String>(Arrays.asList("brown", "br", "braun")), new Integer(5), new HashSet<String>(Arrays.asList("dark brown", "dbr", "dunkelbraun")), new Integer(8), new HashSet<String>(Arrays.asList("dark gray", "dark grey", "dgr", "dunkelgrau")), new Integer(7), new HashSet<String>(Arrays.asList("gray", "grey", "gr", "grau")), new Integer(3), new HashSet<String>(Arrays.asList("light brown", "lbr", "hellbraun", "hbr")), new Integer(6), new HashSet<String>(Arrays.asList("light gray", "light grey", "lgr", "hellgrau", "hgr")), new Integer(2), new HashSet<String>(Arrays.asList("white", "w", "wei\u00df", "weiss"))};
    private static final Integer MY_TYPE = new Integer(1);
    private static final Integer STRAIN_TYPE = new Integer(8);
    private static final Integer LINE_TYPE = new Integer(7);
    private static final Integer USER_TYPE = new Integer(6);
    private static final Integer LOCUS_TYPE = new Integer(14);
    private Line ivBreederLine = null;

    public DISMouse(Line breederLine) {
        this.ivBreederLine = breederLine;
    }

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        res &= DIHelper.polishToInt(hm, TAG_EARTAG, "MOS_EARTAG", sheet, row, di, null);
        res &= DIHelper.getIntegerFromString(hm, SEX_MODE_DICT, TAG_SEX, Mouse.getSexTag(), sheet, row, di);
        res &= DIHelper.polishToDate(hm, TAG_START_DATE, "IDO_START_DATE", sheet, row, di);
        if (hm.get("IDO_START_DATE") != null && (res &= DIHelper.getIntegerFromString(hm, START_MODE_DICT, TAG_START_MODE, "MOS_STARTMODE", sheet, row, di)) && BIRTH.equals(hm.get("MOS_STARTMODE"))) {
            hm.put("MOS_BIRTHDAY", hm.get("IDO_START_DATE"));
        }
        res &= DIHelper.polishToDate(hm, TAG_END_DATE, "IDO_END_DATE", sheet, row, di);
        if (hm.get("IDO_END_DATE") != null) {
            res &= DIHelper.getIntegerFromString(hm, END_MODE_DICT, TAG_END_MODE, "MOS_ENDMODE", sheet, row, di);
        }
        res &= DIHelper.getIntegerFromString(hm, COAT_COLOR_DICT, TAG_COAT_COLOR, "MOS_COAT_COLOR", sheet, row, di);
        res &= DIHelper.getStrainReference(hm, TAG_STRAIN, "MOS_STRAIN", STRAIN_TYPE, sheet, row, di);
        String lineForeignID = (String)hm.get(TAG_LINE);
        if (lineForeignID != null && lineForeignID.equalsIgnoreCase("breeder")) {
            if (this.ivBreederLine != null) {
                hm.put("MOS_LINEID", new Long(-this.ivBreederLine.getID()));
            }
            hm.remove(TAG_LINE);
            hm.remove(TAG_GENOTYPE);
        } else {
            res &= DIHelper.getSingleObjectsReference(hm, TAG_LINE, "MOS_LINEID", LINE_TYPE, sheet, row, di);
            String s = (String)hm.get(TAG_GENOTYPE);
            if (s != null && lineForeignID != null) {
                HashMap line = di.getObject(LINE_TYPE, lineForeignID);
                if (line != null) {
                    LocusAndAlleles[] lals = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
                    if (lals != null && lals.length != 0) {
                        String locusForeignID;
                        Zeile z = new Zeile(s, '|');
                        HashMap<String, String[]> genotypes = new HashMap<String, String[]>();
                        int i = 0;
                        while (i < z.size()) {
                            String fgt = z.getStringNONEmpty(i, null);
                            if (fgt != null) {
                                Zeile z2 = new Zeile(fgt, ';');
                                if (z2.size() == 3) {
                                    locusForeignID = z2.getStringNONEmpty(0, null);
                                    String allel1 = z2.getStringNONEmpty(1, null);
                                    String allel2 = z2.getStringNONEmpty(2, null);
                                    if (locusForeignID != null && allel1 != null && allel2 != null) {
                                        HashMap locus = di.getObject(LOCUS_TYPE, locusForeignID);
                                        if (locus != null) {
                                            LocusAndAlleles lal = this.findLAL(locus, lals);
                                            if (lal != null) {
                                                if (ArrayHelper.contained(allel1, lal.ivAllele) && ArrayHelper.contained(allel2, lal.ivAllele)) {
                                                    genotypes.put(locusForeignID, new String[]{allel1, allel2});
                                                } else {
                                                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + fgt + "> unknown alleles in genotype definition\r\n");
                                                    res = false;
                                                }
                                            } else {
                                                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + locusForeignID + "> undefined in line <" + lineForeignID + ">\r\n");
                                                res = false;
                                            }
                                        } else {
                                            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + locusForeignID + "> unknown locus in genotype definition\r\n");
                                            res = false;
                                        }
                                    } else {
                                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + fgt + "> malformed genotype definition\r\n");
                                        res = false;
                                    }
                                } else {
                                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + fgt + "> malformed genotype definition\r\n");
                                    res = false;
                                }
                            } else {
                                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + fgt + "> empty genotype definition\r\n");
                                res = false;
                            }
                            ++i;
                        }
                        if (!genotypes.isEmpty()) {
                            LocusAndAlleles[] lalarr = new LocusAndAlleles[genotypes.size()];
                            int pos = 0;
                            Iterator iter = genotypes.keySet().iterator();
                            while (iter.hasNext()) {
                                locusForeignID = (String)iter.next();
                                HashMap locus = di.getObject(LOCUS_TYPE, locusForeignID);
                                String[] allels = (String[])genotypes.get(locusForeignID);
                                lalarr[pos++] = new LocusAndAlleles((long)((Long)locus.get("IDO_ID")), allels);
                            }
                            hm.put("MOS_LOCUSGENOTYPES", lalarr);
                        }
                    } else {
                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " genotype definition <" + s + "> but defined line has no defined loci\r\n");
                        res = false;
                    }
                } else {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " genotype definition without defined lines\r\n");
                    res = false;
                }
            }
            hm.remove(TAG_GENOTYPE);
        }
        res &= DIHelper.getObjectsLongArrayReference(hm, TAG_OWNERS, "MOS_OWNER", USER_TYPE, sheet, row, di);
        return res &= DIHelper.polishToInt(hm, TAG_GENERATION, "MOS_GENMAN", sheet, row, di, null);
    }

    private LocusAndAlleles findLAL(HashMap locus, LocusAndAlleles[] arr) {
        if (locus != null) {
            Long locusID = (Long)locus.get("IDO_ID");
            long lid = locusID;
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivLocusID == lid) {
                    return arr[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean check(DataImporter di) {
        boolean res = true;
        HashMap shm = (HashMap)di.ivObjectMapsByType.get(MY_TYPE);
        if (shm != null) {
            Iterator iter = shm.values().iterator();
            while (iter.hasNext()) {
                HashMap mouse;
                HashMap hm = (HashMap)iter.next();
                String s = (String)hm.get(TAG_FATHER);
                if (s != null) {
                    mouse = (HashMap)shm.get(s);
                    if (mouse != null && !mouse.isEmpty()) {
                        hm.put("MOS_FATHER", mouse.get("IDO_ID"));
                    } else {
                        di.ivBruddel.append("Sheet <mice> Father definition <" + s + "> not found\r\n");
                        res = false;
                    }
                }
                hm.remove(TAG_FATHER);
                s = (String)hm.get(TAG_MOTHER);
                if (s != null) {
                    mouse = (HashMap)shm.get(s);
                    if (mouse != null && !mouse.isEmpty()) {
                        hm.put("MOS_MOTHER", mouse.get("IDO_ID"));
                    } else {
                        di.ivBruddel.append("Sheet <mice> Mother definition <" + s + "> not found\r\n");
                        res = false;
                    }
                }
                hm.remove(TAG_MOTHER);
            }
        }
        return res;
    }
}

