/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import jxl.Sheet;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;

public class DISUser
implements DISheetImporter {
    private static final String NAME = "users";
    private static final String TAG_ID = "FOREIGN_ID";
    private static final String TAG_NAME = "NAME";
    private static final String TAG_PASSWORD = "PASSWORD";
    private static final String TAG_ROLE = "ROLE";
    private static final String TAG_LANGUAGE = "LANGUAGE";
    private static final String TAG_COLOR = "COLOR";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "NAME", "PASSWORD", "ROLE", "LANGUAGE", "COLOR"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID", "NAME", "PASSWORD", "ROLE", "LANGUAGE"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY", "NAME", "USR_NAME"};
    private static final Integer MY_TYPE = new Integer(6);

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        String s = (String)hm.get(TAG_PASSWORD);
        if (s != null) {
            hm.put("USR_PASSWORD", StringHelper.encrypt(s));
        } else {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Missing Password definition\r\n");
            res = false;
        }
        hm.remove(TAG_PASSWORD);
        s = (String)hm.get(TAG_ROLE);
        if (s != null) {
            int status = User.getStatusForString(s.toUpperCase().trim());
            if (status != 0) {
                hm.put("USR_MODE", new Integer(status));
            } else {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Undefined Role definition <" + s + ">\r\n");
                res = false;
            }
        } else {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Missing Role definition\r\n");
            res = false;
        }
        hm.remove(TAG_ROLE);
        s = (String)hm.get(TAG_LANGUAGE);
        if (s != null) {
            if (Babel.AVAILABLE_LANGUAGES_SHORT.contains(s = s.toLowerCase().trim())) {
                hm.put("USR_LANGUAGE", s);
            } else {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Unknown Language definition <" + s + ">\r\n");
                res = false;
            }
        } else {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Missing Language definition\r\n");
            res = false;
        }
        hm.remove(TAG_LANGUAGE);
        return res &= DIHelper.polishToColor(hm, TAG_COLOR, "USR_COLOR", '|', sheet, row, di);
    }

    public boolean check(DataImporter di) {
        return true;
    }
}

