/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import jxl.Sheet;
import jxl.Workbook;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISCage;
import mausoleum.dataimport.DISLine;
import mausoleum.dataimport.DISLocus;
import mausoleum.dataimport.DISMouse;
import mausoleum.dataimport.DISStrain;
import mausoleum.dataimport.DISUser;
import mausoleum.dataimport.DISVisit;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.helper.ObjectTransporter;
import mausoleum.line.Line;

public class DataImporter {
    public final HashMap ivObjectMapsByType;
    public final StringBuffer ivBruddel;
    public final DISheetImporter[] ivImporters;
    protected final Date NOW;
    public boolean ivSuccess;

    public DataImporter(File f, Line breederLine) {
        block8: {
            this.ivObjectMapsByType = new HashMap();
            this.ivBruddel = new StringBuffer();
            this.NOW = new Date();
            this.ivSuccess = true;
            this.ivImporters = this.getImporters(breederLine);
            if (f.exists() && f.isFile()) {
                HashMap<String, Sheet> sheetsByLabel = new HashMap<String, Sheet>(20);
                try {
                    Workbook wb = Workbook.getWorkbook(f);
                    if (wb == null) break block8;
                    Sheet[] sheets = wb.getSheets();
                    int i = 0;
                    while (i < sheets.length) {
                        String sname = sheets[i].getName().toLowerCase().trim();
                        sheetsByLabel.put(sname, sheets[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < this.ivImporters.length) {
                        System.out.println(String.valueOf(this.ivImporters[i].getClass().getName()) + " -> " + this.ivImporters[i].getSheetNames()[0]);
                        this.ivSuccess &= this.handleSheet(sheetsByLabel, this.ivImporters[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < this.ivImporters.length) {
                        this.ivSuccess &= this.ivImporters[i].check(this);
                        ++i;
                    }
                    if (this.ivSuccess) {
                        this.createIDObjects();
                    }
                }
                catch (Exception e) {
                    this.ivBruddel.append("File cannot be analyzed\r\n");
                    this.ivSuccess = false;
                }
            } else {
                this.ivBruddel.append("File is missing\r\n");
                this.ivSuccess = false;
            }
        }
    }

    public DISheetImporter[] getImporters(Line breederLine) {
        return new DISheetImporter[]{new DISLocus(), new DISStrain(), new DISUser(), new DISCage(), new DISLine(), new DISMouse(breederLine), new DISVisit()};
    }

    public void createIDObjects() {
        DISVisit.distributeVisits(this);
        Iterator iter = this.ivObjectMapsByType.keySet().iterator();
        while (iter.hasNext()) {
            Integer objType = (Integer)iter.next();
            HashMap objects = (HashMap)this.ivObjectMapsByType.get(objType);
            Hashtable<Object, IDObject> objectsByOldID = new Hashtable<Object, IDObject>();
            this.ivObjectMapsByType.put(objType, objectsByOldID);
            Iterator iterator = objects.values().iterator();
            while (iterator.hasNext()) {
                HashMap object = (HashMap)iterator.next();
                IDObject ido = IDObject.giveNewObjectOfType(objType);
                ido.setValues(object);
                objectsByOldID.put(ido.get("IDO_ID"), ido);
            }
        }
    }

    public boolean handleSheet(HashMap sheetsByLabel, DISheetImporter dsi) {
        boolean res = true;
        String[] snarr = dsi.getSheetNames();
        int i = 0;
        while (i < snarr.length) {
            Sheet sheet = (Sheet)sheetsByLabel.get(snarr[i]);
            if (sheet != null) {
                int bl = this.ivBruddel.length();
                HashMap cols = DIHelper.firstRowDefs(sheet, dsi.getPossibles(), dsi.getMusts(), this.ivBruddel);
                if (bl == this.ivBruddel.length()) {
                    int row = 1;
                    while (row < sheet.getRows()) {
                        HashMap objectData = DIHelper.collectOneRow(sheet, row, cols, dsi.getMusts(), this.ivBruddel);
                        if (!objectData.isEmpty()) {
                            boolean cont = true;
                            DIHelper.polishHashMap(objectData, dsi.getPolishDict());
                            cont = dsi.ownPolish(objectData, this, sheet, row);
                            if (cont) {
                                objectData.put("IDO_TYPE_ID", dsi.getObjectType());
                                if (!objectData.containsKey("IDO_START_DATE")) {
                                    objectData.put("IDO_START_DATE", this.NOW);
                                }
                                this.enterObject(objectData);
                            } else {
                                res = false;
                            }
                        }
                        ++row;
                    }
                }
            }
            ++i;
        }
        return res;
    }

    public void enterObject(HashMap objectData) {
        Integer type = (Integer)objectData.get("IDO_TYPE_ID");
        String foreignID = (String)objectData.get("IDO_FKEY");
        if (type != null && foreignID != null) {
            HashMap<String, HashMap> hm = (HashMap<String, HashMap>)this.ivObjectMapsByType.get(type);
            if (hm == null) {
                hm = new HashMap<String, HashMap>();
                this.ivObjectMapsByType.put(type, hm);
            }
            if (hm.containsKey(foreignID)) {
                Log.error("Duplicate foreignID " + objectData, null, this);
            } else {
                hm.put(foreignID, objectData);
                objectData.put("IDO_ID", new Long(hm.size()));
            }
        } else {
            Log.error("Malformed objectData " + objectData, null, this);
        }
    }

    public HashMap getObject(Integer type, String foreignID) {
        HashMap hm = (HashMap)this.ivObjectMapsByType.get(type);
        if (hm != null) {
            return (HashMap)hm.get(foreignID);
        }
        return null;
    }

    public String getTransport() {
        return ObjectTransporter.getTransport(this.ivObjectMapsByType, false);
    }
}

