/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.datalayer;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.datalayer.dfa.DFAsc;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.SearchProcess;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.util.InstallationType;

public class DataLayerMausoleumAsc
extends DataLayer {
    static /* synthetic */ Class class$0;

    public DataLayerMausoleumAsc() {
        DFAsc.init(this.getGroups(false));
        Iterator iterator = this.getGroups(false).iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            this.enterFromSafeties(group);
        }
        if (InstallationType.hasNormalMode()) {
            try {
                this.addGroup("service", null);
            }
            catch (Exception e1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.datalayer.DataLayerMausoleum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem creating service group", e1, clazz);
            }
        }
        if (InstallationType.hasTGMode()) {
            try {
                this.addGroup("tgservice", null);
            }
            catch (Exception e1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.datalayer.DataLayerMausoleum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem creating transgenics service group", e1, clazz);
            }
        }
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    DataLayerMausoleumAsc.clearOldBackupFiles(GroupFileManager.getBackupsPath());
                    try {
                        Thread.sleep(43200000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }).start();
    }

    public DataLayerMausoleumAsc(String singleGroup) {
        File f = new File(GroupFileManager.getGroupDir(singleGroup));
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.setSingleGroupName(singleGroup);
        DFAsc.init(this.getGroups(false));
    }

    public boolean addGroup(String groupname, User usi) throws Exception {
        boolean res = false;
        if (groupname != null && !this.getGroups(false).contains(groupname)) {
            String newGroupDir = GroupFileManager.getGroupDir(groupname);
            File of = new File(newGroupDir);
            if (!of.exists()) {
                GroupFileManager.prepareGroupDir(groupname);
                DFAsc.addGroup(groupname);
                res = true;
                if (!groupname.equalsIgnoreCase("service")) {
                    if (groupname.equalsIgnoreCase("tgservice")) {
                        res = this.saveIDObject(Line.getBreederLine(groupname));
                    } else {
                        if (usi != null) {
                            User guru = new User();
                            guru.set("IDO_START_DATE", new Date());
                            guru.setInt("USR_MODE", 42);
                            guru.set("USR_PASSWORD", usi.get("USR_PASSWORD"));
                            guru.set("USR_NAME", usi.get("USR_NAME"));
                            guru.set("IDO_ID", new Long(1L));
                            guru.set("IDO_GROUP", groupname);
                            guru.commit(true);
                            res = this.saveIDObject(guru);
                        }
                        if (res) {
                            res = this.saveIDObject(Line.getBreederLine(groupname));
                        }
                    }
                }
            }
            if (!res) {
                FileManager.deleteDir(newGroupDir, true);
            }
        }
        if (res) {
            this.storeGroupName(groupname);
            GroupFileManager.prepareGroupDir(groupname);
        }
        return res;
    }

    public void initSingleGroupData(String group) {
        DFAsc.addGroup(group);
        this.enterFromSafeties(group);
        Runtime.getRuntime().gc();
    }

    public int getLastID(String group, int type) throws Exception {
        DFAsc dfasc = DFAsc.getDFAsc(group, type);
        if (dfasc == null) {
            throw new Exception("No Datafile");
        }
        return dfasc.getLastID();
    }

    public void performSearch(SearchObject so, SearchProcess sp) throws Exception {
        String group = so.getGroup();
        int type = so.getType();
        if (so.wantsAllObjects() || so.wantsOnlyDeadObjects()) {
            so.prepareForSearch(true);
            boolean checkObject = so.afterIndexCheckNecessary();
            boolean onlyDead = so.wantsOnlyDeadObjects();
            int oneBunch = 100;
            Vector<Long> erg = new Vector<Long>(oneBunch + 1);
            DFAsc dfasc = DFAsc.getDFAsc(group, 1);
            if (dfasc != null) {
                long minid = dfasc.getFirstIDL();
                long maxid = dfasc.getLastIDL();
                if (minid != -1L && maxid != -1L) {
                    long id = minid;
                    while (id <= maxid) {
                        if (!(!dfasc.isObjectDa(id) || onlyDead && dfasc.isObjectActual(id))) {
                            Long longID = new Long(id);
                            boolean useIt = so.checkWithIndex(so.getGroup(), longID);
                            if (useIt) {
                                if (checkObject) {
                                    IDObject iob = DFAsc.getObject(group, type, id, false, false);
                                    useIt = iob == null ? false : so.checkAfterIndex((Mouse)iob);
                                    iob.dispose();
                                }
                                if (useIt) {
                                    erg.addElement(longID);
                                    if (erg.size() >= oneBunch) {
                                        sp.sendIntermediate(erg);
                                        erg.clear();
                                    }
                                }
                            }
                        }
                        ++id;
                    }
                }
            }
            if (!erg.isEmpty()) {
                sp.sendIntermediate(erg);
                erg.clear();
            }
            so.searchFinished(true);
        }
    }

    public void deleteGroup(String groupname) {
        String dirName = GroupFileManager.getGroupDir(groupname);
        File dir = new File(dirName);
        if (dir.exists()) {
            FileManager.deleteDir(dirName, true);
        }
    }

    public boolean saveIDObject(IDObject iob) {
        return cvActive && DFAsc.save(iob);
    }

    public boolean provideNewIDToIDObject(IDObject iob) {
        return DFAsc.provideNewIDToIDObject(iob);
    }

    public IDObject getObject(String group, int type, long id, boolean onlyActual) {
        return DFAsc.getObject(group, type, id, onlyActual, false);
    }

    public Hashtable getAllActualObjects(String group, int type) {
        Hashtable erg = new Hashtable(2000);
        DFAsc.getObjects(false, null, null, erg, group, type);
        return erg;
    }

    public Hashtable getAllObjects(String group, int type) {
        Hashtable erg = new Hashtable(2000);
        DFAsc.getObjects(true, null, null, erg, group, type);
        return erg;
    }

    public Vector getSortedIDs(String group, int type) {
        TreeSet sids = DFAsc.getSortedIDs(group, type, true, false, false);
        return new Vector(sids);
    }

    public Vector getSortedActualIDs(String group, int type) {
        TreeSet sids = DFAsc.getSortedIDs(group, type, false, true, false);
        return new Vector(sids);
    }

    public void giveSuccesivelyAllObjectsForCheck(String group, int type, ObjectConsumer consumer) {
        DFAsc.getObjects(true, consumer, IDObject.giveNewObjectOfType(type), null, group, type);
    }

    public boolean hasActualObjects(String groupname, int type) throws Exception {
        DFAsc dfasc = DFAsc.getDFAsc(groupname, type);
        if (dfasc != null) {
            return dfasc.hasActiveObjects();
        }
        return false;
    }
}

