/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.datalayer;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.room.Room;

public abstract class MiscHandler {
    private static final String LAST_EARTAG_SUFFIX = ".let";
    private static final String KILLED_IN_SERVICE_SUFFIX = ".kisr";
    private static final String KILLED_FOR_OWNERS_SUFFIX = ".kifo";
    private static final int MAX_KILLED_MONTHS_INTERVALL = 4;
    private static final int MAX_REMOVED_FOR_USER_MONTHS_INTERVALL = 2;
    private static Vector cvKilleds = null;
    static /* synthetic */ Class class$0;

    public static void handleLastEartag(Mouse mouse) {
        long lineID;
        int eartag;
        if (ProcessDefinition.isServer() && (eartag = mouse.getInt("MOS_EARTAG", -1)) != -1 && (lineID = mouse.getLong("MOS_LINEID", -1L)) != -1L) {
            String dir = GroupFileManager.getMiscDir(mouse.getGroup());
            FileManager.prepareDirs(dir);
            FileManager.saveStringToFile(String.valueOf(dir) + "/" + lineID + LAST_EARTAG_SUFFIX, Integer.toString(eartag));
        }
    }

    public static String getLastEartag(String group, String lineID) {
        String path;
        if (ProcessDefinition.isServer() && new File(path = String.valueOf(GroupFileManager.getMiscDir(group)) + "/" + lineID + LAST_EARTAG_SUFFIX).exists()) {
            return FileManager.getStringFromFile(path);
        }
        return null;
    }

    public static void handleMouseToRemove(Mouse mouse, long endMillis, int exitMode, Hashtable objectbag) {
        if (ProcessDefinition.isServer()) {
            Long serviceRoomID;
            int tage = (int)(endMillis / 86400000L);
            MyDate md = new MyDate(tage);
            Room groupRoom = mouse.getRoom();
            if (groupRoom != null && (serviceRoomID = (Long)groupRoom.get("IDO_SERVID")) != null) {
                String dir = GroupFileManager.getMiscDir("service");
                FileManager.prepareDirs(dir);
                String path = String.valueOf(dir) + "/" + MiscHandler.getKISFilename(serviceRoomID, md.ivJahr, md.ivMonat);
                FileManager.pureAppend(path, String.valueOf(tage) + " " + mouse.getIdentifierString() + "\n");
            }
            String group = mouse.getGroup();
            long[] ownerIds = (long[])mouse.get("MOS_OWNER");
            long[] ownerGroupIds = (long[])mouse.get("MOS_OWNERGROUPS");
            if (ownerIds != null && ownerIds.length != 0 || ownerGroupIds != null && ownerGroupIds.length != 0) {
                int i;
                boolean doit = false;
                StringBuilder msb = new StringBuilder();
                msb.append(tage).append(" ").append(exitMode).append(" |");
                if (ownerIds != null) {
                    i = 0;
                    while (i < ownerIds.length) {
                        msb.append(ownerIds[i]).append("|");
                        doit = true;
                        ++i;
                    }
                }
                if (ownerGroupIds != null) {
                    i = 0;
                    while (i < ownerGroupIds.length) {
                        long[] ids;
                        IDObjectGroup idogr = (IDObjectGroup)ObjectStore.getObjectDeadOrAlive(19, ownerGroupIds[i], group, objectbag, false);
                        if (idogr != null && (ids = (long[])idogr.get("IOG_IDS")) != null) {
                            int i2 = 0;
                            while (i2 < ids.length) {
                                msb.append(ids[i2]).append("|");
                                doit = true;
                                ++i2;
                            }
                        }
                        ++i;
                    }
                }
                if (doit) {
                    msb.append(" ").append(mouse.getID()).append("\n");
                    String dir = GroupFileManager.getMiscDir(group);
                    FileManager.prepareDirs(dir);
                    String path = String.valueOf(dir) + "/" + MiscHandler.getKIFOFilename(md.ivJahr, md.ivMonat);
                    FileManager.pureAppend(path, msb.toString());
                }
            }
        }
    }

    public static String getIdentifiersForMiceKilledInServiceRoom(long serviceRoomID) {
        if (ProcessDefinition.isServer()) {
            StringBuilder msb = new StringBuilder();
            Vector filenames = new Vector();
            MiscHandler.collectRelevantFileNames(filenames, "service", serviceRoomID, true);
            String dir = GroupFileManager.getMiscDir("service");
            if (!filenames.isEmpty()) {
                Iterator iterator = filenames.iterator();
                while (iterator.hasNext()) {
                    String filename = (String)iterator.next();
                    String s = FileManager.getStringFromFile(String.valueOf(dir) + "/" + filename);
                    if (s == null || s.length() == 0) continue;
                    msb.append(s);
                }
            }
            filenames.clear();
            filenames = null;
            return msb.toString();
        }
        return null;
    }

    public static String getIdentifiersForMiceRemovedForUser(String group, long userID) {
        if (ProcessDefinition.isServer()) {
            StringBuilder msb = new StringBuilder();
            Vector filenames = new Vector();
            MiscHandler.collectRelevantFileNames(filenames, group, userID, false);
            String dir = GroupFileManager.getMiscDir(group);
            if (!filenames.isEmpty()) {
                String check = "|" + userID + "|";
                Iterator iterator = filenames.iterator();
                while (iterator.hasNext()) {
                    String path = String.valueOf(dir) + "/" + (String)iterator.next();
                    if (!new File(path).exists()) continue;
                    try {
                        LineNumberReader lnr = new LineNumberReader(new FileReader(path));
                        String line = lnr.readLine();
                        while (line != null) {
                            if (line.contains(check)) {
                                msb.append(line).append("\n");
                            }
                            line = lnr.readLine();
                        }
                        lnr.close();
                    }
                    catch (Exception e) {
                        String string = "Problem reading file " + path;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.datalayer.MiscHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, e, clazz);
                    }
                }
            }
            filenames.clear();
            filenames = null;
            return msb.toString();
        }
        return null;
    }

    private static void collectRelevantFileNames(Vector filenames, String group, long relevantID, boolean checkKIS) {
        String dir = GroupFileManager.getMiscDir("service");
        File f = new File(dir);
        if (f.exists()) {
            int heute = (int)(System.currentTimeMillis() / 86400000L);
            MyDate jetzt = new MyDate(heute);
            int endJahr = jetzt.ivJahr;
            int endMonat = jetzt.ivMonat;
            int startJahr = endJahr;
            int startMonat = endMonat - (checkKIS ? 4 : 2);
            if (startMonat < 1) {
                --startJahr;
                startMonat += 12;
            }
            boolean cont = true;
            while (cont) {
                String filename = checkKIS ? MiscHandler.getKISFilename(relevantID, startJahr, startMonat) : MiscHandler.getKIFOFilename(startJahr, startMonat);
                filenames.add(filename);
                boolean bl = cont = startJahr != endJahr || startMonat != endMonat;
                if (++startMonat <= 12) continue;
                startMonat -= 12;
                ++startJahr;
            }
        }
    }

    private static String getKISFilename(long serviceRoomID, int jahr, int monat) {
        return String.valueOf(serviceRoomID) + "_" + jahr + "_" + monat + KILLED_IN_SERVICE_SUFFIX;
    }

    private static String getKIFOFilename(int jahr, int monat) {
        return String.valueOf(jahr) + "_" + monat + KILLED_FOR_OWNERS_SUFFIX;
    }

    public static void clearCollecteds() {
        if (cvKilleds != null) {
            cvKilleds.clear();
            cvKilleds = null;
        }
    }

    public static Vector getRemovedMice(int datum, int mode) {
        User user;
        if (ProcessDefinition.isClient() && MausoleumClient.isRegular() && (user = UserManager.getUser()) != null && Privileges.hasPrivilege(user, "CAN_OWN")) {
            if (cvKilleds == null) {
                String killeds = (String)RequestManager.createSendAndGetObjectIfFinished((byte)77, user.getLongID(), user.getGroup());
                cvKilleds = killeds != null ? StringHelper.splitStringByAny(killeds, "\n") : new Vector();
            }
            Vector<Mouse> res = new Vector<Mouse>();
            if (datum != Integer.MIN_VALUE) {
                Iterator iterator = cvKilleds.iterator();
                while (iterator.hasNext()) {
                    Mouse mouse;
                    String line = (String)iterator.next();
                    Zeile z1 = new Zeile(line, ' ');
                    if (datum >= z1.getInt(0, Integer.MAX_VALUE) || mode != -1 && mode != z1.getInt(1, -1) || (mouse = MouseManager.getMouse(z1.getLong(3, 0L), user.getGroup())) == null) continue;
                    res.add(mouse);
                }
            }
            return res;
        }
        return null;
    }

    public static Vector getMiceKilledInServiceSince(int datum) {
        if (ProcessDefinition.isClient() && MausoleumClient.isServiceCaretaker()) {
            if (cvKilleds == null) {
                String killeds = (String)RequestManager.createSendAndGetObjectIfFinished((byte)76, MausoleumClient.cvServiceCTRoomID, "service");
                cvKilleds = killeds != null ? StringHelper.splitStringByAny(killeds, "\n") : new Vector();
            }
            Vector<Mouse> res = new Vector<Mouse>();
            Iterator iterator = cvKilleds.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                int ind = line.indexOf(" ");
                if (ind == -1) continue;
                try {
                    Zeile z;
                    Mouse mouse;
                    int kdatum = Integer.parseInt(line.substring(0, ind));
                    if (kdatum < datum || (mouse = MouseManager.getMouse((z = new Zeile(line.substring(ind + 1, line.length()), '|')).getLong(2, 0L), z.getString(0, ""))) == null) continue;
                    res.add(mouse);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return res;
        }
        return null;
    }
}

