/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.db;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.DataFileEntry;
import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.SearchProcess;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.session.ShortSessionInfo;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.io.File;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.gui.ColorManager;
import mausoleum.helper.Zeile;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.result.MResult;

public abstract class DBAssistant {
    private static final String DB_FILE = "mauso.db";
    public static final HashMap ALLOWED_ATTRIBUTES_BY_TYPE = new HashMap();
    public static final HashMap ORDERED_ATTRIBUTES_BY_TYPE = new HashMap();
    public static final HashMap MARKS_FOR_ATTRIBUTES_BY_TYPE = new HashMap();
    public static final HashMap INDEX_SPALTEN_BY_TYPE = new HashMap();
    public static final String ALLG_INDEX_ROOM = "IDX_ROOM";
    public static final String MOUSE_INDEX_SEX = "IDX_SEX";
    public static final String MOUSE_INDEX_STRAINS = "IDX_STRAINS";
    public static final String MOUSE_INDEX_RESULTS = "IDX_RESULTS";
    public static final String MOUSE_INDEX_CAGE = "IDX_CAGE";
    public static final String CAGE_INDEX_RACK = "IDX_RACK";
    public static final String SESSION_INDEX_COMMANDS = "IDX_COMMANDS";
    public static final String COL_SESSIONS = "SESSIONS";
    private static final HashMap INSERTS_BY_TYPE_AND_GROUP = new HashMap();
    private static final HashMap UPDATES_BY_TYPE_AND_GROUP = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Vector<String> v = new Vector<String>(6);
        v.add(MOUSE_INDEX_SEX);
        v.add(MOUSE_INDEX_STRAINS);
        v.add(MOUSE_INDEX_RESULTS);
        v.add(ALLG_INDEX_ROOM);
        v.add(MOUSE_INDEX_CAGE);
        INDEX_SPALTEN_BY_TYPE.put(new Integer(1), v);
        v = new Vector(3);
        v.add(ALLG_INDEX_ROOM);
        v.add(CAGE_INDEX_RACK);
        INDEX_SPALTEN_BY_TYPE.put(new Integer(2), v);
        v = new Vector(3);
        v.add(SESSION_INDEX_COMMANDS);
        INDEX_SPALTEN_BY_TYPE.put(new Integer(5), v);
    }

    public static void bigConversion(String[] groupNames) {
        StringBuilder msb = new StringBuilder();
        HashMap idVersionSammler = new HashMap();
        int i = 0;
        while (i < groupNames.length) {
            String group = groupNames[i];
            if (!DBAssistant.isDBPresent(group)) {
                String string = "Convert data of group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string, clazz);
                DBAssistant.convertGroupData(group, msb, idVersionSammler);
            }
            ++i;
        }
    }

    public static boolean isDBPresent(String group) {
        return new File(DBAssistant.getDBFilePath(group)).exists();
    }

    public static Connection getConnection(String group) {
        try {
            Class.forName("org.sqlite.JDBC");
            return DriverManager.getConnection("jdbc:sqlite:" + DBAssistant.getDBFilePath(group));
        }
        catch (Exception e) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem while getting Connection", e, clazz);
            return null;
        }
    }

    public static void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem closing Connection", e, clazz);
        }
    }

    public static Vector getSortedIDs(String group, int type) {
        return DBAssistant.getSortedIDs(group, type, false);
    }

    public static Vector getSortedActualIDs(String group, int type) {
        return DBAssistant.getSortedIDs(group, type, true);
    }

    public static boolean provideNewIDToIDObject(IDObject iob) {
        try {
            long maxID = DBAssistant.getLastID(iob.getGroup(), iob.getTyp());
            if (maxID != -1L) {
                iob.set("IDO_ID", new Long(maxID + 1L));
                iob.ivIsNew = true;
                return true;
            }
        }
        catch (Exception e) {
            String string = "Exception providing new ID to IDObject Group " + iob.getGroup() + " Type " + iob.getTyp();
            IllegalAccessError illegalAccessError = new IllegalAccessError();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalAccessError, clazz);
        }
        return false;
    }

    public static long getLastID(String group, int type) throws Exception {
        long maxID = -1L;
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            try {
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select max(IDO_ID) from " + IDObject.getFilenameForTypeServerSide(type) + ";");
                rs.next();
                maxID = rs.getLong(1);
                rs.close();
                stat.close();
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem providing new ID to IDObject Group " + group + " Type " + type;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return maxID;
    }

    public static boolean hasActualObjects(String group, int type) {
        return DBAssistant.getActualObjectCount(group, type) != 0;
    }

    public static int getActualObjectCount(String group, int type) {
        int anz = 0;
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            try {
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select count(*) from " + IDObject.getFilenameForTypeServerSide(type) + " where IDO_END_DATE == \"\";");
                rs.next();
                anz = rs.getInt(1);
                rs.close();
                stat.close();
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem checking actual objects of  Group " + group + " Type " + type;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return anz;
    }

    public static Hashtable getAllActualObjects(String group, int type) {
        return DBAssistant.getAllObjects(group, type, true, null);
    }

    public static Hashtable getAllObjects(String group, int type) {
        return DBAssistant.getAllObjects(group, type, false, null);
    }

    public static void giveSuccesivelyAllObjectsForCheck(String group, int type, ObjectConsumer consumer) {
        DBAssistant.getAllObjects(group, type, false, consumer);
    }

    public static int getVersion(String group, int type, long id, int defVal) {
        int res = defVal;
        DBAssistant.initAttributes(new Integer(type));
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_VERSION FROM " + IDObject.getFilenameForTypeServerSide(type);
            query = String.valueOf(query) + " WHERE IDO_ID == " + id;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        res = rs.getInt(1);
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem getting Version for Group " + group + " Type " + type + " ID " + id;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem closing connection " + group;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return res;
    }

    public static void fillShortSessionInfos(String group, long userID, Vector target) {
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_ID, IDO_START_DATE, IDO_END_DATE, IDX_COMMANDS FROM " + IDObject.getFilenameForTypeServerSide(5) + " WHERE " + "SES_USER" + " == " + userID;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        try {
                            target.add(new ShortSessionInfo(rs.getLong(1), userID, rs.getLong(2), rs.getLong(3), rs.getInt(4)));
                        }
                        catch (Exception e) {
                            String string = "Problem initialising ShortSession-Infos for Group " + group + " User " + userID;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.db.DBAssistant");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem getting ShortSession-Infos for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem closing connection " + group;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
    }

    public static TreeSet getSessionIDs(String group, int type, long id) {
        Connection conn;
        TreeSet erg = new TreeSet();
        if (IDObject.storesSession(type, group) && (conn = DBAssistant.getConnection(group)) != null) {
            String query = "SELECT SESSIONS FROM " + IDObject.getFilenameForTypeServerSide(type) + " WHERE " + "IDO_ID" + " = " + id;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        String sess = rs.getString(1);
                        if (sess == null || sess.length() == 0) continue;
                        IDObjectXMLHandler.appendToSessionTreeset(sess, erg);
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem searching ids and versions for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            DBAssistant.closeConnection(conn);
        }
        return erg;
    }

    public static long getIDOfActualUser(String group, String userName, long defVal) {
        long erg = defVal;
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_ID FROM " + IDObject.getFilenameForTypeServerSide(6) + " WHERE " + userName + " = " + userName;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        erg = rs.getLong(1);
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem searching ids and versions for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            DBAssistant.closeConnection(conn);
        }
        return erg;
    }

    public static void performSearch(SearchObject so, SearchProcess sp) throws Exception {
        Integer typeKey = new Integer(1);
        TreeMap allowedAttributes = (TreeMap)ALLOWED_ATTRIBUTES_BY_TYPE.get(typeKey);
        HashMap marksForAttribut = (HashMap)MARKS_FOR_ATTRIBUTES_BY_TYPE.get(typeKey);
        HashMap<String, Object> tempHM = new HashMap<String, Object>();
        Connection conn = DBAssistant.getConnection(so.getGroup());
        if (conn != null) {
            int oneBunch = 100;
            Vector<Long> erg = new Vector<Long>(oneBunch + 1);
            so.prepareForSearch(true);
            boolean checkObject = so.afterIndexCheckNecessary();
            boolean onlyDead = so.wantsOnlyDeadObjects();
            Vector<String> columns = new Vector<String>();
            columns.add("IDO_ID");
            Vector<String> wheres = new Vector<String>();
            wheres.add("IDO_NEVER_EXISTED = \"\"");
            if (onlyDead) {
                wheres.add("IDO_END_DATE != \"\"");
            }
            so.addWheres(wheres, columns);
            StringBuilder msb = new StringBuilder();
            msb.append("SELECT ");
            int i = 0;
            while (i < columns.size()) {
                if (i != 0) {
                    msb.append(",");
                }
                msb.append(columns.elementAt(i));
                ++i;
            }
            msb.append(" FROM ").append(IDObject.getFilenameForTypeServerSide(1));
            if (!wheres.isEmpty()) {
                msb.append(" WHERE ");
                i = 0;
                while (i < wheres.size()) {
                    if (i != 0) {
                        msb.append(" AND ");
                    }
                    msb.append(wheres.elementAt(i));
                    ++i;
                }
            }
            System.out.println(msb.toString());
            System.out.println("--------------------------------------------------------");
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(msb.toString())) != null) {
                    while (rs.next()) {
                        try {
                            tempHM.clear();
                            long mouseID = rs.getLong(1);
                            if (checkObject) {
                                int i2 = 1;
                                while (i2 <= columns.size()) {
                                    String key;
                                    Object toSet;
                                    String s = rs.getString(i2);
                                    if (s.length() != 0 && (toSet = DBAssistant.get(rs, allowedAttributes, marksForAttribut, key = (String)columns.elementAt(i2 - 1), s, i2, so.getGroup())) != null) {
                                        tempHM.put(key, toSet);
                                    }
                                    ++i2;
                                }
                                if (so.checkAfterIndex(tempHM)) {
                                    erg.add(new Long(mouseID));
                                }
                            } else {
                                erg.add(new Long(mouseID));
                            }
                            if (erg.size() < oneBunch) continue;
                            sp.sendIntermediate(erg);
                            erg.clear();
                        }
                        catch (Exception e) {
                            String string = "Problem searching mice for Group " + so.getGroup();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.db.DBAssistant");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    rs.close();
                }
                statement.close();
                if (!erg.isEmpty()) {
                    sp.sendIntermediate(erg);
                    erg.clear();
                }
                so.searchFinished(true);
                DBAssistant.closeConnection(conn);
            }
            catch (Exception e) {
                String string = "Problem [outer] searching mice for Group " + so.getGroup();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
    }

    public static void getActualIDVersionList(String group, int type, long userID, HashMap target) {
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_ID, IDO_VERSION FROM " + IDObject.getFilenameForTypeServerSide(type) + " WHERE " + "IDO_END_DATE" + " == \"\"";
            if (type == 11) {
                query = String.valueOf(query) + " AND MAI_OWNER_ID = " + userID;
            }
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        try {
                            target.put(new Long(rs.getLong(1)), new Integer(rs.getInt(2)));
                        }
                        catch (Exception e) {
                            String string = "Problem searching ids and versions for Group " + group;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.db.DBAssistant");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem searching ids and versions for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            DBAssistant.closeConnection(conn);
        }
    }

    public static LocusAndAlleles[] determineMouseGT(String group, Long id) {
        LocusAndAlleles[] erg = null;
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT MOS_LOCUSGENOTYPES FROM " + IDObject.getFilenameForTypeServerSide(1) + " WHERE " + "IDO_ID" + " = " + id;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        try {
                            String s = rs.getString(1);
                            if (s == null || s.length() == 0) continue;
                            erg = (LocusAndAlleles[])IDObjectXMLHandler.getObject("LAA[", s, group);
                        }
                        catch (Exception e) {
                            String string = "Problem searching ids and versions for Group " + group;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.db.DBAssistant");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem searching ids and versions for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            DBAssistant.closeConnection(conn);
        }
        return erg;
    }

    public static void manageCageTalker() {
        if (CageTalker.useCageTalker()) {
            String[] gnames = DataLayer.cvDataLayer.getGroupStringArray(false);
            int i = 0;
            while (i < gnames.length) {
                String group = gnames[i];
                Connection conn = DBAssistant.getConnection(group);
                if (conn != null) {
                    String query = "SELECT CAG_CTID FROM " + IDObject.getFilenameForTypeServerSide(2) + " WHERE " + "IDO_END_DATE" + " = \"\"";
                    try {
                        ResultSet rs;
                        Statement statement = conn.createStatement();
                        if (statement != null && (rs = statement.executeQuery(query)) != null) {
                            while (rs.next()) {
                                try {
                                    CageTalker.addUsedCagetalkerID(rs.getString(1));
                                }
                                catch (Exception e) {
                                    String string = "Problem manage Cagetalker for Group " + group;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("mausoleum.db.DBAssistant");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Log.error(string, e, clazz);
                                }
                            }
                            rs.close();
                        }
                        statement.close();
                    }
                    catch (Exception e) {
                        String string = "Problem searching ids and versions for Group " + group;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.db.DBAssistant");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, e, clazz);
                    }
                    DBAssistant.closeConnection(conn);
                }
                ++i;
            }
        }
    }

    public static void addCageIDsForPseudoID(String group, int wanted, Vector target) {
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_ID FROM " + IDObject.getFilenameForTypeServerSide(2) + " WHERE " + "CAG_PSEUDOID" + " = " + wanted;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        try {
                            target.add(new Long(rs.getLong(1)));
                        }
                        catch (Exception e) {
                            String string = "Problem searching cages for Group " + group;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.db.DBAssistant");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem searching cages for Group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            DBAssistant.closeConnection(conn);
        }
    }

    public static void addParentIDs(long id, Connection conn, Vector target) {
        String query = "SELECT MOS_FATHER, MOS_MOTHER FROM " + IDObject.getFilenameForTypeServerSide(1);
        query = String.valueOf(query) + " WHERE IDO_ID = " + id;
        try {
            ResultSet rs;
            Statement statement = conn.createStatement();
            if (statement != null && (rs = statement.executeQuery(query)) != null) {
                while (rs.next()) {
                    String s = rs.getString(1);
                    if (s != null && s.length() != 0) {
                        target.add(new Long(s));
                    }
                    if ((s = rs.getString(2)) == null || s.length() == 0) continue;
                    target.add(new Long(s));
                }
                rs.close();
            }
            statement.close();
        }
        catch (Exception e) {
            String string = "Problem getting ParentIds ID " + id;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    public static void addKidIDs(long id, Connection conn, Vector target) {
        String query = "SELECT MOS_KID FROM " + IDObject.getFilenameForTypeServerSide(1);
        query = String.valueOf(query) + " WHERE IDO_ID == " + id;
        try {
            ResultSet rs;
            Statement statement = conn.createStatement();
            if (statement != null && (rs = statement.executeQuery(query)) != null) {
                while (rs.next()) {
                    String s = rs.getString(1);
                    if (s == null || s.length() == 0) continue;
                    Zeile z = new Zeile(s.substring(1, s.length() - 1), '|');
                    int i = 0;
                    while (i < z.size()) {
                        target.add(new Long(z.getLong(i, -1L)));
                        ++i;
                    }
                }
                rs.close();
            }
            statement.close();
        }
        catch (Exception e) {
            String string = "Problem getting KidIds for ID " + id;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    public static void getMoreObjects(String group, int type, long[] ids, boolean mitSessions, Vector target, boolean wantValueString) {
        if (ids != null && ids.length != 0) {
            DBAssistant.initAttributes(new Integer(type));
            Vector keys = new Vector();
            Connection conn = DBAssistant.getConnection(group);
            if (conn != null) {
                StringBuilder msb = new StringBuilder(DBAssistant.getQueryStatement(type, group, mitSessions, new StringBuilder(), conn, keys));
                msb.append(" WHERE ").append("IDO_ID").append(" IN (");
                int i = 0;
                while (i < ids.length) {
                    if (i != 0) {
                        msb.append(",");
                    }
                    msb.append(ids[i]);
                    ++i;
                }
                msb.append(")");
                try {
                    ResultSet rs;
                    Statement statement = conn.createStatement();
                    if (statement != null && (rs = statement.executeQuery(msb.toString())) != null) {
                        while (rs.next()) {
                            IDObject ido = DBAssistant.getIDObject(rs, keys, type, group);
                            if (ido == null) continue;
                            if (wantValueString) {
                                target.add(ido.getValueString());
                                continue;
                            }
                            target.add(ido);
                        }
                        rs.close();
                    }
                    statement.close();
                }
                catch (Exception e) {
                    String string = "Problem getting more Objects Group " + group + " Type " + type;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
                try {
                    conn.close();
                }
                catch (Exception e) {
                    String string = "Problem closing connection >" + group + "<";
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
            }
        }
    }

    public static boolean getNeverExisted(long id, boolean defVal, Connection conn) {
        boolean res = defVal;
        String query = "SELECT IDO_NEVER_EXISTED FROM " + IDObject.getFilenameForTypeServerSide(1);
        query = String.valueOf(query) + " WHERE IDO_ID == " + id;
        try {
            ResultSet rs;
            Statement statement = conn.createStatement();
            if (statement != null && (rs = statement.executeQuery(query)) != null) {
                while (rs.next()) {
                    res = "1".equals(rs.getString(1));
                }
                rs.close();
            }
            statement.close();
        }
        catch (Exception e) {
            String string = "Problem getting never existed for ID " + id;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
        return res;
    }

    public static IDObject getObject(String group, int type, long id, boolean onlyActual) {
        DBAssistant.initAttributes(new Integer(type));
        StringBuilder msb = new StringBuilder();
        Vector keys = new Vector();
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = DBAssistant.getQueryStatement(type, group, true, msb, conn, keys);
            query = String.valueOf(query) + " WHERE IDO_ID=" + id;
            if (onlyActual) {
                query = String.valueOf(query) + " AND IDO_END_DATE == \"\"";
            }
            IDObject ido = null;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next() && ido == null) {
                        ido = DBAssistant.getIDObject(rs, keys, type, group);
                        if (ido != null) continue;
                        ido = IDObject.giveNewObjectOfType(type);
                        ido.set("IDO_GROUP", group);
                        ido.set("IDO_ID", new Long(id));
                        ido.commit(false);
                    }
                    rs.close();
                }
                statement.close();
                conn.close();
                return ido;
            }
            catch (Exception e) {
                String string = "Problem getting Object Group " + group + " Type " + type + " ID " + id;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return null;
    }

    public static String getQueryStatement(int type, String group, boolean mitSessions, StringBuilder msb, Connection conn, Vector keys) {
        String tableName = IDObject.getFilenameForTypeServerSide(type);
        Integer typeKey = new Integer(type);
        String[] orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey);
        int i = 0;
        while (i < orderedAttributes.length) {
            if (msb.length() != 0) {
                msb.append(",");
            }
            msb.append(orderedAttributes[i]);
            keys.add(orderedAttributes[i]);
            ++i;
        }
        if (mitSessions && IDObject.storesSession(type, group)) {
            msb.append(",").append(COL_SESSIONS);
            keys.add(COL_SESSIONS);
        }
        return "SELECT " + msb.toString() + " from " + tableName;
    }

    public static void testChange(String group) {
        block10: {
            try {
                Connection conn = DBAssistant.getConnection(group);
                if (conn == null) {
                    String string = "No Connection for group >" + group + "<";
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, illegalArgumentException, clazz);
                    break block10;
                }
                String sql = "UPDATE mouse SET MOS_COMMENT = ? , IDO_FKEY = ? WHERE IDO_ID = ?";
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                preparedStatement.setString(1, "HUHU");
                preparedStatement.setString(2, "Hall\u00f6chen");
                preparedStatement.setLong(3, 2334L);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                conn.close();
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Murks ", e, clazz);
            }
        }
    }

    public static boolean saveObject(IDObject ido) {
        boolean res = false;
        StringBuilder msbNamen = new StringBuilder();
        StringBuilder msbFrgz = new StringBuilder();
        boolean isInsert = ido.ivIsNew;
        String group = ido.getGroup();
        Connection conn = DBAssistant.getConnection(ido.getGroup());
        if (conn == null) {
            String string = "No Connection for group >" + group + "<";
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
        } else {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = isInsert ? DBAssistant.getInsertStatement(ido.getTyp(), group, msbNamen, msbFrgz, conn) : DBAssistant.getUpdateStatement(ido.getTyp(), group, msbNamen, conn);
            if (preparedStatement != null) {
                try {
                    DBAssistant.insertOrUpdate(ido, preparedStatement, msbFrgz, isInsert);
                    conn.setAutoCommit(false);
                    if (isInsert) {
                        preparedStatement.execute();
                    } else {
                        preparedStatement.executeUpdate();
                    }
                    conn.setAutoCommit(true);
                    preparedStatement.close();
                    ido.ivIsNew = false;
                    res = true;
                }
                catch (Exception e) {
                    String string = "Problem saving object to  group >" + group + "<";
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem closing connection >" + group + "<";
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return res;
    }

    public static void setValueInStatement(Object ooo, PreparedStatement preparedStatement, int column, String colKey, HashMap marksForAttribut, StringBuilder msbFrgz) throws Exception {
        if (ooo == null) {
            preparedStatement.setString(column, "");
        } else if (ooo instanceof Date) {
            Date d = (Date)ooo;
            preparedStatement.setLong(column, d.getTime());
        } else if (ooo instanceof Long) {
            Long d = (Long)ooo;
            preparedStatement.setLong(column, d);
        } else if (ooo instanceof Integer) {
            Integer d = (Integer)ooo;
            preparedStatement.setInt(column, d);
        } else if (ooo instanceof String) {
            String d = (String)ooo;
            preparedStatement.setString(column, d);
        } else if (ooo instanceof Color) {
            Color d = (Color)ooo;
            preparedStatement.setString(column, ColorManager.getColorString(d));
        } else if (ooo instanceof Boolean) {
            Boolean b = (Boolean)ooo;
            preparedStatement.setString(column, b != false ? "1" : "0");
        } else if (ooo instanceof int[]) {
            int[] arr = (int[])ooo;
            msbFrgz.setLength(0);
            msbFrgz.append("|");
            int j = 0;
            while (j < arr.length) {
                msbFrgz.append(arr[j]).append("|");
                ++j;
            }
            preparedStatement.setString(column, msbFrgz.toString());
        } else if (ooo instanceof long[]) {
            long[] arr = (long[])ooo;
            msbFrgz.setLength(0);
            msbFrgz.append("|");
            int j = 0;
            while (j < arr.length) {
                msbFrgz.append(arr[j]).append("|");
                ++j;
            }
            preparedStatement.setString(column, msbFrgz.toString());
        } else if (ooo instanceof boolean[]) {
            boolean[] arr = (boolean[])ooo;
            msbFrgz.setLength(0);
            msbFrgz.append("|");
            int j = 0;
            while (j < arr.length) {
                msbFrgz.append(arr[j] ? "1" : "").append("|");
                ++j;
            }
            preparedStatement.setString(column, msbFrgz.toString());
        } else {
            String mark = (String)marksForAttribut.get(colKey);
            IDObjectXMLHandler.IOXInterpret ioxi = IDObjectXMLHandler.getInterpreter(mark);
            msbFrgz.setLength(0);
            ioxi.append(ooo, msbFrgz, false);
            preparedStatement.setString(column, msbFrgz.toString());
        }
    }

    public static boolean createAllTables(String group) {
        boolean res = true;
        StringBuilder msb = new StringBuilder();
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            int[] typen = DataLayer.getTypen(group);
            int i = 0;
            while (i < typen.length && res) {
                res &= DBAssistant.createTable(typen[i], group, msb, conn);
                ++i;
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem creating all tables for Group " + group;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return res;
    }

    public static boolean createTable(int type, String group, StringBuilder msb, Connection conn) {
        Integer typeKey = new Integer(type);
        DBAssistant.initAttributes(typeKey);
        String tableDef = DBAssistant.getTableDef(typeKey, group, msb);
        try {
            Statement stat = conn.createStatement();
            stat.executeUpdate(tableDef);
            stat.close();
            return true;
        }
        catch (Exception e) {
            String string = "Problem creating table Group " + group + " Type " + type;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            return false;
        }
    }

    public static void getGenealogy(ObjectRequest or, String group, long id, boolean parents, int runden) {
        HashSet behandelteIDs = new HashSet(300);
        HashMap relativesByMouseID = new HashMap(300);
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            DBAssistant.collectRelatives(behandelteIDs, id, relativesByMouseID, parents, runden, conn, new Vector(), new Vector());
        }
        or.ivObject = behandelteIDs;
        or.ivExtraObject = relativesByMouseID;
    }

    public static void collectRelatives(HashSet behandelteIDs, long mouseID, HashMap relativesByMouseID, boolean parents, int runden, Connection conn, Vector ids, Vector w) {
        Long mouseIDL = new Long(mouseID);
        behandelteIDs.add(mouseIDL);
        ids.clear();
        if (parents) {
            DBAssistant.addParentIDs(mouseID, conn, ids);
        } else {
            DBAssistant.addKidIDs(mouseID, conn, ids);
        }
        if (!ids.isEmpty()) {
            w.clear();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                Long mIDL = (Long)iterator.next();
                if (mIDL <= 0L || DBAssistant.getNeverExisted(mIDL, false, conn)) continue;
                w.add(mIDL);
            }
            if (!w.isEmpty()) {
                long[] tgtVerwandtenIDs = new long[w.size()];
                int pos = 0;
                Iterator iterator2 = w.iterator();
                while (iterator2.hasNext()) {
                    Long mIDL = (Long)iterator2.next();
                    long l = tgtVerwandtenIDs[pos++] = behandelteIDs.contains(mIDL) ? -mIDL.longValue() : mIDL;
                }
                if (runden > 1) {
                    int i = 0;
                    while (i < tgtVerwandtenIDs.length) {
                        if (tgtVerwandtenIDs[i] > 0L) {
                            DBAssistant.collectRelatives(behandelteIDs, tgtVerwandtenIDs[i], relativesByMouseID, parents, runden - 1, conn, ids, w);
                        }
                        ++i;
                    }
                }
                relativesByMouseID.put(mouseIDL, tgtVerwandtenIDs);
            }
        }
    }

    private static PreparedStatement getUpdateStatement(int type, String group, StringBuilder msbNamen, Connection conn) {
        String tableName = IDObject.getFilenameForTypeServerSide(type);
        Integer typeKey = new Integer(type);
        String ikey = String.valueOf(group) + "|$$|" + type;
        String updater = (String)UPDATES_BY_TYPE_AND_GROUP.get(ikey);
        if (updater == null) {
            String[] orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey);
            int i = 0;
            while (i < orderedAttributes.length) {
                if (!"IDO_ID".equals(orderedAttributes[i])) {
                    if (msbNamen.length() != 0) {
                        msbNamen.append(",");
                    }
                    msbNamen.append(orderedAttributes[i]).append(" = ? ");
                }
                ++i;
            }
            Vector v = (Vector)INDEX_SPALTEN_BY_TYPE.get(typeKey);
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    String col = (String)iterator.next();
                    msbNamen.append(",").append(col).append(" = ? ");
                }
            }
            if (IDObject.storesSession(type, group)) {
                msbNamen.append(",").append(COL_SESSIONS).append(" = ? ");
            }
            updater = "UPDATE " + tableName + " SET " + msbNamen.toString() + " WHERE " + "IDO_ID" + " = ? ;";
            UPDATES_BY_TYPE_AND_GROUP.put(ikey, updater);
        }
        try {
            return conn.prepareStatement(updater);
        }
        catch (Exception e) {
            String string = "Problem creating InsertStatement for " + type;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            return null;
        }
    }

    private static PreparedStatement getInsertStatement(int type, String group, StringBuilder msbNamen, StringBuilder msbFrgz, Connection conn) {
        String tableName = IDObject.getFilenameForTypeServerSide(type);
        Integer typeKey = new Integer(type);
        String ikey = String.valueOf(group) + "|$$|" + type;
        String inserter = (String)INSERTS_BY_TYPE_AND_GROUP.get(ikey);
        if (inserter == null) {
            String[] orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey);
            int i = 0;
            while (i < orderedAttributes.length) {
                if (msbNamen.length() != 0) {
                    msbNamen.append(",");
                    msbFrgz.append(",");
                }
                msbNamen.append(orderedAttributes[i]);
                msbFrgz.append("?");
                ++i;
            }
            Vector v = (Vector)INDEX_SPALTEN_BY_TYPE.get(typeKey);
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    String col = (String)iterator.next();
                    msbNamen.append(",").append(col);
                    msbFrgz.append(",").append("?");
                }
            }
            if (IDObject.storesSession(type, group)) {
                msbNamen.append(",").append(COL_SESSIONS);
                msbFrgz.append(",").append("?");
            }
            inserter = "INSERT INTO " + tableName + "(" + msbNamen.toString() + ") VALUES(" + msbFrgz.toString() + ")";
            INSERTS_BY_TYPE_AND_GROUP.put(ikey, inserter);
        }
        try {
            return conn.prepareStatement(inserter);
        }
        catch (Exception e) {
            String string = "Problem creating InsertStatement for " + type;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            return null;
        }
    }

    private static void insertOrUpdate(IDObject ido, PreparedStatement preparedStatement, StringBuilder msb, boolean isInsert) throws Exception {
        Integer typeKey = (Integer)ido.get("IDO_TYPE_ID");
        String[] orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey);
        HashMap marksForAttribut = (HashMap)MARKS_FOR_ATTRIBUTES_BY_TYPE.get(typeKey);
        int column = 1;
        int i = 0;
        while (i < orderedAttributes.length) {
            if (isInsert || !"IDO_ID".equals(orderedAttributes[i])) {
                DBAssistant.setValueInStatement(ido.get(orderedAttributes[i]), preparedStatement, column, orderedAttributes[i], marksForAttribut, msb);
                ++column;
            }
            ++i;
        }
        if (ido instanceof Mouse) {
            Mouse mouse = (Mouse)ido;
            int sex = mouse.getSex();
            preparedStatement.setString(column, sex == 0 ? "" : Integer.toString(sex));
            ++column;
            msb.setLength(0);
            IndexObject[] lalArr = (IndexObject[])mouse.get("MOS_STRAIN");
            if (lalArr != null && lalArr.length != 0) {
                msb.append("|");
                int j = 0;
                while (j < lalArr.length) {
                    msb.append(lalArr[j].ivObjectID).append("|");
                    ++j;
                }
            }
            preparedStatement.setString(column, msb.toString());
            ++column;
            msb.setLength(0);
            Vector mrv = (Vector)mouse.get("MOS_MRESULTS");
            if (mrv != null) {
                msb.append("|");
                int j = 0;
                while (j < mrv.size()) {
                    MResult mres = (MResult)mrv.elementAt(j);
                    msb.append(mres.getExperimentID()).append("|");
                    ++j;
                }
            }
            preparedStatement.setString(column, msb.toString());
            Long roomID = (Long)mouse.get("MOS_ROOM");
            preparedStatement.setString(++column, roomID == null ? "" : roomID.toString());
            long cageID = mouse.getActCageIDFromARR(-1L);
            preparedStatement.setString(++column, cageID == -1L ? "" : Long.toString(cageID));
            ++column;
        } else if (ido instanceof Cage) {
            Cage cage = (Cage)ido;
            Long roomID = (Long)cage.get("CAG_ROOM");
            preparedStatement.setString(column, roomID == null ? "" : roomID.toString());
            long rackID = cage.getRackID(-1L);
            preparedStatement.setString(++column, rackID == -1L ? "" : Long.toString(rackID));
            ++column;
        } else if (ido instanceof Session) {
            Session session = (Session)ido;
            Vector comms = (Vector)session.get("SES_COMMAND");
            preparedStatement.setString(column, comms == null ? "" : Integer.toString(comms.size()));
            ++column;
        }
        if (IDObject.storesSession(typeKey, ido.getGroup())) {
            String sessionCont = "";
            TreeSet sessionIDs = ido.getSessions();
            if (sessionIDs != null && !sessionIDs.isEmpty()) {
                sessionCont = IDObjectXMLHandler.getSessionString(sessionIDs);
            }
            preparedStatement.setString(column, sessionCont);
            ++column;
        }
        if (!isInsert) {
            preparedStatement.setLong(column, ido.getID());
        }
    }

    private static Vector getSortedIDs(String group, int type, boolean onlyActuals) {
        Vector<Long> erg = new Vector<Long>(200);
        DBAssistant.initAttributes(new Integer(type));
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = "SELECT IDO_ID FROM " + IDObject.getFilenameForTypeServerSide(type);
            if (onlyActuals) {
                query = String.valueOf(query) + " WHERE IDO_END_DATE = \"\"";
            }
            query = String.valueOf(query) + " ORDER BY IDO_ID ASC";
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        erg.add(new Long(rs.getLong(1)));
                    }
                    rs.close();
                }
                statement.close();
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem getting Object Group " + group + " Type " + type;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return erg;
    }

    private static IDObject getIDObject(ResultSet rs, Vector keys, int type, String group) throws Exception {
        TreeSet sessionsTreeset = new TreeSet();
        Integer typeKey = new Integer(type);
        TreeMap allowedAttributes = (TreeMap)ALLOWED_ATTRIBUTES_BY_TYPE.get(typeKey);
        HashMap marksForAttribut = (HashMap)MARKS_FOR_ATTRIBUTES_BY_TYPE.get(typeKey);
        if (rs != null) {
            sessionsTreeset.clear();
            IDObject ido = IDObject.giveNewObjectOfType(type);
            ido.set("IDO_GROUP", group);
            int i = 1;
            while (i <= keys.size()) {
                String s = rs.getString(i);
                if (s.length() != 0) {
                    String key = (String)keys.elementAt(i - 1);
                    if (key.equals(COL_SESSIONS)) {
                        String sessionIDSring = rs.getString(i);
                        if (sessionIDSring != null && sessionIDSring.length() != 0) {
                            sessionsTreeset.clear();
                            IDObjectXMLHandler.appendToSessionTreeset(sessionIDSring, sessionsTreeset);
                            ido.setSessions(sessionsTreeset);
                        }
                    } else {
                        Object toSet = DBAssistant.get(rs, allowedAttributes, marksForAttribut, key, s, i, group);
                        if (toSet != null) {
                            ido.set(key, toSet);
                        }
                    }
                }
                ++i;
            }
            ido.commit(false);
            return ido;
        }
        return null;
    }

    private static Object get(ResultSet rs, TreeMap allowedAttributes, HashMap marksForAttribut, String key, String s, int i, String group) throws Exception {
        Class colClass;
        Object toSet = null;
        if (s.length() != 0 && (colClass = (Class)allowedAttributes.get(key)) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (colClass.equals(clazz)) {
                toSet = new Long(s);
            } else {
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (colClass.equals(clazz2)) {
                    toSet = new Integer(s);
                } else {
                    Class<?> clazz3 = class$4;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$4 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (colClass.equals(clazz3)) {
                        toSet = s;
                    } else {
                        Class<?> clazz4 = class$5;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$5 = Class.forName("java.util.Date");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (colClass.equals(clazz4)) {
                            toSet = new Date(rs.getLong(i));
                        } else {
                            Class<?> clazz5 = class$6;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$6 = Class.forName("java.lang.Boolean");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (colClass.equals(clazz5)) {
                                toSet = "1".equals(s);
                            } else {
                                Class<?> clazz6 = class$7;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$7 = Class.forName("java.awt.Color");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (colClass.equals(clazz6)) {
                                    toSet = ColorManager.getColorFromNumberString(s);
                                } else {
                                    Class<?> clazz7 = class$8;
                                    if (clazz7 == null) {
                                        try {
                                            clazz7 = class$8 = Class.forName("[I");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (colClass.equals(clazz7)) {
                                        s = s.substring(1, s.length() - 1);
                                        Zeile z = new Zeile(s, '|');
                                        int[] res = new int[z.size()];
                                        int j = 0;
                                        while (j < res.length) {
                                            res[j] = z.getInt(j, 0);
                                            ++j;
                                        }
                                        toSet = res;
                                    } else {
                                        Class<?> clazz8 = class$9;
                                        if (clazz8 == null) {
                                            try {
                                                clazz8 = class$9 = Class.forName("[J");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (colClass.equals(clazz8)) {
                                            s = s.substring(1, s.length() - 1);
                                            Zeile z = new Zeile(s, '|');
                                            long[] res = new long[z.size()];
                                            int j = 0;
                                            while (j < res.length) {
                                                res[j] = z.getLong(j, 0L);
                                                ++j;
                                            }
                                            toSet = res;
                                        } else {
                                            Class<?> clazz9 = class$10;
                                            if (clazz9 == null) {
                                                try {
                                                    clazz9 = class$10 = Class.forName("[Z");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (colClass.equals(clazz9)) {
                                                s = s.substring(1, s.length() - 1);
                                                Zeile z = new Zeile(s, '|');
                                                boolean[] res = new boolean[z.size()];
                                                int j = 0;
                                                while (j < res.length) {
                                                    res[j] = "1".equals(z.getString(j, ""));
                                                    ++j;
                                                }
                                                toSet = res;
                                            } else {
                                                String mark = (String)marksForAttribut.get(key);
                                                IDObjectXMLHandler.IOXInterpret ioxi = IDObjectXMLHandler.getInterpreter(mark);
                                                toSet = ioxi.holObject(s, group);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return toSet;
    }

    private static String getTableDef(Integer typeKey, String group, StringBuilder msb) {
        String[] orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey);
        TreeMap allowedAttributes = (TreeMap)ALLOWED_ATTRIBUTES_BY_TYPE.get(typeKey);
        String tableName = IDObject.getFilenameForTypeServerSide(typeKey);
        msb.setLength(0);
        msb.append("CREATE TABLE IF NOT EXISTS ").append(tableName).append(" (");
        int attrI = 0;
        int i = 0;
        while (i < orderedAttributes.length) {
            boolean useIt = true;
            String attrKey = orderedAttributes[i];
            if ("IDO_GROUP".equals(attrKey)) {
                useIt = false;
            } else if ("IDO_TYPE_ID".equals(attrKey)) {
                useIt = false;
            }
            if (useIt) {
                if (attrI != 0) {
                    msb.append(", ");
                }
                ++attrI;
                msb.append(attrKey);
                Class cl = (Class)allowedAttributes.get(attrKey);
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cl.equals(clazz)) {
                    msb.append(" BIGINT");
                } else {
                    Class<?> clazz2 = class$5;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cl.equals(clazz2)) {
                        msb.append(" BIGINT");
                    } else {
                        Class<?> clazz3 = class$3;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (cl.equals(clazz3)) {
                            msb.append(" INT");
                        }
                    }
                }
                if ("IDO_ID".equals(attrKey)) {
                    msb.append(" UNIQUE NOT NULL");
                }
            }
            ++i;
        }
        Vector v = (Vector)INDEX_SPALTEN_BY_TYPE.get(typeKey);
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                String col = (String)iterator.next();
                msb.append(", ").append(col);
                if (col.equals(MOUSE_INDEX_CAGE) || col.equals(ALLG_INDEX_ROOM) || col.equals(CAGE_INDEX_RACK)) {
                    msb.append(" BIGINT");
                    continue;
                }
                if (!col.equals(MOUSE_INDEX_SEX)) continue;
                msb.append(" INT");
            }
        }
        if (IDObject.storesSession(typeKey, group)) {
            msb.append(", ").append(COL_SESSIONS);
        }
        msb.append(");");
        return msb.toString();
    }

    private static void initAttributes(Integer typeKey) {
        String[] orderedAttributes;
        HashMap marksForAttribut;
        Class cl = IDObject.getClassForType(typeKey);
        boolean fetchIt = false;
        TreeMap allowedAttributes = (TreeMap)ALLOWED_ATTRIBUTES_BY_TYPE.get(typeKey);
        if (allowedAttributes == null) {
            fetchIt = true;
            allowedAttributes = new TreeMap();
            ALLOWED_ATTRIBUTES_BY_TYPE.put(typeKey, allowedAttributes);
        }
        if ((marksForAttribut = (HashMap)MARKS_FOR_ATTRIBUTES_BY_TYPE.get(typeKey)) == null) {
            fetchIt = true;
            marksForAttribut = new HashMap();
            MARKS_FOR_ATTRIBUTES_BY_TYPE.put(typeKey, marksForAttribut);
        }
        if ((orderedAttributes = (String[])ORDERED_ATTRIBUTES_BY_TYPE.get(typeKey)) == null || fetchIt) {
            allowedAttributes.clear();
            marksForAttribut.clear();
            orderedAttributes = IDObject.fillAllowedsAndFindOrdered(allowedAttributes, marksForAttribut, cl, typeKey);
            ORDERED_ATTRIBUTES_BY_TYPE.put(typeKey, orderedAttributes);
        }
    }

    private static String getDBFilePath(String group) {
        File f = new File(".");
        String fullPath = f.getAbsolutePath();
        fullPath = StringHelper.gSub(fullPath, "\\", "/");
        fullPath = String.valueOf(fullPath) + "/" + GroupFileManager.getDataDirPath(group);
        FileManager.prepareDirs(fullPath);
        fullPath = String.valueOf(fullPath) + "/mauso.db";
        return fullPath;
    }

    private static Hashtable getAllObjects(String group, int type, boolean onlyActuals, ObjectConsumer consumer) {
        return DBAssistant.getAllObjects(group, type, onlyActuals, true, consumer);
    }

    public static Hashtable getAllObjects(String group, int type, boolean onlyActuals, boolean withSessions, ObjectConsumer consumer) {
        Hashtable<Object, IDObject> erg = consumer == null ? new Hashtable<Object, IDObject>() : null;
        DBAssistant.initAttributes(new Integer(type));
        StringBuilder msb = new StringBuilder();
        Vector keys = new Vector();
        Connection conn = DBAssistant.getConnection(group);
        if (conn != null) {
            String query = DBAssistant.getQueryStatement(type, group, withSessions, msb, conn, keys);
            if (onlyActuals) {
                query = String.valueOf(query) + " where IDO_END_DATE == \"\"";
            }
            IDObject ido = null;
            try {
                ResultSet rs;
                Statement statement = conn.createStatement();
                if (statement != null && (rs = statement.executeQuery(query)) != null) {
                    while (rs.next()) {
                        ido = DBAssistant.getIDObject(rs, keys, type, group);
                        if (ido == null || !ido.existed()) continue;
                        if (consumer != null) {
                            consumer.handleNewObject(ido);
                            continue;
                        }
                        if (erg == null) continue;
                        erg.put(ido.get("IDO_ID"), ido);
                    }
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                String string = "Problem getting Object Group " + group + " Type " + type;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                String string = "Problem closing Connection while getting Objects Group " + group + " Type " + type;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return erg;
    }

    private static void convertGroupData(String group, StringBuilder msb, HashMap idVersionSammler) {
        Connection conn = DBAssistant.getConnection(group);
        if (conn == null) {
            String string = "No Connection for group >" + group + "<";
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
        } else {
            int[] typen = DataLayer.getTypen(group);
            int i = 0;
            while (i < typen.length) {
                if (!DBAssistant.createTable(typen[i], group, msb, conn)) {
                    String string = "Database Initialisation failed for group " + group;
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.db.DBTest2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, illegalArgumentException, clazz);
                    System.exit(-1);
                }
                String string = "   .. convert " + IDObject.getFilenameForTypeServerSide(typen[i]) + " data of group " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.db.DBAssistant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string, clazz);
                DBAssistant.convert(group, typen[i], msb, conn, idVersionSammler);
                ++i;
            }
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            String string = "Database Initialisation failed [close] for group " + group;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.db.DBTest2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
            System.exit(-1);
        }
    }

    private static boolean convert(String group, int type, StringBuilder msb, Connection conn, HashMap idVersionSammler) {
        idVersionSammler.clear();
        StringBuilder msbNamen = new StringBuilder();
        StringBuilder msbFrgz = new StringBuilder();
        PreparedStatement preparedStatement = DBAssistant.getInsertStatement(type, group, msbNamen, msbFrgz, conn);
        String dataFilePath = GroupFileManager.getDataFilePath(group, IDObject.getFilenameForTypeServerSide(type));
        DataFile df = new DataFile(group, type, dataFilePath);
        if (df != null && preparedStatement != null) {
            df.ivCheckMice = false;
            int minID = Integer.MAX_VALUE;
            int maxID = Integer.MIN_VALUE;
            Enumeration en = df.getIDs();
            if (en.hasMoreElements()) {
                int anz = 0;
                try {
                    RandomAccessFile raf = new RandomAccessFile(df.getFilename(), "r");
                    while (en.hasMoreElements()) {
                        int aa = 0;
                        Integer idInti = (Integer)en.nextElement();
                        if (idInti <= 0) {
                            String string = "Irregular ID " + idInti + " from File";
                            Class<?> clazz = class$11;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.warn(string, clazz);
                            continue;
                        }
                        DataFileEntry dfe = df.getEntry(idInti);
                        try {
                            ++aa;
                            IDObject ido = df.readObject(dfe, raf, idInti.longValue(), null);
                            if (ido != null && ido.getID() > 0L) {
                                boolean useit = true;
                                boolean isInsert = true;
                                Integer thisVersion = (Integer)ido.get("IDO_VERSION");
                                if (thisVersion == null) {
                                    String string = "Version missing for ID " + idInti;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("mausoleum.db.DBAssistant");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Log.warn(string, clazz);
                                    ido.set("IDO_VERSION", 1);
                                } else {
                                    Integer lastVersion = (Integer)idVersionSammler.get(idInti);
                                    if (lastVersion != null) {
                                        String string = "Duplicated ID " + idInti;
                                        Class<?> clazz = class$0;
                                        if (clazz == null) {
                                            try {
                                                clazz = Class.forName("mausoleum.db.DBAssistant");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        Log.warn(string, clazz);
                                        if (thisVersion >= lastVersion) {
                                            isInsert = false;
                                            useit = true;
                                        } else {
                                            useit = false;
                                        }
                                    }
                                }
                                if (!useit) continue;
                                int idval = (int)ido.getID();
                                if (idval > maxID) {
                                    maxID = idval;
                                }
                                if (idval < minID) {
                                    minID = idval;
                                }
                                ++aa;
                                DBAssistant.insertOrUpdate(ido, preparedStatement, msbFrgz, isInsert);
                                ++aa;
                                preparedStatement.addBatch();
                                ++aa;
                                if (++anz > 800) {
                                    conn.setAutoCommit(false);
                                    preparedStatement.executeBatch();
                                    conn.setAutoCommit(true);
                                    anz = 0;
                                }
                                ++aa;
                                continue;
                            }
                            String string = "Could not load Object. Object missing or ID corrupt Inner Problem [" + aa + "] for ID " + idInti + " from File";
                            Class<?> clazz = class$11;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.warn(string, clazz);
                        }
                        catch (Exception e) {
                            String string = "Could not load Object. Inner Problem [" + aa + "] for ID " + idInti + " from File";
                            Class<?> clazz = class$11;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    conn.setAutoCommit(false);
                    preparedStatement.executeBatch();
                    conn.setAutoCommit(true);
                    preparedStatement.close();
                    raf.close();
                    String string = "   ... converted IDs: " + minID + " - " + maxID;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.db.DBAssistant");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.log(string, clazz);
                }
                catch (Exception e) {
                    Class<?> clazz = class$11;
                    if (clazz == null) {
                        try {
                            clazz = class$11 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Could not load Objects from File", e, clazz);
                    return false;
                }
            }
        }
        return true;
    }
}

