/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.definitionlists;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.client.NetReceiverClientCommandManager;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.definitionlists.Microorganism;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.usergroup.UsergroupManager;
import mausoleum.util.InstallationType;

public class ListDefinition
implements Comparable {
    public static final String EXCEL_SHEET_NAME = "list_definitions";
    public static final String LISTDEF_SYSTEM_TAG = "#ldsystem";
    public static final String BABEL_SIGN = "#Babel";
    public static final int TYPE_STORAGE = 1;
    public static final int TYPE_TISSUE = 2;
    public static final int TYPE_EMBEDDING = 3;
    public static final int TYPE_PREPARATION = 4;
    public static final int TYPE_FIXATION = 5;
    public static final int TYPE_ADDRESS = 6;
    public static final int TYPE_GROUP = 7;
    public static final int TYPE_MICROORGANISM = 8;
    public static final int TYPE_MICRO_CHECK_METHOD = 9;
    public static final int SERVICE_AUFSCHLAG = 5000;
    public static final int SYSTEM_AUFSCHLAG = 10000;
    public static int[] KNOWN_TYPES;
    public static String[] KNOWN_TYPE_BABELS;
    private static final String TRENNER = "|";
    private static final char TRENNER_CHAR = '|';
    private static final String HEADER_TYP = "TYP";
    private static final String HEADER_ID = "ID";
    private static final String HEADER_ACTIVE = "ACTIVE";
    private static final String HEADER_VALUE = "VALUE";
    private static final String HEADER_NAME = "NAME";
    private static final String HEADER_DESCRIPTION = "DESCRIPTION";
    private static final String[] EXCEL_HEADERS;
    private static final HashMap DEFINED_LISTS_BY_GROUP;
    private static final ListDefinition EMPTY_DEF;
    private static final Vector GROUP_ADRESSES;
    public int ivTyp = 0;
    public int ivID = 0;
    public boolean ivActive = true;
    public String ivValue = null;
    public String ivName = null;
    public String ivDescription = null;

    static {
        String[] stringArray;
        KNOWN_TYPES = new int[]{2, 3, 4, 5, 6, 8, 9};
        if (MausoleumClient.isHeadOfService()) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "LIST_TYPE_TISSUE";
            stringArray2[1] = "LIST_TYPE_EMBEDDING";
            stringArray2[2] = "LIST_TYPE_PREPARATION";
            stringArray2[3] = "LIST_TYPE_FIXATION";
            stringArray2[4] = "LIST_TYPE_ADDRESS";
            stringArray2[5] = "LIST_TYPE_MICROORGANISM";
            stringArray = stringArray2;
            stringArray2[6] = "LIST_TYPE_MICRO_CHECK_METHOD";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "LIST_TYPE_TISSUE";
            stringArray3[1] = "LIST_TYPE_EMBEDDING";
            stringArray3[2] = "LIST_TYPE_PREPARATION";
            stringArray3[3] = "LIST_TYPE_FIXATION";
            stringArray = stringArray3;
            stringArray3[4] = "LIST_TYPE_ADDRESS";
        }
        KNOWN_TYPE_BABELS = stringArray;
        EXCEL_HEADERS = new String[]{HEADER_TYP, HEADER_ID, HEADER_ACTIVE, HEADER_VALUE, HEADER_NAME, HEADER_DESCRIPTION};
        DEFINED_LISTS_BY_GROUP = new HashMap();
        EMPTY_DEF = new ListDefinition(-1, Babel.get("NOT_SPECIFIED"));
        GROUP_ADRESSES = new Vector();
    }

    public static void init(String group) {
        ListDefinition.handleFile(FileManager.getStringContentFromServer(GroupFileManager.getListDefFilePath(group)), group);
        if (InstallationType.isMouse() && group.equals("service")) {
            Microorganism.init(group);
        }
    }

    public static void initGroupAddresses() {
        String[] existingGroupNames;
        if (GROUP_ADRESSES.isEmpty() && (existingGroupNames = UsergroupManager.getGroupNames(true)) != null) {
            int i = 0;
            while (i < existingGroupNames.length) {
                if (!existingGroupNames[i].equals(UserManager.getFirstGroup()) && !existingGroupNames[i].equals("service")) {
                    ListDefinition ld = new ListDefinition(7);
                    ld.ivID = GROUP_ADRESSES.size() + 1 + 10000;
                    ld.ivName = existingGroupNames[i];
                    ld.ivValue = existingGroupNames[i];
                    GROUP_ADRESSES.add(ld);
                }
                ++i;
            }
            Collections.sort(GROUP_ADRESSES);
        }
    }

    public static void clearGroupHashMaps() {
        DEFINED_LISTS_BY_GROUP.clear();
        GROUP_ADRESSES.clear();
    }

    public static boolean reinitForCommand(String command) {
        Zeile z = new Zeile(command, '|');
        String group = z.getString(1);
        if (group != null) {
            ListDefinition.init(group);
            return true;
        }
        return false;
    }

    private static Vector getMatchingVector(String group, int typ) {
        HashMap hm;
        if (typ == 8 || typ == 9) {
            return Microorganism.getMatchingVector(group, typ);
        }
        if (group != null && (hm = (HashMap)DEFINED_LISTS_BY_GROUP.get(group)) != null) {
            return (Vector)hm.get(new Integer(typ));
        }
        return null;
    }

    public static Vector getItems(String[] groups, int typ, boolean onlyActives, boolean withEmptyDef, boolean withSystemDefs) {
        Vector<ListDefinition> res = new Vector<ListDefinition>();
        if (groups != null) {
            int i = 0;
            while (i < groups.length) {
                ListDefinition.addDefs(res, ListDefinition.getMatchingVector(groups[i], typ), onlyActives);
                ++i;
            }
        } else {
            Iterator iterator = DEFINED_LISTS_BY_GROUP.keySet().iterator();
            while (iterator.hasNext()) {
                ListDefinition.addDefs(res, ListDefinition.getMatchingVector((String)iterator.next(), typ), onlyActives);
            }
        }
        if (!res.isEmpty()) {
            Collections.sort(res);
        }
        if (withSystemDefs && typ == 6) {
            res.addAll(GROUP_ADRESSES);
        }
        if (withEmptyDef) {
            res.insertElementAt(EMPTY_DEF, 0);
        }
        return res;
    }

    private static void addDefs(Vector res, Vector v, boolean onlyActives) {
        if (v != null) {
            if (onlyActives) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    ListDefinition ld = (ListDefinition)iterator.next();
                    if (!ld.ivActive) continue;
                    res.add(ld);
                }
            } else {
                res.addAll(v);
            }
        }
    }

    public static boolean hasValues(String group, int typ) {
        Vector v = ListDefinition.getMatchingVector(group, typ);
        return v != null && !v.isEmpty();
    }

    public static String getName(String group, int typ, int id, String defVal) {
        Vector v;
        if (group != null && typ > 0 && id > 0 && (v = ListDefinition.getMatchingVector(group, typ)) != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                ListDefinition ld = (ListDefinition)iterator.next();
                if (ld.ivID != id) continue;
                return ld.ivName;
            }
        }
        return defVal;
    }

    public static String getToString(String group, int typ, int id, String defVal) {
        Vector v;
        if (group != null && typ > 0 && id > 0 && (v = ListDefinition.getMatchingVector(group, typ)) != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                ListDefinition ld = (ListDefinition)iterator.next();
                if (ld.ivID != id) continue;
                return ld.toString();
            }
        }
        return defVal;
    }

    public static void digestNewDefinition(ListDefinition ld, String group) {
        HashMap target = (HashMap)DEFINED_LISTS_BY_GROUP.get(group);
        if (target == null) {
            target = new HashMap();
            DEFINED_LISTS_BY_GROUP.put(group, target);
            ld.ivID = 1;
            ld.enterInGroupHM(target);
        } else {
            Vector v = ld.getTypeVec(target);
            ld.ivID = v.size() + 1;
            v.add(ld);
        }
        if ("service".equals(group)) {
            ld.ivID += 5000;
        }
        ListDefinition.saveStandardsToServer(group);
    }

    public static void saveStandardsToServer(String group) {
        HashMap hm = (HashMap)DEFINED_LISTS_BY_GROUP.get(group);
        if (hm != null && !hm.isEmpty()) {
            ListDefinition.saveStandardsToServer(hm, group, GroupFileManager.getListDefFilePath(group));
        }
    }

    public static void saveStandardsToServer(HashMap hm, String group, String path) {
        StringBuilder msb = new StringBuilder();
        msb.setLength(0);
        Iterator iter = hm.values().iterator();
        while (iter.hasNext()) {
            Vector v = (Vector)iter.next();
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                ListDefinition ld = (ListDefinition)iterator.next();
                msb.append(ld.getTransport()).append("\n");
            }
        }
        NetReceiverClientCommandManager.saveContentToServer("COM_LIST_DEFS_CHANGED", group, path, msb.toString());
    }

    public static Vector getExcelVector(String group) {
        Vector erg = new Vector();
        if (ProcessDefinition.isServer()) {
            Vector<String> line = new Vector<String>();
            erg.add(line);
            int i = 0;
            while (i < EXCEL_HEADERS.length) {
                line.add(EXCEL_HEADERS[i]);
                ++i;
            }
            String content = FileManager.getStringFromFile(GroupFileManager.getListDefFilePath(group));
            if (content != null) {
                Vector lines = StringHelper.splitStringByAny(content, "\n");
                Iterator iter = lines.iterator();
                while (iter.hasNext()) {
                    String sline = (String)iter.next();
                    if ((sline = sline.trim()).length() == 0 || sline.startsWith("#")) continue;
                    Zeile z = new Zeile(sline, '|');
                    line = new Vector();
                    erg.add(line);
                    int i2 = 0;
                    while (i2 < EXCEL_HEADERS.length) {
                        line.add(z.getString(i2, ""));
                        ++i2;
                    }
                }
            }
        }
        return erg;
    }

    public static void readExcelVector(Vector lines, String group) {
        if (lines != null && lines.size() > 1) {
            Vector firstLine = (Vector)lines.elementAt(0);
            StringBuffer msb = new StringBuffer();
            int i = 1;
            while (i < lines.size()) {
                String typ = null;
                String id = null;
                String active = null;
                String value = null;
                String name = null;
                String description = null;
                Vector line = (Vector)lines.elementAt(i);
                int j = 0;
                while (j < line.size()) {
                    if (j < firstLine.size()) {
                        String header = ((String)firstLine.elementAt(j)).trim();
                        String val = ((String)line.elementAt(j)).trim();
                        if (header.equalsIgnoreCase(HEADER_TYP)) {
                            try {
                                Integer.parseInt(val);
                                typ = val;
                            }
                            catch (Exception exception) {}
                        } else if (header.equalsIgnoreCase(HEADER_ID)) {
                            try {
                                Integer.parseInt(val);
                                id = val;
                            }
                            catch (Exception exception) {}
                        } else if (header.equalsIgnoreCase(HEADER_ACTIVE)) {
                            if (val.equals("1") || val.equals("0")) {
                                active = val;
                            }
                        } else if (header.equalsIgnoreCase(HEADER_VALUE)) {
                            value = val;
                        } else if (header.equalsIgnoreCase(HEADER_NAME)) {
                            name = val;
                        } else if (header.equalsIgnoreCase(HEADER_DESCRIPTION)) {
                            description = val;
                        }
                    }
                    ++j;
                }
                if (id != null && typ != null) {
                    msb.append(typ).append(TRENNER);
                    msb.append(id).append(TRENNER);
                    msb.append(active).append(TRENNER);
                    msb.append(value).append(TRENNER);
                    msb.append(name).append(TRENNER);
                    msb.append(description).append(TRENNER);
                    msb.append("\n");
                }
                ++i;
            }
            FileManager.saveStringToFile(GroupFileManager.getListDefFilePath(group), msb.toString());
        }
    }

    public static String getDisplayValue(String s, String defVal) {
        if (s != null && s.startsWith(BABEL_SIGN)) {
            Zeile z = new Zeile(s, ';');
            String ts = String.valueOf(ProcessDefinition.isClient() ? Babel.cvUserLangue : "en") + ":";
            int i = 1;
            while (i < z.size()) {
                String aaa = z.getString(i, "");
                if (aaa.startsWith(ts)) {
                    return Base64Manager.getDecodedString(aaa.substring(ts.length(), aaa.length()));
                }
                ++i;
            }
            String tts = "en:";
            if (!tts.equals(ts)) {
                int i2 = 1;
                while (i2 < z.size()) {
                    String aaa = z.getString(i2, "");
                    if (aaa.startsWith(tts)) {
                        return Base64Manager.getDecodedString(aaa.substring(tts.length(), aaa.length()));
                    }
                    ++i2;
                }
            }
        }
        return defVal;
    }

    public static String getMultiLanguageTooltip(String s, String defaultName) {
        if (s != null && s.startsWith(BABEL_SIGN)) {
            StringBuilder msb = new StringBuilder();
            msb.append("<HTML><body marginwidth=\"5\" marginheight=\"5\">").append("<table>\n");
            msb.append("<tr><td>").append(Babel.get("DEFAULT")).append("</td>");
            msb.append("<td><b>").append(defaultName).append("</b></td></tr>\n");
            Zeile z = new Zeile(s, ';');
            int i = 1;
            while (i < z.size()) {
                String aaa = z.getString(i, "");
                int ind = aaa.indexOf(":");
                if (ind != -1) {
                    String lanKurz = aaa.substring(0, ind);
                    msb.append("<tr><td>").append(Babel.getStringForLang(lanKurz)).append("</td>");
                    msb.append("<td><b>").append(Base64Manager.getDecodedString(aaa.substring(ind + 1, aaa.length()))).append("</b></td></tr>\n");
                }
                ++i;
            }
            msb.append("</table>\n");
            msb.append("</body>");
            return msb.toString();
        }
        return null;
    }

    public static void fillBabels(String s, HashMap namesByBabel) {
        if (s != null && s.startsWith(BABEL_SIGN)) {
            Zeile z = new Zeile(s, ';');
            int i = 0;
            while (i < z.size()) {
                String aaa = z.getString(i, "");
                int ind = aaa.indexOf(":");
                if (ind != -1) {
                    namesByBabel.put(aaa.substring(0, ind), Base64Manager.getDecodedString(aaa.substring(ind + 1, aaa.length())));
                }
                ++i;
            }
        }
    }

    public static String getBabeledValueString(HashMap namesByBabel) {
        if (namesByBabel != null && !namesByBabel.isEmpty()) {
            StringBuilder msb = new StringBuilder(BABEL_SIGN);
            Iterator iterator = namesByBabel.keySet().iterator();
            while (iterator.hasNext()) {
                String lang = (String)iterator.next();
                String val = (String)namesByBabel.get(lang);
                msb.append(";").append(lang).append(":").append(Base64Manager.encodeBase64(val));
            }
            return msb.toString();
        }
        return null;
    }

    public static boolean isKeimRelevant(int typ) {
        return typ == 8 || typ == 9;
    }

    private static final void handleFile(String s, String group) {
        if (s != null) {
            HashMap hm = (HashMap)DEFINED_LISTS_BY_GROUP.get(group);
            if (hm != null) {
                hm.clear();
            } else {
                hm = new HashMap();
                DEFINED_LISTS_BY_GROUP.put(group, hm);
            }
            Vector lines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                new ListDefinition(line, hm);
            }
        }
    }

    public ListDefinition(String line, HashMap target) {
        Zeile z = new Zeile(line, '|');
        int pos = 0;
        this.ivTyp = z.getInt(pos++, 0);
        this.ivID = z.getInt(pos++, 0);
        this.ivActive = "1".equals(z.getStringNONEmpty(pos++, "0"));
        this.ivValue = z.getStringB64(pos++, null);
        this.ivName = z.getStringB64(pos++, null);
        this.ivDescription = z.getStringB64(pos++, null);
        this.enterInGroupHM(target);
    }

    public ListDefinition(int typ) {
        this.ivTyp = typ;
    }

    public ListDefinition(int typ, int id, boolean active, String value, String name, String description, HashMap target) {
        this.ivTyp = typ;
        this.ivID = id;
        this.ivActive = active;
        this.ivValue = value;
        this.ivName = name;
        this.ivDescription = description;
        this.enterInGroupHM(target);
    }

    private ListDefinition(int id, String name) {
        this.ivID = id;
        this.ivName = name;
        this.ivValue = name;
    }

    public String toString() {
        StringBuilder msb = new StringBuilder(" ");
        if (this.ivID > 10000) {
            msb.append("[M] ");
        } else if (this.ivID > 5000) {
            msb.append("[S] ");
        } else if (this.ivID > 0) {
            msb.append("[G] ");
        }
        if (this.ivTyp == 1) {
            msb.append(this.ivName).append(" = ").append(this.ivValue);
        } else {
            msb.append(this.ivName);
        }
        msb.append(" ");
        return msb.toString();
    }

    public String getTooltip() {
        return null;
    }

    public boolean isActive() {
        return this.ivActive;
    }

    public void setActive(boolean active) {
        this.ivActive = active;
    }

    protected String getTransport() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivTyp).append(TRENNER);
        msb.append(this.ivID).append(TRENNER);
        msb.append(this.ivActive ? "1" : "0").append(TRENNER);
        msb.append(this.ivValue != null ? Base64Manager.encodeBase64(this.ivValue) : "").append(TRENNER);
        msb.append(this.ivName != null ? Base64Manager.encodeBase64(this.ivName) : "").append(TRENNER);
        msb.append(this.ivDescription != null ? Base64Manager.encodeBase64(this.ivDescription) : "").append(TRENNER);
        return msb.toString();
    }

    private Vector getTypeVec(HashMap target) {
        Integer key = new Integer(this.ivTyp);
        Vector v = (Vector)target.get(key);
        if (v == null) {
            v = new Vector();
            target.put(key, v);
        }
        return v;
    }

    private void enterInGroupHM(HashMap target) {
        if (this.ivTyp > 0 && this.ivID > 0 && this.ivName != null) {
            this.getTypeVec(target).add(this);
        }
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof ListDefinition) {
            ListDefinition ld = (ListDefinition)arg0;
            return this.ivName.compareToIgnoreCase(ld.ivName);
        }
        return 0;
    }
}

