/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.definitionlists;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.alert.Alert;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.Microorganism;
import mausoleum.gui.FlexGridLayout;
import mausoleum.helper.FontManager;
import mausoleum.requester.std.MausoOptionPane;
import mausoleum.ui.UIDef;

public abstract class ListDefinitionEditPanel
extends JPanel {
    private static final long serialVersionUID = 11231234L;
    private static final Dimension FIELD_DIM = new Dimension(UIDef.getScaled(300), UIDef.LINE_HEIGHT);
    private static final ListDefinitionEditPanel STD_INSTANCE = new StdListDefinitionEditPanel();
    private static final ListDefinitionEditPanel STORAGE_INSTANCE = new StorageListDefinitionEditPanel();
    private static final ListDefinitionEditPanel BABLEABLE_INSTANCE = new BableableListDefinitionEditPanel();
    private static final ListDefinitionEditPanel KEIM_INSTANCE = new MicroorganismistDefinitionEditPanel();

    public static boolean editDefinition(Component sender, ListDefinition ld) {
        boolean ok = false;
        ListDefinitionEditPanel ldep = STD_INSTANCE;
        if (ld.ivTyp == 1) {
            ldep = STORAGE_INSTANCE;
        } else if (ld.ivTyp == 9) {
            ldep = BABLEABLE_INSTANCE;
        } else if (ld.ivTyp == 8) {
            ldep = KEIM_INSTANCE;
        }
        ldep.fillFromListDefinition(ld);
        if (MausoOptionPane.showOptionPane(sender, ldep, MausoOptionPane.MODE_OK_AND_NO, Babel.get("REQUEST"))) {
            if (ldep.okAllowed()) {
                ok = ldep.fillListDefinition(ld);
            } else {
                Alert.showAlert(Babel.get("INVALID_INPUT"), true);
            }
        }
        return ok;
    }

    public ListDefinitionEditPanel(LayoutManager lm) {
        super(lm);
    }

    public abstract boolean okAllowed();

    public abstract void fillFromListDefinition(ListDefinition var1);

    public abstract boolean fillListDefinition(ListDefinition var1);

    public static class BableableListDefinitionEditPanel
    extends StdListDefinitionEditPanel {
        private static final long serialVersionUID = 123453452L;
        public JComboBox ivLangCombo;
        public JTextField ivBabelTextField;
        public HashMap ivNamesByLang;
        private String ivLastSelectedLang = "en";

        public BableableListDefinitionEditPanel() {
            super(new FlexGridLayout(3, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        }

        public void addSuperDescrItems() {
            this.ivNamesByLang = new HashMap();
            this.ivLangCombo = new JComboBox(Babel.AVAILABLE_LANGUAGES);
            this.ivLangCombo.setSelectedItem(Babel.getStringForLang(this.ivLastSelectedLang));
            this.ivLangCombo.addActionListener(new ActionListener(this){
                final /* synthetic */ BableableListDefinitionEditPanel this$1;
                {
                    this.this$1 = bableableListDefinitionEditPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    BableableListDefinitionEditPanel.access$0(this.this$1);
                    BableableListDefinitionEditPanel.access$1(this.this$1, Babel.getLangForString((String)this.this$1.ivLangCombo.getSelectedItem()));
                    String val = (String)this.this$1.ivNamesByLang.get(BableableListDefinitionEditPanel.access$2(this.this$1));
                    this.this$1.ivBabelTextField.setText(val == null ? "" : val);
                }
            });
            this.ivBabelTextField = new JTextField();
            this.ivBabelTextField.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ BableableListDefinitionEditPanel this$1;
                {
                    this.this$1 = bableableListDefinitionEditPanel;
                }

                public void focusLost(FocusEvent e) {
                    BableableListDefinitionEditPanel.access$0(this.this$1);
                }
            });
            this.ivBabelTextField.addCaretListener(new CaretListener(this){
                final /* synthetic */ BableableListDefinitionEditPanel this$1;
                {
                    this.this$1 = bableableListDefinitionEditPanel;
                }

                public void caretUpdate(CaretEvent e) {
                    BableableListDefinitionEditPanel.access$0(this.this$1);
                }
            });
            this.add(new JLabel(StringHelper.capitalize(Babel.get("LANG_VARIANTS"))));
            JPanel panel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
            panel.setOpaque(false);
            panel.add("Center", this.ivBabelTextField);
            panel.add("West", this.ivLangCombo);
            this.add(panel);
        }

        public void fillFromListDefinition(ListDefinition ld) {
            super.fillFromListDefinition(ld);
            this.ivNamesByLang.clear();
            ListDefinition.fillBabels(ld.ivValue, this.ivNamesByLang);
            String val = (String)this.ivNamesByLang.get(this.ivLastSelectedLang);
            this.ivBabelTextField.setText(val == null ? "" : val);
        }

        public boolean okAllowed() {
            return super.okAllowed() && this.ivNamesByLang.get("en") != null;
        }

        public boolean fillListDefinition(ListDefinition ld) {
            boolean ok = super.fillListDefinition(ld);
            if (ok) {
                ld.ivValue = ListDefinition.getBabeledValueString(this.ivNamesByLang);
            }
            return ok;
        }

        private void storeNameVal() {
            if (this.ivLastSelectedLang != null) {
                String val = this.ivBabelTextField.getText();
                if (val.trim().length() != 0) {
                    this.ivNamesByLang.put(this.ivLastSelectedLang, val);
                } else {
                    this.ivNamesByLang.remove(this.ivLastSelectedLang);
                }
            }
        }

        static /* synthetic */ void access$0(BableableListDefinitionEditPanel bableableListDefinitionEditPanel) {
            bableableListDefinitionEditPanel.storeNameVal();
        }

        static /* synthetic */ void access$1(BableableListDefinitionEditPanel bableableListDefinitionEditPanel, String string) {
            bableableListDefinitionEditPanel.ivLastSelectedLang = string;
        }

        static /* synthetic */ String access$2(BableableListDefinitionEditPanel bableableListDefinitionEditPanel) {
            return bableableListDefinitionEditPanel.ivLastSelectedLang;
        }
    }

    public static class MicroorganismistDefinitionEditPanel
    extends StdListDefinitionEditPanel {
        private static final long serialVersionUID = 123453452L;
        public JComboBox ivKeimTypCombo;
        public JCheckBox ivFELASABox;
        public JComboBox ivMethodBox;
        public Vector ivMethods;

        public MicroorganismistDefinitionEditPanel() {
            super(new FlexGridLayout(5, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        }

        public void addSuperDescrItems() {
            this.add(new JLabel(StringHelper.capitalize(Babel.get("GETN_TYPE"))));
            String[] keimTypArray = new String[Microorganism.KEIM_TYP_BABELS.length];
            int i = 0;
            while (i < keimTypArray.length) {
                keimTypArray[i] = Babel.get(Microorganism.KEIM_TYP_BABELS[i]);
                ++i;
            }
            this.ivKeimTypCombo = new JComboBox<String>(keimTypArray);
            this.add(this.ivKeimTypCombo);
            this.add(new JLabel(StringHelper.capitalize(Babel.get("GETN_FELASA"))));
            this.ivFELASABox = new JCheckBox();
            this.ivFELASABox.setOpaque(false);
            this.ivFELASABox.setFocusPainted(false);
            this.add(this.ivFELASABox);
            this.add(new JLabel(StringHelper.capitalize(Babel.get("GETN_METHOD"))));
            this.ivMethods = Microorganism.getMatchingVector("service", 9);
            this.ivMethodBox = new JComboBox(this.ivMethods);
            this.add(this.ivMethodBox);
        }

        public void fillFromListDefinition(ListDefinition ld) {
            super.fillFromListDefinition(ld);
            if (ld instanceof Microorganism.Keim) {
                Microorganism.Keim keim = (Microorganism.Keim)ld;
                int ind = ArrayHelper.findIndexInArray(keim.ivKeimTyp, Microorganism.KEIM_TYPES);
                this.ivKeimTypCombo.setSelectedIndex(ind == -1 ? 0 : ind);
                ind = 0;
                int i = 0;
                while (i < this.ivMethods.size()) {
                    ListDefinition mld = (ListDefinition)this.ivMethods.elementAt(i);
                    if (mld.ivID == keim.ivMethodID) {
                        ind = i;
                    }
                    ++i;
                }
                this.ivMethodBox.setSelectedIndex(ind);
                this.ivFELASABox.setSelected(keim.ivFelasaRelevant);
            }
        }

        public boolean okAllowed() {
            return super.okAllowed();
        }

        public boolean fillListDefinition(ListDefinition ld) {
            boolean ok = super.fillListDefinition(ld);
            if (ok && ld instanceof Microorganism.Keim) {
                Microorganism.Keim keim = (Microorganism.Keim)ld;
                keim.ivFelasaRelevant = this.ivFELASABox.isSelected();
                keim.ivKeimTyp = Microorganism.KEIM_TYPES[this.ivKeimTypCombo.getSelectedIndex()];
                keim.ivMethodID = ((ListDefinition)this.ivMethods.elementAt((int)this.ivMethodBox.getSelectedIndex())).ivID;
            }
            return ok;
        }
    }

    public static class StdListDefinitionEditPanel
    extends ListDefinitionEditPanel {
        private static final long serialVersionUID = 1L;
        public final JTextField ivNameField = new JTextField();
        public final JTextPane ivDescrPane = new JTextPane();

        public StdListDefinitionEditPanel() {
            this(new FlexGridLayout(2, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        }

        public StdListDefinitionEditPanel(LayoutManager lm) {
            super(lm);
            this.setOpaque(false);
            this.add(new JLabel(Babel.get("LIST_DEF_NAME")));
            this.ivNameField.setPreferredSize(FIELD_DIM);
            this.ivNameField.setFont(FontManager.getFont("SSB12"));
            this.add(this.ivNameField);
            this.addSuperDescrItems();
            JLabel lab = new JLabel(Babel.get("DESCRIPTION"));
            lab.setVerticalAlignment(1);
            this.add(lab);
            this.ivDescrPane.setCaretPosition(0);
            this.ivDescrPane.setMargin(new Insets(4, 4, 4, 4));
            this.ivDescrPane.setFont(FontManager.getFont("SSB12"));
            JScrollPane jsp = new JScrollPane(this.ivDescrPane);
            jsp.setPreferredSize(new Dimension(UIDef.getScaled(300), UIDef.getScaled(150)));
            this.add(jsp);
        }

        public void addSuperDescrItems() {
        }

        public void fillFromListDefinition(ListDefinition ld) {
            this.ivNameField.setText(ld.ivName);
            this.ivDescrPane.setText(ld.ivDescription);
        }

        public boolean okAllowed() {
            return this.ivNameField.getText().trim().length() != 0;
        }

        public boolean fillListDefinition(ListDefinition ld) {
            boolean ok = false;
            String name = this.ivNameField.getText().trim();
            if (name.length() != 0) {
                ok = true;
                String descr = this.ivDescrPane.getText().trim();
                ld.ivValue = null;
                ld.ivName = name;
                ld.ivDescription = descr.length() == 0 ? null : descr;
            }
            return ok;
        }

        public boolean nameIsBabelable() {
            return false;
        }
    }

    public static class StorageListDefinitionEditPanel
    extends StdListDefinitionEditPanel {
        private static final long serialVersionUID = 123453452L;
        public JTextField ivValueField;

        public StorageListDefinitionEditPanel() {
            super(new FlexGridLayout(3, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        }

        public void addSuperDescrItems() {
            this.add(new JLabel(Babel.get("LIST_DEF_NAME")));
            this.ivValueField = new JTextField();
            this.ivValueField.setPreferredSize(FIELD_DIM);
            this.ivValueField.setFont(FontManager.getFont("SSB12"));
            this.add(this.ivValueField);
        }

        public void fillFromListDefinition(ListDefinition ld) {
            super.fillFromListDefinition(ld);
            this.ivValueField.setText(ld.ivValue);
        }

        public boolean okAllowed() {
            return super.okAllowed() && this.ivValueField.getText().trim().length() != 0;
        }

        public boolean fillListDefinition(ListDefinition ld) {
            boolean ok = super.fillListDefinition(ld);
            if (ok) {
                String value = this.ivValueField.getText().trim();
                if (value.length() != 0) {
                    ld.ivValue = value;
                } else {
                    ok = false;
                }
            }
            return ok;
        }
    }
}

